#define PATCHES     1
#define CURVES      2
#define NVERTICES   3
#define NPATCHES    4
#define NCURVES     5
#define VERTEX_LIST 6
#define PATCH_LIST  7
#define CURVE_LIST  8
#define INTEGER     9
#define FLOAT       10


typedef union {
    int    intval;
    double floatval;
} Tokenval;


typedef struct {
    double coor[3];
} Bez_Vertex;

typedef struct {
    int cp[4];
} Bez_Curve;

typedef struct {
    int cp[4][4];
} Bez_Patch;

typedef struct {
    int         type;
    int         nvertex;
    Bez_Vertex *vertex;
    union {
        int ncurves;
        int npatches;
    } n;
    union {
        Bez_Curve *ccp;
        Bez_Patch *pcp;
    } cp;
} Bez_Object;
