/*	Copyright (c) 1982 Michael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/* xorseq.c -- compute the logical xor of two sequences.
 *		 
 * usage: xorseq file  < insequence > outsequence
 *
 * to load: cc -o xorseq xorseq.c -lhipl
 *
 * Yoav Cohen 1/11/83
 */

#include <hipl_format.h>
#include <stdio.h>
char *Progname;

main(argc,argv)

int argc;
char *argv[];

{	
	char *in1,*in2;
	int fd,mask,i,nels,nf,nrc,byte,byte_size,factor,c;
	struct header hd1,hd2;

	Progname = strsave(*argv);
	if (argv[argc][0]=='-' && argv[argc][1]=='D') argc--;
	if(argc<2)
		perr("usage: xorseq file ");
	if((fd=open(argv[1],0))==-1)
		perr("can't open %s",argv[1]);

	read_header(&hd1);
	fread_header(fd,&hd2);
	if((hd1.pixel_format != PFBYTE)||(hd2.pixel_format != PFBYTE))
		perr("image pixel format must be bytes");
	nf=hd1.num_frame;
	if (nf<0)
		perr("#frames must be zero or positive");
	byte_size=hd1.bits_per_pixel;
	if((hd1.bits_per_pixel!=hd2.bits_per_pixel) ||
	   (hd1.num_frame!=hd2.num_frame) ||
	   (hd1.bit_packing!=hd2.bit_packing) ||
	   (hd1.rows!=hd2.rows) || (hd1.cols!=hd2.cols) )
		perr("headers must agree");
	c = hd1.bit_packing ? (hd1.cols+7)/8 : hd1.cols;
	nrc=hd1.rows*c;
	in1=(char *)halloc(nrc,sizeof(char));
	in2=(char *)halloc(nrc,sizeof(char));
	update_header(&hd1,argc,argv);
	write_header(&hd1);

	mask=0;
	for(i=0;i<byte_size;i++)
		mask=(mask<<1)+1;
	for(nf=0;nf<hd1.num_frame;nf++) {
		if(pread(0,in1,nrc*sizeof(char))!=nrc*sizeof(char)
			|| read(fd,in2,nrc*sizeof(char))!=nrc*sizeof(char))
				perr("error in reading");
		for(nels=0;nels<nrc;nels++)
			in2[nels] ^= in1[nels];
		write(1,in2,nrc*sizeof(char));
	}
}
