/* $Id: symwin.c,v 1.14 90/05/09 22:11:13 pturner Exp Locker: pturner $
 *
 * symbols, legends, and error bars
 *
 */

#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "defines.h"
#include "objdefs.h"
#include "globals.h"

extern Frame main_frame;
extern Pixfont *winfont;

Frame define_symbols_frame;
Panel_item legend_x_panel;	/* needed in the canvas event proc */
Panel_item legend_y_panel;

static Panel define_symbols_panel;
static Panel_item toggle_symbols_item[MAXPLOT];
static Panel_item toggle_pen_item[MAXPLOT];
static Panel_item toggle_lines_item[MAXPLOT];
static Panel_item toggle_legends_item;
static Panel_item toggle_legendloc_item;
static Panel_item legend_str_panel[MAXPLOT];
static Panel_item legends_gap_item;
static Panel_item legends_len_item;
static Panel_item error_from_set;
static Panel_item error_to_set;
static Panel_item error_xy_item;

/*
 * remove all error bar sets
 */
static void clearall_errbar_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i;

    for (i = 0; i < maxplot; i++) {
	clearseterrbar(i);
    }
    drawgraph();
}

/*
 * remove error bars from a single set
 */
static void undefine_errbar_proc(item, event)
    Panel_item item;
    Event *event;
{
    int setn;

    setn = (int) panel_get_value(error_from_set);
    clearseterrbar(setn);
    drawgraph();
}

/*
 * associate a set as error bars to another set
 */
static void define_errbar_proc(item, event)
    Panel_item item;
    Event *event;
{
    int setfrom, setto, errbar_xy;

    setfrom = (int) panel_get_value(error_from_set);
    setto = (int) panel_get_value(error_to_set);
    errbar_xy = (int) panel_get_value(error_xy_item);
    makeseterrbar(setfrom, setto);
    seterrbarxy(setfrom, errbar_xy);
    update_status(setfrom);
    drawgraph();
}

/*
 * set the width (length) of all error bars
 */
static void errbar_length_proc(item, value, event)
    Panel_item item;
    Event *event;
    int value;
{
    errbarper = value / 50.0;
}

/*
 * define symbols for all sets
 */
static void define_symbols_proc(item, event)
    Panel_item item;
    Event *event;
{
    int sym, line, pen, i;

    for (i = 0; i < maxplot; i++) {

	sym = (int) panel_get_value(toggle_symbols_item[i]);
	pen = (int) panel_get_value(toggle_pen_item[i]);
	line = (int) panel_get_value(toggle_lines_item[i]);
	setplotsym(i, sym);
	setlinesym(i, line);
	setplotcolor(i, pen);
    }
    drawgraph();
}

/*
 * freshen up symbol items, generally after a parameter
 * file has been read
 */
updatesymbols(value)
    unsigned int value;
{
    panel_set_value(toggle_symbols_item[value], getsetplotsym(value));
    panel_set_value(toggle_pen_item[value], getsetcolor(value));
    panel_set_value(toggle_lines_item[value], getsetlinesym(value));
}

/*
 * legends
 */

static int firstrun = TRUE;
extern plotstr legstr[];

/*
 * freshen up legend items, generally after a parameter
 * file has been read
 */

updatelegendstr()
{
    int i;

    for (i = 0; i < maxplot; i++) {
	panel_set_value(legend_str_panel[i], legstr[i].s);
    }
}

updatelegends()
{
    int i;

    panel_set_value(toggle_legends_item, legendflag);
    sprintf(buf, "%lf", legx);
    panel_set_value(legend_x_panel, buf);
    sprintf(buf, "%lf", legy);
    panel_set_value(legend_y_panel, buf);
    panel_set_value(legends_gap_item, lgap - 1);
    panel_set_value(legends_len_item, llen - 1);
    panel_set_value(toggle_legendloc_item, legloctype);
    updatelegendstr();
}

/*
 * define legends for all sets
 */
void define_legends_proc(item, event)
    Panel_item item;
    Event *event;
{
    char val[80];
    int i;

    legendflag = (int) panel_get_value(toggle_legends_item);
    lgap = (int) panel_get_value(legends_gap_item) + 1;
    llen = (int) panel_get_value(legends_len_item) + 1;
    legloctype = (int) panel_get_value(toggle_legendloc_item);
    strcpy(val, panel_get_value(legend_x_panel));
    legx = atof(val);
    strcpy(val, panel_get_value(legend_y_panel));
    legy = atof(val);
    for (i = 0; i < maxplot; i++) {
	strcpy(legstr[i].s, panel_get_value(legend_str_panel[i]));
    }
    drawgraph();
}

/*
 * activate the legend location flag
 */
void legend_loc_proc()
{
    extern Cursor cursor_legloc;
    extern Canvas canvas;

    legloctype = (int) panel_get_value(toggle_legendloc_item);
    set_action(0);
    set_action(LEG_LOC);
    window_set(canvas, WIN_CURSOR, cursor_legloc, 0);
}

/*
 * close the symbols/legends popup
 */
static void define_symbols_done_proc()
{
    window_set(define_symbols_frame, WIN_SHOW, FALSE, 0);
}

/*
 * create the symbols/legends popup
 */
void define_symbols_popup()
{
    int i;

    if (firstrun && !legendflag) {
	for (i = 0; i < MAXPLOT; i++)
	    legstr[i].s[0] = '\0';
	firstrun = FALSE;
    }
    define_symbols_frame = window_create(main_frame, FRAME,
					 WIN_FONT, winfont,
					 FRAME_LABEL, "Symbols and legends",
					 FRAME_SHOW_LABEL, TRUE,
		      WIN_ERROR_MSG, "Couldn't create define_symbols_frame",
					 WIN_Y, 0,
					 0);
    define_symbols_panel = window_create(define_symbols_frame, PANEL,
					 WIN_FONT, winfont,
				WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
					 0);

    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
     panel_button_image(define_symbols_panel, "Define symbols", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      PANEL_NOTIFY_PROC, define_symbols_proc,
		      0);
    for (i = 0; i < maxplot; i++) {
	sprintf(buf, "Set %2d  Sym:", i);
	toggle_symbols_item[i] = panel_create_item(define_symbols_panel, PANEL_CYCLE,
						   PANEL_LABEL_STRING, buf,
						   PANEL_CHOICE_STRINGS,
						   "No symbol",
						   "Dot",
						   "Square",
						   "Triangle",
						   "Diamond",
						   "Open star",
						   "Plus",
						   "X",
						   "Star",
						   "Solid circle",
						   "Solid box",
						   "Solid triangle",
						   "Solid triangle left",
						   "Solid triangle",
						   "Solid triangle",
						   "Solid star",
						   "Impulse",
						   "Vertical line at X",
						   "Horizontal line at Y",
						   "Histogram X",
						   "Histogram Y",
						   "Stair step X",
						   "Stair step Y",
						   "Bar X",
						   "Bar Y",
						   "Location in set",
						   "Set #",
						   "Set #, location",
						   "Range of set",
						   "Line segments",
						   0,
						   PANEL_ITEM_X, ATTR_COL(1),
					      PANEL_ITEM_Y, ATTR_ROW(1 + i),
						   0);
	toggle_pen_item[i] = panel_create_item(define_symbols_panel, PANEL_CYCLE,
					       PANEL_LABEL_STRING, "Pen:",
					       PANEL_CHOICE_STRINGS,
					       "No pen",
					       "Pen 1",
					       "Pen 2",
					       "Pen 3",
					       "Pen 4",
					       "Pen 5",
					       "Pen 6",
					       "Pen 7",
					       "Pen 8", 0,
					       PANEL_ITEM_X, ATTR_COL(38),
					       PANEL_ITEM_Y, ATTR_ROW(1 + i),
					       0);
	toggle_lines_item[i] = panel_create_item(define_symbols_panel, PANEL_CYCLE,
						 PANEL_LABEL_STRING, "Line:",
						 PANEL_CHOICE_STRINGS,
						 "No line",
						 "Solid",
						 "Dotted",
						 "Dashed",
						 "Long Dashed",
						 "Dot-dashed", 0,
						 PANEL_ITEM_X, ATTR_COL(58),
					      PANEL_ITEM_Y, ATTR_ROW(1 + i),
						 0);
    }
    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
      panel_button_image(define_symbols_panel, "Define legend", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(17),
		      PANEL_NOTIFY_PROC, define_legends_proc,
		      0);
    toggle_legendloc_item = panel_create_item(define_symbols_panel, PANEL_CYCLE,
					      PANEL_ITEM_X, ATTR_COL(25),
					      PANEL_ITEM_Y, ATTR_ROW(17),
				       PANEL_LABEL_STRING, "Location type:",
					      PANEL_CHOICE_STRINGS,
					      "World coordinates",
					      "Viewport coordinates",
					      0, 0);
    for (i = 0; i < maxplot; i++) {
	sprintf(buf, "Set %2d  legend:", i);
	legend_str_panel[i] = panel_create_item(define_symbols_panel, PANEL_TEXT,
						PANEL_ITEM_X, ATTR_COL(1),
					     PANEL_ITEM_Y, ATTR_ROW(18 + i),
						PANEL_LABEL_STRING, buf,
					 PANEL_VALUE_DISPLAY_LENGTH, 50, 0);
    }
    legends_gap_item = panel_create_item(define_symbols_panel, PANEL_CYCLE,
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(33),
					 PANEL_LABEL_STRING, "Lgap:",
					 PANEL_CHOICE_STRINGS,
					 "1",
					 "2",
					 "3",
					 "4",
					 0, 0);
    legends_len_item = panel_create_item(define_symbols_panel, PANEL_CYCLE,
					 PANEL_ITEM_X, ATTR_COL(12),
					 PANEL_ITEM_Y, ATTR_ROW(33),
					 PANEL_LABEL_STRING, "Llen:",
					 PANEL_CHOICE_STRINGS,
					 "1",
					 "2",
					 "3",
					 "4",
					 "5",
					 "6",
					 "7",
					 "8",
					 0, 0);
    legend_x_panel = panel_create_item(define_symbols_panel, PANEL_TEXT,
				       PANEL_ITEM_X, ATTR_COL(1),
				       PANEL_ITEM_Y, ATTR_ROW(34),
				       PANEL_LABEL_STRING, "X location:",
				       PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    legend_y_panel = panel_create_item(define_symbols_panel, PANEL_TEXT,
				       PANEL_ITEM_X, ATTR_COL(1),
				       PANEL_ITEM_Y, ATTR_ROW(35),
				       PANEL_LABEL_STRING, "Y location:",
				       PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    toggle_legends_item = panel_create_item(define_symbols_panel, PANEL_CYCLE,
					    PANEL_LABEL_STRING, "Legends:",
					    PANEL_CHOICE_STRINGS,
					    "OFF",
					    "ON",
					    0,
					    PANEL_ITEM_X, ATTR_COL(1),
					    PANEL_ITEM_Y, ATTR_ROW(36),
					    0);
    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(define_symbols_panel, "Define location with mouse", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(37),
		      PANEL_NOTIFY_PROC, legend_loc_proc,
		      0);

    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	       panel_button_image(define_symbols_panel, "Done", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(39),
		      PANEL_NOTIFY_PROC, define_symbols_done_proc,
		      0);
    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
    panel_button_image(define_symbols_panel, "Define error bar", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(30),
		      PANEL_ITEM_Y, ATTR_ROW(33),
		      PANEL_NOTIFY_PROC, define_errbar_proc,
		      0);
    error_from_set = panel_create_item(define_symbols_panel,
				       PANEL_CYCLE,
				 PANEL_LABEL_STRING, "Error bars from set:",
				       PANEL_CHOICE_STRINGS,
		       "Set 0", "Set 1", "Set 2", "Set 3", "Set 4", "Set 5",
		     "Set 6", "Set 7", "Set 8", "Set 9", "Set 10", "Set 11",
				       "Set 12", "Set 13", "Set 14", 0,
				       PANEL_ITEM_X, ATTR_COL(30),
				       PANEL_ITEM_Y, ATTR_ROW(34),
				       0);
    error_to_set = panel_create_item(define_symbols_panel,
				     PANEL_CYCLE,
				     PANEL_LABEL_STRING, "To set:",
				     PANEL_CHOICE_STRINGS,
		       "Set 0", "Set 1", "Set 2", "Set 3", "Set 4", "Set 5",
		     "Set 6", "Set 7", "Set 8", "Set 9", "Set 10", "Set 11",
				     "Set 12", "Set 13", "Set 14", 0,
				     PANEL_ITEM_X, ATTR_COL(60),
				     PANEL_ITEM_Y, ATTR_ROW(34),
				     0);
    error_xy_item = panel_create_item(define_symbols_panel, PANEL_CYCLE,
				      PANEL_LABEL_STRING, "Error bars on:",
				      PANEL_CHOICE_STRINGS,
				      "Y top and bottom",
				      "X left and right",
				      "Y top only",
				      "X left only",
				      "Y bottom only",
				      "X right only",
				      0,
				      PANEL_ITEM_X, ATTR_COL(30),
				      PANEL_ITEM_Y, ATTR_ROW(35),
				      0);
    panel_create_item(define_symbols_panel, PANEL_SLIDER,
		      PANEL_ITEM_X, ATTR_COL(30),
		      PANEL_ITEM_Y, ATTR_ROW(39),
		      PANEL_LABEL_STRING, "Error bar length %",
		      PANEL_VALUE, 50,
		      PANEL_MIN_VALUE, 1,
		      PANEL_MAX_VALUE, 100,
		      PANEL_NOTIFY_PROC, errbar_length_proc,
		      0);
    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(define_symbols_panel, "Undefine error bar", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(30),
		      PANEL_ITEM_Y, ATTR_ROW(36),
		      PANEL_NOTIFY_PROC, undefine_errbar_proc,
		      0);
    panel_create_item(define_symbols_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(define_symbols_panel, "Clear all error bars", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(30),
		      PANEL_ITEM_Y, ATTR_ROW(37),
		      PANEL_NOTIFY_PROC, clearall_errbar_proc,
		      0);
    window_fit(define_symbols_panel);
    window_fit(define_symbols_frame);
    for (i = 0; i < maxplot; i++) {
	updatesymbols(i);
    }
    updatelegends();
}
