/* $Id: ptswin.c,v 1.22 90/04/13 20:33:49 pturner Exp Locker: pturner $
 *
 * edit points, clip points to window, etc.
 *
 */

#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "globals.h"
#include "defines.h"

#define define_select_set_panel(panel,x,y,panelname,panel_item) \
				panel_item=panel_create_item( panel,\
				PANEL_CYCLE,\
				PANEL_ITEM_X,x,\
				PANEL_ITEM_Y,y,\
				PANEL_LABEL_STRING,panelname,\
	 			PANEL_CHOICE_STRINGS,\
			"Set 0", "Set 1", "Set 2", "Set 3", "Set 4", "Set 5",\
			"Set 6", "Set 7", "Set 8", "Set 9", "Set 10", "Set 11",\
			"Set 12", "Set 13", "Set 14", 0, 0 );

void drawgraph();
void define_points_popup();

extern Pixfont *winfont;
extern Panel_item help_item;

extern Window main_frame, main_panel;
Frame points_frame;
static Panel points_panel;
Panel_item locate_point_item;
Panel_item clipinset_item;
Panel_item cliptoset_item;

static void do_find_proc();
static void do_move_proc();
static void do_del_proc();
static void do_extract_proc();

/*
 * locate a point and the set the point is in
 */
findpoint(x, y, xs, ys, setno, loc)
    double x, y;
    double *xs, *ys;
    int *setno, *loc;
{
    double dx = xg2 - xg1, dy = yg2 - yg1, *getx(), *gety(), *xtmp, *ytmp, tmp, tmin = 1.0e307;
    int i, j, len;

    *setno = -1;
    for (i = 0; i < maxplot; i++) {
	if (isactive(i)) {
	    xtmp = getx(i);
	    ytmp = gety(i);
	    len = getsetlength(i);
	    for (j = 0; j < len; j++) {
		if ((tmp = hypot((x - xtmp[j]) / dx, (y - ytmp[j]) / dy)) < tmin) {
		    *setno = i;
		    *loc = j + 1;
		    *xs = xtmp[j];
		    *ys = ytmp[j];
		    tmin = tmp;
		}
	    }
	}
    }
}

/*
 * delete the point pt in setno
 */
del_point(setno, pt)
    int setno, pt;
{
    int i, len, n;
    double *getx(), *gety(), *x, *y, *xtmp, *ytmp;

    x = getx(setno);
    y = gety(setno);
    len = getsetlength(setno);
    xtmp = (double *) calloc(len, sizeof(double));
    ytmp = (double *) calloc(len, sizeof(double));
    if (xtmp == NULL || ytmp == NULL) {
	cxfree(xtmp);
	cxfree(ytmp);
	errwin("Not enough memory for delete points");
	return;
    }
    n = 0;
    for (i = 0; i < getsetlength(setno); i++) {
	if (i != pt - 1) {
	    xtmp[n] = x[i];
	    ytmp[n] = y[i];
	    n++;
	}
    }
    setlength(setno, getsetlength(setno) - 1);
    x = getx(setno);
    y = gety(setno);
    for (i = 0; i < getsetlength(setno); i++) {
	x[i] = xtmp[i];
	y[i] = ytmp[i];
    }
    cxfree(xtmp);
    cxfree(ytmp);
    updatesetminmax(setno);
    drawgraph();
}

/*
 * activate the find point item in the canvas event proc
 */
static void do_find_proc(item, event)
    Panel_item item;
    Event *event;
{
    extern Cursor cursor_locpoint;
    extern Canvas canvas;

    set_action(0);
    /*
     * panel_set_value(help_item, "Position cursor near point and press left
     * mouse button");
     */
    set_action(FIND_POINT);
    window_set(canvas, WIN_CURSOR, cursor_locpoint, 0);
}

/*
 * activate the delete point item in the canvas event proc
 */
static void do_del_proc(item, event)
    Panel_item item;
    Event *event;
{
    extern Cursor cursor_delpoint;
    extern Canvas canvas;

    set_action(0);
    set_action(DEL_POINT);
    window_set(canvas, WIN_CURSOR, cursor_delpoint, 0);
}

/*
 * see if (x,y) lies inside the plot
 */
static int inbounds(x, y)
    double x, y;
{
    return ((x >= xg1 && x <= xg2) && (y >= yg1 && y <= yg2));
}

/*
 * clip points in a set inside or outside the window
 * depending on flag
 */
static void clip_set(setno, itype)
    int setno, itype;
{
    int j, n, len, flag;
    double *getx(), *gety(), *x, *y, *xtmp, *ytmp;

    if (isactive(setno) && (iserrbar(setno) < 0)) {
	n = 0;
	x = getx(setno);
	y = gety(setno);
	len = getsetlength(setno);
	xtmp = (double *) calloc(len, sizeof(double));
	ytmp = (double *) calloc(len, sizeof(double));
	if (xtmp == NULL || ytmp == NULL) {
	    errwin("Not enough memory for clip points");
	    cxfree(xtmp);
	    cxfree(ytmp);
	    return;
	}
	for (j = 0; j < len; j++) {
	    if (itype) {
		flag = inbounds(x[j], y[j]);
	    } else {
		flag = !inbounds(x[j], y[j]);
	    }

	    if (flag) {
		xtmp[n] = x[j];
		ytmp[n] = y[j];
		n++;
	    }
	}
	if (n == 0)
	    killset(setno);
	else {
	    setlength(setno, n);
	    x = getx(setno);
	    y = gety(setno);
	    for (j = 0; j < n; j++) {
		x[j] = xtmp[j];
		y[j] = ytmp[j];
	    }
	    updatesetminmax(setno);
	}
	update_status(setno);
	cxfree(xtmp);
	cxfree(ytmp);
    }
}

static void do_clip_to_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i;

    for (i = 0; i < maxplot; i++) {
	clip_set(i, 1);
    }
    drawgraph();
}

static void do_clip_in_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i;

    for (i = 0; i < maxplot; i++) {
	clip_set(i, 0);
    }
    drawgraph();
}

static void do_clip_toset_proc(item, event)
    Panel_item item;
    Event *event;
{
    int setno;

    setno = (int) panel_get_value(cliptoset_item);
    clip_set(setno, 1);
    drawgraph();
}

static void do_clip_inset_proc(item, event)
    Panel_item item;
    Event *event;
{
    int setno;

    setno = (int) panel_get_value(clipinset_item);
    clip_set(setno, 0);
    drawgraph();
}

static void points_done_proc()
{
    window_set(points_frame, WIN_SHOW, FALSE, 0);
}

void define_points_popup()
{
    points_frame = window_create(main_frame, FRAME,
				 WIN_Y, 50,
				 WIN_FONT, winfont,
				 FRAME_LABEL, "Edit points",
				 FRAME_SHOW_LABEL, TRUE,
			      WIN_ERROR_MSG, "Couldn't create points_frame",
				 0);
    points_panel = window_create(points_frame, PANEL,
				 WIN_FONT, winfont,
				 WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
				 0);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		 panel_button_image(points_panel, "Find point", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(1),
		      PANEL_NOTIFY_PROC, do_find_proc,
		      0);
    locate_point_item = panel_create_item(points_panel, PANEL_TEXT,
			      PANEL_LABEL_STRING, "Set, location, (X, Y): ",
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(2),
					  PANEL_VALUE_DISPLAY_LENGTH, 40, 0);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	       panel_button_image(points_panel, "Delete point", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(5),
		      PANEL_NOTIFY_PROC, do_del_proc,
		      0);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
      panel_button_image(points_panel, "Clip points to window", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(7),
		      PANEL_NOTIFY_PROC, do_clip_to_proc,
		      0);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	 panel_button_image(points_panel, "Clip set to window", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(8),
		      PANEL_NOTIFY_PROC, do_clip_toset_proc,
		      0);
    define_select_set_panel(points_panel, ATTR_COL(30), ATTR_ROW(8), "Clip:", cliptoset_item);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
      panel_button_image(points_panel, "Clip points in window", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(9),
		      PANEL_NOTIFY_PROC, do_clip_in_proc,
		      0);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	 panel_button_image(points_panel, "Clip set in window", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(10),
		      PANEL_NOTIFY_PROC, do_clip_inset_proc,
		      0);
    define_select_set_panel(points_panel, ATTR_COL(30), ATTR_ROW(10), "Clip:", clipinset_item);

    panel_create_item(points_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
		      panel_button_image(points_panel, "Done", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(11),
		      PANEL_NOTIFY_PROC, points_done_proc,
		      0);
    window_fit(points_panel);
    window_fit(points_frame);
}
