/*****************************************************************************/
/* 				  symbol.c				     */
/*===========================================================================*/
/* 									     */
/*	symbol.c  describes the three functions called by lex to generate    */
/*	symbols.							     */
/*									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/
#include <math.h>
#include "runtime.h"
#include "symbol.h"
extern	char	yytext[] ;
extern	int	yyleng ;
sym_t
  * create_id ( )
{
	register sym_t	*tmp ;

	tmp = (sym_t *)malloc(sizeof(sym_t)) ;
	if( tmp==0 ) {
	    yyerror("malloc failed in create_id") ;
	    exit(-1) ;
	}
	tmp->type = S_ID ;
	tmp->u.idval = (char *)malloc(yyleng+1) ;
	strcpy(tmp->u.idval,yytext) ;
	return(tmp) ;
}
sym_t
  * create_str ( )
{
	register sym_t	*tmp ;

	tmp = (sym_t *)malloc(sizeof(sym_t)) ;
	if( tmp==0 ) {
	    yyerror("malloc failed in create_str") ;
	    exit(-1) ;
	}
	tmp->type = S_ID ;
	tmp->u.idval = (char *)malloc(yyleng-2+1) ;
	yytext[yyleng-1] = '\0' ;
	strcpy(tmp->u.idval,&yytext[1]) ;
	return(tmp) ;
}
sym_t
  * create_num ( )
{
	register sym_t	*tmp ;

	tmp = (sym_t *)malloc(sizeof(sym_t)) ;
	tmp->type = S_NUM ;
	if( tmp==0 ) {
	    yyerror("malloc failed in create_num") ;
	    exit(-1) ;
	}
	tmp->u.numval = atof(yytext) ;
	return(tmp) ;
}
