/*****************************************************************************/
/* 				 runtime.h				     */
/*===========================================================================*/
/* 									     */
/*	runtime.h describes the data structures built by the parser for	     */
/*	the execution module.						     */
/* 									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

typedef	int	frm_t ;			       /* frame number is an integer */

#define	POINT_S	struct point_s
typedef POINT_S {
	double	samp ;
	POINT_S	*next ;
} point_t ;


typedef	double	*arg_t ;		 /* a pointer to an array of doubles */

#define INTER_S	struct inter_s
typedef INTER_S	{
	frm_t	start ;			     /* frame to start this interval */
	arg_t	(*init)() ;
	double	(*calc)() ;
	union {
	    arg_t	params ;
	    point_t	*ptlist ;
	} u ;
	INTER_S	*next ;
} inter_t ;

typedef	struct {
	char	*source ;		       /* source file for ray tracer */
	double	runtime ;		      /* length in seconds for scene */
	double	speed ;				   /* frames/second of scene */
} dblock_t ;

#define TRIG_S	struct trig_s
typedef	TRIG_S {
	char	*trigname ;				  /* name of trigger */
	frm_t	trigtime ;	 /* trigger time converted into frame number */
	TRIG_S	*next ;
} trig_t ;

#define	VAR_S	struct var_s
typedef VAR_S {
	char	*vname ;				 /* name of variable */
	inter_t	*intlist ;	      /* list of intervals for this variable */
	inter_t	*currint ;
	double	prev_value ;	/* value of previous frame */
	VAR_S	*next ;
} var_t ;

#define PROC_S struct proc_s
typedef PROC_S {
	char	*procname ;
	dblock_t desc ;
	trig_t	*trig_head ;
	var_t	*var_head ;
	frm_t	last_frame ;  /* previous frame (calculated) */
	PROC_S	*next ;
} proc_t ;
