/*======================================================================
                    I N P U T . M 
                    doc: Fri Sep 13 12:51:55 1991
                    dlm: Wed Nov 20 15:12:52 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 84 71 FALSE 0 0 72 2 2 ofnI
======================================================================*/

#include	<stdio.h>
#include	<strings.h>
#include	"types.h"
#include	"world.h"

/*
  NOTE:
	no sscanf() on maspar. Besides, the paramlist in inputTri is too
	large for mpl_cc.
	Solution: atof!!!!
*/

double strtod();

#define	TRIFORM 			/* Format of Triangle */ \
"%d %d %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf"
/*     Point A     Normal A    Point B     Normal B    Point C     Normal C  */

#define	LIGFORM 			/* Format of LightSourceType */ \
	"%d %lf %lf %lf %lf %lf %lf %lf %lf %lf"
/*    local ambient     diffuse     specular  */

#define MATFORM				/* Format of Material */ \
"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf"
/*emittant   ambient     diffuse     specular    specularity*/

#define FGETS(buf,mlen,fp)		/* no EoF allowed */ \
	if (fgets(buf,mlen,fp) == NULL) { \
		fprintf(stderr,"fgets: Error EoF encountered!\n"); \
		exit(1); \
	} \

#define startS()	pos = buf
#define	sBool(var)	var = (Bool)strtol(pos,&pos,10)
#define sInt(var)	var = (int)strtol(pos,&pos,10)
#define sFp(var)	var = strtod(pos,&pos)

/* #define	TRI(obj,tri)			/* access to triangle  \ */
/*	world.oList[obj].tList[tri] */
#define TRI(obj,tri) tmp

#define toPlural(idx,field) \
	proc[idx].pWorld.t.field = tmp.field

void inputTri(baseName)			/* read Triangle file */
char baseName[];
{
	char 	fn[100],buf[255],*pos;
	int	obj,tri,bounded;
	FILE	*fp;
	STri	tmp;

	strcpy(fn,baseName);
	strcat(fn,".tri");
	fp = fopen(fn,"r");
	if (fp == NULL) {
		fprintf(stderr,"inputTri: Error opening %s!\n",fn);
		exit(1);
	}
	
	FGETS(buf,255,fp);		/* get # of objects */
/*	sscanf(buf,"%d",&world.nObj); */
	startS(); sInt(world.nObj);
/*	world.oList = (Obj *)malloc(world.nObj*sizeof(Obj)); */

	for (obj = 0; obj < world.nObj; obj++) {
	    FGETS(buf,255,fp);	/* get # of triangles */
/*	    sscanf(buf,"%d",&world.oList[obj].nTri); */
/*	    startS(); sInt(world.oList[obj].nTri); */
	    startS(); sInt(world.nTri);
/*	    world.oList[obj].tList =
		(Stri *)malloc(world.oList[obj].nTri*sizeof(Stri)); */

/*	    for (tri = 0; tri < world.oList[obj].nTri; tri++) { */
	    for (tri = 0; tri < world.nTri; tri++) {
	    	if ((tri % 100) == 0) { putchar('%'); fflush(stdout); }
	    	FGETS(buf,255,fp);	/* get simple triangle */
/*	    	sscanf(buf,TRIFORM,	   would be nice
	    	    &TRI(obj,tri).matId,
	    	    &bounded,
	    	    &TRI(obj,tri).v[PA][VX],
	    	    &TRI(obj,tri).v[PA][VY],
	    	    &TRI(obj,tri).v[PA][VZ],
	    	    &TRI(obj,tri).n[PA][VX],
	    	    &TRI(obj,tri).n[PA][VY],
	    	    &TRI(obj,tri).n[PA][VZ],
	    	    &TRI(obj,tri).v[PB][VX],
	    	    &TRI(obj,tri).v[PB][VY],
	    	    &TRI(obj,tri).v[PB][VZ],
	    	    &TRI(obj,tri).n[PB][VX],
	    	    &TRI(obj,tri).n[PB][VY],
	    	    &TRI(obj,tri).n[PB][VZ],
	    	    &TRI(obj,tri).v[PC][VX],
	    	    &TRI(obj,tri).v[PC][VY],
	    	    &TRI(obj,tri).v[PC][VZ],
	    	    &TRI(obj,tri).n[PC][VX],
	    	    &TRI(obj,tri).n[PC][VY],
	    	    &TRI(obj,tri).n[PC][VZ]); 
		TRI(obj,tri).bounded = (Bool)bounded; */
		startS();
	    	sInt(TRI(obj,tri).matId);
	    	sBool(TRI(obj,tri).bounded);
	    	sFp(TRI(obj,tri).v[PA][VX]);
	    	sFp(TRI(obj,tri).v[PA][VY]);
	    	sFp(TRI(obj,tri).v[PA][VZ]);
	    	sFp(TRI(obj,tri).n[PA][VX]);
	    	sFp(TRI(obj,tri).n[PA][VY]);
	    	sFp(TRI(obj,tri).n[PA][VZ]);
	    	sFp(TRI(obj,tri).v[PB][VX]);
	    	sFp(TRI(obj,tri).v[PB][VY]);
	    	sFp(TRI(obj,tri).v[PB][VZ]);
	    	sFp(TRI(obj,tri).n[PB][VX]);
	    	sFp(TRI(obj,tri).n[PB][VY]);
	    	sFp(TRI(obj,tri).n[PB][VZ]);
	    	sFp(TRI(obj,tri).v[PC][VX]);
	    	sFp(TRI(obj,tri).v[PC][VY]);
	    	sFp(TRI(obj,tri).v[PC][VZ]);
	    	sFp(TRI(obj,tri).n[PC][VX]);
	    	sFp(TRI(obj,tri).n[PC][VY]);
	    	sFp(TRI(obj,tri).n[PC][VZ]);
	    	toPlural(tri,matId);
	    	toPlural(tri,bounded);
	    	toPlural(tri,v[PA][VX]);
	    	toPlural(tri,v[PA][VY]);
	    	toPlural(tri,v[PA][VZ]);
	    	toPlural(tri,n[PA][VX]);
	    	toPlural(tri,n[PA][VY]);
	    	toPlural(tri,n[PA][VZ]);
	    	toPlural(tri,v[PB][VX]);
	    	toPlural(tri,v[PB][VY]);
	    	toPlural(tri,v[PB][VZ]);
	    	toPlural(tri,n[PB][VX]);
	    	toPlural(tri,n[PB][VY]);
	    	toPlural(tri,n[PB][VZ]);
	    	toPlural(tri,v[PC][VX]);
	    	toPlural(tri,v[PC][VY]);
	    	toPlural(tri,v[PC][VZ]);
	    	toPlural(tri,n[PC][VX]);
	    	toPlural(tri,n[PC][VY]);
	    	toPlural(tri,n[PC][VZ]);
	    	proc[tri].pWorld.triSet = 1;
	    }
	}
}
			
void inputLig(baseName)			/* read LightSourceType file */
char baseName[];
{
	char 	fn[100],buf[255],*pos;
	int	lst,local;
	FILE	*fp;

	strcpy(fn,baseName);
	strcat(fn,".lig");
	fp = fopen(fn,"r");
	if (fp == NULL) {
		fprintf(stderr,"inputTri: Error opening %s!\n",fn);
		exit(1);
	}
	
	FGETS(buf,255,fp);		/* get global ambient light */
/*	sscanf(buf,"%lf %lf %lf",
/*		&world.ambient[CR],
		&world.ambient[CG],
		&world.ambient[CB]); */
	startS();
	sFp(world.ambient[CR]);
	sFp(world.ambient[CG]);
	sFp(world.ambient[CB]);
		
	FGETS(buf,255,fp);		/* get # of LSTs */
/*	sscanf(buf,"%d",&world.nLST); */
	startS(); sInt(world.nLST);
	world.lstList = (LST *)malloc(world.nLST*sizeof(LST));

	for (lst = 0; lst < world.nLST; lst++) {
	    	FGETS(buf,255,fp);	/* get LST */
/*	    	sscanf(buf,LIGFORM,
	    	    &local,
	    	    &world.lstList[lst].ambient[CR],
	    	    &world.lstList[lst].ambient[CG],
	    	    &world.lstList[lst].ambient[CB],
	    	    &world.lstList[lst].diffuse[CR],
	    	    &world.lstList[lst].diffuse[CG],
	    	    &world.lstList[lst].diffuse[CB],
	    	    &world.lstList[lst].specular[CR],
	    	    &world.lstList[lst].specular[CG],
	    	    &world.lstList[lst].specular[CB]);
		world.lstList[lst].local = (Bool)local; */
		startS();
   		sBool(world.lstList[lst].local);
		sFp(world.lstList[lst].ambient[CR]);
		sFp(world.lstList[lst].ambient[CG]);
		sFp(world.lstList[lst].ambient[CB]);
		sFp(world.lstList[lst].diffuse[CR]);
		sFp(world.lstList[lst].diffuse[CG]);
		sFp(world.lstList[lst].diffuse[CB]);
		sFp(world.lstList[lst].specular[CR]);
		sFp(world.lstList[lst].specular[CG]);
		sFp(world.lstList[lst].specular[CB]);
	}
}
			

void inputMat(baseName)			/* read Material file */
char baseName[];
{
	char 	fn[100],buf[255],*pos;
	int	lst,local;
	FILE	*fp;

	strcpy(fn,baseName);
	strcat(fn,".mat");
	fp = fopen(fn,"r");
	if (fp == NULL) {
		fprintf(stderr,"inputMat: Error opening %s!\n",fn);
		exit(1);
	}
	
	FGETS(buf,255,fp);		/* get # of Mats */
/*	sscanf(buf,"%d",&world.nMat); */
	startS(); sInt(world.nMat);
	world.nMat++;			/* Reserve 0!!! */
	world.mList = (Material *)malloc(world.nMat*sizeof(Material));

	for (lst = 1; lst < world.nMat; lst++) {
	    	FGETS(buf,255,fp);	/* get Mat */
/*	    	sscanf(buf,MATFORM,
	    	    &world.mList[lst].emittant[CR],
	    	    &world.mList[lst].emittant[CG],
	    	    &world.mList[lst].emittant[CB],
	    	    &world.mList[lst].ambient[CR],
	    	    &world.mList[lst].ambient[CG],
	    	    &world.mList[lst].ambient[CB],
	    	    &world.mList[lst].diffuse[CR],
	    	    &world.mList[lst].diffuse[CG],
	    	    &world.mList[lst].diffuse[CB],
	    	    &world.mList[lst].specular[CR],
	    	    &world.mList[lst].specular[CG],
	    	    &world.mList[lst].specular[CB],
	    	    &world.mList[lst].specularity); */
	    	startS();
	    	sFp(world.mList[lst].emittant[CR]);
	    	sFp(world.mList[lst].emittant[CG]);
	    	sFp(world.mList[lst].emittant[CB]);
	    	sFp(world.mList[lst].ambient[CR]);
	    	sFp(world.mList[lst].ambient[CG]);
	    	sFp(world.mList[lst].ambient[CB]);
	    	sFp(world.mList[lst].diffuse[CR]);
	    	sFp(world.mList[lst].diffuse[CG]);
	    	sFp(world.mList[lst].diffuse[CB]);
	    	sFp(world.mList[lst].specular[CR]);
	    	sFp(world.mList[lst].specular[CG]);
	    	sFp(world.mList[lst].specular[CB]);
	    	sFp(world.mList[lst].specularity);
	}
}
			

	

