/*
 * Copyright (C) 1992 WIlfried Koch, Palanterstr. 46, D-5000 Koeln 41 (Germany)
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 * Initial version.
*/
#include "rrconfig.h"
#define Float double



/***************        RPC relating headers *************************/
#ifdef RPC_HDR
%#ifndef RRRPC_H
%#define RRRPC_H
%#include <rrconfig.h>
%#include <rpc/types.h>
%#include <time.h>
%typedef char *nm;
%bool_t xdr_nm();
%bool_t sendrpcargs();
#endif

#ifdef ONCRPC
struct RRConnection {
	nm progname;
        nm clientname;                  /**  Client's name              **/
        u_long  clientno;               /**  Client's prgNo             **/

        nm servername;
        u_long  servno;
	int transport;
	bool busy;

};
#endif
struct rpc_Pixel {
        u_char r;
        u_char g;
        u_char b;
        u_char alpha;
};


struct RRreq {
	u_long RRID;
	RRConnection	connect;
	int 	  	frame;
	int 	  	minx;
	int 	  	maxx;
	int 		miny;
	int 		maxy;
	int 		size;
	int 	        sequence;
	};

struct rpc_square {
        rpc_Pixel pixels<>;
	RRreq	  req;
};
struct rpc_op_square {
        opaque pixels<>;
	RRreq	  req;
};

#ifdef RPC_HDR
%#endif
#endif


#ifdef RPC_XDR
%#include <limits.h>
%/************** custom string filter when char* points to zero *******/
%bool_t xdr_nm(xdr,objp)
%        XDR *xdr;
%        nm  *objp;
%{
%        bool_t a;
%        a=(bool_t)*objp;
%         if(!xdr_bool(xdr,&a))
%            return(FALSE);
%         if(!a)
%            return (TRUE);
%         if(xdr->x_op==XDR_DECODE){
%               *objp=NULL;
%               }
%         return xdr_string(xdr,objp,ULONG_MAX);
%}
%
#endif
program REMOTERENDER {
		version REMOTERENDERVERS{
			int  RRMARSHALL(RRarg)		 =1;
			int  RRBLOCKED(void)		 =2;
			int  RRREQUEST(RRreq)		 =3;
			int  RRFREE(u_long)		 =4;
			string RRINFO(void)		 =5;
			void RRINITSERVICE(RRConnection) =6;
		} = 1;
	} = 0x25000000;

program REMOTERENDERCALLBACK{
		version  REMOTERENDERCALLBACKVERS{
			void RRSQUARE (rpc_square)       =1;
			void RRNEWSERVICE (RRConnection) =2;
		}=1;
}	= 0x40000000; /* CALLBACK */

