#include <stdio.h>
#include <math.h>
#include "rtd.h"
#include "extern.h"
#include "macros.h"

g_bal (df)
FILE * df;
{
    int     i;
    double  x,
            y,
            z,
            r,
            ior,
            rfr,
            rfl,
            dif,
            amb;
    char object_type;
    char throw_away[120];
    struct vector vec1, vec2, vec3, v1, v2;
    int num_obj = 1;

    while (fscanf(df, "%c", &object_type) != EOF)
      {
      if ((object_type == SPHERE_TYPE) || (object_type == FACET_TYPE))
        {
        data = (struct object_data *) malloc (sizeof (struct object_data));
        data->type = object_type;
        if (object_type == SPHERE_TYPE)
          {
          fscanf(df, "%F %F %F %F %F %F %F %F %F\n",
            &data->object.sphere.cent.x,
            &data->object.sphere.cent.y,
            &data->object.sphere.cent.z,
            &data->object.sphere.rad,
            &data->ior, &data->rfr, &data->rfl, &data->dif, &data->amb);
          data->id = num_obj;
          num_obj++;
          }
        else
          if (object_type == FACET_TYPE) 
            {
            fscanf(df, "%F %F %F %F %F", &data->ior, &data->rfr, &data->rfl, 
                   &data->dif, &data->amb);
            for (i = 0; i < 3; i++)
              {
              fscanf(df, "%F %F %F", 
                     &FACET_COMP(x, i),
                     &FACET_COMP(y, i),
                     &FACET_COMP(z, i));
              }
            fscanf(df, "\n");
            MV(FACET_COMP(x, 0), FACET_COMP(y, 0), FACET_COMP(z, 0), vec1);
            MV(FACET_COMP(x, 1), FACET_COMP(y, 1), FACET_COMP(z, 1), vec2);
            MV(FACET_COMP(x, 2), FACET_COMP(y, 2), FACET_COMP(z, 2), vec3);
            SV(v1, vec1, vec2);
            SV(v2, vec2, vec3);
            CROSS_PRODUCT(data->object.facet.normal, v1, v2);
            data->object.facet.normal.l = LEN(data->object.facet.normal);
            data->object.facet.normal.xzl = XZL(data->object.facet.normal);
            data->id = num_obj;
            num_obj++;
       
          }
        make_seads(data);
        } /* end of if */
      else
        if (object_type == '\*')   /* comment line in data */
          fscanf(df, "%s\n", throw_away);
        else /* error in type */
          {
          printf("ERROR in object type %c\n", object_type);
          fscanf(df, "%s\n", throw_away);
          }; /* end of else */
    }; /* end of while */

}  /* end of g_bal */

