#define BACKGROUND 0
#define LEDON      1
#define LEDOFF     2

int counter(double dispnumber, double exponent, double
            modulus, double digwidth, double digheight,
            double digspacing, int numdigits, int
            numdecimals, double X, double Y)
{
  double num;
  double xp,yp;
  int maxplace,digit,segment,led_on,negflag,i,inum;

  double xf,yf;

/* Strategy: first find what LED element we're nearest. Next
   find if we're in any LED segments. Finally, determine if
   that segment is lit. */

  yp= Y+digheight*0.5;
  yf=yp/digheight;
  if (yf<0.0 || yf>1.0) return(BACKGROUND); /* way above or
                                               below LEDS */
  xp=X+(digwidth+(numdigits-1)*digspacing)*0.5;
  if (xp<0.0 || xp>(numdigits-1)*digspacing+digwidth*1.15)
     return(BACKGROUND); 

  digit=floor(xp/digspacing); /* closest digit! */
  xf=(xp-digit*digspacing)/digwidth;
  if (xf>1.15) return(BACKGROUND); /* beyond end of digit*/
  
      /*   1 33333 6
           1       6
           1       6
           1       6
            4444444 
           2       7        
           2       7        
           2       7 88       
           2 55555 7 88       
           
           possible LED segments
           */
  
  if (xf<0.16666666) /* left hand, 1 or 2 */
    {
      if (yf>0.525) segment=1;
      else if (yf<.475) segment=2;
      else return(BACKGROUND);
    }
  else if (xf>0.83333333)
    {
      if (xf<1.0)
        {
          if (yf>0.525) segment=6;
          else if (yf<.475) segment=7;
          else return(BACKGROUND);              
        }
      else
        {
          if (xf<1.05 || yf>0.10) return(BACKGROUND);
          segment=8;
        }
    }      
  
  else if (xf<.25 || xf>.75) return(BACKGROUND);
  else if (yf<.1) segment=5;
  else if (yf>0.90) segment=3;
  else if (yf>.45&&yf<.55) segment=4;
  else return(BACKGROUND);
  if (segment<1) return(BACKGROUND);

  /* we're in a segment, now tell us if it's lit! */

  num=dispnumber;
  while (exponent>0) 
    {
      exponent--;
      num*=10.0;
    }

  while (exponent<0) 
    {
      exponent++;
      num*=.1;
    }
  if (modulus>=0.001)  
     num-=(modulus*floor(num/modulus));
  if (num<0.0)
    {
      negflag=1;
      num= - num;
    }
  else negflag=0;
  
  inum=floor(num+0.5); /* now integer */
  maxplace=1;
  
  while (inum>=10.0)
    {
      inum=inum/10;
      maxplace++;
    }
  
  for(i=0;i<numdecimals;i++) num*=10.0;
  inum=floor(num+0.5); /* now integer */
  for(i=numdigits;i>digit+1;i--) inum=inum/10;
   
  led_on=0;

  /* This table tells us what segments must be lit for
     each kind of digit. */

  switch (inum%10){
  case 0:
    if (segment!=4) led_on=1;
  case 1:
    if (segment==6||segment==7) led_on=1;
    break;
  case 2:
    if (segment!=1&&segment!=7) led_on=1;
    break;
  case 3:
    if (segment!=1&&segment!=2) led_on=1;
    break;
  case 4:
    if (segment!=2&&segment!=3&&segment!=5) led_on=1;
    break;
  case 5:
    if (segment!=2&&segment!=6) led_on=1;
    break;
  case 6:
    if (segment!=6) led_on=1;
    break;
  case 7:
    if (segment==3||segment==6||segment==7) led_on=1;
    break;
  case 8:
    led_on=1;
    break;
  case 9:
    if (segment!=2) led_on=1;
    break;
  default:
    break;
  }

  if (segment==8)
    {
      if (digit==(numdigits-numdecimals-1)
          && numdecimals!=0) 
        led_on=1;
      else led_on=0;
    }
  
  /* no leading zeros */
  if (digit<numdigits-numdecimals-maxplace) led_on=0;

  /* negative sign*/
  if (negflag&&segment==4 && (digit==(numdigits-numdecimals
      -maxplace-1)))
    led_on=1;
  
  if (led_on) return(LEDON);

  return(LEDOFF);

}
/* Done! */
