#define XYZ_ADD(c,a,b)   { (c).x = (a).x + (b).x; (c).y = (a).y + (b).y;\
                           (c).z = (a).z + (b).z;}
#define XYZ_SUB(c,a,b)   { (c).x = (a).x - (b).x; (c).y = (a).y - (b).y; \
                           (c).z = (a).z - (b).z;}
#define XYZ_MULT(c,a,b)  { (c).x = (a).x * (b).x; (c).y = (a).y * (b).y; \
                           (c).z = (a).z * (b).z;}
#define XYZ_DIV(c,a,b)   { (c).x = (a).x / (b).x; (c).y = (a).y / (b).y; \
                           (c).z = (a).z / (b).z;}

#define XYZ_INC(c,a)     { (c).x += (a).x; (c).y += (a).y;\
                           (c).z += (a).z;}
#define XYZ_DEC(c,a)     { (c).x -= (a).x; (c).y -= (a).y;\
                           (c).z -= (a).z;}
#define XYZ_ADDC(c,a,b)  { (c).x = (a).x + (b); (c).y = (a).y + (b);\
                           (c).z = (a).z + (b);}
#define XYZ_SUBC(c,a,b)  { (c).x = (a).x - (b); (c).y = (a).y - (b); \
                           (c).z = (a).z - (b);}
#define XYZ_MULTC(c,a,b) { (c).x = (a).x * (b); (c).y = (a).y * (b);\
                           (c).z = (a).z * (b);}
#define XYZ_DIVC(c,a,b)  { (c).x = (a).x / (b); (c).y = (a).y / (b);\
                           (c).z = (a).z / (b);}
#define XYZ_COPY(b,a)    { (b).x = (a).x; (b).y = (a).y; (b).z = (a).z; }
#define XYZ_COPYC(b,a)   { (b).x = (a); (b).y = (a); (b).z = (a); }
#define  DOT_XYZ(p1, p2)  ((p1).x * (p2).x + (p1).y * (p2).y + (p1).z * (p2).z)

#define CROSS_XYZ(c,a,b) { (c).x = (a).y * (b).z - (a).z * (b).y; \
			   (c).y = (a).z * (b).x - (a).x * (b).z; \
			   (c).z = (a).x * (b).y - (a).y * (b).x; }
#define CROSS_3(c,a,b)   { (c)[0] = (a)[1] * (b)[2] - (a)[2] * (b)[1]; \
			   (c)[1] = (a)[2] * (b)[0] - (a)[0] * (b)[2]; \
			   (c)[2] = (a)[0] * (b)[1] - (a)[1] * (b)[0]; }

#define NORMALIZE_XYZ(v)  { float __tmpnormval; \
			    __tmpnormval = (double)sqrt((v).x*(v).x +  \
					    (v).y*(v).y + (v).z*(v).z); \
			      (v).x /= __tmpnormval; \
			      (v).y /= __tmpnormval;  \
			      (v).z /= __tmpnormval;}
#define R_NORMALIZE_XYZ(v)  { float __tmpnormval; \
			    (((__tmpnormval = (double)sqrt((v).x*(v).x +  \
					    (v).y*(v).y + (v).z*(v).z)) \
			      == 0.0) ? FALSE : ((v).x /= __tmpnormval,  \
						 (v).y /= __tmpnormval,  \
						 (v).z /= __tmpnormval,TRUE));}

#define RGB_ADD(c,a,e)   { (c).r = (a).r + (e).r; (c).g = (a).g + (e).g; \
                           (c).b = (a).b + (e).b; }
#define RGB_SUB(c,a,e)   { (c).r = (a).r - (e).r; (c).g = (a).g - (e).g; \
                           (c).b = (a).b - (e).b; }
#define RGB_MULT(c,a,e)  { (c).r = (a).r * (e).r; (c).g = (a).g * (e).g; \
                           (c).b = (a).b * (e).b; }
#define RGB_ADDC(c,a,e)  { (c).r = (a).r + (e); (c).g = (a).g + (e); \
                           (c).b = (a).b + (e); }
#define RGB_SUBC(c,a,e)  { (c).r = (a).r - (e); (c).g = (a).g - (e); \
                           (c).b = (a).b - (e); }
#define RGB_MULTC(c,a,e) { (c).r = (a).r * (e); (c).g = (a).g * (e); \
                           (c).b = (a).b * (e); }
#define RGB_DIVC(c,a,e)  { (c).r = (a).r / (e); (c).g = (a).g / (e); \
                           (c).b = (a).b / (e); }
#define RGB_COPY(c,a)    { (c).r = (a).r; (c).g = (a).g; (c).b = (a).b; }
#define RGB_COPYC(c,a)   { (c).r = (a); (c).g = (a); (c).b = (a); }

#undef MIN
#undef MAX
#define    MIN(a, b)       ((a) < (b) ? (a) : (b))
#define    MAX(a, b)       ((a) > (b) ? (a) : (b))
