
/* @(#)dtree.c 1.3 93/06/01
 *
 *  Routine to dump popi expression tree.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#ifdef TREEDEBUG
#include "popi.h"
#include "expr.h"

#define  cst(t, st)  case t : str = st ; break

extern int treedump ;


void
dtree(st, t, d)
char *st ;
Tree *t ;
int d ;
{
  int i ;
  struct var *v ;
  char *str ;
  char tb[128] ;

  if (!treedump || !t) return ;

  FPUTS(st, stdout) ;
  for (i = 0; i < d; i++) putchar('.') ;

  switch (t->t)
    {
      cst(T_Top,     "Top") ;
      cst(T_Add,     "+") ;
      cst(T_Sub,     "-") ;
      cst(T_Neg,     "0-") ;
      cst(T_Bang,    "!") ;
      cst(T_Not,     "~") ;
      cst(T_Mul,     "*") ;
      cst(T_Div,     "/") ;
      cst(T_Mod,     "%") ;
      cst(T_Comma,   ";") ;
      cst(T_And,     "&") ;
      cst(T_Or,      "|") ;
      cst(T_Xor,     "^") ;
      cst(T_Eq,      "==") ;
      cst(T_Ne,      "!=") ;
      cst(T_Land,    "&&") ;
      cst(T_Lor,     "||") ;
      cst(T_Gt,      ">") ;
      cst(T_Lt,      "<") ;
      cst(T_Ge,      ">=") ;
      cst(T_Le,      "<=") ;
      cst(T_Lshift,  "<<") ;
      cst(T_Rshift,  ">>") ;
      cst(T_Xcoord,  "x") ;
      cst(T_Ycoord,  "y") ;
      cst(T_Prad,    "r") ;
      cst(T_Pang,    "a") ;
      cst(T_Rand,    "rand") ;
      cst(T_Polar,   "{}") ;
      cst(T_Cond,    "?:") ;
      cst(T_Sin,     "sin") ;
      cst(T_Cos,     "cos") ;
      cst(T_Sqr,     "sqr") ;
      cst(T_Sqrt,    "sqrt") ;
      cst(T_Nop,     "nop") ;

      case T_Inum     : SPRINTF(tb, "%d", t->i) ;
                        str = tb ;
                        break ;
      case T_Mapcoord :
      case T_Coord    : if (t->i >= 0)
                          {
                            SPRINTF(tb, "%s[]%s", Images[t->i].str,
                                        t->t == T_Mapcoord ? "=" : "") ;
                            str = tb ;
                          }
                        else str = "bad-coord" ;
                        break ;
      case T_Assign   : v = findVar(t->i) ;
                        SPRINTF(tb, "$%s=", v->n) ;
                        str = tb ;
                        break ;
      case T_Var      : v = findVar(t->i) ;
                        SPRINTF(tb, "$%s", v->n) ;
                        str = tb ;
                        break ;  
      default         : SPRINTF(tb, "??%d", t->t) ;
                        str = tb ;
    }

  PRINTF("%s\n", str) ;
  for (i = 0; i < t->siz; i++)
    if (t->kids[i])
      dtree("", t->kids[i], d+1) ;
  FFLUSH(stdout) ;
}
#endif /*TREEDEBUG*/
