
/*  @(#)colspec.c 1.3 93/06/01
 *
 *  Special transformations for color images used by the popi program.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

/*  The way this is done is fairly nasty at the moment, but it does work.
 */

#include <sys/types.h>

#include "popi.h"
#include "expr.h"

#define  New      (CurNew->pix)


void
imageOK(imgno)
int imgno ;
{
  if ((imgno >= nimages) || (imgno < 0))
  {
    STRCPY(ErrBuf, "no such image") ;
    run_error(ERR_SNARK) ;
  }
}


void
luma(t)
Tree *t ;
{
  register int dyoff, x, y, yoff ;
  pixel_t **img ;
  struct SRC *srcp ;
  int    imgno ;
  
  if (t->kids[0])
    {
      imgno = ((Tree *) (t->kids[0]))->i ;
      imageOK(imgno) ;
      srcp = &Images[imgno] ;
    }
  else srcp = CurOld ;
  img = srcp->pix ;
  if (srcp->ncolors != 3)
    {
      STRCPY(ErrBuf, "not a color image") ;
      run_error(ERR_SNARK) ;
    }

  for (y = 0; y < srcp->height; y++)
    {
      yoff = y * Xsize ;
      dyoff = y * srcp->Xalloc ;
      for (x = 0; x < srcp->width; x++)
        New[0][yoff+x] = img[0][dyoff+x] * 0.299 +
	                 img[1][dyoff+x] * 0.587 +
	                 img[2][dyoff+x] * 0.114 ;
      disp_percentdone((y+1) * 100 / srcp->height) ;
    }

  disp_percentdone(100) ;
  CurNew->width = srcp->width ;
  CurNew->height = srcp->height ;
  CurOld->width = srcp->width ;
  CurOld->height = srcp->height ;
  CurNew->ncolors = 1 ;
  if (disp_active) drawimg(CurNew) ;
  SwapOldNew() ;
}


void
explode(t)
Tree *t ;
{
  struct SRC *srcp ;
  int    imgno, i ;
  
  if (t->kids[0])
    {
      imgno = ((Tree *) (t->kids[0]))->i ;
      imageOK(imgno) ;
      srcp = &Images[imgno] ;
    }
  else srcp = CurOld ;
  
  if (srcp->ncolors != 3)
    {
      STRCPY(ErrBuf, "not a color image") ;
      run_error(ERR_SNARK) ;
    }
  for (i = 0; i < 3; ++i)
    stopict((Tree *) 0, i, srcp->str) ;
}


void
combine(t)
Tree *t ;
{
  register int dyoff, x, y, yoff ;
  pixel_t **img[3] ;
  struct SRC *pict[3] ;
  int    rgbidx[3], i, wi, he ;
  char   oldname[5] ;
  char   rgbchars[4] ;
  char   buff[80] ;
  char   *imgname ;
  pixel_t    **tmpOldp, **tmpNewp ;

  STRCPY(oldname, "old") ;
  STRCPY(rgbchars, "rgb") ;
  if (colors != 3)   /* change to color mode - realloc new and old */
    {
      colors = 3 ;
      if (ntsc != NULL) FREE((char *) ntsc) ;
      ntsc = (pixel_t *) Emalloc((unsigned) Xsize * sizeof(pixel_t)) ;
      wi = CurOld->width ;
      he = CurOld->height ;

      tmpOldp = ImgAlloc(Xsize, Ysize, colors) ;
      adjust_image(CurOld, tmpOldp, Xsize, colors) ;
      tmpNewp = ImgAlloc(Xsize, Ysize, colors) ;
      adjust_image(CurNew, tmpNewp, Xsize, colors) ;
      ImgFree(CurOld) ;
      ImgFree(CurNew) ;

      CurOld->pix     = tmpOldp ;          /* Create new "old" image. */
      CurOld->str     = Emalloc((unsigned int) (strlen("old")+1)) ;
      STRCPY(CurOld->str, "old") ;
      CurOld->width   = wi ;
      CurOld->height  = he ;
      CurOld->ncolors = 1 ;
      CurOld->Xalloc  = Xsize ;

      CurNew->pix     = tmpNewp ;          /* Create new "new" image. */
      CurNew->str     = Emalloc((unsigned int) (strlen("new")+1)) ;
      STRCPY(CurNew->str, "new") ;
      CurNew->width   = wi ;
      CurNew->height  = he ;
      CurNew->ncolors = 1 ;
      CurNew->Xalloc  = Xsize ;
    }

  if (t->kids[0])
    imgname = lastimage ;
  else
    imgname = oldname ;
  for (i = 0; i < 3; ++i)
    {
      SPRINTF(buff, "%s%c", imgname, rgbchars[i]) ;
      rgbidx[i] = getImageNo(buff) ;
      imageOK(rgbidx[i]) ;
      pict[i] = &Images[rgbidx[i]] ;
      img[i] = pict[i]->pix ;
    }
  if ((pict[0]->width != pict[1]->width) ||
      (pict[0]->width != pict[2]->width) ||
      (pict[0]->height != pict[1]->height) ||
      (pict[0]->height != pict[2]->height))
    {
      STRCPY(ErrBuf, "rgb components not of same size") ;
      run_error(ERR_SNARK) ;
    }
  
  for (y = 0; y < pict[0]->height; y++)
    {
      yoff = y * Xsize ;
      dyoff = y * pict[0]->Xalloc ;
      for (x = 0; x < pict[0]->width; x++)
        {
	  New[0][yoff+x] = img[0][0][dyoff+x] ;
	  New[1][yoff+x] = img[1][0][dyoff+x] ;
	  New[2][yoff+x] = img[2][0][dyoff+x] ;
	}
      disp_percentdone((y+1) * 100 / pict[0]->height) ;
    }

  disp_percentdone(100) ;
  CurNew->width = pict[0]->width ;
  CurNew->height = pict[0]->height ;
  CurOld->width = pict[0]->width ;
  CurOld->height = pict[0]->height ;
  CurNew->ncolors = 3 ;
  if (disp_active) drawimg(CurNew) ;
  SwapOldNew() ;
}


void
getputrgb(t, getit)
Tree *t ;
int getit ;
{
  register int dyoff, x, y, yoff ;
  pixel_t **img ;
  struct SRC *srcp = (struct SRC *) 0 ;
  int imgno, col ;

  if (t->kids[1])
    {
      imgno = ((Tree *) (t->kids[1]))->i ;
      if (imgno < 2) imgno = -1 ;    /* using "old" is not allowed */
      imageOK(imgno) ;
      srcp = &Images[imgno] ;
    }
  else imageOK(-1) ;                 /* need a stored picture */
  if (srcp->ncolors != 3)
    {
      STRCPY(ErrBuf, "not a color image") ;
      run_error(ERR_SNARK) ;
    }
  img = srcp->pix ;
  col = ((Tree *) (t->kids[0]))->i ;
  
  for (y = 0; y < srcp->height; y++)
    {
      yoff = y * Xsize ;
      dyoff = y * srcp->Xalloc ;
      for (x = 0; x < srcp->width; x++)
        {
	  if (getit)
	    New[0][yoff+x] = img[col][dyoff+x] ;
	  else
	    img[col][dyoff+x] = CurOld->pix[0][yoff+x] ;
	}
    }

  if (getit)
    {
      CurNew->width = srcp->width ;
      CurNew->height = srcp->height ;
      CurOld->width = srcp->width ;
      CurOld->height = srcp->height ;
      CurNew->ncolors = 1 ;
      if (disp_active) drawimg(CurNew) ;
      SwapOldNew() ;
    }  
}
