/* 

Gents-

Now that we have four contributions which pass all of the simple minded
tests (Boucher, Heckbert, Sloan, and Schorn - plus, I believe that
Hollasch could easily make his program work if he had the time, and he
agreed with our notion of "convexity"), it's time to up the ante.

At the end of this message is a simple-minded test program.  It
generates polygons whose vertices all lie on a circle.  All of the above
names programs work well on its polygons (aren't you glad you
implemented a stream reader?) - but there are differences.

In particular, consider:

    Circle -r 5.9375       and        Circle -r 5.875

Three of the above named programs report CONVEX for the first polygon
and NOT CONVEX for the second (on my machine - please test on yours).

One of the above named programs reports "CONVEX" all the way down to "-r
4.75", and reports "NOT CONVEX" for "-r 4.625.

What is the concensus here?  Which behavior is correct?  Why?  What is
the source of the non-convexity?

Have fun!

-Ken Sloan
*/

/*
 File: Circle.c
 Authors: K.R. Sloan
 Last Modified: 1 November 1992
 Purpose: produces a circle - suitable for input to
          a convexity tester.
 */
#include <stdio.h>
#include <math.h>
double atof();

#define PI (3.1415926)

static int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-h][-v][-O x y][-r r][-n n]\n",
               RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }

typedef struct Point { double x, y; } Point;

static void WritePoints(s,O,r,n)
FILE *s;
Point O;
double r;
int n;
{
  int i;
  Point P;
  double theta;

  for(i=0;i<n;i++) {
    theta = 2.0*PI*(double)i/(double)n;
    P.x = r*cos(theta); P.y = r*sin(theta);
    fprintf(s,"%lf %lf\n",P.x,P.y);
   }
}

int main (argc, argv)
int argc;
char *argv[];
{
  int ArgsParsed=0;
  Point O;
  double r;
  int n;

  RoutineName = argv[ArgsParsed++];

  O.x = 0.0; O.y = 0.0;
  r = 10000.0;
  n = (int)r;

  while (ArgsParsed < argc) {
    if ('-' == argv[ArgsParsed][0])
     switch (argv[ArgsParsed++][1]) {
       case 'O': if (2 > (argc-ArgsParsed)) {usage();exit(-1);}
                 O.x = atof(argv[ArgsParsed++]);
                 O.y = atof(argv[ArgsParsed++]);
                 break;
       case 'r': if (1 > (argc-ArgsParsed)) {usage();exit(-1);}
                 r =  atof(argv[ArgsParsed++]);
                 break;
       case 'n': if (1 > (argc-ArgsParsed)) {usage();exit(-1);}
                 n =  atoi(argv[ArgsParsed++]);
                 break;
       case 'v': VERBOSE  = -1; break;
       default:
       case 'h': usage(); exit(-1);
     }
  }

  WritePoints(stdout,O,r,n);

  exit(0);
}
