/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <stdio.h>
#include <fcntl.h>

#include "global.h"

extern int optind;
/***************************************************************************
  Creates MPEGTool Main window, which contains four buttons, MPEG (encoder),
  STATISTICS (statistics tool), INFORMATION (README display) and QUIT.
 ***************************************************************************/
main(argc, argv)
  int   argc;
  char  *argv[];
{
  XtAppContext app;
  Widget toplevel, main_w, rc, pb, pane;
  MPEG_param *P;

  extern void mpeg_pushed();
  extern void stat_pushed();
  extern void info_pushed();
  extern void quit_pushed();
  extern void SetUnsensitive();

  char i;

  Xon = 1;
/*---------------------- Get Options -------------------------*/
  while ((i = getopt(argc, argv, "f")) != EOF) {
    switch (i) {
    case 'f':
      Xon = 0;
      break;
    }
  }

/*---------------------- Init toplevel -----------------------*/
  if (Xon) {
  toplevel = XtVaAppInitialize(&app, "MPEGTool", NULL,
               0, &argc, argv, NULL, 
               XmNtitle,     "MPEGTool",
               XmNiconName,  "MPEGTool",
               XmNwidth,  135,
               XmNheight, 140,
               XmNmaxWidth,  135,
               XmNminWidth,  135,
               XmNmaxHeight, 140,
               XmNminHeight, 140,
               NULL);
/*------------------- Main Menu Widget define ------------------*/
  main_w = XtVaCreateManagedWidget("main",
             xmMainWindowWidgetClass, toplevel,
             NULL);
  pane = XtVaCreateWidget("pane", 
           xmPanedWindowWidgetClass, main_w,
           XmNsashWidth, 0,
           XmNsashHeight, 0,
           NULL);
/*-------------------- Create pane for push button --------------------*/
  rc = XtVaCreateWidget("rowcol",
         xmRowColumnWidgetClass, pane, 
         XmNpaneMinimum, 133,
         XmNpaneMaximum, 133,
	 XmNx,	0,
	 XmNy,	0,
	 XmNentryAlignment, XmALIGNMENT_CENTER,
	 XmNmarginHeight,	10,
	 XmNmarginWidth,	10,
	 XmNspacing,	5, 
	 NULL);
/*-------------------- Create push button MPEG -----------------------*/
  pb = XtVaCreateManagedWidget("MPEG", xmPushButtonWidgetClass, rc,
         NULL, 0);
  XtAddCallback(pb, XmNactivateCallback, SetUnsensitive, pb);
  XtAddCallback(pb, XmNactivateCallback, mpeg_pushed, app);
/*-------------------- Create push button Statistics -----------------*/
  pb = XtVaCreateManagedWidget("STATISTICS", xmPushButtonWidgetClass,
	 rc, NULL, 0); 
  XtAddCallback(pb, XmNactivateCallback, SetUnsensitive, pb);
  XtAddCallback(pb, XmNactivateCallback, stat_pushed, NULL);
/*-------------------- Create push button information -----------------------*/
  pb = XtVaCreateManagedWidget("INFORMATION", xmPushButtonWidgetClass,
         rc, NULL);
  XtAddCallback(pb, XmNactivateCallback, SetUnsensitive, pb);
  XtAddCallback(pb, XmNactivateCallback, info_pushed, 
               XmDIALOG_PRIMARY_APPLICATION_MODAL);
/*-------------------- Create push button Quit -----------------------*/
  pb = XtVaCreateManagedWidget("QUIT", xmPushButtonWidgetClass, rc, NULL);
  XtAddCallback(pb, XmNactivateCallback, quit_pushed, toplevel);
  
/*---------------------------------------------------------------------*/
  XtManageChild(rc);
  XtManageChild(pane);

  XtRealizeWidget(toplevel);
  XtAppMainLoop(app);
}
else {
  P = (MPEG_param *)malloc(sizeof(MPEG_param));
  init_mpeg_param(P,argv[optind]);
  mpeg_encoder_param_set(P);
}
  
  
}

/* Exit popup dialog to confirm to quit MPEGTool */

void
  quit_pushed(pb, top) 
Widget pb;
Widget top;
{
  static Widget dialog;
  XmString t;

  if(!dialog) {
    extern void exit();
    extern void dlg_callback();
    Arg args[3];
    XmString yes = XmStringCreateSimple("Yes");
    XmString no = XmStringCreateSimple("No");

    XtSetArg(args[0], XmNautoUnmanage, False);
    XtSetArg(args[1], XmNokLabelString, yes);
    XtSetArg(args[2], XmNcancelLabelString, no);
    dialog = XmCreateQuestionDialog(pb, "exit", args, 3);
    XtVaSetValues(XtParent(dialog),
      XmNtitle, "EXIT Confirm",
      NULL);
    XtAddCallback(dialog, XmNokCallback, exit, NULL);
    XtAddCallback(dialog, XmNcancelCallback, dlg_callback, NULL);
    XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  }

  t = XmStringCreateSimple("Quit MPEGTool?");
  XtVaSetValues(dialog,
    XmNmessageString,       t,
    XmNdefaultButtonType, XmDIALOG_CANCEL_BUTTON,
    NULL);
  XmStringFree(t);
  XtManageChild(dialog);
  XtPopup(XtParent(dialog), XtGrabExclusive);
}
