/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/*******************************************************************
  Creates MPEGTool Information dialog, which shows README file.
 *******************************************************************/
#define INFO_FILE "README"

#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/PushBG.h>

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
void
  info_pushed(w)
Widget w;
{
  Widget dialog, pane, text_w, form, pb;
  struct stat istat;
  Arg args[4];
  FILE *fdinfo;
  char* text;
  extern void quit_dialog();
  extern void SetSensitive();
/*------------------ Creating the dialog ------------------------------------*/
  dialog = XtVaCreatePopupShell("dialog",
             xmDialogShellWidgetClass,  w,
             XmNtitle,          "MPEGTool: Information",
             XmNdeleteResponse, XmDESTROY,
             XmNx,   WidthOfScreen(XtScreen(w)) / 4,
             XmNy,   HeightOfScreen(XtScreen(w)) / 4,
/*           XmNmaxWidth,  365,
             XmNminWidth,  365,
             XmNmaxHeight, 285,
             XmNminHeight, 285,*/
             NULL);
/*------------------ Creating the pane window (BASE widget) -----------------*/
  pane = XtVaCreateWidget("pane",
           xmPanedWindowWidgetClass,  dialog,
           XmNsashWidth,  1,
           XmNsashHeight, 1,
           NULL);
/*------ make scrolled text ------*/ 
  XtSetArg(args[0], XmNrows,      17);
  XtSetArg(args[1], XmNcolumns,   80);
  XtSetArg(args[2], XmNeditable,  False);
  XtSetArg(args[3], XmNeditMode,  XmMULTI_LINE_EDIT);
  text_w = XmCreateScrolledText(pane, "text_w", args, 4);
  /*------ file open ------*/
  if(stat(INFO_FILE,&istat)||(fdinfo = fopen(INFO_FILE, "r"))==NULL) {
    fprintf(stderr,"can't open info file\n");
    text = (char*)calloc(256,sizeof(char));
    sprintf(text,"MPEGTool : Information File not found.\n");  
    free(text);
    XmTextSetString(text_w, text);
  }
  else {
    text = XtMalloc((unsigned)(istat.st_size+1));    
    fread(text, sizeof(char), istat.st_size+1, fdinfo);
    text[istat.st_size] = 0;
    XmTextSetString(text_w, text);
    XtFree(text);
    fclose(fdinfo);
  }
  XtManageChild(text_w);
/*------ Action area with 'OK' button  ------*/
  form = XtVaCreateWidget("form",
           xmFormWidgetClass, pane,
           XmNfractionBase, 5,
           XmNpaneMinimum, 40,
           XmNpaneMaximum, 40,
           NULL);
  pb = XtVaCreateManagedWidget(" OK ",
         xmPushButtonGadgetClass, form,
         XmNtopAttachment,    XmATTACH_FORM,
         XmNbottomAttachment, XmATTACH_FORM,
         XmNleftAttachment,   XmATTACH_POSITION,
         XmNleftPosition,     2,
         XmNrightAttachment,  XmATTACH_POSITION,
         XmNrightPosition,    3,
         XmNshowAsDefault,    True,
         XmNdefaultButtonShadowThickness, 1,
         NULL);

  XtAddCallback(pb, XmNactivateCallback, SetSensitive, w);
  XtAddCallback(pb, XmNactivateCallback, quit_dialog, dialog);

  XtManageChild(form);
  XtManageChild(pane);
  XtPopup(dialog, XtGrabNone);
}


