/* 
  morphine triangle drawing
  
  slightly modified routines by mark hall
  original code by Paul Heckbert, in the Graphics Gems code
  
  the code here was more general than I needed, but
  I wanted a quick solution and it was a handy routine
  */
/*
 * Concave Polygon Scan Conversion
 * by Paul Heckbert
 * from "Graphics Gems", Academic Press, 1990
 */

/*
 * concave: scan convert nvert-sided concave non-simple polygon with vertices at
 * (point[i].x, point[i].y) for i in [0..nvert-1] within the window win by
 * calling spanproc for each visible span of pixels.
 * Polygon can be clockwise or counterclockwise.
 * Algorithm does uniform point sampling at pixel centers.
 * Inside-outside test done by Jordan's rule: a point is considered inside if
 * an emanating ray intersects the polygon an odd number of times.
 * drawproc should fill in pixels from xl to xr inclusive on scanline y,
 * e.g:
 *	drawproc(y, xl, xr)
 *	int y, xl, xr;
 *	{
 *	    int x;
 *	    for (x=xl; x<=xr; x++)
 *		pixel_write(x, y, pixelvalue);
 *	}
 *
 *  Paul Heckbert	30 June 81, 18 Dec 89
 */

#include <stdio.h>
#include <math.h>
#include "globals.h"

#define ALLOC(ptr,type,n) ASSERT(ptr=(type *)malloc((unsigned)((n)*sizeof(type))))

static int n;			/* number of vertices */
static Point2 *pt;		/* vertices */

static int nact;		/* number of active edges */
static Edge *active;		/* active edge list:edges crossing scanline y */

int compare_ind(), compare_active();

static CSinsert(i, y)		/* append edge i to end of active list */
int i, y;
{
   int j;
   double dx;
   Point2 *p, *q;
   
   j = i<n-1 ? i+1 : 0;
   if (pt[i].y < pt[j].y) {p = &pt[i]; q = &pt[j];}
   else		   {p = &pt[j]; q = &pt[i];}
   /* initialize x position at intersection of edge with scanline y */
   active[nact].dx = dx = (q->x-p->x)/(q->y-p->y);
   active[nact].x = dx*(y+.5-p->y)+p->x;
   active[nact].i = i;
   nact++;
}




concave(nvert, point, win, pcent, btri, bpic, etri, epic, outpic)
int nvert;			/* number of vertices */
Point2 *point;	/* vertices of polygon, & texture polygon */
GGWindow *win;			/* screen clipping window */
float pcent;
Point2 *btri, *etri;
InternalPic *bpic, *epic, *outpic;              /* the texture input */
{
   int k, y0, y1, y, i, j, xl, xr, x, rgb;
   int *ind;		/* list of vertex indices, sorted by pt[ind[j]].y */
   Point2 *a, *b, *c, pp, *p, oldpp, *oldp;  /* triangle corners */
   Barycoord bc, *BC;
   byte color, bcolor, ecolor, lastcolor=0, find_closest_color();
   int fullcolor[3];
   int off;
   float pcent1 = (1.0 - pcent);
   a = &point[0];  /* a, b, c, p  notation is for barycentric coordinates */
   b = &point[1];
   c = &point[2];
   p = &pp;         /* a point in the triangle */
   BC = &bc;
   oldp = &oldpp;
   
   n = nvert;
   pt = point;
   if (n<=0) return;

   ALLOC(ind, int, n);
   ALLOC(active, Edge, n);
   
   /* find max and min coordinates in this polygon */
   /* used later to redraw the background */
   for (i=0; i<nvert; i++)
   {
      x = point[i].x;
      y = point[i].y;
      if (x<redrawxmin) redrawxmin = x;
      if (x>redrawxmax) redrawxmax = x;
      if (y<redrawymin) redrawymin = y;
      if (y>redrawymax) redrawymax = y;
      
   }
   /*fprintf(stderr, "concave, pcent = %f\n", pcent);*/
   
   pt = point;
   /* create y-sorted array of indices ind[k] into vertex list */
   for (k=0; k<n; k++) ind[k] = k;
   qsort(ind, n, sizeof ind[0], compare_ind);	/* sort ind by pt[ind[k]].y */
   
   nact = 0;				/* start with empty active list */
   k = 0;				/* ind[k] is next vertex to process */
   y0 = MAX(win->y0, ceil(pt[ind[0]].y-.5));		/* ymin of polygon */
   y1 = MIN(win->y1, floor(pt[ind[n-1]].y-.5));	/* ymax of polygon */
   
   for (y=y0; y<=y1; y++) {		/* step through scanlines */
      /* scanline y is at y+.5 in continuous coordinates */
      p->y = y;
      /*fprintf(stderr, "\n\ny=%d ", y);*/
      /* check vertices between previous scanline and current one, if any */
      for (; k<n && pt[ind[k]].y<=y+.5; k++) {
	 /* to simplify, if pt.y=y+.5, pretend it's above */
	 /* invariant: y-.5 < pt[i].y <= y+.5 */
	 i = ind[k];	
	 /*
	  * insert or delete edges before and after vertex i (i-1 to i,
	  * and i to i+1) from active list if they cross scanline y
	  */
	 j = i>0 ? i-1 : n-1;	/* vertex previous to i */
	 if (pt[j].y <= y-.5)	/* old edge, remove from active list */
	    CSdelete(j);
	 else if (pt[j].y > y+.5)	/* new edge, add to active list */
	    CSinsert(j, y);
	 j = i<n-1 ? i+1 : 0;	/* vertex next after i */
	 if (pt[j].y <= y-.5)	/* old edge, remove from active list */
	    CSdelete(i);
	 else if (pt[j].y > y+.5)	/* new edge, add to active list */
	    CSinsert(i, y);
      }
      
      /* sort active edge list by active[j].x */
      qsort(active, nact, sizeof active[0], compare_active);
      
      /* draw horizontal segments for scanline y */
      for (j=0; j<nact; j+=2) {	/* draw horizontal segments */
	 /* span 'tween j & j+1 is inside, span tween j+1 & j+2 is outside */
	 xl = ceil(active[j].x-.5);		/* left end of span */
	 if (xl<win->x0) xl = win->x0;
	 xr = floor(active[j+1].x-.5);	/* right end of span */
	 if (xr>win->x1) xr = win->x1;
	 
	 /**************
            HERE WE REALLY DRAW 
	 ******************/
	 /*if (xl<=xr) (*spanproc)(y, xl, xr);   /* draw pixels in span */
	 for (x=xl; x<=xr; x++) 
	 {
	    p->x = x;
	    /*find the barycentric coord of output point in  output triangle*/
	    bary(a, b,  c, p, BC);
	    
	    /* find the begin image pixel corresponding to this point */
	    findoldpoint(BC, btri, oldp);
	    
	    /* lookup the color from the BEGIN image using BC */
	    off = (int)(bpic->wide * (int) oldp->y)  + (int) (oldp->x);
	    bcolor = bpic->data[off];
	    
	    for (rgb=0; rgb<3; rgb++) 
	       fullcolor[rgb] = (int) ((bpic->cmap[rgb][bcolor] << 8) *pcent1);

	    /* find the end image pixel corresponding to this point */
	    findoldpoint(BC, etri, oldp);
	    
	    /* lookup the color from the END image using BC */
	    off = (int)(epic->wide * (int) oldp->y)  + (int) (oldp->x);
	    ecolor = epic->data[off];

	    for (rgb=0; rgb<3; rgb++)
	    {
	       fullcolor[rgb] += ((int)((epic->cmap[rgb][ecolor]<<8)*pcent));
	       fullcolor[rgb] = fullcolor[rgb] >> 8;
	    }

	    /*fprintf(stderr, "combo color %d %d %d\n", 
	      fullcolor[0], fullcolor[1], fullcolor[2]);*/
	    
	    /* find closest color to this fullcolor in outpic */
	    lastcolor=color = find_closest_color(fullcolor, outpic, 
						 bcolor, ecolor, lastcolor);
	    
	    drawpoint(x, y, color);
	 }
	 active[j].x += active[j].dx;	/* increment edge coords */
	 active[j+1].x += active[j+1].dx;
      }
   }
   
   
}




/*      the following is SLOW  - work on it later   */


/* given a colormap, and a 24-bit color, find the closest color,
   or one close enough (user setable */
byte find_closest_color(fcolor, pic, hint1, hint2, hint3)
int fcolor[3];
InternalPic *pic;
byte hint1, hint2, hint3;  /* guesses for correct index */
{
   int i;
   int dist, rdist, gdist, bdist;
   int mindist, minindex;
   int r, g, b;
   
   mindist = 1000;  /* bigger than largest distance */
   minindex = -1;
   
   r = fcolor[0];
   g = fcolor[1];
   b = fcolor[2];
   
   /* try hinted colors first */
   rdist = abs(r - pic->cmap[0][hint1]); 
   if (rdist < CLOSEdist)
   {
      gdist = abs(g - pic->cmap[1][hint1]);
      if (gdist < CLOSEdist)
      {
	 bdist = abs(b - pic->cmap[2][hint1]);
	 if (bdist < CLOSEdist)
	 {
	    /* close enough */
	    return(hint1);
	 }
      }
   }
   
   rdist = abs(r - pic->cmap[0][hint2]); 
   if (rdist < CLOSEdist)
   {
      gdist = abs(g - pic->cmap[1][hint2]);
      if (gdist < CLOSEdist)
      {
	 bdist = abs(b - pic->cmap[2][hint2]);
	 if (bdist<CLOSEdist)
	 {
	    /* close enough */
	    return(hint2);
	 }
      }
   }
   
   rdist = abs(r - pic->cmap[0][hint3]); 
   if (rdist < CLOSEdist)
   {
      gdist = abs(g - pic->cmap[1][hint3]);
      if (gdist < CLOSEdist)
      {
	 bdist = abs(b - pic->cmap[2][hint3]);
	 if (bdist<CLOSEdist)
	 {
	    /* close enough */
	    return(hint3);
	 }
      }
   }
   
   /* linear search through the cmap  - bad idea */
   for (i=0; i<pic->numcolors; i++)
   {
      rdist = abs(r - pic->cmap[0][i]); 
      gdist = abs(g - pic->cmap[1][i]);
      bdist = abs(b - pic->cmap[2][i]);
      
      if (rdist<CLOSEdist && gdist<CLOSEdist && bdist<CLOSEdist)
      {
	 /* close enough  to quit */
	 return((byte)i);
      }
      
      dist = rdist + gdist + bdist;
      /*fprintf(stderr,"rgb = %d %d %d    vs %d %d %d   dist = %d\n", r, g, b, 
	pic->cmap[0][i], pic->cmap[1][i], pic->cmap[2][i], dist);*/
      
      if (dist < mindist)
      {
	 mindist = dist;
	 minindex = i;
      }
   }
   
   /*
     fprintf(stderr, "color %dr %dg %db  closest=%d   %dr %dg %db\n", 
     r, g, b, minindex, 
     pic->cmap[0][minindex], 
     pic->cmap[1][minindex], 
     pic->cmap[2][minindex]);
     */   
   
   
   /* no good match was found */
   /* might want to add color table entries, if some are available */
   if (pic->numcolors < 255) 
   {
      /*fprintf(stderr, "%d colors\n", pic->numcolors);*/
      pic->cmap[0][pic->numcolors] = r;
      pic->cmap[1][pic->numcolors] = g;
      pic->cmap[2][pic->numcolors] = b;
      pic->numcolors = pic->numcolors+1;
      minindex =(byte)(pic->numcolors);
   }
   /*
   else fprintf(stderr, "too many unavailable colors\n");
   */
   
   return((byte)minindex);
   
}



static CSdelete(i)		/* remove edge i from active list */
int i;
{
   int j;
   
   for (j=0; j<nact && active[j].i!=i; j++);
   if (j>=nact) return;	/* edge not in active list; happens at win->y0*/
   nact--;
   bcopy((char *)&active[j+1], (char *)&active[j], (nact-j)*sizeof active[0]);
}



/* comparison routines for qsort */
compare_ind(u, v) int *u, *v; {return pt[*u].y <= pt[*v].y ? -1 : 1;}
compare_active(u, v) Edge *u, *v; {return u->x <= v->x ? -1 : 1;}
