#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <Sender.h>
#include <Receiver.h>


char *progn;

main(argc,argv)
     int argc;
     char **argv;
{
  int retVal;
  Sender *sender;
  Receiver *receiver;
  Port senderPort;
  
  progn=argv[0];
  if (argc==1)
  {
    usage();
    exit(-1);
  }
  printf("This program tests connecting to the Port Manager.\n");
  printf("The PortMgrPortNumber is %d.\n",PortMgrPortNumber);
  senderPort.hostName = argv[1];
  printf("The hostName we are trying to connect to is %s\n",argv[1]);
  senderPort.portNumber = PortMgrPortNumber;
  printf("Now, we try to get a sender.\n");
  sender = NewSender(&senderPort);
  if (sender)
  {
    printf("The fields of sender are:\n");
    printf("\tclientPtr (an address): %ld\n",
	   (unsigned long)(sender->clientPtr));
    printf("\tclientSocket (an int): %d\n",sender->clientSocket);
    printf("\tportNumber (an int): %d\n",sender->portNumber);
    printf("\n");
  } else
  {
    fprintf(stderr,"sender came back null---aborting\n");
    exit(-2);
  }
  printf("Now, we try to get a receiver.\n");
  receiver = NewReceiver(sender,argv[0],AnyPort);
  if (sender)
  {
    printf("The fields of receiver are:\n");
    printf("Port fields:\n");
    printf("\thostName: %s\n",(receiver->receivePort).hostName);
    printf("\tappName: %s\n",(receiver->receivePort).appName);
    printf("\tportNumber: %d\n",(receiver->receivePort).portNumber);
    printf("Other fields:\n");
    printf("\treceiveSocket (an int): %d\n",receiver->receiveSocket);
    printf("\tcreateErrorCode (an int): %d\n",receiver->createErrorCode);
    printf("\ttransport (an address): %ld\n",
	   (unsigned long)(receiver->transport));
    printf("\n");
  }
  else
  {
    fprintf(stderr,"receiver came back null---aborting\n");
    exit(-3);
  }
  printf("This completes the connection to the Manager.\n");
  printf("Press <CR> and program will try to disconnect\n");
  getchar();
  printf("\nTrying to disconnect.\n");
  retVal=SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));
  printf("SenderDisconnectFromPortMgr returns with code %d\n",retVal);
  printf("(0 is success, -1 is failure)\n");
  exit(0);
}
usage()
{
  fprintf(stderr,"USAGE: %s name\n",progn);
  fprintf(stderr,"where name names a host with a port manager (on port %d)\n",
	  PortMgrPortNumber);
  fprintf(stderr,"For example, you might type %s `hostname`\n",progn);
}
