/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/vcrEdit/RCS/vcrEdit.h,v 0.29 92/09/08 14:28:28 drapeau Exp $ */
/* $Log:	vcrEdit.h,v $
 * Revision 0.29  92/09/08  14:28:28  drapeau
 * Re-defined "MAX_FRAME" to take into account the new variable
 * "FrameRate".  The old definition assumed NTSC frame rates only.
 * 
 * Revision 0.28  92/06/17  00:01:18  drapeau
 * Added declaration of function "SetAsynchReadFunction()" to accommodate
 * toolkit-independent asynchronous I/O.
 * 
 * Revision 0.27  92/06/15  14:44:53  drapeau
 * Minor change: declared function prototype for "UpdateHeader()".
 * 
 * Revision 0.26  92/05/29  12:34:31  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 0.25  92/05/13  23:54:53  drapeau
 * Minor cosmetic changes to conform to coding standards.
 * 
 * Revision 0.24  91/09/29  16:13:38  lim
 * Removed mySerialPort.
 * 
 * Revision 0.23  91/09/26  12:31:50  lim
 * Added chosenHost as global.
 * 
 * Revision 0.22  91/09/24  22:00:47  lim
 * 1. Combined 'vcrEditProtocol.h' into this file.
 * 2. Used relative filenames for drivers.
 * 
 * Revision 0.21  91/08/28  13:04:39  lim
 * Added preSearch and nextTLSelection for implementation of Presearching.
 * 
 * Revision 0.20  91/08/24  18:00:22  lim
 * Added diagMode.
 * 
 * Revision 0.19  91/08/23  17:23:24  lim
 * Included PlayerStatus.h instead of NECDriver.h
 * 
 * Revision 0.18  91/08/21  10:44:05  lim
 * Added new variable, mySerialPort, to denote serial port setting on
 * options panel.
 * 
 * Revision 0.17  91/08/17  20:49:58  lim
 * OpenPanel now called Browse.
 * 
 * Revision 0.16  91/08/16  12:33:01  lim
 * OpenPanel header file included.
 * 
 * Revision 0.15  91/08/11  18:45:43  lim
 * Changed return type of FileLoad() from int to void.
 * 
 * Revision 0.14  91/08/09  16:42:10  lim
 * Included OpenPanel.
 * 
 * Revision 0.13  91/08/09  11:05:09  lim
 * Moved 'NECDriver.h' to 'videoObjects.c'
 * 
 * Revision 0.12  91/08/08  16:27:30  lim
 * 1. speedStg is now an array of integers.
 * 2. MaxHeaderLength define.
 * 3. currTape is now an array MaxHeaderLength long.
 * 4. Added instance pointer to each public function call.
 * 5. currentAudio is used to denote current audio setting in edit list.
 * 
 * Revision 0.11  91/07/20  11:42:59  lim
 * Added data structures for audio and speed settings.
 * 
 * Revision 0.10  91/07/16  16:15:42  lim
 * Initial revision.
 *  */

#ifndef _VCREditHeader_
#define _VCREditHeader_

/* System files */
#include <errno.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/panel.h>
#include <xview/fullscreen.h>
#include <xview/notice.h>
#include <xview/sel_attrs.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>

/* Other header files */
#include "vcrEdit_ui.h"
#include "Sender.h"
#include "Receiver.h"
#include <getopt.h>
#include <videoObj.h>
#include <PlayerStatus.h>
#include <Browse.h>


/* Definitions used in vcrEdit files */
#define MAX_LISTSIZE 1000
#define MAX_LABELSIZE 22
#define MAX_FRAME (8 * 3600 * FrameRate)			    /* 8 hours worth of frames */
#define MAX_PATHLENGTH 256
#define MAX_HOSTNAME 256
#define MaxHeaderLength 10
#define LOAD 0
#define SAVE 1

enum AudioType {Stereo, Right, Left, Mute};			    /* Different audio settings available for each edit */


/* Command line variables */
int receiverPort;						    
char* startFilename;				                    
char hostname[MAX_HOSTNAME];					    

/* Variables used for making edits */
int lines;							    /* number of lines in the edit list */
int editnum;							    /* the current selection in the edit list */
int change;							    /* indicates if unsaved changes exist in the edit list */
int clearframe;							    /* determines if the frame/chapter textfield is to be cleared*/
int search;							    /* flag to indicate if a notify procedure is to be executed. 
								       This is necessary because a textfield notify procedure 
								       is executed twice for each key depressed (possibly a XView 
								       bug */
extern char	currentFilename[256];				    /* Name of currently-opened file */

/* Arrays to store edit information */
char startframe[MAX_LISTSIZE][12];
char endframe[MAX_LISTSIZE][12];	
char label[MAX_LISTSIZE][MAX_LABELSIZE+1];         
enum AudioType audioStg[MAX_LISTSIZE];
int speedStg[MAX_LISTSIZE];

/* Networking stuff */
Sender*		sender;
Receiver*	receiver;
char		deviceName[MaxNameLength];			    /* Name of device currently used */
VideoObject*	myVideo;					    /* Current video object */
static char	chosenHost[MAX_HOSTNAME];			    /* Current (chosen from options panel) network host */
int		currentAudio;					    /* Current audio setting */
enum Boolean	diagMode;					    /* Flag : whether diagnostic messages should be printed */
enum Boolean	preSearch;					    /* Flag : whether presearching should be done */

/* XView stuff */
vcrEdit_window1_objects	        *vcrEdit_window1;
vcrEdit_optionsPopup_objects     	*vcrEdit_optionsPopup;
vcrEdit_editPopup_objects     	*vcrEdit_editPopup;
vcrEdit_previewPopup_objects     	*vcrEdit_previewPopup;
vcrEdit_infoPopup_objects     	*vcrEdit_infoPopup;

/* Fonts */
Xv_font *font;	

/* Indexing variables */
FILE* indexFp;
int indexing;

static char vcrEdithrcsid[] = "$Header: /Source/Media/collab/vcrEdit/RCS/vcrEdit.h,v 0.29 92/09/08 14:28:28 drapeau Exp $";
void Quit();
void SetIndexActive();
void EditDone();
void DisplayError();
void PrintDiagnostics();
Menu_item FileLoad();
void ConvertToTime();
void SetPort();
void PlayEdit();
VideoObject* DevInit();
int OpenHandler();
int SaveHandler();
void SetPlayer();
void UpdateHeader (char* documentName, int modified);
void SetAsynchReadFunction();


/* Defined in vcrEditProtocol.c */

void InitNetwork();
void OpenDoc();
void SetSelection();
void PerformSelection();
char ** GetDoc();
MAESelection* GetSelection();
void HaltSelection();
void PauseSelection();
void ResumeSelection();
void HideApplication();
void ShowApplication();
IconData* GetAppIcon();

Sender* sender;
Receiver* receiver;


#endif
