/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/cdEdit/RCS/file.c,v 2.11 92/07/17 16:33:17 drapeau Exp $ */
/* $Log:	file.c,v $
 * Revision 2.11  92/07/17  16:33:17  drapeau
 * Minor cosmetic changes, comment changes.
 * 
 * Revision 2.10  92/01/03  17:49:14  drapeau
 * Modified all calls to Browse() to use "0" instead of "NULL", in order to
 * accommodate ANSI-C definition of NULL as (void*) 0.
 * 
 * Revision 2.0  91/10/06  21:01:22  chua
 * Update to version 2.0
 * 
 * Revision 1.14  91/09/18  17:26:49  chua
 * Removed the hard path for the include files.
 * 
 * Revision 1.13  91/09/10  13:35:12  chua
 * Cast tempfile to char * in line 71
 * 
 * Revision 1.12  91/09/04  11:36:04  chua
 * In OpenHandler, delete the stbuf structure (not used).
 * 
 * In SaveHandler (line 361), return Error instead of just a return.
 * 
 * Revision 1.11  91/09/03  15:10:47  chua
 * Added the copyright header.
 * 
 * Deleted the functions FileError and CheckFilename, which are no longer necessary,
 * since error checks for files are now done in the browser.
 * 
 * Include the handlers for the menu items in the Document menu (Open, Save, Save as, 
 * Close).
 * 
 * Uses the file browser to open and save files.
 * 
 * Changed the file format for a cdEdit document.  It is now more readable (with more
 * labelling and spacing), and also stores the total tracks and total time of a CD as a 
 * form of ID.  The OpenHandler will not open a document that is incompatible with the
 * currently inserted disc (the IDs don't match).
 * 
 * Revision 1.1  91/07/09  16:47:19  chua
 * 
 * 
 * Revision 1.0  91/07/08  13:45:53  chua
 * Initial revision
 *  */

static char filercsid[] = "$Header: /Source/Media/collab/cdEdit/RCS/file.c,v 2.11 92/07/17 16:33:17 drapeau Exp $";

#include "main.h"
#include <Browse.h>

int editmin, editsec;						    /* Total time for a disc read from an edit document */
int editTotalTracks;						    /* Total tracks for a disc read from an edit document */

/*
 * Checks if the filename specified by the user is 'untitled'.  This is not allowed as it is the default used by the timeline if no filename
 * has been specified.  A return value of 1 indicates that the filename is 'untitled' and the user should choose another.  Otherwise,
 * a value of 0 is returned.
 */
int CheckforUntitled(filename)
     char *filename;
{
  char *tempfile;
    
  tempfile = (char *) rindex(filename, '/');			    /* check if filename is 'untitled'.  If so, ask for another filename */
  if (tempfile != NULL) 
  {
    if (strcmp(&tempfile[1], "untitled") == 0) 
    {
      return OK;
    }
  }  
  else if (strcmp(filename, "untitled") == 0) 
  {
    return OK;
  }
  return Error;
}

/*
 * Menu handler for `DocumentMenu (Open)'.
 */
Menu_item OpenFileHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    Browse(NULL, BrowseOpen, 0, "#CD Edit Document#", "cdEdit");
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `DocumentMenu (Save)'.
 */
Menu_item SaveFileHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    if (strcmp(cdfilename, "untitled") == 0)		    /* No filename specified yet */
    {
      Browse(NULL, BrowseSave, 0, "#CD Edit Document#", "cdEdit");
    }
    else 
    {
      Browse(cdfilename, BrowseCheckSave, 0, "#CD Edit Document#", "cdEdit");
    }
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `DocumentMenu (Save as ... )'.
 */
Menu_item SaveAsFileHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    Browse(NULL, BrowseSave, 0, "#CD Edit Document#", "cdEdit");
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `DocumentMenu (Close)'.
 */
Menu_item CloseFileHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    if (CheckChanges(CloseFile) == NOTICE_YES)			    /* Check if unsaved changes exist in edit list */
    {
      return item;
    }
    change = 0;
    editmin = 0;
    editsec = 0;
    editTotalTracks = 0;
    xv_set(cdEdit_EditPopup->DiscLabelText, PANEL_VALUE, "", NULL); /* Clear the text fields in the edit panel */
    xv_set(cdEdit_EditPopup->EditPopupStartTrackText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupStartMinText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupStartSecText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupStartFrameText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupEndTrackText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupEndMinText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupEndSecText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupEndFrameText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupLabelText, PANEL_VALUE, "", NULL); 
    xv_set(cdEdit_EditPopup->EditPopupDurationText, PANEL_VALUE, "", NULL); 
    EditDeleteAll(item, NULL);
    strcpy(cdfilename, "untitled");
    change = 0;
    UpdateHeader(0);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * This function will load a file into the edit list, assuming there are no errors in opening the file.
 */
int OpenHandler(filename, id)
     char *filename;
     int id;
{
  FILE *fp;	
  int i, oldlines;
  int dummy;
  char buf[100], header[20], tempLabel[MaxLabelLength + 14];
  char discLabel[MaxLabelLength];
  int tempTotalTracks, tempmin, tempsec;
  
  if (CheckforUntitled (filename) == OK)			    /* Check if filename is 'untitled' (unacceptable) */
  {
    AlertMessage("'untitled' is not an acceptable filename.", "please type in a new one.");
    return Error;
  }
  if (CheckChanges (LoadFile) == NOTICE_YES)			    /* Check if there are unsaved changes */
  {
    return OK;
  }
  fp = fopen(filename, "r");				
  fgets(header, 20, fp);
  if (strcmp(header, "#CD Edit Document#\n") != 0)		    /* Check if the file is a cdEdit file */
  {
    AlertMessage("This is not a cdEdit document.", "Please try another file");
    fclose(fp);
    return Error;
  }
  oldlines = lines;
  fscanf(fp, "#Total number of tracks : %d\n", &tempTotalTracks);
  fscanf(fp, "#Total time : %d %d\n", &tempmin, &tempsec);
  if (discInPlayer == 1 && (tempTotalTracks != toc->size
			    || tempmin != toc->total_msf->min || tempsec != toc->total_msf->sec)) 
  {
    AlertMessage("This document is not compatible with the disc currently in the player.",
		 "Please try another document, or change the disc.");
    fclose(fp);
    return Error;
  }
  strcpy(cdfilename, filename);
  editTotalTracks = tempTotalTracks;
  editmin = tempmin;
  editsec = tempsec;
  fgets(tempLabel, MaxLabelLength + 14, fp);
  strcpy(discLabel, &tempLabel[14]);
  discLabel[strlen(discLabel) - 1] = '\0';
  xv_set(cdEdit_EditPopup->DiscLabelText, PANEL_VALUE, discLabel, NULL);
  fscanf(fp, "#Number of edits : %d\n", &lines);					    /* Start loading the edit list from the file */
  for (i=0; i < lines; i++) 
  {
    fscanf(fp, "\n");
    fscanf(fp, "#Edit Number : %d\n", &dummy);
    fscanf(fp, "Start time : %d %d %d %d\n", &starttrack[i], &startmin[i], 
	   &startsec[i], &startframe[i]);
    fscanf(fp, "End time : %d%d%d%d\n", &endtrack[i], &endmin[i], 
	   &endsec[i], &endframe[i]);
    fscanf(fp, "Volume : %d\n", &volume[i]);
    fscanf(fp, "Balance : %d\n", &balance[i]);
    fscanf(fp, "Duration : %d\n", &duration[i]);
    fgets(tempLabel, MaxLabelLength + 8, fp);
    strcpy(label[i], &tempLabel[8]);
    label[i][strlen(label[i]) - 1] = '\0';
  }
  fclose (fp);
  if (editnum != -1)						    /* Deselect any currently selected entry */
  {
    xv_set(cdEdit_EditPopup->EditList,
	   PANEL_LIST_SELECT, editnum, FALSE,
	   NULL);
  }
  for (i=0; i<oldlines; i++)					    /* Replace the old strings by the new ones */
  {
    PrintOnList(i, buf);
    xv_set (cdEdit_EditPopup->EditList,
	    PANEL_LIST_STRING, i, buf,
	    PANEL_LIST_FONT, i, font,
	    NULL);
  }
  if (oldlines < lines)						    /* Insert the additional new strings */
  {
    for (i=oldlines; i<lines; i++) 
    {
      PrintOnList(i, buf);
      xv_set (cdEdit_EditPopup->EditList,
	      PANEL_LIST_INSERT, i,
	      PANEL_LIST_STRING, i, buf,
	      PANEL_LIST_FONT, i, font,
	      NULL);
    }
  }
  else								    /* Delete the additional old entries */
  {
    for (i=lines; i< oldlines; i++)
    {
      xv_set(cdEdit_EditPopup->EditList,
	     PANEL_LIST_DELETE, lines,
	     NULL);
    }
  }
  PrintNumEdit();						    /* Update the edit status information */
  xv_set(cdEdit_EditPopup->CurrentSelectionMsg, PANEL_LABEL_STRING, "Current Selection : None", NULL); /*  */
  editnum = -1;
  change = 0;
  UpdateHeader(0);
  xv_set(cdEdit_EditPopup->ModifyButton, PANEL_INACTIVE, TRUE, NULL); /* Set the modify, delete buttons to inactive */
  xv_set(cdEdit_EditPopup->DeleteButton, PANEL_INACTIVE, TRUE, NULL);
  return OK;
}

/*
 * Notify callback function for `SaveButton'.
 * This function will save the current edit list onto the file as specified in the filename textfield.  If the file already exists, the user is
 * warned and given the choice to proceed or abort.
 */
int SaveHandler(filename, id)
     char *filename;
     int id;
{
  FILE *fp;			
  struct stat stbuf;
  int i, result;
  char header[20], buf[40];
  char discLabel[MaxLabelLength];

  if (CheckforUntitled(filename) == OK)				    /* Check if filename is 'untitled' (unacceptable) */
  {
    AlertMessage("'untitled' is not an acceptable filename.",
		 "please type in a new one.");
    return Error;
  }
  if (stat(filename, &stbuf) == 0)				    /* Check if the file already exists */
  {
    fp = fopen(filename, "r");
    fgets(header, 20, fp);
    fclose(fp);
    if (strcmp(header, "#CD Edit Document#\n") != 0)		    /* Check if it is a cdEdit file */
    {
      sprintf(buf, "This file is not a CD edit document.");
    }
    else 
    {
      sprintf(buf, "This CD edit document exists.");
    }
    result = notice_prompt(cdEdit_EditPopup->EditPopup, NULL,
			   NOTICE_MESSAGE_STRINGS,
			   buf,
			   "Do you wish to overwrite it?",
			   NULL,
			   NOTICE_BUTTON_NO,	"Yes",
			   NOTICE_BUTTON_YES,	"No",
			   NULL);
    if (result == NOTICE_YES)					    /* Abort the save operation */
    {
      return Error;
    }
  }								    /* end if (stat... */
  fp = fopen(filename, "w");
  if (fp == (FILE*)NULL)					    /* Was there an error in opening the file for writing? */
  {								    /* Yes, return without doing anything else */
    return Error;
  }
  lines = xv_get(cdEdit_EditPopup->EditList, PANEL_LIST_NROWS);	    /* Get the number of lines in the edit list */
  fprintf(fp, "#CD Edit Document#\n");				    /* Start writing the file with info from the edit list */
  if (discInPlayer == 1)
  {
    fprintf(fp, "#Total number of tracks : %d\n", toc->size);
    fprintf(fp, "#Total time : %d %d\n", toc->total_msf->min, toc->total_msf->sec);
  }
  else 
  {
    fprintf(fp, "#Total number of tracks : %d\n", editTotalTracks);
    fprintf(fp, "#Total time : %d %d\n", editmin, editsec);
  }
  strcpy(discLabel, (char *) xv_get(cdEdit_EditPopup->DiscLabelText, PANEL_VALUE));
  fprintf(fp, "#Disc Label : %s\n", discLabel);
  fprintf(fp, "#Number of edits : %d\n", lines);
  for (i=0; i < lines; i++) 
  {
    fprintf(fp, "\n");
    fprintf(fp, "#Edit Number : %d\n", i + 1);
    fprintf(fp, "Start time : %d %d %d %d\n", starttrack[i], startmin[i], startsec[i],
	    startframe[i]);
    fprintf(fp, "End time : %d %d %d %d\n", endtrack[i], endmin[i], endsec[i],
	    endframe[i]);
    fprintf(fp, "Volume : %d\n", volume[i]);
    fprintf(fp, "Balance : %d\n", balance[i]);
    fprintf(fp, "Duration : %d\n", duration[i]);
    fprintf(fp, "Label : %s\n", label[i]);
  }
  fclose (fp);
  strcpy(cdfilename, filename);
  change = 0;
  UpdateHeader(0);
  return OK;
}
