/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/cdEdit/RCS/dim.c,v 2.0 91/10/06 21:01:16 chua Exp $ */
/* $Log:	dim.c,v $
 * Revision 2.0  91/10/06  21:01:16  chua
 * Update to version 2.0
 * 
 * Revision 1.11  91/09/05  14:14:01  chua
 * In DimButtons, also dim the modify and delete buttons.  However, only
 * undim them if a selection has been chosen.
 * 
 * Revision 1.10  91/09/03  14:52:24  chua
 * Removed a few extra blank lines at the end of the dim function.
 * The revision number is changed to 1.10 (it was incremented to 0.100 from 0.99, and
 * I could not force it to be 1.00).
 * 
 * Revision 0.99  91/09/03  14:50:10  chua
 * This file contains the function DimButtons, which is called when a disc is newly inserted,
 * or a disc has been ejected.  It will either dim or undim the buttons on the remote
 * control as well as the edit buttons on the edit panel.
 *  */

static char dimrcsid[] = "$Header: /Source/Media/collab/cdEdit/RCS/dim.c,v 2.0 91/10/06 21:01:16 chua Exp $";

#include "main.h"

void DimButtons(dim)
     int dim;
{
  Menu menu;
  Menu_item mi;

  menu = xv_get(cdEdit_EditPopup->OpenPreviewPopupButton, PANEL_ITEM_MENU); /* Dim/undim the preview button and menu */
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Play whole edit",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  mi = (Menu_item) xv_find (menu, MENUITEM,
			    MENU_STRING, "Play part of edit ...",
			    NULL);
  xv_set(mi, MENU_INACTIVE, dim, NULL);
  xv_set(cdEdit_EditPopup->OpenPreviewPopupButton, PANEL_INACTIVE, dim, NULL);
  xv_set(cdEdit_EditPopup->GetStartButton, PANEL_INACTIVE, dim, NULL);
  xv_set(cdEdit_EditPopup->GetEndButton, PANEL_INACTIVE, dim, NULL);
  xv_set(cdEdit_EditPopup->AddButton, PANEL_INACTIVE, dim, NULL);
  xv_set(cdEdit_EditPopup->DeleteAllButton, PANEL_INACTIVE, dim, NULL);
  if (dim || editnum >= 0) 
  {
    xv_set(cdEdit_EditPopup->DeleteButton, PANEL_INACTIVE, dim, NULL);
    xv_set(cdEdit_EditPopup->ModifyButton, PANEL_INACTIVE, dim, NULL);
  }
  xv_set(cdEdit_window1->OneButton, PANEL_INACTIVE, dim, NULL);	    /* Dim/undim all the numeric pad buttons */
  xv_set(cdEdit_window1->TwoButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->ThreeButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->FourButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->FiveButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->SixButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->SevenButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->EightButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->NineButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->ZeroButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->SearchButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->SearchTrackText, PANEL_INACTIVE, dim, NULL);	 

  xv_set(cdEdit_window1->DurationSlider, PANEL_INACTIVE, dim, NULL); /* Dim/undim the duration slider */

  xv_set(cdEdit_window1->PauseButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->StopButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->PlayButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->ReverseSkipButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->EjectButton, PANEL_INACTIVE, dim, NULL);	 
  xv_set(cdEdit_window1->ForwardSkipButton, PANEL_INACTIVE, dim, NULL);	 
}
