/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/Pioneer6000Driver.h,v 0.17 92/09/01 17:09:01 drapeau Exp $ */
/* $Log:	Pioneer6000Driver.h,v $
 * Revision 0.17  92/09/01  17:09:01  drapeau
 * Updated copyright notice.
 * Also, added function prototypes to function definitions for better
 * ANSI compliance.
 * 
 * Revision 0.16  92/01/03  16:54:12  drapeau
 * Removed inclusion of string.h so as not to conflict with other files
 * that use this driver.
 * 
 * Revision 0.15  91/09/30  17:06:53  lim
 * Added Pioneer6000Ping.
 * 
 * Revision 0.14  91/08/24  13:38:11  lim
 * 1. Updated to use status codes in new PlayerStatus.h
 * 2. Clear Marker() removed as part of video object.
 * 
 * Revision 0.13  91/08/07  13:16:56  lim
 * 1. Included "videoObj.h" and "PlayerStatus.h"
 * 
 * Revision 0.12  91/08/02  12:53:14  lim
 * Pause() is removed.
 * 
 * Revision 0.11  91/07/29  22:27:16  lim
 * Removed #define's for player status to PlayerStatus.h
 * 
 * Revision 0.10  91/07/27  22:19:42  lim
 * *** empty log message ***
 *  */

#include <ctype.h>
#include <fcntl.h>
#include <sys/termio.h>
#include <stdio.h>
#include "videoObj.h"
#include "PlayerStatus.h"

static char P6000hrcs[] = "$Header: /Source/Media/collab/VideoObject/RCS/Pioneer6000Driver.h,v 0.17 92/09/01 17:09:01 drapeau Exp $";


int Pioneer6000Play			(VideoObject*);
int Pioneer6000PlayFromTo		(VideoObject*, int, int, int);
int Pioneer6000FastForward		(VideoObject*);
int Pioneer6000Reverse			(VideoObject*);
int Pioneer6000CalcSpeed		(VideoObject*, int, int);
int Pioneer6000PlayAtSpeedDir		(VideoObject*, int, enum Direction);
int Pioneer6000Step			(VideoObject*, enum Direction);
int Pioneer6000Still			(VideoObject*);
int Pioneer6000Stop			(VideoObject*);
int Pioneer6000SetDefaults		(VideoObject*, int, int, int, int);
int Pioneer6000SetAudio			(VideoObject*, int);
int Pioneer6000SetVideo			(VideoObject*, int);
int Pioneer6000SetAddMode		(VideoObject*, int);
int Pioneer6000SetAddressDisplay	(VideoObject*, int, int);
int Pioneer6000Eject			(VideoObject*);
int Pioneer6000Power			(VideoObject*, int);
int Pioneer6000QueryFrame		(VideoObject*);
int Pioneer6000QueryChapter		(VideoObject*);
int Pioneer6000QueryAudio		(VideoObject*);
int Pioneer6000QueryVideo		(VideoObject*);
int Pioneer6000QueryMedium		(VideoObject*, char*);
int Pioneer6000QueryStatus		(VideoObject*);
int Pioneer6000Ping			(VideoObject*);
int Pioneer6000Record			(VideoObject*);
int Pioneer6000RecordFromTo		(VideoObject*, int, int, int);
