/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoEdit/RCS/VideoEdit.h,v 0.29 92/06/15 14:54:35 drapeau Exp $ */
/* $Log:	VideoEdit.h,v $
 * Revision 0.29  92/06/15  14:54:35  drapeau
 * Minor change, declared "UpdateHeader()" with function prototypes.
 * 
 * Revision 0.28  92/05/29  12:38:47  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 0.27  92/05/13  00:21:39  drapeau
 * Minor change, changed name of function "SetPlayer()" to
 * "SetPlayerHandler()".
 * 
 * Revision 0.26  92/05/12  19:07:32  drapeau
 * Slight changes to definitions of a couple of functions, that reflect
 * changes in the interface.
 * 
 * Revision 0.25  92/01/07  14:06:57  drapeau
 * Cosmetic changes only, to make the code more readable.
 * 
 * Revision 0.24  91/09/26  11:48:45  lim
 * Added chosenHost.
 * 
 * Revision 0.23  91/09/24  20:45:22  lim
 * Combined all the header files (from Edit, Options, Preview, and Protocol)
 * into this file.
 * 
 * Revision 0.22  91/08/24  17:56:11  lim
 * Added diagMode for printing diagnostics.
 * 
 * Revision 0.21  91/08/21  10:47:50  lim
 * Added new variable, mySerialPort, to denote serial port setting on
 * options panel.
 * 
 * Revision 0.20  91/08/09  10:45:48  lim
 * *** empty log message ***
 * 
 * Revision 0.19  91/08/09  10:44:09  lim
 * *** empty log message ***
 * 
 * Revision 0.18  91/08/09  10:34:36  lim
 * Header files for drivers are taken out and put with 
 * 'videoObjects.c'
 * 
 * Revision 0.17  91/08/07  13:25:25  lim
 * 1. Removed 'MyAbs' and 'MyRound' to 'videoObj.h'.
 * 2. Removed 'playerLine' because now each device has an instance object, which
 * stores the appropriate file descriptor.
 * 3. Added 'DevInit()' and 'DisplayError()'.
 * 
 * Revision 0.16  91/08/02  12:59:03  lim
 * 1. Removed "videoObjects.h"
 * 2. Added variables : 'currentAudio' and 'myVideo'.
 * 
 * Revision 0.15  91/07/29  22:29:38  lim
 * Added "PlayerStatus.h" and "Sony1550Driver.h"
 * 
 * Revision 0.14  91/07/27  22:28:41  lim
 * 1. Changed speed to int from double.
 * 2. Added Pioneer6000Driver.
 * 3. "MyRound" has been shifted here.
 * 
 * Revision 0.13  91/07/24  11:01:36  lim
 * Ran through xsaber - added declarations for Pause and Stop.
 * 
 * Revision 0.12  91/07/23  15:56:20  lim
 * Included Panasonic Optical Driver header file.
 * Declared SetPlayer() for choosing driver to use.
 * 
 * Revision 0.11  91/07/19  14:10:15  lim
 * Added AudioType and arrays for audio and speed settings.
 * 
 * Revision 0.10  91/07/12  16:19:42  lim
 * Initial revision implementing VideoObject.
 *  */

#include <errno.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "VideoEdit_ui.h"
#include "Sender.h"
#include "Receiver.h"
#include <getopt.h>
#include <videoObj.h>
#include <PlayerStatus.h>
#include <Browse.h>

#define MAX_LISTSIZE	1000
#define MAX_LABELSIZE	22
#define MAX_FRAME	54000
#define MAX_PATHLENGTH	256
#define MAX_HOSTNAME	256
#define MaxNameLength	30

#define LOAD 0
#define SAVE 1
#define SAVEAS 2

enum AudioType {Stereo, Right, Left, Mute};			    /* Different audio settings available for each edit */

int paused;							    /* Set when player is paused. Unset when pause is hit again */
int lines;							    /* number of lines in the edit list */
int editnum;							    /* the current selection in the edit list */
int change;							    /* indicates if unsaved changes exist in the edit list */
int clearframe;							    /* determines if the frame/chapter textfield is to be cleared*/
int search;							    /* flag to indicate if a notify procedure is to be executed. 
								       This is necessary because a textfield notify procedure is 
								       executed twice for each key depressed (possibly a XView 
								       bug */
int		startframe[MAX_LISTSIZE]; 
int		endframe[MAX_LISTSIZE];				    /* arrays to store the start/end frames of
								       each entry in the edit list */
char		label[MAX_LISTSIZE][MAX_LABELSIZE+1];		    /* array to store the label of each entry in the edit list */
enum AudioType	audioStg[MAX_LISTSIZE];				    /* array to store the audio settings for each edit */
int		speedStg[MAX_LISTSIZE];				    /* array to store the speed settings for each edit */

char		deviceName[MaxNameLength];			    /* Name of device currently used */
int		currentAudio;					    /* Audio setting of current edit */
VideoObject*	myVideo;					    /* Pointer to current video object */
static char	chosenHost[MAX_HOSTNAME];			    /* Current (chosen from options panel) network host */
char		mySerialPort[10];				    /* Serial port setting from options panel */

int		receiverPort;					    /* Command line port */
char*		startFilename;					    /* Name of file in command line */
char		hostname[MAX_HOSTNAME];				    /* Name of host */
Xv_font*	font;						    /* Font used in the panel list */

enum Boolean	diagMode;					    /* Flag : Whether to print diagnostic messages */

VideoEdit_window1_objects		*VideoEdit_window1;
VideoEdit_optionsPopup_objects     	*VideoEdit_optionsPopup;
VideoEdit_editPopup_objects     	*VideoEdit_editPopup;
VideoEdit_previewPopup_objects     	*VideoEdit_previewPopup;
VideoEdit_infoPopup_objects     	*VideoEdit_infoPopup;

Attr_attribute	INSTANCE;

void PlayMode();
void SetDuration();
void SetPlayerHandler(Panel_item item, Event *event);
void Stop();
void Pause();

VideoObject* DevInit();						    /* These functions are added from `videoObjects.c' */
void DisplayError();
void PrintDiagnostics();

/* Defined in VideoEditProtocol.c */

void InitNetwork();
void OpenDoc();
void SetSelection();
void PerformSelection();
char ** GetDoc();
MAESelection* GetSelection();
void HaltSelection();
void PauseSelection();
void ResumeSelection();
void HideApplication();
void ShowApplication();
IconData* GetAppIcon();

Sender* sender;
Receiver* receiver;


/* Defined in VideoEditPreview.c */

Menu_item PreviewStartEnd();
void PreviewStart();
void PreviewEnd();
void PreviewDone();


/* Defined in VideoEditOptions.c */

void DisplaySelect();
void SearchSet();
void optionsSetPort();
void Audio();
void Done();


/* Defined in VideoEditEdit.c */

int OpenHandler();
int SaveHandler();

void PrintOnList();
void PrintNumEdits();
void FileError();
Menu_item FileLoad();
Menu_item FileSave();
Menu_item FileSaveAs();
Menu_item EditCloseFile();
void EditDone();
void GetStart();
void GetEnd();
Menu_item EditPreview();
void EditAdd();
void EditDelete();
void EditModify();
int List();
void EditDeleteAll();
void UpdateHeader (char* documentName, int modified);


static char mainhrcs[] = "$Header: /Source/Media/collab/VideoEdit/RCS/VideoEdit.h,v 0.29 92/06/15 14:54:35 drapeau Exp $";

