/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/TimeLine/RCS/instrument.h,v 1.11 92/09/24 17:11:22 drapeau Exp $ */
/* $Log:	instrument.h,v $
 * Revision 1.11  92/09/24  17:11:22  drapeau
 * A new field was added to the MediaSegment structure: the "setupTime" field
 * was added to hold synchronization information for each note on the TimeLine.
 * The field indicates an estimate of the time (in milliseconds) it will take
 * to perform the note to which the MediaSegment belongs.
 * Other changes are cosmetic, to improve readability.
 * 
 * Revision 1.10  92/05/29  14:42:09  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 1.0  91/09/30  17:03:26  chua
 * Update to version 1.0
 * 
 * Revision 0.62  91/09/25  13:43:27  chua
 * Changed the name InstrumentInfo to EditInfo
 * 
 * Revision 0.61  91/09/19  17:28:51  chua
 * Make sure that variables are initialized properly.  Change formatting slightly,
 * so that (if, for, while) statements with only one statement in them will not have
 * braces.
 * 
 * Revision 0.60  91/09/17  17:20:27  chua
 * Renamed Region to tlRegion.
 * 
 * Revision 0.59  91/08/16  13:50:43  chua
 * In the instrument data structure, have a new variable, icon, which will store the
 * icon for the instrument so that it need not be created each time.
 * 
 * Revision 0.58  91/08/14  12:11:29  chua
 * In the Instrument data structure, include a new variable initialNote, which indicates if 
 * the current note is the first in a play operation.
 * 
 * Revision 0.57  91/07/30  11:23:52  chua
 * In the Region structure, change the type of label from int to char.
 * 
 * Revision 0.56  91/07/26  17:18:42  chua
 * Added a new data structure, Region, to deal with annotated regions.
 * 
 * Revision 0.55  91/07/22  15:23:30  chua
 * Added a new data structure, Pause, which serves as the nodes for the Pause linked list 
 * which keeps track of where all the pause markers are.
 * 
 * Revision 0.54  91/07/17  10:07:58  chua
 * Deleted the constant definition of AnchorWidth as it is no longer required.
 * 
 * Revision 0.53  91/06/26  16:46:29  chua
 * Added a new field, partialNote to the instrument structure, which indicates if a partial note
 * has been chosen for playing during the TimerNotify procedure.
 * 
 * Deleted the HalfSecondScale constant (replaced it by the value 5 wherever it appears in code).
 * 
 * Revision 0.52  91/06/04  17:37:17  chua
 * Added the copyright comments in the beginning of the file.
 * 
 * Revision 0.51  91/05/28  12:10:56  chua
 * 
 * 
 * Revision 0.50  91/05/24  16:36:45  chua
 * *** empty log message ***
 * 
 * Revision 0.49  91/05/23  17:39:21  chua
 * *** empty log message ***
 * 
 * Revision 0.48  91/05/22  16:40:12  chua
 * 
 * 
 * Revision 0.47  91/05/22  13:56:11  chua
 * 
 * 
 * Revision 0.46  91/05/22  11:52:09  chua
 * *** empty log message ***
 * 
 * Revision 0.45  91/05/17  16:56:12  chua
 * *** empty log message ***
 * 
 * Revision 0.44  91/05/17  16:56:06  chua
 * *** empty log message ***
 * 
 * Revision 0.43  91/05/17  16:56:02  chua
 * *** empty log message ***
 * 
 * Revision 0.42  91/05/17  16:55:57  chua
 * *** empty log message ***
 * 
 * Revision 0.41  1991/04/08  21:07:41  chua
 * A new include file "InstrumentInfo_ui.h" is included as this is the header file generated by Guide for
 * the instrument info pop-up window.
 *
 * New additions to the Note data structure:
 * int startMin, startSec, endMin, endSec, durationMin, durationSec
 *
 * These fields are used for displaying the panel list information in the info pop-up windows.  The use of
 * these fields avoid having to compute the values each time a panel list is to be updated.
 *
 * New additions to the Instrument data structure:
 * Note *infoNote - points to the note structure that is currently selected in the info panel list for this
 *                  instrument.
 * int selectedInfoNote - gives the relative position of the selected note in the notes list of the instrument.
 * InstrumentInfo_InstrumentInfoWindow_objects *instInfo - Object pointer to the instrument info pop-up window.
 *
 * Revision 0.40  1991/03/29  00:01:51  chua
 * This file contains the definitions for the data structures used in keeping track of the information entered
 * by the user (Notes) as well as those obtained from the PortManager and the 'remote' applications.  It also has
 * the constant definitions of values used for drawing the notes, cables and icons on the canvases.
 *
 * Each application that is checked in with the PortManager is represented by an Instrument data structure.  This
 * data structure holds information on what port the application is listening on, the sender to that port, a list
 * of Notes for this application and some other miscellaneous data for drawing and playback purposes.  Each
 * application will be represented by its icon on the left side of the TimeLine application, and there will be a
 * cable associated with each instrument where the user can insert new Notes.
 *
 * A Note data structure consists of the current selection in the 'remote' application at the time the user inserts
 * this note.  It stores information on where the note is on the screen, as well as a MediaSegment data structure,
 * which stores information obtained via the LinkProtocol from the application, such as the document name,
 * the Selection data structure and duration of the note.
 * */

static char instrumentHrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/instrument.h,v 1.11 92/09/24 17:11:22 drapeau Exp $";

#ifndef _instrument_
#define _instrument_
#include "EditInfo_ui.h"


/*
 * Constants for drawing the notes, cables, icons on the canvases.
 * The numbers refer to pixel values. 
 */

#define MaxLabelLength          256
#define PixelsPerSecond         10				    /* Number of pixels representing 1 second in lowest zoom level */
#define FirstCableYPosition     36				    /* Starting Y position of the first cable */
#define CableHeight		4				    /* A cable is the line on which notes are drawn */
#define NoteHeight      	14				    /* Specifies the height of a note */
#define IconHeight              64				    /* Height of an application icon (instrument icon) */
#define IconGap                 8				    /* gap between application icons */
#define IconXOffset             12				    /* X offset for start position of apps icons */
#define TimeLineInterval	5				    /* Time interval in seconds between time markers on timeline */
#define TimeLineY		20				    /* Y position of the timeline on the TimeCanvas */
#define MarkerWidth		2				    /* Width of a time marker on the timeline */
#define MarkerHeight		8				    /* Height of a time marker on the timeline */

typedef struct MediaSegment					    /* Stores the information about a note.  This information... */
{								    /* ...is obtained from an app through the network protocol. */
  char*		documentName;					    /* Name of the file to be opened for the remote application */
  MAESelection*	selection;					    /* Contains info necessary for the remote app to playback... */
								    /* ...the note.  The duration field here is in milliseconds. */
  long   	duration;					    /* Application set duration (in half seconds) */
  int		setupTime;					    /* Time (in milliseconds) taken to perform OpenDoc and... */
								    /* ...SetSelection methods.  Used for synchronization hints. */
} MediaSegment;

typedef struct Note 
{
  int		start;						    /* X-coordinate of the start point of the note on the canvas */
  int		end;						    /* X-coordinate of the end point of the note on the canvas */
  int		startMin, startSec, endMin, endSec;		    /* Fields used for the info pop-up window */
  int		durationMin, durationSec;
  MediaSegment*	ms;						    /* Contains information necessary for playback of the note */
  struct Note*	next;
} Note;

typedef struct Instrument 
{
  int					relativePosition;	    /* Position of this instrument in the instrument list */
  int					cableStart;		    /* Starting Y position of the cable for this instrument */
  Pixmap				icon;			    /* Stores the pixmap image of the application icon */
  int					numnotes;		    /* Number of notes in this instrument */
  int					playNote;		    /* Flag to indicate if there is a note to be played now */
  int					initialNote;		    /* Indicates if 1st note from where play begins is being played */
  int					partialNote;		    /* Indicates if a partial note is chosen */
  Note*					firstNote;		    /* Pointer to 1st note in list of notes for this instrument */
  Note*					currentNote;		    /* Points to the current note in playback */
  Note*					infoNote;		    /* Points to the selected note in the info pop-up window */
  int					selectedInfoNote;	    /* Relative position of selected note in the info pop-up window */
  Port*					port;			    /* Used to get names, icons, etc. */
  Sender*				sender;			    /* Sender to the open app */
  EditInfo_EditInfoWindow_objects*	editInfo;		    /* Object pointer to the instrument info pop-up window */
  struct Instrument*			next;	
} Instrument;

typedef struct Pause 
{
  int position;							    /* Position of the pause marker in terms of pixels */
  int min;							    /* Minutes portion of time for the position of the pause marker */
  int sec;							    /* Seconds portion of time for the position of the pause marker */
  struct Pause *next;
} Pause;

typedef struct tlRegion						    /* Data structure for the region info list */
{
  int startX;							    /* Starting and ending x positions in pixels */
  int endX;
  int startMin;							    /* Starting and ending X positions in min/secs */
  int startSec;
  int endMin;
  int endSec;
  char label[MaxLabelLength];
  struct tlRegion *next;
} tlRegion;

#endif
