/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/TimeLine/RCS/edit.c,v 1.1 92/01/03 17:30:34 drapeau Exp $ */
/* $Log:	edit.c,v $
 * Revision 1.1  92/01/03  17:30:34  drapeau
 * Slight modification to ClearAllHandler(); changed a reference from
 * "NULL" to "0" to reflect change in ANSI-C definition of NULL to
 * (void*)0.
 * 
 * Revision 1.0  91/09/30  16:54:36  chua
 * Update to version 1.0
 * 
 * The parameter to ClearAllNotes (line 314) is now tlFrame, instead of tlFrame->instHead.
 * 
 * Revision 0.67  91/09/25  13:47:20  chua
 * Changed the instrument field, instInfo, to editInfo. 
 * Changed InstrumentInfo to EditInfo.
 * 
 * Revision 0.66  91/09/23  17:09:48  chua
 * In line 323, change selectedInstrument to noteInstrument, as the latter is
 * now used to indicate which instrument has the currently selected note.
 * 
 * Revision 0.65  91/08/26  14:21:14  chua
 * Deleted the actualApps variable from the tlFrame structure.
 * 
 * Revision 0.64  91/08/08  15:47:01  chua
 * In ClearAll routine, change return NULL to return item.
 * 
 * Revision 0.63  91/08/05  16:53:03  chua
 * Deleted the RepaintCanvas routine, as it is no longer necessary.  In places where it
 * is called, just call the ScrollToFirstQuarter routine, which will do the necessary
 * repaint as well.
 * 
 * Revision 0.62  91/07/26  17:23:50  chua
 * In the ClearAllHandler, clear all the entries in the region list as well.
 * 
 * Revision 0.61  91/07/24  10:32:44  chua
 * In the ClearAllHandler, clear all the pause markers as well.
 * 
 * Revision 0.60  91/07/09  16:56:46  chua
 * Some reformatting changes only.
 * 
 * Revision 0.59  91/06/04  17:37:13  chua
 * Added the copyright comments in the beginning of the file.
 * 
 * Revision 0.58  91/06/04  17:22:32  chua
 * Added a new function, ShowClipboardHandler, which will show the current clipboard (only if
 * the clipboard is not already showing).
 * 
 * In the CutHandler and CopyHandler, add code to update the clipboard window if it is
 * showing.
 * 
 * Revision 0.57  91/06/04  10:42:20  chua
 * Added a call to UpdateHeader whenever there is a change in the status of
 * the current document (the change flag set to 1).
 * 
 * Revision 0.56  91/06/03  11:10:45  chua
 * Make changes to accomodate multiple documents.  This involves identifying
 * which is the current active window, that is, the one where the last mouse
 * click was done.
 * 
 * Revision 0.55  91/05/30  12:07:42  chua
 * Added an extra parameter in the call to InitNotesInfo.  The second parameter,
 * deselect, indicates if the currently selected note is to be deselected.
 * 
 * Revision 0.54  91/05/29  18:29:59  chua
 * In the ClearAllHandler, the old panel list found in the info popup window is destroyed and a 
 * new note created.  This seems to eliminate the problems of the application crashing when we
 * try to insert a note after doing a clear all notes function.
 * 
 * Revision 0.53  91/05/29  17:04:09  chua
 * Added the ClearAllNotes function call in the ClearAllHandler and set instrument->infoNote to
 * NULL.
 * 
 * Revision 0.52  91/05/29  14:30:14  chua
 * In the ClearAllHandler routine, in lines 208-211, the ClearNoteInfo and UpdateNotesCount function
 * calls are no longer necessary, due to the rewriting of the InitNotesInfo function.
 * 
 * Revision 0.51  91/05/28  12:09:37  chua
 * *** empty log message ***
 * 
 * Revision 0.50  91/05/24  16:35:49  chua
 * *** empty log message ***
 * 
 * Revision 0.49  91/05/23  17:38:43  chua
 * *** empty log message ***
 * 
 * Revision 0.48  91/05/22  16:38:04  chua
 * Removed the CheckIfNoteSelected function.  Instead, everytime the SelectNoteInfo procedure
 * in notesInfo.c is called, similar code as that in the CheckIfNoteSelected function is
 * performed.
 * 
 * The CheckIfNoteSelected function calls in the edit function handlers are also deleted.
 * 
 * Revision 0.47  91/05/22  13:55:48  chua
 * 
 * 
 * Revision 0.46  91/05/22  11:36:43  chua
 * Added a call to CheckIfNoteSelected in the PasteHandler, just before calling the
 * PasteFromClipboard routine.
 * This is because if a note is selected, we can replace it with whatever is contained in
 * the clipboard (provided the contents consists of just that particular instrument which the
 * selected note belongs to).
 * 
 * Revision 0.45  91/05/16  15:22:25  chua
 * Removed the undo menu function for the time being.  UndoHandler is deleted.
 * 
 * Revision 0.44  91/05/16  14:35:16  chua
 * A new function CheckIfNoteSelected is added.  The capability to apply the edit functions to a
 * single selected note, instead of a whole selected region is added.
 * The function first checks if an area is selected.  If so, it doesn't do anything, since the
 * edit functions will be as before (to a whole selected region).
 * If no area is selected and the selectedInstrument pointer is not NULL, a check is then made
 * to see if there is a note selected in this instrument.  If so, the coordinates of a selected
 * region (startX, endX, startY, endY) are set to simulate the note being selected in a region.
 * The edit functions in the file select.c are then called and the operations will be very similar
 * as for a whole selected region.
 * 
 * This new function is called in the Cut, Copy, Delete and Paste Handlers. 
 * 
 * Revision 0.43  1991/05/15  02:55:28  chua
 * A parameter is added in the calls to DeleteNotesFromList found in the CutHandler and
 * DeleteHandler.
 * The value is 1 to indicate that refreshing of the canvas is necessary after the delete notes
 * operation is done.
 *
 * Revision 0.42  1991/04/24  00:54:59  chua
 * Added the function calls for the Cut, Copy, Paste and Delete Handlers.  The functions called
 * are found in select.c
 *
 * They are:
 *
 * CopyToClipboard
 * DeleteNotesFromList
 * PasteFromClipboard
 *
 * Also, since the instrument info pop-up window is now created whenever an instrument is created,
 * instead of only when the 'Show notes info' button is pressed, there is no need to check if
 * the pointer to the pop-up window is NULL in the ClearAllHandler function, since the pop-up
 * window will always be present.
 *
 * Revision 0.41  1991/04/08  20:49:54  chua
 * Added code to update the info pop-up windows when the notes are cleared in the ClearAllHandler procedure.
 * This will clear all the panel lists and set the notes count to zero for all the info pop-up windows that
 * have been created.
 *
 * Revision 0.40  1991/04/01  01:43:27  chua
 * This file contains the menu notify procedures for the edit menu button.  The different edit functions at this
 * point are:
 * Cut, Copy, Paste, Delete, Undo, ClearAll.
 * At present, only the ClearAll function is implemented.  This function clears the TimeLine of all notes,
 * essentially leaving the user a fresh canvas to start with.  The function will check if any unsaved changes
 * exist and give the user the option of going on or cancelling the operation if there are unsaved changes.
 * */

static char editrcsid[] = "$Header: /Source/Media/collab/TimeLine/RCS/edit.c,v 1.1 92/01/03 17:30:34 drapeau Exp $";

#include "main.h"

/*
 * Menu handler for `edit_menu (Cut)'.
 * This function cuts out the selected area and copies it to the clipboard.
 * It will then update the clipboard display if the window is visible.
 */
Menu_item CutHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    CopyToClipboard(tlFrame);
    DeleteNotesFromList(1, tlFrame);
    if (xv_get(TimeLineWindow[0]->TimeLine_window->window, XV_SHOW) == TRUE) /* Update clipboard only if it is showing */
    {
      SetCanvasHeight(TimeLineWindow[0]);
      ScrollToFirstQuarter(TimeLineWindow[0], 0, 1);
    }
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `edit_menu (Copy)'.
 */
Menu_item CopyHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    CopyToClipboard(tlFrame);
    if (xv_get(TimeLineWindow[0]->TimeLine_window->window, XV_SHOW) == TRUE) /* Update clipboard only if it is showing */
    {
      SetCanvasHeight(TimeLineWindow[0]);
      ScrollToFirstQuarter(TimeLineWindow[0], 0, 1);
    }
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `edit_menu (Paste)'.
 */
Menu_item PasteHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    PasteFromClipboard(tlFrame);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `edit_menu (Delete)'.
 */
Menu_item DeleteHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    DeleteNotesFromList(1, tlFrame);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `edit_menu (Clear All)'.
 * This function will clear the TimeLine.  It first check if there are unsaved changes.  If not, it will then free all notes on all instruments and
 * then call the ScrollToFirstQuarter routine to clear the canvas and redraw all the cables. It will also update the information displayed on the info
 * pop-up windows.  The old panel list is destroyed (if not, segmentation faults occur at times (not sure why), and a new panel list is created.
 */
Menu_item ClearAllHandler(item, op)
     Menu_item       item;
     Menu_generate   op;
{
  Instrument *instrument;
  TimeLineFramePtr tlFrame;
  TimeLine_window_objects * ip = (TimeLine_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

  tlFrame = TimeLineWindow[xv_get(ip->controls, PANEL_CLIENT_DATA)];
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    if (CheckChanges(ClearAll, tlFrame) == NOTICE_YES)	    /* Check if unsaved changes exist in edit list */
    {
      return item;
    }
    ClearAllNotes(tlFrame);				    /* Clear the notes for all the instruments */
    FreePause(tlFrame);
    UpdatePauseList(tlFrame, 0);
    ClearAllRegion(tlFrame->RegionPopup->ClearAllRegionButton, NULL); /* Clear all the region */
    instrument = tlFrame->instHead;		
    while (instrument != NULL) 
    {
      xv_destroy_safe (instrument->editInfo->NoteInfoList);	    /* Destroy the old panel list and create a new one */
      instrument->editInfo->NoteInfoList = 0;
      instrument->editInfo = EditInfo_EditInfoWindow_objects_initialize (instrument->editInfo, 
									 tlFrame->TimeLine_window->window);
      xv_set(instrument->editInfo->NoteInfoList,		    /* Attach the instrument's relative position as the PANEL_CLIENT_DATA. */
	     PANEL_CLIENT_DATA, instrument->relativePosition,	    /* Lets the program know which instrument the panel belongs to. */
	     NULL);
      InitNotesInfo(instrument, 1, tlFrame);
      instrument = instrument->next;
    }
    tlFrame->noteInstrument = NULL;
    tlFrame->change = 1;
    UpdateHeader(tlFrame, 1);
    ScrollToFirstQuarter(tlFrame, 0, 1);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `EditMenu (Show Clipboard ...)'.
 * This function checks to see if the clipboard is open.  If not, it will update it and make it visible.
 * The updating is done simply by calling the ScrollToFirstQuarter routine, which will update the instrument and note displays.
 */
Menu_item ShowClipboardHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    if (xv_get(TimeLineWindow[0]->TimeLine_window->window, XV_SHOW) == FALSE) 
    {
      SetCanvasHeight(TimeLineWindow[0]);
      ScrollToFirstQuarter(TimeLineWindow[0], 0, 1);
      xv_set(TimeLineWindow[0]->TimeLine_window->window, XV_SHOW, TRUE, NULL);
    }
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}
