;GIL-3
(
(
	:type                   :menu
	:name                   EditMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Edit"
	:menu-item-labels       ("Cut" "Copy" "Paste" "Delete" "Clear All" "Show Clipboard ..." )
	:menu-item-label-types  (:string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active )
	:menu-item-defaults     (t nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil )
	:menu-item-handlers     (CutHandler CopyHandler PasteHandler DeleteHandler ClearAllHandler ShowClipboardHandler )
	:menu-item-menus        (nil nil nil nil nil nil )
	:menu-item-colors       ("Black" "Black" "Black" "Black" "Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (EditMenu "Cut")
		:when                   (Notify )
		:to                     (EditMenu "Cut")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CutHandler)
		)
		(
		:from                   (EditMenu "Copy")
		:when                   (Notify )
		:to                     (EditMenu "Copy")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CopyHandler)
		)
		(
		:from                   (EditMenu "Paste")
		:when                   (Notify )
		:to                     (EditMenu "Paste")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PasteHandler)
		)
		(
		:from                   (EditMenu "Delete")
		:when                   (Notify )
		:to                     (EditMenu "Delete")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DeleteHandler)
		)
		(
		:from                   (EditMenu "Clear All")
		:when                   (Notify )
		:to                     (EditMenu "Clear All")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ClearAllHandler)
		)
		(
		:from                   (EditMenu "Show Clipboard ...")
		:when                   (Notify )
		:to                     (EditMenu "Show Clipboard ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ShowClipboardHandler)
		)
	)
)
(
	:type                   :menu
	:name                   PlayMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Play"
	:menu-item-labels       ("Play from insertion point" "Play whole document" "Play selected region" "Synchronize This Document" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (t nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (PlayFromHandler PlayHandler PlaySelectedHandler SynchronizeDocument )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("Black" "Black" "Black" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (PlayMenu "Play from insertion point")
		:when                   (Notify )
		:to                     (PlayMenu "Play from insertion point")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayFromHandler)
		)
		(
		:from                   (PlayMenu "Play whole document")
		:when                   (Notify )
		:to                     (PlayMenu "Play whole document")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlayHandler)
		)
		(
		:from                   (PlayMenu "Play selected region")
		:when                   (Notify )
		:to                     (PlayMenu "Play selected region")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PlaySelectedHandler)
		)
		(
		:from                   (PlayMenu "Synchronize This Document")
		:when                   (Notify )
		:to                     (PlayMenu "Synchronize This Document")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SynchronizeDocument)
		)
	)
)
(
	:type                   :menu
	:name                   AppMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Applications"
	:menu-item-labels       ("Update Applications List" "Show edit info for an application ..." "Delete selected application" "Show application" "Hide application" "Mute application" "Remove mute from application" )
	:menu-item-label-types  (:string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :active )
	:menu-item-defaults     (t nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil )
	:menu-item-handlers     (UpdateAppsHandler ShowEditInfoHandler DeleteAppHandler ShowApplicationHandler HideApplicationHandler MuteAppHandler RemoveMuteAppHandler )
	:menu-item-menus        (nil nil nil nil nil nil nil )
	:menu-item-colors       ("Black" "Black" "Black" "Black" "Black" "Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (AppMenu "Update Applications List")
		:when                   (Notify )
		:to                     (AppMenu "Update Applications List")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (UpdateAppsHandler)
		)
		(
		:from                   (AppMenu "Show edit info for an application ...")
		:when                   (Notify )
		:to                     (AppMenu "Show edit info for an application ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ShowEditInfoHandler)
		)
		(
		:from                   (AppMenu "Delete selected application")
		:when                   (Notify )
		:to                     (AppMenu "Delete selected application")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DeleteAppHandler)
		)
		(
		:from                   (AppMenu "Show application")
		:when                   (Notify )
		:to                     (AppMenu "Show application")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ShowApplicationHandler)
		)
		(
		:from                   (AppMenu "Hide application")
		:when                   (Notify )
		:to                     (AppMenu "Hide application")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (HideApplicationHandler)
		)
		(
		:from                   (AppMenu "Mute application")
		:when                   (Notify )
		:to                     (AppMenu "Mute application")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MuteAppHandler)
		)
		(
		:from                   (AppMenu "Remove mute from application")
		:when                   (Notify )
		:to                     (AppMenu "Remove mute from application")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (RemoveMuteAppHandler)
		)
	)
)
(
	:type                   :menu
	:name                   DocumentMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Document"
	:menu-item-labels       ("About TimeLine Editor ..." "New ..." "Open ..." "Save" "Save as ..." "Close" "Quit" )
	:menu-item-label-types  (:string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :active )
	:menu-item-defaults     (nil nil t nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil )
	:menu-item-handlers     (AboutHandler NewHandler OpenFileHandler SaveFileHandler SaveAsFileHandler CloseHandler QuitHandler )
	:menu-item-menus        (nil nil nil nil nil nil nil )
	:menu-item-colors       ("Black" "Black" "Black" "Black" "Black" "Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (DocumentMenu "About TimeLine Editor ...")
		:when                   (Notify )
		:to                     (DocumentMenu "About TimeLine Editor ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AboutHandler)
		)
		(
		:from                   (DocumentMenu "New ...")
		:when                   (Notify )
		:to                     (DocumentMenu "New ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (NewHandler)
		)
		(
		:from                   (DocumentMenu "Open ...")
		:when                   (Notify )
		:to                     (DocumentMenu "Open ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (OpenFileHandler)
		)
		(
		:from                   (DocumentMenu "Save")
		:when                   (Notify )
		:to                     (DocumentMenu "Save")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveFileHandler)
		)
		(
		:from                   (DocumentMenu "Save as ...")
		:when                   (Notify )
		:to                     (DocumentMenu "Save as ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (SaveAsFileHandler)
		)
		(
		:from                   (DocumentMenu "Close")
		:when                   (Notify )
		:to                     (DocumentMenu "Close")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (CloseHandler)
		)
		(
		:from                   (DocumentMenu "Quit")
		:when                   (Notify )
		:to                     (DocumentMenu "Quit")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (QuitHandler)
		)
	)
)
(
	:type                   :menu
	:name                   GridMenu
	:help                   ""
	:columns                1
	:menu-type              :exclusive
	:menu-handler           nil
	:menu-title             "Grid"
	:menu-item-labels       ("Grid Off" "1/2 second" "1 second" "2 seconds" "3 seconds" "4 seconds" "5 seconds" )
	:menu-item-label-types  (:string :string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil )
	:menu-item-handlers     (GridOffHandler FivePixelHandler TenPixelHandler TwentyPixelHandler ThirtyPixelHandler FortyPixelHandler FiftyPixelHandler )
	:menu-item-menus        (nil nil nil nil nil nil nil )
	:menu-item-colors       ("Black" "Black" "Black" "Black" "Black" "Black" "Black" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (GridMenu "Grid Off")
		:when                   (Notify )
		:to                     (GridMenu "Grid Off")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (GridOffHandler)
		)
		(
		:from                   (GridMenu "1/2 second")
		:when                   (Notify )
		:to                     (GridMenu "1/2 second")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FivePixelHandler)
		)
		(
		:from                   (GridMenu "1 second")
		:when                   (Notify )
		:to                     (GridMenu "1 second")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TenPixelHandler)
		)
		(
		:from                   (GridMenu "2 seconds")
		:when                   (Notify )
		:to                     (GridMenu "2 seconds")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TwentyPixelHandler)
		)
		(
		:from                   (GridMenu "3 seconds")
		:when                   (Notify )
		:to                     (GridMenu "3 seconds")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ThirtyPixelHandler)
		)
		(
		:from                   (GridMenu "4 seconds")
		:when                   (Notify )
		:to                     (GridMenu "4 seconds")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FortyPixelHandler)
		)
		(
		:from                   (GridMenu "5 seconds")
		:when                   (Notify )
		:to                     (GridMenu "5 seconds")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (FiftyPixelHandler)
		)
	)
)
(
	:type                   :menu
	:name                   OptionsMenu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Options"
	:menu-item-labels       ("Show Region Info ..." "Insert Blank Time ..." "Insert/Delete Pause Marker ..." "Grid" "Connect with new Port Manager ..." )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (ShowRegionInfoHandler InsertBlankTimeHandler InsertPauseMarkerHandler nil ConnectPortManagerHandler )
	:menu-item-menus        (nil nil nil GridMenu nil )
	:menu-item-colors       ("Black" "Black" "Black" "Black" "Black" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (OptionsMenu "Show Region Info ...")
		:when                   (Notify )
		:to                     (OptionsMenu "Show Region Info ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ShowRegionInfoHandler)
		)
		(
		:from                   (OptionsMenu "Insert Blank Time ...")
		:when                   (Notify )
		:to                     (OptionsMenu "Insert Blank Time ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InsertBlankTimeHandler)
		)
		(
		:from                   (OptionsMenu "Insert/Delete Pause Marker ...")
		:when                   (Notify )
		:to                     (OptionsMenu "Insert/Delete Pause Marker ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (InsertPauseMarkerHandler)
		)
		(
		:from                   (OptionsMenu "Connect with new Port Manager ...")
		:when                   (Notify )
		:to                     (OptionsMenu "Connect with new Port Manager ...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ConnectPortManagerHandler)
		)
	)
)
(
	:type                   :base-window
	:name                   window
	:owner                  nil
	:width                  804
	:height                 234
	:background-color       ""
	:foreground-color       ""
	:label                  "TimeLine Editor"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              t
	:icon-file              "icons/TimeLine.icon"
	:icon-label             ""
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls
	:owner                  window
	:help                   ""
	:x                      0
	:y                      0
	:width                  804
	:height                 92
	:background-color       "Light Gray"
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   documentButton
	:owner                  controls
	:help                   ""
	:x                      16
	:y                      16
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Document"
	:label-type             :string
	:initial-state          :active
	:menu                   DocumentMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   appButton
	:owner                  controls
	:help                   ""
	:x                      132
	:y                      16
	:width                  107
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Applications"
	:label-type             :string
	:initial-state          :active
	:menu                   AppMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   editButton
	:owner                  controls
	:help                   ""
	:x                      260
	:y                      16
	:width                  56
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   EditMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   playButton
	:owner                  controls
	:help                   ""
	:x                      336
	:y                      16
	:width                  58
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Play"
	:label-type             :string
	:initial-state          :active
	:menu                   PlayMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   optionsButton
	:owner                  controls
	:help                   ""
	:x                      416
	:y                      16
	:width                  80
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "Options"
	:label-type             :string
	:initial-state          :active
	:menu                   OptionsMenu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :slider
	:name                   ZoomSlider
	:owner                  controls
	:help                   ""
	:x                      520
	:y                      20
	:width                  264
	:height                 20
	:value-x                571
	:value-y                20
	:slider-width           150
	:ticks                  0
	:foreground-color       "Black"
	:label                  "Zoom : "
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-endboxes          nil
	:show-range             nil
	:show-value             t
	:min-value              1
	:max-value              40
	:min-value-string       ""
	:max-value-string       ""
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:notify-handler         ZoomSliderNotify
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window ZoomSlider)
		:when                   (Notify )
		:to                     (window ZoomSlider)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ZoomSliderNotify)
		)
	)
)
(
	:type                   :button
	:name                   pauseButton
	:owner                  controls
	:help                   ""
	:x                      192
	:y                      52
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/pauseIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         PauseResume
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window pauseButton)
		:when                   (Notify )
		:to                     (window pauseButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PauseResume)
		)
	)
)
(
	:type                   :button
	:name                   stopButton
	:owner                  controls
	:help                   ""
	:x                      264
	:y                      52
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/stopIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Stop
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window stopButton)
		:when                   (Notify )
		:to                     (window stopButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Stop)
		)
	)
)
(
	:type                   :button
	:name                   playIconButton
	:owner                  controls
	:help                   ""
	:x                      340
	:y                      52
	:width                  42
	:height                 25
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/playIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         Play
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window playIconButton)
		:when                   (Notify )
		:to                     (window playIconButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Play)
		)
	)
)
(
	:type                   :button
	:name                   MoveCanvasFastLeftButton
	:owner                  controls
	:help                   ""
	:x                      528
	:y                      52
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/FastLeftCanvasIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         MoveCanvasFastLeft
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window MoveCanvasFastLeftButton)
		:when                   (Notify )
		:to                     (window MoveCanvasFastLeftButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MoveCanvasFastLeft)
		)
	)
)
(
	:type                   :button
	:name                   MoveCanvasLeftButton
	:owner                  controls
	:help                   ""
	:x                      568
	:y                      52
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/LeftCanvasIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         MoveCanvasLeft
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window MoveCanvasLeftButton)
		:when                   (Notify )
		:to                     (window MoveCanvasLeftButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MoveCanvasLeft)
		)
	)
)
(
	:type                   :button
	:name                   MoveCanvasRightButton
	:owner                  controls
	:help                   ""
	:x                      668
	:y                      52
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/RightCanvasIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         MoveCanvasRight
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window MoveCanvasRightButton)
		:when                   (Notify )
		:to                     (window MoveCanvasRightButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MoveCanvasRight)
		)
	)
)
(
	:type                   :button
	:name                   MoveCanvasFastRightButton
	:owner                  controls
	:help                   ""
	:x                      708
	:y                      52
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "icons/FastRightCanvasIcon"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         MoveCanvasFastRight
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window MoveCanvasFastRightButton)
		:when                   (Notify )
		:to                     (window MoveCanvasFastRightButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (MoveCanvasFastRight)
		)
	)
)
(
	:type                   :button
	:name                   ResetCanvasButton
	:owner                  controls
	:help                   ""
	:x                      608
	:y                      56
	:width                  55
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Black"
	:label                  "RESET"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         ResetCanvas
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (window ResetCanvasButton)
		:when                   (Notify )
		:to                     (window ResetCanvasButton)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (ResetCanvas)
		)
	)
)
(
	:type                   :canvas-pane
	:name                   AppCanvas
	:owner                  window
	:help                   ""
	:x                      0
	:y                      90
	:width                  112
	:height                 144
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       112
	:vertical-scrollbar     nil
	:scrollable-height      144
	:repaint-proc           AppCanvasRepaintHandler
	:event-handler          AppCanvasEventHandler
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (window AppCanvas)
		:when                   (Repaint )
		:to                     (window AppCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AppCanvasRepaintHandler)
		)
		(
		:from                   (window AppCanvas)
		:when                   (AnyEvent )
		:to                     (window AppCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (AppCanvasEventHandler)
		)
	)
)
(
	:type                   :canvas-pane
	:name                   DrawCanvas
	:owner                  window
	:help                   ""
	:x                      108
	:y                      90
	:width                  696
	:height                 102
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       696
	:vertical-scrollbar     nil
	:scrollable-height      102
	:repaint-proc           DrawCanvasRepaintHandler
	:event-handler          DrawCanvasEventHandler
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (window DrawCanvas)
		:when                   (Repaint )
		:to                     (window DrawCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DrawCanvasRepaintHandler)
		)
		(
		:from                   (window DrawCanvas)
		:when                   (AnyEvent )
		:to                     (window DrawCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (DrawCanvasEventHandler)
		)
	)
)
(
	:type                   :canvas-pane
	:name                   TimeCanvas
	:owner                  window
	:help                   ""
	:x                      108
	:y                      190
	:width                  696
	:height                 44
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:draggable              nil
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:horizontal-scrollbar   nil
	:scrollable-width       696
	:vertical-scrollbar     nil
	:scrollable-height      44
	:repaint-proc           TimeCanvasRepaintHandler
	:event-handler          TimeCanvasEventHandler
	:drawing-model          :xwindows
	:user-data              ()
	:actions                (
		(
		:from                   (window TimeCanvas)
		:when                   (Repaint )
		:to                     (window TimeCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TimeCanvasRepaintHandler)
		)
		(
		:from                   (window TimeCanvas)
		:when                   (AnyEvent )
		:to                     (window TimeCanvas)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (TimeCanvasEventHandler)
		)
	)
)
)
