/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/QuoteMaker/RCS/QuoteMaker.c,v 2.16 92/09/25 13:55:32 drapeau Exp $ */
/* $Log:	QuoteMaker.c,v $
 * Revision 2.16  92/09/25  13:55:32  drapeau
 * Fixed errors in the way the quoted text window was being located.  The
 * earlier version used the XView attributes "XV_WIDTH", "XV_HEIGHT", "XV_X",
 * and "XV_Y".  This version now uses the more proper "frame_get_rect()" and
 * "frame_set_rect()" functions for window placement and sizing.
 * Also, some cosmetic changes were made to enhance readability and ANSI
 * compliance.
 * 
 * Revision 2.15  92/09/12  18:43:00  drapeau
 * Replaced non-portable "irint()" function with simple cast-to-integer syntax.
 * 
 * Revision 2.14  92/06/15  14:32:50  drapeau
 * Minor changes, casting xv_get() calls to (char*) to avoid compiler
 * warning messages.
 * 
 * Revision 2.13  92/05/14  15:40:06  drapeau
 * * Updated copyright information in the source.
 * * Removed obsolete code that was already commented out.
 * 
 * Revision 2.12  92/01/11  01:42:03  drapeau
 * Removed redeclarations of string functions since OpenWindows 2.0
 * headers don't seem to like them (OpenWindows 3.0 seemed to need
 * them).
 * 
 * Revision 2.11  92/01/09  18:25:10  drapeau
 * Slight modifications to make code ANSI-compliant.
 * 
 * Revision 2.1  91/12/31  18:38:48  drapeau
 * Removed inclusion of string.h, since XView should include the
 * appropriate definitions.
 * 
 * Revision 2.0  91/09/30  15:01:43  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.59  91/09/18  20:53:31  derek
 * The Makefile is changed due to the changes made in the collab/ directory.
 * 
 * Revision 1.58  91/09/15  20:04:54  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.57  91/09/05  15:47:18  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.56  91/08/29  11:56:34  derek
 * x-y-coordinates-reversed-bug in SetQuotedTextWindowLocation() is fixed.
 * 
 * Revision 1.55  91/08/28  14:03:38  derek
 * The following things are done:
 * 1.	I have changed the NewEditList option to call the file browser
 * 	instead of giving a popup window.
 * 2.	I ahve renamed all the options in the file menu so that they
 * 	are clearer and more informative.
 * 3.	The documentFileType has been changed from "DTR" (which was
 * 	a copying fault :)) to "QuoteMaker".
 * 4.	I ahve changed the stop button so that if it sees that 
 * 	HideQTWAfterPlayingEdit is true, stopplay will hide the window too.
 * 5.	I have changed QuoteMaker.G (the interface) so that there is no
 * 	way to deselect a fontfamily and fontstyle item from the panel list
 * 	(ie. a choice is required.)
 * 
 * Revision 1.54  91/08/27  14:50:26  derek
 * I have added a notice prompt which gives a warning when NewSender
 * returns a NULL (meaning that the PortManager is absent).
 * 
 * Revision 1.53  91/08/27  14:34:51  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.52  91/08/26  11:58:13  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.51  91/08/13  22:52:11  derek
 * I have incorporated the openpanel/savepanel stuff.
 * 
 * Revision 1.50  91/08/09  18:17:44  derek
 * I removed all the free() statements from the code to
 * fix the bug and improve run-time efficiency.
 * 
 * Revision 1.49  91/08/08  21:47:06  derek
 * I fixed an edit list bug.
 * 
 * Revision 1.48  91/07/29  10:37:10  derek
 * Now the textWindowPopup would not show when the application first comes up.
 * 
 * Revision 1.47  91/07/22  16:46:11  derek
 * I have added 4 buttons to get and set the current
 * location and size of the quoted text window.
 * 
 * Revision 1.46  91/07/15  12:18:17  derek
 * 1.      I have added font selection panel to the application.
 *         Now a user can specify a font by choosing a font family, a font
 *         style and font size.
 * 2.      Location and size fields are added to the application.  User
 *         can specify the size and location of the QuotedTextWindow.
 * 3.      A duration estimate button is added to estimate how long the
 *         the quoted text should last.
 * 4.      Interface has been redesigned to accomodate the addition of
 *         font, size and location functionalities.
 * 6.      EditList file format has been changed to accomodate the new
 *         fields.  They are:  location (x,y), width, height, font family,
 *         font style, font width for QuotedTextWindow.
 * 5.      Two timers have been added in an attempt to ensure accuracy
 *         of gauge-updating in the preview panel.
 * 6.      Command line args are now supported.
 * 7.      I have cleaned up the code by using saber.
 * 8.      Several bugs from previous revision are fixed.
 * 
 * 
 * Revision 1.45  91/07/02  15:07:25  derek
 * QuoteMaker now fully speaks the new MAEstro protocol.
 * 
 * Revision 1.44  91/07/01  18:42:56  derek
 * The following things are done:
 * 1.	The interface is redesigned.  Duration fields are added to each 
 * 	edit list.
 * 2.	The function panel (functions Window) is implemented.  The 
 * 	application is now capable of being "played", "stopped" and
 * 	"paused".  The sense of "time" is now complete.
 * 3.	Makefile fixed.  
 * 4.	Declaration errors left by previous author are cleaned up.
 * 5.	Redundant malloc statements removed.   Certain other
 * 	functions are changed to improve code efficiency.
 * 6.	Code cleaned up by saber.  Removed redundant
 * 	variables.
 * 
 * Revision 1.43  91/06/28  13:15:13  derek
 * Blank functions added to the code to make the application "compatible"
 * with the new protocol.
 * 
 * Revision 1.42  91/06/27  18:20:51  derek
 * I have cleaned up some of the comments.  No change in code.
 * 
 * Revision 1.41  91/06/19  17:47:37  drapeau
 * No changes; changing RCS revision numbers.
 * 
 * Revision 1.4  91/05/06  01:48:30  drapeau
 * Added code to set position of top level frame, so that XV_X and XV_Y
 * attributes need not be set in the _ui.c file.  The new functionality is done
 * via the "frame_set_rect()" XView function.
 * 
 * Revision 1.3  91/01/06  20:14:44  drapeau
 * Made several modifications relating to selection of text and items from the
 * edit list.  Current selection information is no longer erased when an edit
 * is added to the list.  Currently selected text is no longer de-selected when
 * anything is done to an edit (add, modify, select, delete).  Message showing
 * current edit number now correctly updates.  Message showing number of edits
 * in the current document now correctly updates.  Modify feature now works
 * correctly.  Modify and Delete buttons now dim and "undim" at the appropriate
 * times.
 * 
 * Revision 1.2  91/01/05  00:46:42  drapeau
 * Modified QuitProc() so that a dialog appears only if there are unsaved
 * changes to be made or discarded.  If there are no outstanding changes to be
 * made, application exit is immediate.
 * 
 * Revision 1.1  90/12/04  17:21:26  drapeau
 * Initial revision
 *  */

static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/QuoteMaker.c,v 2.16 92/09/25 13:55:32 drapeau Exp $";


/*
 * QuoteMaker.c - Notify and event callback function stubs.
 * This file was copied from "QuoteMaker_stubs.c", which was
 * generated by `gxv' from `QuoteMaker.G'.
 * Modified by George Drapeau on October 26, 1990.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "QuoteMaker_ui.h"
#include <sys/stat.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include <math.h>
#include "Sender.h"
#include "Receiver.h"
#include <getopt.h>
#include "quoteMakerDefs.h"
#include <Browse.h>
#include <string.h>

QuoteMaker_baseWindow_objects		*QuoteMaker_baseWindow;
QuoteMaker_quotedTextBaseWindow_objects *QuoteMaker_quotedTextBaseWindow;
QuoteMaker_infoPopup_objects		*QuoteMaker_infoPopup;
QuoteMaker_textWindowPopup_objects	*QuoteMaker_textWindowPopup;
QuoteMaker_QuoteWindowSpecificationsPopup_objects	*QuoteMaker_QuoteWindowSpecificationsPopup;


Sender*		sender;						    /* Variables for the Link Protocol. */
Receiver*	receiver;
Port		senderPort;
int             ReceiverPortNumber;

int		mostRecentEditNum;
EditList	editList;					    /* Currently this app. supports only 1 open... */
                                                                    /* ...document; thus, only one editList is needed. */
char            *startFilename;

/* Variables describing documents and edit lists. */
char	absoluteDocumentName[MAXPATHLEN + 1];
char	absoluteEditListName[MAXPATHLEN + 1];
int	unsavedChangesExist;
int	untitledEditListNum;					    /* So we can say untitled0  */

Xv_Server server;


#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

void main(argc, argv)
     int		argc;
     char		**argv;
{
  int	counter;
  Rect	tempRect;
  
  static DispatchTable  DT = 
  {
    OpenDoc,
    GetDoc,
    GetSelection,
    SetSelection,
    PerformSelection,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    HaltSelection,
    PauseSelection,
    ResumeSelection,
    HideApplication,
    ShowApplication,
    GetAppIcon
    };
  
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);		    /* Initialize XView. */
  INSTANCE = xv_unique_key();					    /* Initialize user interface components. */
  
  QuoteMaker_baseWindow = QuoteMaker_baseWindow_objects_initialize(NULL, NULL);
  QuoteMaker_infoPopup = QuoteMaker_infoPopup_objects_initialize(NULL, QuoteMaker_baseWindow->baseWindow);
  QuoteMaker_textWindowPopup = QuoteMaker_textWindowPopup_objects_initialize(NULL, QuoteMaker_baseWindow->baseWindow);
  QuoteMaker_QuoteWindowSpecificationsPopup =
    QuoteMaker_QuoteWindowSpecificationsPopup_objects_initialize(NULL, QuoteMaker_baseWindow->baseWindow);
  QuoteMaker_quotedTextBaseWindow = QuoteMaker_quotedTextBaseWindow_objects_initialize(NULL, NULL);
 
  frame_get_rect(QuoteMaker_baseWindow->baseWindow,&tempRect);	    /* Get the size of the top-level window */
  tempRect.r_top = 110;
  tempRect.r_left = 615;
  frame_set_rect(QuoteMaker_baseWindow->baseWindow,&tempRect);	    /* Set the position of the top-level window */
  
  frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);
  tempRect.r_top = 100;
  tempRect.r_left = 100;
  frame_set_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		 &tempRect);					    /* Set the position of the top-level window */

  OldLocX = tempRect.r_left;
  OldLocY = tempRect.r_top;
  OldSizeWidth = tempRect.r_width;				    /* Initialize the old width and old height for the */
  OldSizeHeight = tempRect.r_height;				    /* ...sake of the modified bit.                    */
  
  server = (Xv_Server) xv_get (xv_get (QuoteMaker_baseWindow->baseWindow, XV_SCREEN), SCREEN_SERVER);
  
  listFont = (Xv_font *) xv_find(QuoteMaker_baseWindow->baseWindow, FONT,
				 FONT_FAMILY, FONT_FAMILY_LUCIDA_FIXEDWIDTH,
				 FONT_STYLE, FONT_STYLE_NORMAL,
				 FONT_SIZE, 12,
				 NULL);
  displayFont = (Xv_font *) xv_find(QuoteMaker_baseWindow->baseWindow, FONT,
				    FONT_FAMILY, FONT_FAMILY_ROMAN,
				    FONT_STYLE, FONT_STYLE_BOLD,
				    FONT_SIZE, 24,
				    NULL);
  annotateFont = (Xv_font *) xv_find(QuoteMaker_baseWindow->baseWindow, FONT,
				     FONT_NAME, "-*-helvetica-medium-r-normal-*-*-120-*-*-*-*-*-*",
				     NULL);
  
  xv_set (QuoteMaker_textWindowPopup->mainTextPane,
	  TEXTSW_MEMORY_MAXIMUM, MAX_TEXTSW_LEN,
	  TEXTSW_BROWSING, TRUE,        
	  TEXTSW_AGAIN_RECORDING, FALSE,
	  TEXTSW_LINE_BREAK_ACTION, TEXTSW_WRAP_AT_WORD,
	  WIN_CONSUME_EVENTS,
	  WIN_NO_EVENTS, LOC_WINENTER, NULL,
	  XV_FONT, annotateFont,
	  NULL);
  
  xv_set (QuoteMaker_quotedTextBaseWindow->quotedTextPane,
	  TEXTSW_MEMORY_MAXIMUM, MAX_TEXTSW_LEN,
	  TEXTSW_BROWSING, TRUE,        
	  TEXTSW_AGAIN_RECORDING, FALSE,
	  TEXTSW_LINE_BREAK_ACTION, TEXTSW_WRAP_AT_WORD,
	  XV_FONT, displayFont,
	  NULL);
  
  mostRecentEditNum = NO_CURRENT_EDIT;
  unsavedChangesExist = NO;
  untitledEditListNum = 1;
  editList.numItems = 0;
  for (counter = 0; counter < MAXLISTSIZE; counter++)		    /* Initialize the editList's labels to NULL strings */
    editList.label[counter] = (char*)NULL;
  SetEditList("NoneSpecified");
  
  senderPort.hostName = "localhost";				    /* Network code start up... setting up ports etc.   */
  senderPort.portNumber = AnyPort;

  startFilename = NULL;
  CheckOptions(argc, argv);

  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);

  if (sender == NULL)
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"Error:  PortManager seems to be absent.  Please start PortManager again.");
    exit(0);
  }
    
  receiver = NewReceiver(sender, "QuoteMaker", ReceiverPortNumber);

  BuildDispatchTable (&DT);
  
  (void) notify_enable_rpc_svc (TRUE);				    /* Tell the toolkit to listen for network messages */
  
  InitTimer();							    /* Initialize the timer. */
  
  InitMainPanel();
  
  InitFontPanel();						    /* Initialize the font scrolled lists. */

  InitQuotedTextWindow();

  ClearQuoteWindowSpecificationsPopup();

  InitBrowse();

  InitTextFields();						    /* Change the notify levels of the text fields to  */
								    /* ...be PANEL_ALL.  This is for the sake of the.. */
								    /* ...EditModified Bit.                            */
  if (startFilename != NULL)					    
    ReadEditListFromFile(startFilename, USER);			    

  xv_main_loop(QuoteMaker_baseWindow->baseWindow);		    /* Turn control over to XView. */
  exit(0);
}

#endif


void CheckOptions(argc, argv)
     int 	argc;
     char 	**argv;
{
  int optionChar;  
  int option_index = 0;
  static struct option long_options[] =
  {
    {"hostname", 1, 0, 'h'},		

    {"portnumber", 1, 0, 'p'},
    {0, 0, 0, 0}
  };

  while (1)							    /* Start parsing all known options */
  {
    optionChar = getopt_long_only (argc, argv, "h:p:",
			      long_options, &option_index);
    if (optionChar == EOF)					    /* Done with all known options */
    {
      break;
    }
    switch (optionChar)
    {
     case 'h':
      if (optarg) 
      {
	strcpy (senderPort.hostName, optarg);
      }
      break;
     case 'p':
      if (optarg) 
      {
	ReceiverPortNumber = atoi(optarg);
      }
      break;
     default:
      break;
    }
  }
  if (optind < argc)						    /* Check if a filename has been specified */
  {
    startFilename = (char *) malloc (256);
    strcpy (startFilename, argv[optind]);
  }
}



Menu_item Info(item, op)					    /* Menu handler for `fileMenu (Info...)'. */
     Menu_item	item;
     Menu_generate	op;
{
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    Show(&QuoteMaker_infoPopup->infoPopup);
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}								    /* end function Info */




Menu_item Quit(item, op)					    /* Menu handler for `fileMenu (Quit)'. */
     Menu_item	item;
     Menu_generate	op;
{
  switch (op)
  {
   case MENU_DISPLAY:
    break;
    
   case MENU_DISPLAY_DONE:
    break;
    
   case MENU_NOTIFY:
    QuitProc();
    break;
    
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}								    /* end function Quit */


/*
 * Menu handler for `OptionsMenu (                  Show Text Window)'.
 */
Menu_item
ShowTextWindowHandler(item, op)
	Menu_item	item;
	Menu_generate	op;
{
  switch (op) {
   case MENU_DISPLAY:
    break;

   case MENU_DISPLAY_DONE:
    break;

   case MENU_NOTIFY:
    Show(&QuoteMaker_textWindowPopup->textWindowPopup);
    break;

   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `OptionsMenu (Show Quote Window Specifications Panel)'.
 */
Menu_item
ShowQuoteWindowSpecificationsPanelHandler(item, op)
	Menu_item	item;
	Menu_generate	op;
{
  switch (op) {
   case MENU_DISPLAY:
    break;

   case MENU_DISPLAY_DONE:
    break;

   case MENU_NOTIFY:
    Show(&QuoteMaker_QuoteWindowSpecificationsPopup->QuoteWindowSpecificationsPopup);
    break;

   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}


QuitProc()
{
  if (unsavedChangesExist == YES)
    GiveOneLastChanceToSave();
  unsavedChangesExist = NO;					    /* This is to tell the DestroyBaseWindow notifier...*/
								    /* ...that it should quit assuming that there are...*/
								    /* ...no more changes.                              */
  SenderDisconnectFromPortMgr(sender,&(receiver->receivePort));	    /* Tell the Port Manager "I'm outtahere" */
  xv_destroy_safe(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow);
  xv_destroy_safe(QuoteMaker_baseWindow->baseWindow);
}								    /* end function QuitProc */



int DumpEntry(item, string, client_data, op, event)		    /* Notify callback func. for `editListScrolledList'. */
     Panel_item		item;
     char*		string;
     Xv_opaque		client_data;
     Panel_list_op	op;
     Event*		event;
{
  int  selected;

  switch(op)
  {
   case PANEL_LIST_OP_DESELECT:
    break;
    
   case PANEL_LIST_OP_SELECT:
    if (Playing)
    {
      StopButtonHandler(NULL, NULL);
    }
    
    selected = Selected();
    SetCurrentSelection(selected);
    ClearQuotedTextWindow();
    DisplayTextOnQuoteWindow();
    ClearEditModified();
    break;
    
   case PANEL_LIST_OP_VALIDATE:
   case PANEL_LIST_OP_DELETE:
    break;
  }
  return XV_OK;
}								    /* end function DumpEntry */


void LoadSelection()
{
  GetSelectionEndpoints (&textWindowStart, &textWindowEnd);
}								    /* end function LoadSelection */


void ShowSelection(item, event)					    /* Notify callback func. for `showSelectionButton'. */
     Panel_item	item;
     Event		*event;
{
  int   select;
  
  select = Selected();

  if (Playing)
  {
    StopButtonHandler(NULL, NULL);
  }

  if (select == NO_CURRENT_EDIT)
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"You must select an edit first.");
  }
  else
  {
    ClearQuotedTextWindow();
    SetCurrentSelection(select);
    SetCurrentSelection(select);				    /* This function is called twice in order to fix... */
								    /* ...the weird bug concerning the "modify bit"...  */
								    /* ...of the QuotedTextWindowInterposer.            */
								    /* ...This extra statement can surely removed if... */
								    /* ...the "modify bit" for the edit is no longer... */
								    /* ...implemented.                                  */
    DisplayTextOnQuoteWindow();
    ClearEditModified();
  }
}								    /* end function ShowSelection */


void
  ShowTextWindowSelection()
{
  Show(&QuoteMaker_textWindowPopup->textWindowPopup);
/**************
  start = (int) xv_get(QuoteMaker_baseWindow->selectionStartField,
		       PANEL_VALUE);
  end = (int) xv_get(QuoteMaker_baseWindow->selectionEndField,
		     PANEL_VALUE);
  HighlightSelection(start, end);
****************/
}



void ButtonShowText(item, event)				    /* Notify callback function for `showTextButton'. */
     Panel_item	item;
     Event		*event;
{
  Show(&QuoteMaker_textWindowPopup->textWindowPopup);
}



/*
 * Notify callback function for `EstimateDurationButton'.
 * The formula for estimating duration given the number of bytes
 * of the current edit is as follows:
 *     duration = latency + 0.1 * (number of characters)
 */
void
EstimateDurationNotifyHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  int    selected;
  double estimatedDuration;
  int    mins;
  double secs;

  estimatedDuration = 1.5 + 0.1 * (textWindowEnd - textWindowStart);
  mins = (int)(floor(estimatedDuration / 60.0));
  secs = estimatedDuration - mins * 60.0;
  sprintf(msg, "%d", mins);
  xv_set (QuoteMaker_baseWindow->DurationMinsTextField, PANEL_VALUE, msg, NULL);
  sprintf(msg, "%.1lf", secs);
  xv_set (QuoteMaker_baseWindow->DurationSecsTextField, PANEL_VALUE, msg, NULL);
}


/*
 * Notify callback function for `HideQuoteWindowButton'.
 */
void
HideQuoteWindowButtonHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	 XV_SHOW, FALSE,
	 NULL);
  
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeMessage,
	 PANEL_LABEL_STRING, "", NULL);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocationMessage,
	 PANEL_LABEL_STRING, "", NULL);
  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);
}


/*
 * Notify callback function for `IconifyQuoteWindowButton'.
 */
void
IconifyQuoteWindowButtonHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	 XV_SHOW, TRUE,
	 FRAME_CLOSED, TRUE,
	 NULL);
  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);
}


Panel_setting TextFieldAddSelection(item, event)		    /* Notify callback func. for `selectionLabelField'. */
     Panel_item	item;
     Event		*event;
{
  CheckIfEditModified(TRUE);
  
  return panel_text_notify(item, event);
}								    /* end function TextFieldAddSelection */



/*
 * Notify callback function for `ShowQuoteWindowButton'.
 */
void ShowQuoteWindowButtonHandler(Panel_item	item,
			       Event*		event)
{
  static Rect	tempRect;
  int           selected;
  
  if (xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	     XV_SHOW) == FALSE ||
      xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	     FRAME_CLOSED) == TRUE)
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	   FRAME_CLOSED, FALSE,
	   XV_SHOW, TRUE,
	   NULL);
    
    selected = Selected();
    if (selected != NO_CURRENT_EDIT)
    {
      frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		     &tempRect);		
      tempRect.r_left = editList.locX[selected] + FRAME_X_OFFSET;
      tempRect.r_top  = editList.locY[selected] + FRAME_Y_OFFSET;
      
      frame_set_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		     &tempRect);
    }
  }
  else
  {
    xv_set(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
	   FRAME_CLOSED, FALSE,
	   XV_SHOW, TRUE,
	   NULL);
  }
  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);
}								    /* end function ShowQuoteWindowButtonHandler */


void AddSelection(item, event)					    /* Notify callback function for `addButton'. */
     Panel_item	item;
     Event		*event;
{
  /* Note that text selection is unhighlighted, then selected row is deselected,
     then operation is performed on panel list.  This seems to be about the best
     way to avoid getting segmentation faults when selecting a panel list row:
     
     A. Deselect selected text before working with panel list
     B. Deselect selected row before adding/deleting/modifying list.
     */
  
  QuoteMaker_baseWindow_objects	*ip =				    /* In this case, ip points to the control panel... */
    (QuoteMaker_baseWindow_objects *) xv_get(item,		    /* ...that contans the 'addButton' */
					     XV_KEY_DATA,
					     INSTANCE);
  char	   label[MAX_LABEL_LEN + 1];
  int	   start;
  int	   end;
  double   duration;
  int      locX;
  int      locY;
  int      sizeWidth;
  int      sizeHeight;
  int      mins;
  double   secs;
  int      fontFamily;
  int      fontStyle;
  int      fontSize;
  int	   hideQTWAfterPlayingEdit;
  
  DeselectList();
  strcpy(label, xv_get (ip->selectionLabelField, PANEL_VALUE));

  start = textWindowStart;
  end   = textWindowEnd;

  mins = (int) atoi(xv_get (ip->DurationMinsTextField, PANEL_VALUE));
  secs = (double) atof((char*)xv_get(ip->DurationSecsTextField, PANEL_VALUE));
  duration = mins * 60.0 + secs;

  GetCurrentLocation(&locX, &locY);
  GetCurrentSize(&sizeWidth, &sizeHeight);

  fontFamily = currentFontFamily;
  fontStyle = currentFontStyle;
  fontSize  = currentFontSize = xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
				       PANEL_VALUE);

  hideQTWAfterPlayingEdit = HideQTWAfterPlayingEdit;
  
  editList.start[editList.numItems] = start;			    /* Add the new information to the edit list */
  editList.end[editList.numItems] = end;
  editList.duration[editList.numItems] = duration;
  editList.locX[editList.numItems] = locX;
  editList.locY[editList.numItems] = locY;
  editList.sizeWidth[editList.numItems] = sizeWidth;
  editList.sizeHeight[editList.numItems] = sizeHeight;
  editList.fontFamily[editList.numItems] = fontFamily;
  editList.fontStyle[editList.numItems] = fontStyle;
  editList.fontSize[editList.numItems] = fontSize;
  editList.hideQTWAfterPlayingEdit[editList.numItems] = hideQTWAfterPlayingEdit;
  
  if (editList.label[editList.numItems])			    /* Free space taken by previous label */
    free(editList.label[editList.numItems]);
  editList.label[editList.numItems] = strdup(label);
  editList.numItems++;						    /* Update number of items in the edit list */
  xv_set (QuoteMaker_baseWindow->editListScrolledList,
	  PANEL_LIST_INSERT, editList.numItems-1,
	  PANEL_LIST_STRING, editList.numItems-1,
	  FormatEntry(editList.numItems, label, duration, hideQTWAfterPlayingEdit),
	  PANEL_LIST_FONT, editList.numItems-1, listFont,
	  NULL);

  UpdateNumEditsMessage();

  sprintf(msg , "%d", editList.numItems);
  xv_set(QuoteMaker_baseWindow->currentSelectionNumberLabel, PANEL_LABEL_STRING, strdup(msg), NULL);
  
  unsavedChangesExist = YES;

  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);

  xv_set(QuoteMaker_baseWindow->deleteButton, PANEL_INACTIVE, FALSE, NULL); /* Re-activate Modify and Delete buttons */
  xv_set(QuoteMaker_baseWindow->modifyButton, PANEL_INACTIVE, FALSE, NULL);
  xv_set(QuoteMaker_baseWindow->deleteAllButton, PANEL_INACTIVE, FALSE, NULL);

  xv_set(QuoteMaker_baseWindow->editListScrolledList,		    /* Select the newly-added item */
	 PANEL_LIST_SELECT, editList.numItems-1, TRUE,NULL);
}								    /* end function AddSelection */



void ModifySelection(item, event)				    /* Notify callback function for `modifyButton'. */
     Panel_item	item;
     Event*		event;
{
  QuoteMaker_baseWindow_objects	*ip =				    /* In this case, ip points to the control panel... */
    (QuoteMaker_baseWindow_objects *) xv_get(item,		    /* ...that contans the 'modifyButton' */
					     XV_KEY_DATA,
					     INSTANCE);
  int	   selected;
  char	   label[MAX_LABEL_LEN + 1];
  int	   start;
  int	   end;
  double   duration;
  int      locX;
  int      locY;
  int      sizeWidth;
  int      sizeHeight;
  int      mins;
  double   secs;
    
  selected = Selected();
  if (selected == NO_CURRENT_EDIT)				    /* Was a valid selection chosen to be modified? */
  {								    /* No, no valid selection was chosen to be modified */
    notice_prompt (QuoteMaker_baseWindow->baseWindow, NULL,
		   NOTICE_MESSAGE_STRINGS,
		   "You need to select an edit before you can Modify it.",
		   NULL,
		   NOTICE_BUTTON,	"OK", 100,
		   NULL);
    return;							    /* Exit this function without doing anything more */
  }
  strcpy(label,xv_get (ip->selectionLabelField, PANEL_VALUE));

  start = textWindowStart;
  end   = textWindowEnd;
  
  mins = (int) atoi(xv_get (ip->DurationMinsTextField, PANEL_VALUE));
  secs = (double) atof((char*)xv_get(ip->DurationSecsTextField, PANEL_VALUE));
  duration = mins * 60.0 + secs;

  GetCurrentLocation(&locX, &locY);
  GetCurrentSize(&sizeWidth, &sizeHeight);

  editList.start[selected] = start;
  editList.end[selected] = end;
  editList.duration[selected] = duration;
  editList.locX[selected] = locX;
  editList.locY[selected] = locY;
  editList.sizeWidth[selected] = sizeWidth;
  editList.sizeHeight[selected] = sizeHeight;
  editList.fontFamily[selected] = currentFontFamily;
  editList.fontStyle[selected] = currentFontStyle;
  editList.fontSize[selected] = xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
				       PANEL_VALUE);
  currentFontSize = editList.fontSize[selected];
  
  editList.hideQTWAfterPlayingEdit[selected] = HideQTWAfterPlayingEdit;
  
  if (editList.label[selected])
    free(editList.label[selected]);
  editList.label[selected] = strdup(label);
  xv_set (QuoteMaker_baseWindow->editListScrolledList,
	  PANEL_LIST_STRING, selected, FormatEntry(selected + 1, label, duration, HideQTWAfterPlayingEdit),
	  PANEL_LIST_FONT, selected, listFont,
	  NULL);
  unsavedChangesExist = YES;
  ClearEditModified();

  textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane,    /*  Highlight the selection (because the text_sw... */
		       textWindowStart, textWindowEnd + 1,	    /*  ...will keep forgetting about it.               */
		       PRIMARY_SELECTION);
}								    /* end function ModifySelection */





void DeleteSelection(item, event)				    /* Notify callback function for `deleteButton'. */
     Panel_item	item;
     Event		*event;
{
  int	selected;
  int   savedCurrentSelection;
  
  selected = Selected();
  if (selected == NO_CURRENT_EDIT)				    /* Was a valid selection chosen to be modified? */
  {								    /* No, no valid selection was chosen to be modified */
    notice_prompt (QuoteMaker_baseWindow->baseWindow, NULL,
		   NOTICE_MESSAGE_STRINGS,
		   "You need to select an edit before you can Delete it.",
		   NULL,
		   NOTICE_BUTTON,	"OK", 100,
		   NULL);
    return;							    /* Exit this function without doing anything more */
  }

  savedCurrentSelection = selected;

/***** I erased the deselect statement, and see if it works... **/

  xv_set (QuoteMaker_baseWindow->editListScrolledList,
	  PANEL_LIST_DELETE, savedCurrentSelection,
	  NULL);
  DeleteItemFromEditList(selected);

  ClearQuoteWindowSpecificationsPopup();
  
  UpdateNumEditsMessage();

  if (editList.numItems >= 1)
  {
    if (selected == editList.numItems)				    /* If it is the last item which got deleted...      */
    {
      xv_set(QuoteMaker_baseWindow->editListScrolledList,
	     PANEL_LIST_SELECT, selected - 1, TRUE, NULL);
      SetCurrentSelection(selected - 1);
    }
    else
    {
      xv_set(QuoteMaker_baseWindow->editListScrolledList,
	     PANEL_LIST_SELECT, selected, TRUE, NULL);
      SetCurrentSelection(selected);
    }
  }
  else
  {
    xv_destroy(QuoteMaker_baseWindow->editListScrolledList);
    QuoteMaker_baseWindow->editListScrolledList =
      QuoteMaker_baseWindow_editListScrolledList_create(QuoteMaker_baseWindow,
							QuoteMaker_baseWindow->editListControlPanel);
    ResetCurrentSelection();
    
    xv_set(QuoteMaker_baseWindow->deleteButton, 
	   PANEL_INACTIVE, TRUE, NULL);				    /* De-activate the Delete and Modify buttons */
    xv_set(QuoteMaker_baseWindow->modifyButton,
	   PANEL_INACTIVE, TRUE, NULL);
    xv_set(QuoteMaker_baseWindow->deleteAllButton,
	   PANEL_INACTIVE, TRUE, NULL);
  }

  unsavedChangesExist = YES;
}								    /* end function DeleteSelection */




void DeleteAllSelections(item, event)				    /* Notify callback function for `deleteAllButton'. */
     Panel_item	item;
     Event*	event;
{
  DeselectList();
  ResetCurrentSelection();
/******
  EmptyList();
*****/
  xv_destroy(QuoteMaker_baseWindow->editListScrolledList);
  QuoteMaker_baseWindow->editListScrolledList =
    QuoteMaker_baseWindow_editListScrolledList_create(QuoteMaker_baseWindow,
						      QuoteMaker_baseWindow->editListControlPanel);
  editList.numItems = 0;
  UpdateNumEditsMessage();
  unsavedChangesExist = YES;
  xv_set(QuoteMaker_baseWindow->deleteButton,
	 PANEL_INACTIVE, TRUE, NULL);				    /* De-activate the Delete and Modify buttons */
  xv_set(QuoteMaker_baseWindow->modifyButton,
	 PANEL_INACTIVE, TRUE, NULL);
  xv_set(QuoteMaker_baseWindow->deleteAllButton,
	 PANEL_INACTIVE, TRUE, NULL);
  
  ClearQuoteWindowSpecificationsPopup();
}								    /* End function DeleteAllSelections */


Notify_value
  TextPaneEventHandler(win, event, arg, type)	    /* Event callback function for `mainTextPane'. */
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
  int   length;

  GetSelectionEndpoints(&textWindowStart, &textWindowEnd);

  if (event_id(event) == MS_LEFT || event_id(event) == MS_MIDDLE)
  {
    if (event_is_up(event))
    {
      CheckIfEditModified(TRUE);
      DisplayTextOnQuoteWindow();
    }
    else
    {
      length=xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextPane, /* Get the number of characters currently in the... */
		  TEXTSW_LENGTH);				    /* ...popup win. */
      if (length > 0)
      {
	textsw_delete(QuoteMaker_quotedTextBaseWindow->quotedTextPane, /* Erase any previously shown text in the Text... */
		      0, length);				    /* popup window. */
	textsw_reset(QuoteMaker_quotedTextBaseWindow->quotedTextPane,0,0); /* Pretend that the QTW was never modified */
      }  
    }
  }
  
  return notify_next_event_func(win, (Notify_event) event, arg, type);
}								    /* end function TextPaneEventHandler */


/*
 * Event callback function for `textWindowPopup'.
 */
Notify_value
  TextWindowPopupEventHandler(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
  extern  QuoteMaker_textWindowPopup_objects *QuoteMaker_textWindowPopup;

  if (event_id(event) == LOC_WINENTER)
  {
    textsw_set_selection(QuoteMaker_textWindowPopup->mainTextPane, textWindowStart, textWindowEnd + 1,
			 PRIMARY_SELECTION);
  }
  
  return notify_next_event_func(win, (Notify_event) event, arg, type);
}



/* ----------------------------------------------------------------------------
   Utilities: Popup support
   */


void Show (popup)
     Frame *popup;
{
  xv_set(*popup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
  xv_set(*popup, XV_SHOW, TRUE, NULL);	
}								    /* end function Show */


void Hide (popup)
     Frame *popup;
{
  if ((int)xv_get(*popup,FRAME_CMD_PUSHPIN_IN) == TRUE)		    /* Is this frame's pushpin pushed in? */
    xv_set (*popup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);		    /* Yes, take out the pushpin so the frame can be... */
								    /* ...hidden.  */
  if ((int)xv_get(*popup, XV_SHOW) == TRUE)			    /* Is this frame being shown? */
    xv_set (*popup,XV_SHOW, FALSE, NULL);			    /* Yes, hide the frame */
}								    /* end function Hide */



void GiveOneLastChanceToSave()
{
  char	message [MAX_MESSAGE_LEN + 1];
  int	response;
  char	shortOldEditListName [MAXPATHLEN + 1];
  
  strcpy (shortOldEditListName, (char *) xv_get(QuoteMaker_baseWindow->editListNameLabel, PANEL_LABEL_STRING));
  sprintf (message, "Save changes in '%s'?", shortOldEditListName);
  response = notice_prompt(QuoteMaker_baseWindow->baseWindow, NULL,
			   NOTICE_MESSAGE_STRINGS,
			   message,
			   NULL,
			   NOTICE_BUTTON_NO, "No",
			   NOTICE_BUTTON_YES, "Yes",
			   NULL);
  if (response == NOTICE_YES)
    WriteEditListToFile(absoluteEditListName, SAVE);
}								    /* end function GiveOneLastChanceToSave */




void SetCurrentSelection(int entry)
{
  int     mins;
  double  secs;
  
  if (entry == NO_CURRENT_EDIT)
  {
    AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow,
			"Error:  There is no selected edit.  An edit must be selected first.");
  }
  HighlightSelection(editList.start[entry],
		     editList.end[entry]);			    /*  Show the selection over the text window.        */
  textWindowStart = editList.start[entry];
  textWindowEnd   = editList.end[entry];
  xv_set (QuoteMaker_baseWindow->selectionLabelField,PANEL_VALUE, strdup(editList.label[entry]),NULL);
  
  mins = (int)(floor(editList.duration[entry] / 60.0));
  secs = editList.duration[entry] - mins * 60.0;
  sprintf(msg, "%d", mins);
  xv_set (QuoteMaker_baseWindow->DurationMinsTextField, PANEL_VALUE, msg, NULL);
  sprintf(msg, "%.1lf", secs);
  xv_set (QuoteMaker_baseWindow->DurationSecsTextField, PANEL_VALUE, msg, NULL);
  
  sprintf(msg, "%d:%.1lf", mins, secs);				    /*  Display the endtime message in the duration...  */
  xv_set(QuoteMaker_baseWindow->EndTimeMessage,			    /*  ...gauge.                                       */
	 PANEL_LABEL_STRING, msg, NULL);
  
  sprintf(msg, "%d", entry+1);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->EditNumberMessage,
	 PANEL_LABEL_STRING, msg, NULL);
  
  sprintf(msg, "%d x %d", editList.locX[entry], editList.locY[entry]);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocationMessage,
	 PANEL_LABEL_STRING, msg, NULL);
  sprintf(msg, "%d x %d", editList.sizeWidth[entry], editList.sizeHeight[entry]);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeMessage,
	 PANEL_LABEL_STRING, msg, NULL);
  
  SetQuotedTextWindowLocation(editList.locX[entry],
			      editList.locY[entry]);
  SetQuotedTextWindowSize(editList.sizeWidth[entry],
			  editList.sizeHeight[entry]);
  OldLocX = editList.locX[entry];				    /*  These values are used to ensure that the old... */
  OldLocY = editList.locY[entry];				    /*  ...loc and size values are updated so that...   */
  OldSizeWidth = editList.sizeWidth[entry];			    /*  ...the "modified bit" will not be changed...    */
  OldSizeHeight = editList.sizeHeight[entry];			    /*  ...because of the notify_interposer.            */
  
  SetFontPanel(editList.fontFamily[entry],
	       editList.fontStyle[entry],
	       editList.fontSize[entry]);
  xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->FontSizeTextField,
	 PANEL_VALUE, currentFontSize,
	 NULL);
  if (editList.hideQTWAfterPlayingEdit[entry])
    EnableHideQTWAfterPlayingEdit();
  else
    DisableHideQTWAfterPlayingEdit();
  
  sprintf(msg,"%d",entry+1);
  xv_set (QuoteMaker_baseWindow->currentSelectionNumberLabel,
	  PANEL_LABEL_STRING, strdup(msg),
	  NULL);
  
  mostRecentEditNum = entry;
  xv_set(QuoteMaker_baseWindow->deleteButton,
	 PANEL_INACTIVE, FALSE, NULL);				    /* Re-activate Modify and Delete buttons */
  xv_set(QuoteMaker_baseWindow->modifyButton,
	 PANEL_INACTIVE, FALSE, NULL);
}								    /* end function SetCurrentSelection */



char* FormatEntry(int		entryNum,
		  char*		label,
		  double	duration,
		  int		hideQTWFlag)
{
  int       mins;
  double    secs;
  
  mins = (int)(floor(duration / 60.0));
  secs = duration - mins * 60.0;
  sprintf(msg, "%d:%.1lf", mins, secs);
  if (hideQTWFlag)
    sprintf(Entry, "%4d   %-15.15s      %s        YES", entryNum, label, msg);
  else
    sprintf(Entry, "%4d   %-15.15s      %s        NO", entryNum, label, msg);
  return(Entry);
}								    /* end function FormatEntry */




void ResetCurrentSelection()
{
  xv_set (QuoteMaker_baseWindow->selectionLabelField, 
	  PANEL_VALUE, "",
	  NULL);  
  
  PutInDefaultDuration();

  ClearQuoteWindowSpecificationsPopup();

/************
  xv_set (QuoteMaker_baseWindow->numEditsLabel,
	  PANEL_LABEL_STRING, "New Edit",
	  NULL);
************/

  UpdateNumEditsMessage();
}



void UpdateNumEditsMessage()
{
  int	size;
  char* sizeMessage;
  
  size = ListSize();
  sizeMessage = (char *) malloc (MAX_MESSAGE_LEN + 1);
  sprintf (sizeMessage, "Number of Edits: %d", size);
  xv_set (QuoteMaker_baseWindow->numEditsLabel,
	  PANEL_LABEL_STRING, sizeMessage,NULL);
}


void Alert(callingObject,message)				    /* Puts up a dialog box with a message and on... */
     Xv_opaque	callingObject;					    /* ..."ok" button for acknowledgement. */
     char*	message;
{
  notice_prompt(callingObject, NULL,
		NOTICE_MESSAGE_STRINGS,
		message, NULL, NOTICE_BUTTON, "OK", 100, NULL);	
}								    /* end function Alert */




char* ShortName (fileName)					    /* Given full path name, returns tail (the part... */
     char* fileName;						    /* ...after the last "/") */
{
  char* tempName;
  char*	rindex();
  
  tempName = rindex(fileName, '/');				    /* catch the last "/" in the path passed in as arg. */
  if (tempName == (char *)NULL)					    /* Was there a "/" in the path passed in? */
    tempName = fileName;					    /* No, just return the whole file passed in */
  else								    /* Yes, there was a "/" in the path passed in */
    tempName = &tempName[1];					    /* Skip over the last "/" and return the following */
								    /* string. */
  return (tempName);
}								    /* end function ShortName */


void SetDocument(documentName)
     char*	documentName;
{
  char			frameTitle[1024];

/**********
  strcpy (shortName, ShortName(documentName));
**********/
  xv_set (QuoteMaker_baseWindow->docNameLabel,PANEL_LABEL_STRING,
	  documentName,NULL);
  realpath(documentName, absoluteDocumentName);
  xv_set (QuoteMaker_textWindowPopup->mainTextPane,TEXTSW_FILE,
	  absoluteDocumentName,NULL);
  sprintf(frameTitle,"QuoteMaker:  Annotating  '%s'", documentName);
  xv_set (QuoteMaker_textWindowPopup->textWindowPopup,		    /* Change the label of the Text window's title bar */
	  XV_LABEL, frameTitle,NULL);
}								    /* end function SetDocument */


/*
 * Notify callback function for `HideQuoteWindowAfterPlayingEditSettingHandler'.
 */
void
  HideQuoteWindowAfterPlayingEditSettingHandler(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
  CheckIfEditModified(TRUE);
  
  HideQTWAfterPlayingEdit = value;
}


void
GetCurrentLocationHandler()
{
  static  Rect  tempRect;
  
  if (xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, XV_SHOW) == TRUE)
  {
    frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		   &tempRect);

    sprintf(msg, "%d x %d", tempRect.r_left, tempRect.r_top);
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocationMessage,
	   PANEL_LABEL_STRING, msg);

/********
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocXTextField,
	   PANEL_VALUE, tempRect.r_left, NULL);
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->LocYTextField,
	   PANEL_VALUE, tempRect.r_top, NULL);
**********/
  }
}


void
  GetCurrentSizeHandler()
{
  int		currentSizeWidth;
  int		currentSizeHeight;
  static Rect	tempRect;

  if (xv_get(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow, XV_SHOW) == TRUE)
  {
    frame_get_rect(QuoteMaker_quotedTextBaseWindow->quotedTextBaseWindow,
		   &tempRect);		
    currentSizeWidth = tempRect.r_width;
    currentSizeHeight = tempRect.r_height;
    sprintf(msg, "%d x %d", currentSizeWidth, currentSizeHeight);
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeMessage,
	   PANEL_LABEL_STRING, msg);

/**********
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeWidthTextField,
	   PANEL_VALUE, currentSizeWidth, NULL);
    xv_set(QuoteMaker_QuoteWindowSpecificationsPopup->SizeHeightTextField,
	   PANEL_VALUE, currentSizeHeight, NULL);
**********/
  }
}



/*
 * Notify callback function for `FontFamilyList'.
 */
int
  FontFamilyNotifyHandler(item, string, client_data, op, event)
Panel_item	item;
char		*string;
Xv_opaque	client_data;
Panel_list_op	op;
Event		*event;
{
  int  i;
  int  oldFontFamily;
  int  selected;
	
  switch(op) {
   case PANEL_LIST_OP_DESELECT:
    break;

   case PANEL_LIST_OP_SELECT:

    oldFontFamily = currentFontFamily;

    for(i=0 ; i < MAX_NUM_OF_FONT_FAMILIES ; i++)
    {
      if (xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->FontFamilyList,
		 PANEL_LIST_SELECTED, i) == TRUE)
      {
	currentFontFamily = i;
	break;
      }
    }
    if (i == MAX_NUM_OF_FONT_FAMILIES) 
    {
      fprintf(stderr, "Error:  No font family selected.");
      exit(0);
    }

    if (oldFontFamily != currentFontFamily)
    {
      CheckIfEditModified(TRUE);
    }
    
    selected = Selected();
    if (selected != NO_CURRENT_EDIT)
    {
      SetQuotedTextWindowFont(currentFontFamily, currentFontStyle, currentFontSize);
    }

    break;

   case PANEL_LIST_OP_VALIDATE:
    fprintf(stderr, "QuoteMaker: FontFamilyNotifyHandler: PANEL_LIST_OP_VALIDATE: %s\n",string);
    break;

   case PANEL_LIST_OP_DELETE:
    fprintf(stderr, "QuoteMaker: FontFamilyNotifyHandler: PANEL_LIST_OP_DELETE: %s\n",string);
    break;
  }
  return XV_OK;
}

/*
 * Notify callback function for `FontStyleList'.
 */
int
FontStyleNotifyHandler(item, string, client_data, op, event)
	Panel_item	item;
	char		*string;
	Xv_opaque	client_data;
	Panel_list_op	op;
	Event		*event;
{
  int  i;
  int  oldFontStyle;
  int  selected;
 	
  switch(op) {
   case PANEL_LIST_OP_DESELECT:
    break;

   case PANEL_LIST_OP_SELECT:
    oldFontStyle = currentFontStyle;
    
    for(i=0 ; i < MAX_NUM_OF_FONT_STYLES ; i++)
    {
      if (xv_get(QuoteMaker_QuoteWindowSpecificationsPopup->FontStyleList,
		 PANEL_LIST_SELECTED, i) == TRUE)
      {
	currentFontStyle = i;
	break;
      }
    }
    if (i == MAX_NUM_OF_FONT_STYLES)
    {
      fprintf(stderr, "Error:  No font style selected.");
      exit(0);
    }
    if (oldFontStyle != currentFontStyle)
    {
      CheckIfEditModified(TRUE);
    }

    selected = Selected();
    if (selected != NO_CURRENT_EDIT)
    {
      SetQuotedTextWindowFont(currentFontFamily, currentFontStyle, currentFontSize);
    }
    

    break;

   case PANEL_LIST_OP_VALIDATE:
    break;

   case PANEL_LIST_OP_DELETE:
    break;
  }
  return XV_OK;
}


/*
 * Notify callback function for `FontSizeTextField'.
 */
Panel_setting
FontSizeNotifyHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  int   select;
  int	value = (int) xv_get(item, PANEL_VALUE);
  
  currentFontSize = value;
  select = Selected();

  if (select != NO_CURRENT_EDIT)
  {
    CheckIfEditModified(TRUE);
  }
    
  if ((event_is_ascii(event) && (event_action(event) == '\n' ||	    /*  The Quote Window font will be updated only when */
				event_action(event) == '\r'))	    /*  ...a return or line-feed is hit, or when one... */
    || event_is_button(event))					    /*  ...of the textfield "triangles" are pressed.    */
  {								    
    SetQuotedTextWindowFont(currentFontFamily,
			    currentFontStyle,
			    currentFontSize);
  }

  return panel_text_notify(item, event);
}


/*
 * Notify callback function for `QTWSpecsDoneButton'.
 */
void
QTWSpecsDoneButtonHandler(item, event)
	Panel_item	item;
	Event		*event;
{
  Hide(&QuoteMaker_QuoteWindowSpecificationsPopup->QuoteWindowSpecificationsPopup);
}


void
  InitMainPanel()
{
  PutInDefaultDuration();
  notify_interpose_destroy_func(QuoteMaker_baseWindow->baseWindow,
				DestroyBaseWindow);
  BlackColorIndex = gcm_color_index("black");
  GreenColorIndex = gcm_color_index("green");
}



void
  AlertByNoticePrompt(control, message)
Xv_Window	control;
char		*message;
{
  notice_prompt(control, NULL,
		NOTICE_MESSAGE_STRINGS, message, NULL,
		NOTICE_BUTTON, "OK", 'O',
		NULL);
}


/*
 * Notify callback function for `DurationMinsTextField'.
 */
Panel_setting
  DurationMinsTextFieldHandler(item, event)
Panel_item	item;
Event		*event;
{
  CheckIfEditModified(TRUE);
  
  return panel_text_notify(item, event);
}


/*
 * Notify callback function for `DurationSecsTextField'.
 */
Panel_setting
  DurationSecsTextFieldHandler(item, event)
Panel_item	item;
Event		*event;
{
  CheckIfEditModified(TRUE);
  
  return panel_text_notify(item, event);
}
