/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstroxdr.c,v 1.16 92/05/29 12:40:34 drapeau Exp $ */
/* $Log:	MAEstroxdr.c,v $
 * Revision 1.16  92/05/29  12:40:34  drapeau
 * Changed the name of the "Selection" structure to "MAESelection",
 * to avoid name conflicts with other software packages and toolkits
 * that might also define a "Selection" structure.
 * 
 * Revision 1.15  91/11/25  13:01:40  drapeau
 * Added a function, DestroyPort(), to free space taken by a Port*.
 * 
 * Revision 1.14  91/09/18  12:45:29  drapeau
 * - Added a utility function "DestroyPortArray()", to help programmers clean up after they have
 *   called the SenderGetPortFromName() method.  The function will free all of the data in a
 *   PortArray* passed in as argument, including the component Port* data.
 * - Changed the name of the major include file from LinkProtocol.h to MAEstro.h, in keeping with the
 *   project name.
 * 
 * Revision 1.13  91/06/19  14:01:53  drapeau
 * Minor cosmetic changes (reformatting of code).
 * Also, modified xdr_Selection to accomodate the new Selection structure (two
 * new fields, offset and label were added).  For the label, which is declared
 * as a "char[LabelLength]", this meant adding a temporary pointer of type
 * "char*".  Evidently, the xdr_string() function doesn't like using character
 * arrays (char[]), so a string (char*) is used to point to the beginning of
 * the character array.  xdr_string() seems to like that better.
 * 
 * Also, added a new function, xdr_IconData(), to transfer icons among apps.
 * 
 * Revision 1.12  91/06/17  18:17:18  drapeau
 * Added copyright notice.
 * 
 * Revision 1.11  1991/02/28  07:29:48  drapeau
 * No code changes; this version uses a new version numbering scheme and a new
 * version of RCS.
 *
 * Revision 1.1  90/10/24  18:22:00  drapeau
 * Initial revision
 *  */

static char maestroxdrRcsid[] = "$Header: /Source/Media/drapeau/NetworkProtocol/RCS/MAEstroxdr.c,v 1.16 92/05/29 12:40:34 drapeau Exp $";

#include <rpc/rpc.h>
#include <MAEstro.h>


bool_t	xdr_Port(XDR* xdrs, Port *objp)
{
  if (!xdr_string(xdrs, &objp->hostName, ~0))
  {
    return (FALSE);
  }
  if (!xdr_string(xdrs, &objp->appName, ~0))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->portNumber))
  {
    return (FALSE);
  }
  return (TRUE);
}



bool_t	xdr_PortArray(XDR *xdrs, PortArray *objp)
{
  if (!xdr_array(xdrs, (char **)&objp->portArray,
		 (u_int *)&objp->numberOfPorts, ~0,
		 sizeof(Port), xdr_Port))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->numberOfPorts))
  {
    return (FALSE);
  }
  return (TRUE);
}



bool_t	xdr_MAESelection(XDR *xdrs, MAESelection *objp)
{
  char*	tempString = (char*)objp->label;			    /* xdr_string doesn't like char[]; char* tempString...  */
  
  if (!xdr_int(xdrs, &objp->start))				    /*  ...works around this problem */
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->end))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->duration))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->offset))
  {
    return (FALSE);
  }
  if (!xdr_string(xdrs, &tempString, LabelLength))
  {
    return (FALSE);
  }
  return (TRUE);
}


bool_t	xdr_IconData(XDR *xdrs, IconData *objp)
{
  if (!xdr_bytes(xdrs, (char **)&objp->iconData,
		 (u_int *)&objp->dataLength, ~0))
  {
    return (FALSE);
  }
  if (!xdr_int(xdrs, &objp->dataLength))
  {
    return (FALSE);
  }
  return (TRUE);
}



void	DestroyPortArray(PortArray* thePortArray)
{
  int	arrayElement = 0;
  Port*	thePort = (Port*) NULL;
  
  if (thePortArray == (PortArray*)NULL)
    return;
  for (arrayElement = 0;					    /* Traverse list of Ports in array, freeing space one by one */
       arrayElement < thePortArray->numberOfPorts;
       arrayElement++)
  {
    thePort = &(thePortArray->portArray[arrayElement]);		    /* Point to the current Port in the array */
    if (thePort != (Port*)NULL)					    /* Is this a valid Port*? */
    {								    /* Yes, free space taken by each element of the Port* */
      if (thePort->appName)
	free(thePort->appName);
      if (thePort->hostName)
	free(thePort->hostName);
    }
  }								    /* end for... */
  if (thePortArray->portArray != (Port*)NULL)
  {
    free(thePortArray->portArray);				    /* Now that each Port's fields have been freed, free Port's */
    thePortArray->portArray = (Port*)NULL;			    /* Re-initialize the PortArray passed in as argument */
    thePortArray->numberOfPorts = 0;
  }
  return;
}								    /* end function DestroyPortArray */


void	DestroyPort(Port* thePort)
{
  if (thePort != (Port*)NULL)					    /* Make sure a non-NULL Port* was passed in */
  {
    if (thePort->hostName != (char*)NULL)
      free(thePort->hostName);
    if (thePort->appName != (char*)NULL)
      free(thePort->appName);
    free(thePort);
  }
  return;
}								    /* end function DestroyPort */
