/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V. and HIO Enschede          *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*
 * MaMA_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `MaMA.G'.
 */
#include <MaMA_main_include.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/cursor.h>
#include <gdd.h>
#include <group.h>

/*
 * ToolTalk include files
 */
#include <desktop/tt_c.h>
#include <desktop/ce.h>

#include "MaMA_ui.h"
#include <MaMA_main_global.h>

/*
 * tricky solution to get around the Selection declaration
 * NOTE: do not compile with -DMAIN  !!!
 */
#ifdef MAIN
    #include <xview/dragdrop.h>
#endif

/*
 * Get proper icon
 */
#ifdef MaMA
    static unsigned short icon_bits[] =
    {
        #include "./include/images/MaMA_main.icon"
    };

    static unsigned short icon_mask_bits[] =
    {
        #include "./include/images/MaMA_main_mask.icon"
    };
#endif

#ifdef SaM
    static unsigned short icon_bits[] =
    {
        #include "./include/images/SaM_main.icon"
    };

    static unsigned short icon_mask_bits[] =
    {
        #include "./include/images/SaM_main_mask.icon"
    };
#endif

char    *GetFrameVersion();
void    Icon_init();
void    PM_Connect();
void    Hardset_positions();
void    XView_init();
void    fork_PM();
void	delete_sel_proc(Menu_item, Menu_generate);
void	del_all_proc(Menu_item, Menu_generate);
void	up_button_proc(Panel_item, Event *);
void	down_button_proc(Panel_item, Event *);
void	Repeat_proc(Panel_item, int, Event *);

static  XrmOptionDescRec OpTable[] =
{
  {"-rpcProp",  ".rpcProp",  XrmoptionSepArg,  NullString  }
};   

Widget     xwsTopLevel;
Display    *d;
char       *propName;
 
FILELIST   *FileList;		/* Ptr to the start of the FileList           */
ACTIONLIST *ActionList;		/* Ptr to the start of the ActionList         */
ACTIONLIST *Old_ActionList;	/* Ptr to a old ActionList when changing one  */
ACTIONLIST *ActionListPerformPtr;
EDITLIST   *EditList;		/* Ptr to the start of the EditList           */
EDITLISTINFO *EditListInfo;
Xv_font    *listFont;
ACTIONTYPE ActionType;
ACTIONLIST *CurAction;		/* Ptr to the currently used Action           */
EDITLIST   *CurEdit;		/* Ptr to the currently used Edit             */
FILELIST   *CurDoc;		/* Ptr to the currently used FM doc           */
int        EditOffset = 0;	/* offset within an Edit                      */
int        NumberOfActions;	/* # of Actions of the current ActionList     */
int        NumberOfEdits;	/* # of Edits of the current EditList         */
int        NumberOfDoc;		/* # of FM doc's of the current FileList      */
int        ActionListChanged;	/* Bool, check if ActionList has been changed */
int        EditListChanged;	/* Bool, check if EditList has been changed   */
int        ReturnValue;
int        result;		/* return value of notice prompts             */
int        RepeatOn;		/* Bool, is the repeat button on or off       */
int        CurRow;		/* Currently selected row in EditList         */
int        OldRow;		/* Previous selected row in EditList          */
AUTOMNTLIST *AutoMntList;	/* Ptr to start of auto mnt dir list          */
AUTOMNTLIST *AutoMntListPtr;	/* Ptr to start of auto mnt dir list          */
AUTOMNTLIST *CurAutoMnt;	/* Ptr to currently selected auto mnt dir     */
 
char       *FrameVersion;	/* Holds the FrameMaker version MaMA is using */

/*
 * timer.c globals
 */
int BlackColorIndex;
int GreenColorIndex;
int OrangeColorIndex;
int EditPlaying;
int EditPlayPaused;
int ActionPlaying;
int ActionPlayPaused;
int FILL_POPUP;
double ActionTime;
extern double actionTime;
unsigned int DocHandler;
 
extern double endTime;
extern int RepeatValue;		/* # of times to repeat the action GotoNP/PP  */

struct stat *fileInfo;
char        tmpbuf[ 1024 ];
char *home;
 
static gfm_popup_objects *Load;
static gfm_popup_objects *Select;
static gfm_popup_objects *Saveas;

#ifndef SaM
    Sender   *sender;                             
    Receiver *receiver;
    Port     senderPort;
    int      ReceiverPortNumber;
#endif

char Command[PATHLEN];

extern   char startFilename[MAXPATHLEN];
char	 EditListDragLabel[FILELEN];

int DebugMode = False;

/*
 * Global object definitions.
 */
MaMA_Main_Window_objects *MaMA_Main_Window;
MaMA_About_Panel_objects *MaMA_About_Panel;
MaMA_Edit_Panel_objects  *MaMA_Edit_Panel;
MaMA_PM_Panel_objects    *MaMA_PM_Panel;	
MaMA_Pref_Panel_objects  *MaMA_Pref_Panel;

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute  INSTANCE;


/******************************************************************************\
*                                                                              *
*        Name : main                                                           *
*                                                                              *
* Description : main                                                           *
*                                                                              *
\******************************************************************************/
main(int argc, char **argv)
{

#ifndef SaM
    /*
     * Dispatch table init
     */
    static DispatchTable DT =
    {
        MaMA_OpenDocument,	/* OpenDocument                               */
        MaMA_GetCurDoc,		/* char* *GetCurrentDocName                   */
        MaMA_GetSelection,	/* Selection* GetSelection                    */
        MaMA_SetSelection,	/* SetSelection                               */
        MaMA_PerformSelection,	/* PerformSelection                           */
        NULL,			/* ConnectWithPortMgr                         */
        NULL,			/* PortArray* GetOpenApps                     */
        NULL,			/* PortArray* GetPortFromName                 */
        NULL,			/* DispatchMsg                                */
        NULL,			/* DisconnectFromPortMgr                      */
        NULL,			/* Ping                                       */
        MaMA_HaltSelection,	/* HaltSelection                              */
        MaMA_PauseSelection,	/* PauseSelection                             */
        MaMA_ResumeSelection,	/* ResumeSelection                            */
        MaMA_HideApplication,	/* HideApllication                            */
        MaMA_ShowApplication,	/* ShowApllication                            */
        MaMA_GetAppIcon		/* GetAppIcon                                 */
    };

    BuildDispatchTable(&DT);
#endif

    FrameVersion = GetFrameVersion();		/* retrieve from ..client...c */

    MaMA_init();				/* init in-core stuff         */

    CheckOptions(argc, argv);			/* Check commandline options  */

    /*
     * Initialize stuff for the Frame Server functions 
     */
    xwsTopLevel = XtInitialize("MaMA", "MaMA", OpTable,
        XtNumber(OpTable), &argc, argv);
    d = XtDisplay(xwsTopLevel);

    /*
     * initialize Xresources
     */
    Xrc_init(&argc, argv);

    /*
     * Initialize user interface components.
     * Do NOT edit the object initializations by hand.
     */
    MaMA_Main_Window = MaMA_Main_Window_objects_initialize(NULL, NULL);
    MaMA_About_Panel = MaMA_About_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    MaMA_Edit_Panel = MaMA_Edit_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    MaMA_PM_Panel = MaMA_PM_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    MaMA_Pref_Panel = MaMA_Pref_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    gdd_init_dragdrop(MaMA_Main_Window->Main_Window);

    XView_init();				/* init XView stuff           */
    
    /*
     * Add resource key data
     */
    Add_Resource_Data();

    /*
     * Define List Font
     */
     listFont = (Xv_font *) xv_find(MaMA_Main_Window->Main_Window,
         FONT,
         FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
         FONT_STYLE, FONT_STYLE_NORMAL,
         FONT_SIZE, 12,
         NULL);

     
    /*
     * Check if a filename was specified
     */
    if ((strcmp(startFilename, "") != 0) &&
        (CheckFileType(startFilename, MaMA_EDIT_MAGIC)))
    {
        strcpy(EditListInfo->FullFileName, startFilename);

        LoadEditList(startFilename);
    
    SetHeader(startFilename);

    strcpy(EditListDragLabel, (char *)RetrieveFileName(startFilename));

    } else { 
        strcpy(EditListInfo->FullFileName, "NoName");
    strcpy(EditListDragLabel, "NoName");
    }

    PM_Connect();				/* Connect with Port Manager  */

    EditButtonsActive();			/* (de-)activate Edit buttons */

    /*
     * Fit (fits panels into window)
     */
    window_fit(MaMA_Edit_Panel->Edit_Panel);
    window_fit(MaMA_Main_Window->Main_Window);

    bindtextdomain("MaMA_labels", ".");

    ToolTalk_init();

#ifndef SaM
    xv_destroy(MaMA_Main_Window->Repeat_Setting);
#endif

    xv_main_loop(MaMA_Main_Window->Main_Window);

#ifndef SaM
    DestroyReceiver(sender, receiver);
#endif

    tt_close();

    exit(0);
}

/*
 * Menu handler for `File_Menu (Open Edit List...)'.
 */
Menu_item
open_edit_proc(Menu_item item, Menu_generate op)
{
    Print("->open_edit_proc\n");

    switch (op) {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
            gfm_activate(Load, NULL, NULL, NULL, load_proc, NULL, GFM_LOAD);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

            break;

        case MENU_NOTIFY_DONE:
            break;
    }
    return item;
}

/*
 * Menu handler for `File_Menu (Save Edit List...)'.
 */
Menu_item
save_edit_proc(Menu_item item, Menu_generate op)
{
    int response;
    
    Print("->save_edit_proc\n");

    switch (op) {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
            /*
             * Check if a Name has been specified
             */
            if (strcmp(EditListInfo->FullFileName, "NoName") == 0)
            {
                notice_prompt (MaMA_Main_Window->Main_Window, NULL,
                    NOTICE_MESSAGE_STRINGS,    
                    dgettext("MaMA_labels", 
                        "No EditList file name specified!"),
                    dgettext("MaMA_labels", 
                        "Use 'Save As...' to save the Edit List."),
                    NULL,
                    NOTICE_BUTTON, "OK", 100,
                    NULL);
                break;
            }

            if (WriteEditList2File(EditList))
	    {
	        ResetMenu();
                EditListChanged = False;
                xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, "", 
                    NULL);
	    }
        
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

            break;

        case MENU_NOTIFY_DONE:
            break;
    }
    return item;
}

/*
 * Menu handler for `File_Menu (Save As...)'.
 */
Menu_item
saveas_edit_proc(Menu_item item, Menu_generate op)
{
    Print("->saveas_edit_proc\n");

    switch (op) {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
            gfm_activate(Saveas, NULL, NULL, NULL, saveas_proc, NULL,
                GFM_SAVE);
        
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

            break;

        case MENU_NOTIFY_DONE:
            break;
    }
    return item;
}

/*
 * Menu handler for `File_Menu (About MaMA...)'.
 */
Menu_item
MaMA_File_Menu_item3_callback(Menu_item item, Menu_generate op)
{
    switch (op) {
    case MENU_DISPLAY:
        break;

    case MENU_DISPLAY_DONE:
        break;

    case MENU_NOTIFY:
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(MaMA_About_Panel->About_Panel, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(MaMA_About_Panel->About_Panel, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

        break;

    case MENU_NOTIFY_DONE:
        break;
    }
    return item;
}

/*
 * Menu handler for `File_Menu (Quit MaMA)'.
 */
Menu_item
quit_proc(Menu_item item, Menu_generate op)
{
    Print("->quit_proc\n");

    switch (op) 
    {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
            xv_destroy(MaMA_Main_Window->Main_Window);
            break;

        case MENU_NOTIFY_DONE:
            break;
    }
    return item;
}

/*
 * Menu handler for `Delete_Actions_Menu (Selected)'.
 */
Menu_item
del_sel_action(Menu_item item, Menu_generate op)
{
    Print("->del_sel_action\n");

    switch (op) {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		delete_sel_proc(item, op);
		
		/* gxv_end_connections */

            break;

        case MENU_NOTIFY_DONE:
            break;
    }
    return item;
}

/*
 * Menu handler for `Delete_Actions_Menu (All)'.
 */
Menu_item
del_all_actions(Menu_item item, Menu_generate op)
{
    Print("->del_sel_actions\n");

    switch (op) {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		del_all_proc(item, op);
		
		/* gxv_end_connections */

            break;

        case MENU_NOTIFY_DONE:
            break;
    }
    return item;
}

/*
 * User-defined action for `Delete_Actions_Menu'.
 */
void
delete_sel_proc(Menu_item item, Menu_generate op)
{
    int row;

    Print("->delete_sel_proc\n");
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);

    row = (int)xv_get(MaMA_Edit_Panel->Action_List, PANEL_LIST_FIRST_SELECTED);

    xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_DELETE, row, NULL);
    ActionList = DeleteSelectedAction(ActionList);
    NumberOfActions--;

    ActionButtonsActive();		/* (De-) activate actions buttons     */

    if (NumberOfActions > 0)
    {
        /*
         * Mark a entry as selected
         */
     	if (row == NumberOfActions)
        {
            xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_SELECT, row - 1 , 
                TRUE, NULL);
            (void )SelectAction(ActionList, row - 1);
        } else {
            xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_SELECT, row, 
                TRUE, NULL);
            (void )SelectAction(ActionList, row);
        }
    }

    PrintActionList(ActionList);
    ActionListChanged = True;
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, 
        dgettext("MaMA_labels", "Action List Modified"), NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
}

/*
 * User-defined action for `Delete_Actions_Menu'.
 */
void
del_all_proc(Menu_item item, Menu_generate op)
{
    Print("->del_all_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);
    
    xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_DELETE_ROWS, 0,
        NumberOfActions, NULL);
    DeleteActionList(ActionList);
    ActionList = NIL(ACTIONLIST *);

    ActionListChanged = True;
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, 
        dgettext("MaMA_labels", "Action List Modified"), NULL);
    NumberOfActions = 0;

    /*
     * (De-) activate action button
     */
    ActionButtonsActive();

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
}

/*
 * Drop callback function for `edit_drop_target'.
 */
void
edit_list_drop_proc(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info)
{
    EDITLIST *EditListPtr;
    ACTIONLIST *ActionListPtr;
    char SaveString[300];

    Print("->edit_list_drop_proc\n");

    /*
     * Open MaMA (Edit List could be dropped on icon!)
     */
    xv_set(MaMA_Main_Window->Main_Window, FRAME_CLOSED, FALSE, NULL);

    if (ActionListChanged || EditListChanged)
    {
        strcpy(SaveString, EditListInfo->FullFileName);
        strcat(SaveString, "?");

        result = notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Warning:"),
            dgettext("MaMA_labels", "You have unsaved changes!"),
            dgettext("MaMA_labels", "Shall I save the Edit List in:"),
            SaveString,
            NULL,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Save"), 100,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Ignore changes"), 101,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 102,
            NULL);

        if (result == 100) 
        {
            if (!WriteEditList2File(EditList))
	    {
		return;
            } else {
	        ResetMenu();
            }
        } 

        if (result == 102) 
        {
            return;
        }
    }

        /*
         * Read in file
         */
        if (CheckFileType(drop_info->filename, MaMA_EDIT_MAGIC))
        {
        LoadEditList(drop_info->filename);

        strcpy(EditListDragLabel, drop_info->data_label);

        SetHeader((char *)drop_info->filename);

        /*
         * Reset changed bools
         */
        ActionListChanged = False;
        EditListChanged = False;
        xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, "", NULL);
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

            EditButtonsActive();		/* (De)acivate edit buttons   */
        }
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Drag callback function for `edit_drop_target'.
 */
void
edit_list_drag_proc(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info,
        int drag_state)
{
char *buf;
    
    Print("->edit_list_drag_proc\n");

    if (buf) free(buf);

    buf = (char *) malloc((unsigned)((3000) * sizeof(char)));

    strcpy(buf, WriteEditList2Buf(EditList));

    switch(drag_state)
    {
        case GDD_DRAG_STARTED:
            drop_info->app_name = "MaMA";
            drop_info->data =  buf; 
            drop_info->data_label = EditListDragLabel; 
            drop_info->length = strlen(buf);

            break;

        case GDD_DRAG_COMPLETED:
            free(drop_info);
            break;
    }
}


/*
 * Notify callback function for `Insert_Edit_Button'.
 */
void
insert_edit_proc(Panel_item item, Event *event)
{
    int i, SelectedRow;
    char *ListString;
    EDITLIST *EditListPtr;

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);

    Print("->insert_edit_proc\n");
    
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    /*
     * Chop off spaces at beginning of label name and check if it is filled
     * & Check for unique label name
     */
    if (CheckLabelName())
    {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return;
    }

    ChangeEditMode = False;

    if (CheckIfUniqueLabel())
    {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return;
    }

    /*
     * Add an Edit to the EditList
     */
    CurEdit = InsertEdit(EditList);
    if (EditList == NIL(EDITLIST *))
    {
        EditList = CurEdit;
    }
    CurEdit->ActionList = NIL(ACTIONLIST *);

    /*
     * Fill CurEdit and build the List String
     */
    FillEdit();
    ListString = BuildEditString();

    xv_set(MaMA_Main_Window->Edit_List,
        PANEL_LIST_INSERT,NumberOfEdits,
        PANEL_LIST_STRING,NumberOfEdits, ListString,
        PANEL_LIST_FONT, NumberOfEdits, listFont,NULL);

    /*
     * Mark entry as selected
     */
    xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_SELECT, NumberOfEdits , 
        TRUE, NULL);
    (void )SelectEdit(EditList, NumberOfEdits);

    NumberOfEdits++;

    EditButtonsActive();			/* Deacivate edit buttons     */

    xv_set(MaMA_Main_Window->edit_drop_target, PANEL_DROP_FULL, TRUE, NULL);
    
    PrintEditList(EditList);
    ActionListChanged = False;
    EditListChanged = True;

    SetMenu();
    xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, 
        dgettext("MaMA_labels", "Edit List Modified"), NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

    ActionList = CopyActionList(CurEdit->ActionList);
    CurAction = GetSelectedAction(ActionList);

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Notify callback function for `Change_Edit_Button_In_Pop'.
 */
void
Change_Edit_From_Pop_Proc(Panel_item item, Event *event) 
{ 
    int i;
    int SelectedRow;
    char *ListString;
    EDITLIST *EditListPtr;
    
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);

    Print("->Change_Edit_From_Pop_Proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    /*
     * Chop off spaces at beginning of label name and check if it is filled
     */
    if (CheckLabelName())
    {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return;
    }

    /*
     * Check for a unique label name
     */
    ChangeEditMode = True;
    if (CheckIfUniqueLabel())
    {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return;
    }

    /*
     * Apply changes to the EditList
     */
    FillEdit();
    ListString = BuildEditString();

    /*
     * Insert String in GUI
     */
    xv_set(MaMA_Main_Window->Edit_List,
        PANEL_LIST_STRING, CurRow, ListString,
        PANEL_LIST_FONT, CurRow, listFont,NULL);

    PrintEditList(CurEdit);
    ActionListChanged = False;
    EditListChanged = True;

    SetMenu();
    xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, 
        dgettext("MaMA_labels", "Edit List Modified"), NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

    ActionList = CopyActionList(CurEdit->ActionList);
    CurAction = GetSelectedAction(ActionList);

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Notify callback function for `Create_Edit_Button'.
 */
void
create_edit_proc(Panel_item item, Event *event)
{
    Print("->create_edit_proc\n");

    if (ActionListChanged && (!(Notice_Handler())))
    {
       return; 
    }

    PrintActionList(ActionList);
    ActionList = NIL(ACTIONLIST *);

    InitPopup();			/* Clear GUI                          */
    NumberOfActions = 0;

    ActionButtonsActive();		/* (De-) activate action buttons      */

    DocButtonsActive();			/* (De-) activate Document buttons    */

    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_LABEL, dgettext("MaMA_labels",
        "Create Edit"), NULL);


    if(!((int)xv_get(MaMA_Edit_Panel->Edit_Panel, XV_SHOW)))
    {
        PositionPopup();
    }
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(MaMA_Edit_Panel->Edit_Panel, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */
}

/******************************************************************************\
*                                                                              *
*        Name : FillPopup                                                      *
*                                                                              *
* Description : Fills in the Popup window with the proper information          *
*                                                                              *
\******************************************************************************/
void
FillPopup()
{
    ACTIONLIST *ActionListPtr;
    ACTIONLIST *Tmp_ActionListPtr;
    FILELIST   *FileListPtr;
    char       *ListString;
    
    Print("->FillPopup\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);

    if (strcmp( (char *)xv_get(MaMA_Edit_Panel->Edit_Label_tf, PANEL_VALUE), 
        CurEdit->Label) == 0)
    {
	if (!(FILL_POPUP))
 	{	
            Print(dgettext("MaMA_labels", "Edit is  already in Popup"));
    	    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    	    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
    	    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_CMD_PUSHPIN_IN,
             TRUE, NULL);
    	    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_SHOW, TRUE, NULL);
            return;
	}
    }

    /*
     * Reset ActionList for next Edit
     */
    ActionList = NIL(ACTIONLIST *);

    InitPopup();

    /*
     * Clear the document list as well
     */
    xv_set(MaMA_Edit_Panel->Doc_List, PANEL_LIST_DELETE_ROWS, 0, NumberOfDoc, 
        NULL);
    xv_set(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, "", NULL);
    xv_set(MaMA_Edit_Panel->File_tf, PANEL_VALUE, "", NULL);
    xv_set(MaMA_Edit_Panel->doc_drop_target, PANEL_DROP_FULL, FALSE, NULL);

    NumberOfDoc = 0;
    NumberOfActions = 0;

    ActionButtonsActive();		/* (De-) activate action buttons      */

    DocButtonsActive();			/* (De-) activate Document buttons    */
        
    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_LABEL, dgettext("MaMA_labels",
        "Change Edit"), NULL);

    Tmp_ActionListPtr = ActionList;
    ActionList = CopyActionList(CurEdit->ActionList);
    DeleteActionList(Tmp_ActionListPtr);
    CurAction = GetSelectedAction(ActionList);

    xv_set(MaMA_Edit_Panel->Edit_Label_tf, PANEL_VALUE,
        CurEdit->Label, NULL);

    /*
     * Fill the Action List in the GUI with the Actions
     */
    ActionListPtr = ActionList;
    while (ActionListPtr != NIL(ACTIONLIST *))
    {
        CurAction = ActionListPtr;
        ListString = BuildActionString();

        xv_set(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_INSERT,NumberOfActions,
            PANEL_LIST_STRING,NumberOfActions, ListString,
            PANEL_LIST_FONT, NumberOfActions, listFont,NULL);

        NumberOfActions++;

        ActionListPtr = ActionListPtr->next;
    }

    ActionButtonsActive();		/* (De-) activate action buttons      */

    /*
     * Fill the Document List in the GUI with the Doc's used in the Actions
     */
    FileList = BuildFileList(ActionList);
    FileListPtr = FileList;
    while (FileListPtr != NIL(FILELIST *))
    {
        xv_set(MaMA_Edit_Panel->Doc_List,
            PANEL_LIST_INSERT,NumberOfDoc,
            PANEL_LIST_STRING,NumberOfDoc, FileListPtr->File->Name,
            PANEL_LIST_FONT, NumberOfDoc, listFont,NULL);
        
        NumberOfDoc++;

        DocButtonsActive();		/* (De-) activate Document buttons    */

        FileListPtr = FileListPtr->next;
    }

    if (NumberOfDoc > 0)
    {
        xv_set(MaMA_Edit_Panel->doc_drop_target, PANEL_DROP_FULL, TRUE, NULL);
    }
    
    /*
     * Select first item
     */
    SelectAction(ActionList, 0);

    FILL_POPUP = False;

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_CMD_PUSHPIN_IN,
             TRUE, NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_SHOW, TRUE, NULL);
}

/*
 * Notify callback function for `Delete_Edit_Button'.
 */
void
del_edit_proc(Panel_item item, Event *event)
{
    int row;
    
    Print("->del_edit_proc\n");

    row = (int)xv_get(MaMA_Main_Window->Edit_List, PANEL_LIST_FIRST_SELECTED);

    if (ActionListChanged)
    {
        result = notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Warning: The ActionList is changed!"),
            NULL,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 100,
            NOTICE_BUTTON, dgettext("MaMA_labels", 
                "Continue, ignore changes"), 101,
            NULL);

        if (result == 100) return;
    }

    xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_DELETE, row, NULL);

    CurEdit = NIL(EDITLIST *);

    EditList = DeleteSelectedEdit(EditList);
    NumberOfEdits--;

    if (NumberOfEdits > 0)
    {
        /*
         * Mark a entry as selected
         */
     	if (row == NumberOfEdits)
        {
            xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_SELECT, row - 1 , 
                TRUE, NULL);
            (void )SelectEdit(EditList, row - 1);

            if((int)xv_get(MaMA_Edit_Panel->Edit_Panel, XV_SHOW))
            {
                FillPopup();
            }
        } else {
            xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_SELECT, row, 
                TRUE, NULL);
            (void )SelectEdit(EditList, row);

            if((int)xv_get(MaMA_Edit_Panel->Edit_Panel, XV_SHOW))
            {
                FillPopup();
            }
        }
    } else {
        xv_set(MaMA_Main_Window->edit_drop_target, PANEL_DROP_FULL, FALSE,NULL);
    }

    ActionListChanged = False;
    EditListChanged = True;

    SetMenu();
    xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, 
        dgettext("MaMA_labels", "Edit List Modified"), NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

    EditButtonsActive();			/* Deacivate edit buttons     */

    PrintEditList(EditList);
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Stop_Button'.
 */
void
stop_button_proc(Panel_item item, Event *event)
{
    Print("->stop_button_proc\n");

    if(ActionPlaying) return;

    CancelTimers();
 
    if (EditPlaying)
    {
        CancelButtonGlowTimer();
        CancelButtonGlow();
    }   
 
    EditPlayPaused = FALSE;
    EditPlaying = FALSE;
    ActionListPerformPtr = NIL(ACTIONLIST *);
    RepeatValue = 0;
 
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `EditPlay_Button'.
 */
void
play_button_proc(Panel_item item, Event *event)
{
    int min;
    int sec;
    int PlayingDur;
    int Rep;
    int Dur;
    int Cumm;
    char EndTime[6];
    char StartTime[6];

    Print("->play_button_proc\n");

    if((EditPlaying && !EditPlayPaused) || ActionPlaying) return;

    /*
     * Resume if previewing is paused
     */
    if (EditPlayPaused)
    {
        EditPlayPaused = FALSE;
        SetTimer(endTime);
        xv_set(MaMA_Main_Window->Pause_Button, PANEL_ITEM_COLOR,
        BlackColorIndex, NULL);
        return;
    }

    if (NumberOfActions == 0) /*WARNING!!!*/
    {
        notice_prompt (MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "No Actions To Preview!"),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        return;
    }
    min = ((CurEdit->TotalDur) / 60);
    sec = ((CurEdit->TotalDur) % 60);

    sprintf(StartTime, "00:00", min, sec);
    xv_set(MaMA_Main_Window->Start_message1, PANEL_LABEL_STRING, StartTime, 
        NULL);

    sprintf(EndTime, "%d:%d", min, sec);
    if (sec < 10) sprintf(EndTime, "%d:0%d", min, sec);
    if (min < 10) sprintf(EndTime, "0%d:%d", min, sec);
    if ((min < 10)  && (sec < 10)) sprintf(EndTime, "0%d:0%d", min, sec);
    xv_set(MaMA_Main_Window->End_message1, PANEL_LABEL_STRING, EndTime, NULL);

    ActionListPerformPtr = CurEdit->ActionList;

    InitTimer();
    EditPlaying = True;

    if (EditOffset != 0) /* There is an offset */
    {
        Cumm = 0;
        min = ((EditOffset) / 60);
        sec = ((EditOffset) % 60);

        /*
         * Set StartTime to offset
         */
        sprintf(StartTime, "%d:%d", min, sec);
        if (sec < 10) sprintf(StartTime, "%d:0%d", min, sec);
        if (min < 10) sprintf(StartTime, "0%d:%d", min, sec);
        if ((min < 10)  && (sec < 10)) sprintf(StartTime, "0%d:0%d", min, sec);
        xv_set(MaMA_Main_Window->Start_message1, PANEL_LABEL_STRING,
            StartTime, NULL);

        while(Cumm < EditOffset)
        {
            if (((ActionListPerformPtr->Action->ActionType == GotoNP)
             || (ActionListPerformPtr->Action->ActionType == GotoPP))) 
            {
                Rep = ActionListPerformPtr->Action->Param->Times;
                Dur = ActionListPerformPtr->Duration;
                Cumm += (Rep * Dur); 

                if (Cumm > EditOffset) 
                {
                    RepeatValue = (((Rep * Dur) - 
                        (EditOffset - (Cumm - (Rep * Dur)))) / Dur);

                } else {
                    ActionListPerformPtr = ActionListPerformPtr->next;
                }
            } else {
                Cumm += ActionListPerformPtr->Duration;
                if (Cumm < EditOffset)
                {
                    ActionListPerformPtr = ActionListPerformPtr->next;
                }
            }
        }
        PlayingDur = CurEdit->TotalDur - EditOffset;

        if ((ActionListPerformPtr->Action->ActionType == GotoNP)
         || (ActionListPerformPtr->Action->ActionType == GotoPP)) 
        {
            ActionTime = (double)((Cumm - EditOffset) - (RepeatValue * Dur));
            actionTime = Dur - ActionTime;
            if (ActionTime == 0.0)
            {
                PerformAction(ActionListPerformPtr);
                ActionTime = (double)Dur;
                actionTime = Dur - ActionTime;
            }
        } else {
            ActionTime = (double)(Cumm - EditOffset);
            actionTime = Dur - ActionTime;
        }

    } else { /* No Offset */

        if ((ActionListPerformPtr->Action->ActionType == GotoNP)
         || (ActionListPerformPtr->Action->ActionType == GotoPP)) 
        {
            RepeatValue = ActionListPerformPtr->Action->Param->Times;
        }

        PerformAction(ActionListPerformPtr);
        ActionTime = (double)ActionListPerformPtr->Duration;
        PlayingDur = CurEdit->TotalDur;
    }

    SetButtonGlowTimer(0.5);
    SetTimer((double)PlayingDur);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Pause_Button'.
 */
void
pause_button_proc(Panel_item item, Event *event)
{
    Print("->pause_button_proc\n");

    if(ActionPlaying) return;

    if (EditPlaying)
    {
        if (EditPlayPaused)
        {
            EditPlayPaused = FALSE;
            SetTimer(endTime);
            xv_set(MaMA_Main_Window->Pause_Button, PANEL_ITEM_COLOR,
            BlackColorIndex, NULL);
        } else {   
            EditPlayPaused = TRUE;
      	    CancelTimers();
      	    xv_set(MaMA_Main_Window->Pause_Button, PANEL_ITEM_COLOR,
            OrangeColorIndex, NULL);
      	    xv_set(MaMA_Main_Window->Play_Button, PANEL_ITEM_COLOR,
            GreenColorIndex, NULL);
        }
    }  
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Up_Button'.
 */
void
MaMA_Edit_Panel_Up_Button_notify_callback(Panel_item item, Event *event)
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	up_button_proc(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `Up_Button'.
 */
void
up_button_proc(Panel_item item, Event *event)
{
    int SelectedRow;
    char buf[100];

    Print("->up_button_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    ActionList = MoveUp(ActionList);

    SelectedRow = (int)xv_get(MaMA_Edit_Panel->Action_List, 
        PANEL_LIST_FIRST_SELECTED);

    if ((SelectedRow != 0) && (SelectedRow != -1))
    {
        strcpy(buf, (char *)xv_get(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_STRING, SelectedRow));

        xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_STRING,
            SelectedRow, ((int)xv_get(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_STRING, SelectedRow - 1, NULL)), NULL);

        xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_STRING,
            SelectedRow - 1, buf, NULL);

        /* 
         * Mark entry as selected
         */
        xv_set(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_SELECT, SelectedRow-1, TRUE, NULL);
        SelectAction(ActionList, SelectedRow - 1);

        ActionListChanged = True;
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, 
            dgettext("MaMA_labels", "Action List Modified"), NULL);
    }

    MoveButtonsActive();			/* (de-)activate move buttons */
}

/*
 * Notify callback function for `Down_Button'.
 */
void
MaMA_Edit_Panel_Down_Button_notify_callback(Panel_item item, Event *event)
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	down_button_proc(item, event);
	
	/* gxv_end_connections */

}

/*
 * User-defined action for `Down_Button'.
 */
void
down_button_proc(Panel_item item, Event *event)
{
    int SelectedRow;
    char buf[100];

    Print("->down_button_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    ActionList = MoveDown(ActionList);

    SelectedRow = (int)xv_get(MaMA_Edit_Panel->Action_List, 
        PANEL_LIST_FIRST_SELECTED);

    if ((SelectedRow + 1 < NumberOfActions) && (SelectedRow != -1))
    {
        strcpy(buf, (char *)xv_get(MaMA_Edit_Panel->Action_List,
                PANEL_LIST_STRING, SelectedRow, NULL));

        xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_STRING,
      	    SelectedRow, (xv_get(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_STRING, SelectedRow + 1, NULL)),NULL);

        xv_set(MaMA_Edit_Panel->Action_List, PANEL_LIST_STRING,
            SelectedRow + 1, buf, NULL);

        
        /* 
         * Mark entry as selected
         */
        xv_set(MaMA_Edit_Panel->Action_List,
            PANEL_LIST_SELECT, SelectedRow + 1, TRUE, NULL);
        SelectAction(ActionList, SelectedRow + 1);

        ActionListChanged = True;
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, 
            dgettext("MaMA_labels", "Action List Modified"), NULL);
    }

    MoveButtonsActive();			/* (de-)activate move buttons */
}

/*
 * Notify callback function for `Action_Settings'.
 */
void
MaMA_Edit_Panel_Action_Settings_notify_callback(Panel_item item, int	 value, Event *event)
{
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
		xv_set(MaMA_Edit_Panel->Link_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(MaMA_Edit_Panel->Link_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 4)
	{
		xv_set(MaMA_Edit_Panel->Link_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 8)
	{
		xv_set(MaMA_Edit_Panel->Link_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 9)
	{
		xv_set(MaMA_Edit_Panel->Link_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 5)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 6)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 7)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 4)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 8)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 9)
	{
		xv_set(MaMA_Edit_Panel->Zoom_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 2)
	{
		xv_set(MaMA_Edit_Panel->Rep_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 3)
	{
		xv_set(MaMA_Edit_Panel->Rep_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(MaMA_Edit_Panel->Rep_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 4)
	{
		xv_set(MaMA_Edit_Panel->Rep_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 8)
	{
		xv_set(MaMA_Edit_Panel->Rep_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 9)
	{
		xv_set(MaMA_Edit_Panel->Rep_Layer, XV_SHOW, FALSE, NULL);
	}
	
	if (value == 1)
	{
		xv_set(MaMA_Edit_Panel->Empty_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 4)
	{
		xv_set(MaMA_Edit_Panel->Empty_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 8)
	{
		xv_set(MaMA_Edit_Panel->Empty_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 9)
	{
		xv_set(MaMA_Edit_Panel->Empty_Layer, XV_SHOW, TRUE, NULL);
	}
	
	if (value == 10)
	{
		xv_set(MaMA_Edit_Panel->Empty_Layer, XV_SHOW, TRUE, NULL);
	}
	
	/* gxv_end_connections */

}

/*
 * Drop callback function for `doc_drop_target'.
 */
void
doc_drop_proc(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info)
{
    char buf[PATHLEN + FILELEN];
    char dir_name[PATHLEN];
    char file_name[FILELEN];
    int  dir_len;

    Print("->doc_drop_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    dir_len = ((strlen(drop_info->filename)) - (drop_info->length));
    strncpy(dir_name, drop_info->filename, dir_len);

    /*
     * remove last `/' of path
     */
    dir_name[dir_len - 1] = '\0';

    strcpy(dir_name, RemoveAutoMntDir(dir_name));

    strcpy(file_name, drop_info->data_label);
    
    /*
     * A 'CE-check' if "file_name" is a FrameMaker document
     */
    if(!CheckFileType(drop_info->filename, FRAME_MAGIC))
    {
        return;
    }

    AddFileInList(dir_name, file_name);
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Drag callback function for `doc_drop_target'.
 */
void
doc_drag_proc(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info,
        int drag_state)
{
    char *filename;

    Print("->doc_drag_proc\n");

    filename = (char *) malloc((unsigned)((256) * sizeof(char)));

    switch(drag_state)
    {
        case GDD_DRAG_STARTED:
            drop_info->app_name = "MaMA";

            if (0 == strcmp((char *)xv_get(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE,
                NULL), "/"))
            {
                sprintf(filename, "/%s", (char *)
                    xv_get(MaMA_Edit_Panel->File_tf, PANEL_VALUE, NULL));
            } else {
                sprintf(filename, "%s/%s", (char *)
                    xv_get(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, NULL), 
                        (char *)xv_get(MaMA_Edit_Panel->File_tf, PANEL_VALUE, 
                        NULL));
            }
        
            drop_info->filename = filename;
            drop_info->data_label = (char *)xv_get(MaMA_Edit_Panel->File_tf,
                PANEL_VALUE, NULL);
                                       
            break;

        case GDD_DRAG_COMPLETED:
            free(drop_info);
            break;
    }
}

/*
 * Notify callback function for `Doc_List'.
 */
int
doc_list_proc(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
    Print("->doc_list_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    switch(op) {
        case PANEL_LIST_OP_DESELECT:

            (void )DisplayFileInfo(FileList, row, False);
            break;

        case PANEL_LIST_OP_SELECT:
            /*  
             * Set CurrentlySelected field in FileList
             */
            (void )SelectFile(FileList, row);
            (void )DisplayFileInfo(FileList, row, True);
            if (doubleclick(event))
            {
                view_target_doc_proc(MaMA_Edit_Panel->Doc_List, NIL(Event *));
            } else {
                PutLinksInChoice(CurDoc->File->LinkList);
            }
            break;

        case PANEL_LIST_OP_VALIDATE:
            break;

        case PANEL_LIST_OP_DELETE:
            break;
    }
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    return XV_OK;
}


/*
 * Notify callback function for `Add_Doc_Button'.
 */
void
add_target_doc_proc(Panel_item item, Event *event)
{
    Print("->add_target_doc_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    gfm_activate(Select, NULL, NULL, NULL, select_proc, NULL, GFM_DEFAULT);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Delete_Doc_Button'.
 */
void
del_target_doc_proc(Panel_item item, Event *event)
{
    int row;

    Print("->del_target_doc_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    row = (int)xv_get(MaMA_Edit_Panel->Doc_List,
        PANEL_LIST_FIRST_SELECTED);

    xv_set(MaMA_Edit_Panel->Doc_List, PANEL_LIST_DELETE, row, NULL);

    /*
     * Delete selected file from FileList
     */
    FileList = DeleteSelectedFile(FileList);
    NumberOfDoc--;

    if(NumberOfDoc == 0)
    {
        xv_set(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, "", NULL);
        xv_set(MaMA_Edit_Panel->File_tf, PANEL_VALUE, "", NULL);
    }

    DocButtonsActive();			/* (De-) activate Document buttons    */

    PrintFileList(FileList);

    if (NumberOfDoc > 0)
    {
        /*
         * Mark a entry as selected
         */
       if (row == NumberOfDoc)
       {
           xv_set(MaMA_Edit_Panel->Doc_List, PANEL_LIST_SELECT, row - 1 , 
               TRUE, NULL);
           (void )SelectFile(FileList, row - 1);
       } else {
           xv_set(MaMA_Edit_Panel->Doc_List, PANEL_LIST_SELECT, row, TRUE,NULL);
           (void )SelectFile(FileList, row);
        }
    } else {	
        xv_set(MaMA_Edit_Panel->doc_drop_target, PANEL_DROP_FULL, FALSE, NULL);
    }

    (void )DisplayFileInfo(FileList, row, True);
        
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Link_Name_tf'.
 */
Panel_setting
link_name_tf_proc(Panel_item item, Event *event)
{
    char *value = (char *) xv_get(item, PANEL_VALUE);

    Print("->link_name_tf_proc\n");
    
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    return panel_text_notify(item, event);
}

/*
 * Notify callback function for `Stop_Button2'.
 */
void
stop_button2_proc(Panel_item item, Event *event)
{
    Print("->stop_button2_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    if (EditPlaying) return;

    CancelTimers();
 
    if (ActionPlaying)
    {
        CancelButtonGlowTimer();
        CancelButtonGlow();
    }   
 
    ActionPlayPaused = FALSE;
    ActionPlaying = FALSE;
    ActionListPerformPtr = NIL(ACTIONLIST *);
    RepeatValue = 0;
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Play_Button2'.
 */
void
play_button2_proc(Panel_item item, Event *event)
{
    int min;
    int sec;
    int Duration;
    char EndTime[6];

    Print("->play_button2_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    if(EditPlaying || (ActionPlaying && !ActionPlayPaused)) return;

    /*
     * Resume if previewing is paused
     */
    if (ActionPlayPaused)
    {
        ActionPlayPaused = FALSE;
        SetTimer(endTime);
        xv_set(MaMA_Edit_Panel->Pause_Button2, PANEL_ITEM_COLOR,
        BlackColorIndex, NULL);
        return;
    }

    ActionListPerformPtr = CurAction;

    InitTimer();

    if ((ActionListPerformPtr->Action->ActionType == GotoNP)
     || (ActionListPerformPtr->Action->ActionType == GotoPP)) 
    {
        RepeatValue = ActionListPerformPtr->Action->Param->Times;
        Duration = ((CurAction->Duration) * (RepeatValue));

    } else Duration = CurAction->Duration;

    min = ((Duration) / 60);
    sec = ((Duration) % 60);

    sprintf(EndTime, "%d:%d", min, sec);
    if (sec < 10) sprintf(EndTime, "%d:0%d", min, sec);
    if (min < 10) sprintf(EndTime, "0%d:%d", min, sec);
    if ((min < 10)  && (sec < 10)) sprintf(EndTime, "0%d:0%d", min, sec);
    xv_set(MaMA_Edit_Panel->End_message2, PANEL_LABEL_STRING, EndTime, NULL);

    PerformAction(ActionListPerformPtr);
    ActionTime = (double)ActionListPerformPtr->Duration;

    ActionPlaying = True;
    SetButtonGlowTimer(0.5);
    SetTimer((double)Duration);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Pause_Button2'.
 */
void
pause_button2_proc(Panel_item item, Event *event)
{
    Print("->pause_button2_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    if(EditPlaying) return;
    
    if (ActionPlaying)
    {
        if (ActionPlayPaused)
        {
            ActionPlayPaused = FALSE;
            SetTimer(endTime);
            xv_set(MaMA_Edit_Panel->Pause_Button2, PANEL_ITEM_COLOR,
            BlackColorIndex, NULL);
        } else {   
      	    ActionPlayPaused = TRUE;
      	    CancelTimers();
      	    xv_set(MaMA_Edit_Panel->Pause_Button2, PANEL_ITEM_COLOR,
            OrangeColorIndex, NULL);
      	    xv_set(MaMA_Edit_Panel->Play_Button2, PANEL_ITEM_COLOR,
            GreenColorIndex, NULL);
        }
    }  
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Add_Action_Button'.
 */
void
add_action_proc(Panel_item item, Event *event)
{
    char *ListString;
    Xv_notice notice;
    int notice_stat;
    int entry;
    ACTIONLIST *ActionListPtr;
    
    Print("->add_action_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    /* 
         * Check if the Action is properly defined                       
     */
    if (!ActionOk())
    {
    	xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    	xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return;
    }

    /*
     * Create A New Action Structure At The End Of The List 
     */
    CurAction = GetNewAction(ActionList);
    if (ActionList == NIL(ACTIONLIST *))
    {
        ActionList = CurAction;
    }
    
    /*
     * Fill the New Action Structure and Build ListString
     */	
    FillAction();
    ListString = BuildActionString();

    xv_set(MaMA_Edit_Panel->Action_List,
        PANEL_LIST_INSERT,NumberOfActions,
        PANEL_LIST_STRING,NumberOfActions, ListString,
        PANEL_LIST_FONT, NumberOfActions, listFont, NULL);

    /*
     * Mark entry as selected
     */
    xv_set(MaMA_Edit_Panel->Action_List,
        PANEL_LIST_SELECT, NumberOfActions, TRUE, NULL);

    entry = 0;
    ActionListPtr = ActionList;

    /*
     * Select the Action, deselect the rest
     * We don't use SelectAction() cause it does to much work
     * on the GUI                                            
     */ 
    while(ActionListPtr != NIL(ACTIONLIST *))
    {
        ActionListPtr->Selected = False;
 
        if (entry == NumberOfActions)
        {
            ActionListPtr->Selected = True;
            CurAction = ActionListPtr;
        }
        entry++;
        ActionListPtr = ActionListPtr->next;
    }

    NumberOfActions++;

    ActionButtonsActive();		/* (De-) activate action buttons      */

    PrintActionList(ActionList);
    
    ActionListChanged = True;
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, 
        dgettext("MaMA_labels", "Action List Modified"), NULL);

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Change_Action_Button'.
 */
void
change_action_proc(Panel_item item, Event *event)
{
    char *ListString;
    int SelectedRow;

    Print("->change_action_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    /* 
     * Check if the Action is properly defined                       
     */
    if (!ActionOk())
    {
    	xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    	xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return;
    }

    /*
     * Fill the Sel. Action Structure and Build A New ListString
     */	
    FillAction();
    ListString = BuildActionString();

    /*
     * Find which row is selected
     */
    SelectedRow = (int)xv_get(MaMA_Edit_Panel->Action_List, 
        PANEL_LIST_FIRST_SELECTED); 

    xv_set(MaMA_Edit_Panel->Action_List,
        PANEL_LIST_STRING, SelectedRow, ListString,
        PANEL_LIST_FONT, SelectedRow, listFont,NULL);

    PrintActionList(ActionList);

    ActionListChanged = True;
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, 
        dgettext("MaMA_labels", "Action List Modified"), NULL);
    
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Notify callback function for `View_Doc_Button'.
 */
void
view_target_doc_proc(Panel_item item, Event *event)
{
    char DocName[MAXPATHLEN];
    char *mama_home;

    Print("->viewTarget_doc_proc\n");

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER, "", NULL);

    /*
     * Build DocName
     */
    strcpy(DocName, (char *)xv_get(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, NULL));
    if (strcmp("$MaMAHOME/Demo", DocName) == 0)
    {
	if ((mama_home = getenv( "MaMAHOME" )) != NULL) 
        { 
        	strcpy(DocName, getenv( "MaMAHOME" ));
        	strcat(DocName, "/Demo/");
        } else {        
                    fprintf(stderr,"MaMA ERROR: $MaMAHOME undefined!\n");
		    exit(1);
	}
    } else {

        strcat(DocName, "/");
    }

    strcat(DocName, (char *)xv_get(MaMA_Edit_Panel->File_tf, PANEL_VALUE,NULL));

    /*
     * Open the FrameMaker document
     */
    OpenDocProc(DocName);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Callback routines for the 'load Edit List' 
 *			     'Select Frame Doc' and
 *			     'Save Edit List' File Choosers
 */

/******************************************************************************\
*                                                                              *
*        Name : load_proc                                                      *
*                                                                              *
* Description : Function for loading an EditList in the application            *
*                                                                              *
\******************************************************************************/
int load_proc(gfm_popup_objects *ip, char *dir, char *file)
{
    EDITLIST *EditListPtr;
    ACTIONLIST *ActionListPtr;
    char FullFileName[PATHLEN + FILELEN];
    char SaveString[300];

    Print("->load_proc\n");

    if (ActionListChanged || EditListChanged)
    {
        strcpy(SaveString, EditListInfo->FullFileName);
        strcat(SaveString, "?");

        result = notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Warning:"),
            dgettext("MaMA_labels", "You have unsaved changes!"),
            dgettext("MaMA_labels", "Shall I save the Edit List in:"),
            SaveString,
            NULL,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Save"), 100,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Ignore changes"), 101,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 102,
            NULL);

        if (result == 100) 
        {
            if (! WriteEditList2File(EditList))
	    {
	        return;
	    }
            ResetMenu();
        } 
        if (result == 102) 
        {
            return;
        }
    }

    if (strcmp(dir,"/")==0)
    {
        sprintf(FullFileName, "/%s", file);
    } else {
        sprintf(FullFileName, "%s/%s", dir, file);
    }

    /*
     * Read in file
     */
    if (CheckFileType(FullFileName, MaMA_EDIT_MAGIC))
    {
        LoadEditList(FullFileName);

        strcpy(EditListDragLabel, file);

        strcpy(EditListInfo->FullFileName, FullFileName);
        SetHeader(FullFileName);

        /*
         * Reset changed bools
         */
        ActionListChanged = False;
        EditListChanged = False;
        xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, "", NULL);
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

        EditButtonsActive();			/* (De)acivate edit buttons   */
    }

    return(False);
}

/******************************************************************************\
*                                                                              *
*        Name : select_proc                                                    *
*                                                                              *
* Description : Function for inserting a target document in the list           *
*                                                                              *
\******************************************************************************/
int select_proc(gfm_popup_objects *ip, char *dir, char *file)
{
    char    file_name[MAXPATHLEN];

    Print("->select_proc\n");

    dir = RemoveAutoMntDir(dir);

    /*
     * A 'CE-check' if "file_name" is a FrameMaker document
     */
    if (strcmp(dir,"/")==0)
    {
        sprintf(file_name, "/%s", file);
    }  else {
        sprintf(file_name, "%s/%s", dir, file);
    }

    if(!CheckFileType(file_name, FRAME_MAGIC))
    {
        return;
    }

    AddFileInList(dir, file);
    
    return(False);
}
 
/******************************************************************************\
*                                                                              *
*        Name : saveas_proc                                                    *
*                                                                              *
* Description : Function for saving an EditList                                *
*                                                                              *
\******************************************************************************/
int saveas_proc(gfm_popup_objects *ip, char *dir, char *file)
{
    char FullFileName[MAXPATHLEN];
    int response;
    int file_response;

    Print("->saveas_proc\n");

    if (strcmp(dir,"/")==0)
    {
        strcpy(FullFileName,dir);
        strcat(FullFileName,file);
    } else {
        strcpy(FullFileName, dir);
        strcat(FullFileName, "/");
        strcat(FullFileName, file);
    }

    /*
     * Check if file exists
     */
    file_response = stat(FullFileName, fileInfo);

    if (file_response == 0)
    {
        response = notice_prompt(MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "This file already exists!"),
            dgettext("MaMA_labels", "Overwrite ?"),
            NULL,
            NOTICE_BUTTON_YES, dgettext("MaMA_labels", "Yes"),
            NOTICE_BUTTON_NO, dgettext("MaMA_labels", "No"),
            NULL);
        if (response == NOTICE_NO)
        {
            return(False);
        }	
    }

    SetHeader(FullFileName);

    strcpy(EditListDragLabel, file);
    strcpy(EditListInfo->FullFileName, FullFileName);

    if (WriteEditList2File(EditList))
    {
        ResetMenu();
        EditListChanged = False;
        xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, "", NULL);
        return(False);
    }
    return(True);
}

/******************************************************************************\
*                                                                              *
*        Name : MaMA_init                                                      *
*                                                                              *
* Description : Initializes the list with Complete file names used in Doc_List *
*               Initializes the list with Actions                              *
*               Initializes the list with Edits                                *
*                                                                              *
\******************************************************************************/

void
MaMA_init()
{
    Print("->MaMA_init\n");

    FileList = NIL(FILELIST *);
    NumberOfDoc = 0;

    ActionList = NIL(ACTIONLIST *);
    CurAction = NIL(ACTIONLIST *);
    NumberOfActions = 0;

    EditListInfo = (EDITLISTINFO *)malloc((unsigned)sizeof(EDITLISTINFO));
    strcpy(EditListInfo->FullFileName, "\0");
    EditListInfo->EditList = NIL(EDITLIST *);

    AutoMntList = NIL(AUTOMNTLIST *);
    CurAutoMnt = NIL(AUTOMNTLIST *);

    EditList = NIL(EDITLIST *);
    CurEdit = NIL(EDITLIST *);
    NumberOfEdits = 0;
    ChangeEditMode = False;

    propName = (char *) malloc((unsigned)((20) * sizeof(char)));
    strcpy(propName, "");

    RepeatOn = False;
    CurRow = 0;

    fileInfo = (struct stat *)malloc((unsigned)sizeof(struct stat));
}

/*
 * Notify callback function for `Action_List'.
 */
int
action_list_proc(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
    Print("->action_list_proc\n");

    switch(op) 
    {
        case PANEL_LIST_OP_DESELECT:
            MoveButtonsActive();		/* (de-)activate move buttons */
            break;

        case PANEL_LIST_OP_SELECT:
            /*  
             * Set CurrentlySelected field in ActionList
             */
            (void )SelectAction(ActionList, row);

            MoveButtonsActive();		/* (de-)activate move buttons */
            break;

        case PANEL_LIST_OP_VALIDATE:
            break;

        case PANEL_LIST_OP_DELETE:
            break;
    }
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    return XV_OK;
}


/*
 * Notify callback function for `Edit_List'.
 */
int
edit_list_proc(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
    Print("->edit_list_proc\n");

    switch(op) 
    {
        case PANEL_LIST_OP_DESELECT:
            MoveEditButtonsActive();		/* (de-)activate move buttons */

            break;

        case PANEL_LIST_OP_SELECT:

            /*  
             * Set CurrentlySelected field in EditList
             */

            if (doubleclick(event))
            {
                OldRow = CurRow;
                if ((ActionListChanged) && (!(Notice_Handler())))
                {
                    xv_set(MaMA_Main_Window->Edit_List,
                        PANEL_LIST_SELECT, OldRow, TRUE, NULL);
                    (void )SelectEdit(EditList, OldRow);
                    return(False); 
                }

                (void )SelectEdit(EditList, row);
                FillPopup();


            } else {

                OldRow = CurRow;
                (void )PrintEditList(EditList);                                  
                if ((ActionListChanged) && (!(Notice_Handler())))
                {
                    /* Cancel the selection, restore. */
                    xv_set(MaMA_Main_Window->Edit_List,
                        PANEL_LIST_SELECT, OldRow, TRUE, NULL);
                    (void )SelectEdit(EditList, OldRow);
                    return(False); 
                }

                (void )SelectEdit(EditList, row);

                if((int)xv_get(MaMA_Edit_Panel->Edit_Panel, XV_SHOW))
                {
                    FillPopup();
                }
            }

            MoveEditButtonsActive();		/* (de-)activate move buttons */
 
            break;

        case PANEL_LIST_OP_VALIDATE:
            break;

        case PANEL_LIST_OP_DELETE:
            break;
    }
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    return XV_OK;
}


/******************************************************************************\
*                                                                              *
*        Name : done_proc                                                      *
*                                                                              *
* Description : This function is called when the user pulls out the PushPin    *
*               or dismisses the popup window                                  *
*                                                                              *
\******************************************************************************/
void
done_proc()
{
    Print("->done_proc\n");

    if ((ActionListChanged) && (!(Notice_Handler())))
    {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
        return;
    } 

    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_SHOW, FALSE, NULL);
    ActionListChanged = False;
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

}

/*
 * Event callback function for `Link_Button'.
 */
void
MaMA_Edit_Panel_Link_Button_event_callback(Panel_item item, Event *event)
{
    /* gxv_start_connections DO NOT EDIT THIS SECTION */
    /* gxv_end_connections */

    panel_default_handle_event(item, event);
}

/*
 * User-defined action for `Link_Button'.
 */
void
link_menu_proc(Panel_item item, Event *event)
{
    Print("->link_menu_proc\n");
}

/*
 * Notify callback function for `Update_Button'.
 */
void
update_button_proc(Panel_item item, Event *event)
{
    char DocName[100];
    char *mama_home;

    Print("->update_button_proc\n");

    /*
     * Build DocName
     */
    strcpy(DocName, (char *)xv_get(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, NULL));
    if (strcmp("$MaMAHOME/Demo", DocName) == 0) 
    { 
	if ((mama_home = getenv( "MaMAHOME" )) != NULL) 
        { 
        	strcpy(DocName, getenv( "MaMAHOME" ));
        	strcat(DocName, "/Demo/");
        } else {        
                    fprintf(stderr,"MaMA ERROR: $MaMAHOME undefined!\n");
		    exit(1);
	}
    } else {
 
        strcat(DocName, "/");
    }
    strcat(DocName, (char *)xv_get(MaMA_Edit_Panel->File_tf, PANEL_VALUE,NULL));

    /*
     * Build the list of Hyperlinks occurring in this doc
     */
    if (OpenDocProc(DocName) != -1)
    {
        saveMarkers(DocHandler, "/tmp/.markers");
        CloseFMDoc(DocHandler);

        BuildLinkList();
    }
    
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/*
 * Notify callback function for `Link_Settings'.
 */
void
link_setting_proc(Panel_item item, int	 value, Event *event)
{
    Print("->link_setting_proc\n");

    xv_set(MaMA_Edit_Panel->Link_Name_tf, PANEL_VALUE, 
        (char *)xv_get(MaMA_Edit_Panel->Link_Settings,
        PANEL_CHOICE_STRING, value, NULL),
        NULL);
    
    xv_set(MaMA_Edit_Panel->Update_Button, XV_SHOW, TRUE, NULL);

    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}

/******************************************************************************\
*                                                                              *
*        Name : DestroyBaseWindow                                              *
*                                                                              *
* Description : This function is called when the application is stopped        *
*                                                                              *
\******************************************************************************/
Notify_value
DestroyBaseWindow(Notify_client client, Destroy_status status)
{
    char SaveString[300];

    Print("->DestroyBaseWindow\n");

    if (status == DESTROY_CHECKING)
    {
        if ((EditListChanged) || (ActionListChanged))
        {
            strcpy(SaveString, EditListInfo->FullFileName);
            strcat(SaveString, "?");

            result = notice_prompt(MaMA_Edit_Panel->Edit_Panel, NULL,
                NOTICE_MESSAGE_STRINGS,
                dgettext("MaMA_labels", "Warning:"),
                dgettext("MaMA_labels", "You have unsaved changes!"),
                dgettext("MaMA_labels", "Shall I save the Edit List in:"),
                SaveString,
                NULL,
                NOTICE_BUTTON, dgettext("MaMA_labels", "Save"), 100,
                NOTICE_BUTTON, dgettext("MaMA_labels", "Ignore changes"), 101,
                NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 102,
                NULL);

            if (result == 100) 
            {
    		if (! WriteEditList2File(EditList))
    		{
                    notify_veto_destroy(client);
    		    return NOTIFY_DONE;
		}
#ifndef SaM
                DestroyReceiver(sender, receiver);
#endif
                xv_destroy_safe(MaMA_Main_Window->Main_Window);
                exit(0);
            } 
            if (result == 101) 
            {
#ifndef SaM
                DestroyReceiver(sender, receiver);
#endif
                xv_destroy_safe(MaMA_Main_Window->Main_Window);
                exit(0);
            } 
            if (result == 102) 
            {
                notify_veto_destroy(client);
            }
        }
    } else {
        if (status == DESTROY_CLEANUP)
        {
#ifndef SaM
            DestroyReceiver(sender, receiver);
#endif
            xv_destroy_safe(MaMA_Main_Window->Main_Window);
            exit(0);

            return notify_next_destroy_func(client, status);
        } 
    } 
    return NOTIFY_DONE;
}

/*
 * Notify callback function for `OK_Button'.
 */
void
MaMA_About_Panel_OK_Button_notify_callback(Panel_item item, Event *event)
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(MaMA_About_Panel->About_Panel, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
	xv_set(MaMA_About_Panel->About_Panel, XV_SHOW, FALSE, NULL);
	
	/* gxv_end_connections */

}

/******************************************************************************\
*                                                                              *
*        Name : OpenDocProc                                                    *
*                                                                              *
* Description : Tries to open a FrameMaker document, and returns a doc. handle *
*                                                                              *
\******************************************************************************/
int OpenDocProc(char *DocName)
{
    Print("->OpenDocProc\n");

    /*
     * OpenFMDoc could take a while so:
     */
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);

    if((DocHandler = OpenFMDoc(DocName)) == -1)
    {
        /*
         * Check if file exists
         */
        if (stat(DocName, fileInfo) == 0)
        {
            /*
             * File exists => proper frame version is not running
             */
            sprintf(Command, "Is %s running?\nYou can:", FrameVersion);

            result = notice_prompt (MaMA_Main_Window->Main_Window, NULL,
       	        NOTICE_MESSAGE_STRINGS,    
                Command,
                NULL,
                NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 100,
                NOTICE_BUTTON, dgettext("MaMA_labels", "Start FrameMaker"), 101,
                NULL);
            if (result == 101)
            {
                /*
                 * Start FrameMaker
                 */
                system(FramePath);
            }
        } else {
            /*
             * File does not exist
             */
            result = notice_prompt (MaMA_Main_Window->Main_Window, NULL,
       	        NOTICE_MESSAGE_STRINGS,    
                dgettext("MaMA_labels", "Unable to open FrameMaker document!"),
                NULL,
                NOTICE_BUTTON, "OK", 100,
                NULL);
        }

    }
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
    return(DocHandler);
}

/******************************************************************************\
*                                                                              *
*        Name : PM_Connect                                                     *
*                                                                              *
* Description : Try to connect with the PortManager                            *
*                                                                              *
\******************************************************************************/
void
PM_Connect()
{
#ifndef SaM
    int pid;

    Print("->PM_Connect\n");

    /*
     * Port Manager connection
     */
    senderPort.hostName = "localhost";
    senderPort.appName = "MaMA";
    strcpy(startFilename, "");
    senderPort.portNumber = PortMgrPortNumber;

    sender = NIL(Sender *);

    sender = NewSender(&senderPort);
    if (sender == NIL(Sender *))
    {
        result = notice_prompt (MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,    
            dgettext("MaMA_labels", "Port Manager is not running!"),
            dgettext("MaMA_labels", "You can:"),
            NULL,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Start Port Manager"), 100,
            NOTICE_BUTTON, dgettext("MaMA_labels", "Quit MaMA"), 101,
            NULL);

        /*
         * resolve answer
         */
        switch (result)
        {
            case  100:
                fork_PM();
                break;

            case  101:
                exit(0);
                break;
        }
    }

    receiver = NewReceiver(sender, "MaMA", ReceiverPortNumber);
    xv_set(MaMA_PM_Panel->PM_Cur_Connection_tf, PANEL_VALUE, 
        senderPort.hostName, NULL);
    xv_set(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, "", NULL);

#endif
    return;
}

/******************************************************************************\
*                                                                              *
*        Name : fork_PM                                                        *
*                                                                              *
* Description : Forks another process for starting the PortManager             *
*                                                                              *
\******************************************************************************/
void
fork_PM()
{
#ifndef SaM
    int pid;

    Print("->fork_PM\n");

    /*
     * start Port Manager for user
     */
    pid = fork();
    switch(pid)
    {
        case -1:			/* ERROR                              */
            break;
        case 0:				/* CHILD                              */
            execlp("PortManager", "PortManager", NIL(char*));
            break;
        default:			/* PARENT                             */

            sender = NIL(Sender *);

            /*
             * Allow CHILD time to get initialized !!!!
             */
            sleep(7);

            sender = NewSender(&senderPort);
            if (sender == NIL(Sender *))
            {
                notice_prompt (MaMA_Main_Window->Main_Window, NULL,
                    NOTICE_MESSAGE_STRINGS,    
                    dgettext("MaMA_labels", "Cannot find the Port Manager!"),
                    NULL,
                    NOTICE_BUTTON, dgettext("MaMA_labels", "Quit MaMA"), 100,
                    NULL);
                exit(1);
            }
            break;
    }
#endif
}

/******************************************************************************\
*                                                                              *
*        Name : Hardset_positions                                              *
*                                                                              *
* Description : Positions some GUI-objects the hard way...                     *
*                                                                              *
\******************************************************************************/
void
Hardset_positions()
{
    Print("->Hardset_positions\n");

    /*
     * The lines that follow now seem ridiculous
     * because size and position are defined using Devguide-3.0.
     * But if we leave them away... 
     * Try it, you will see!
     */
    xv_set(MaMA_About_Panel->About_Panel,
        XV_WIDTH, 442,
        XV_HEIGHT, 184, NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel,
        XV_WIDTH, 515,
        XV_HEIGHT, 524, NULL);
    xv_set(MaMA_Edit_Panel->Label_Control,
        XV_X, 0,
        XV_Y, 0,
        XV_WIDTH, 516,
        XV_HEIGHT, 202, NULL);
    xv_set(MaMA_Edit_Panel->Action_Preview_Control,
        XV_X, 0,
        XV_Y, 368,
        XV_WIDTH, 238,
        XV_HEIGHT, 78, NULL);
    xv_set(MaMA_Edit_Panel->Duration_Control,
        XV_X, 0,
        XV_Y, 296,
        XV_WIDTH, 238,
        XV_HEIGHT, 72, NULL);
    xv_set(MaMA_Edit_Panel->Action_Control,
        XV_X, 0,
        /*XV_Y, 202,*/
        XV_Y, 204,
        XV_WIDTH, 238,
        XV_HEIGHT, 33, NULL);
    xv_set(MaMA_Edit_Panel->Empty_Layer,
        XV_X, 0,
        XV_Y, 237,
        XV_WIDTH, 238,
        XV_HEIGHT, 59, NULL);
    xv_set(MaMA_Edit_Panel->Link_Layer,
        XV_X, 0,
        XV_Y, 237,
        XV_WIDTH, 238,
        XV_HEIGHT, 59, NULL);
    xv_set(MaMA_Edit_Panel->Zoom_Layer,
        XV_X, 0,
        XV_Y, 237,
        XV_WIDTH, 238,
        XV_HEIGHT, 59, NULL);
    xv_set(MaMA_Edit_Panel->Rep_Layer,
        XV_X, 0,
        XV_Y, 237,
        XV_WIDTH, 238,
        XV_HEIGHT, 59, NULL);
    xv_set(MaMA_Edit_Panel->Doc_Control,
        XV_X, 238,
        XV_Y, 204,
        XV_WIDTH, 280,
        XV_HEIGHT, 242, NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : XView_init                                                     *
*                                                                              *
* Description : Handles all kinds of inits                                     *
*                                                                              *
\******************************************************************************/
void
XView_init()
{
    char Label[50];
    Menu prop_menu;

    Print("->XView_init\n");

    INSTANCE = xv_unique_key();

    /*
     * Initialize user interface components.
     * Do NOT edit the object initializations by hand.
    MaMA_Main_Window = MaMA_Main_Window_objects_initialize(NULL, NULL);
    MaMA_About_Panel = MaMA_About_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    MaMA_Edit_Panel = MaMA_Edit_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    MaMA_PM_Panel = MaMA_PM_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
    MaMA_Pref_Panel = MaMA_Pref_Panel_objects_initialize(NULL, MaMA_Main_Window->Main_Window);
     */
    
    (void ) notify_enable_rpc_svc(True);

    /*
     * init proper icon
     */
    Icon_init();

    /*
     * Set Notify procedure for Popup when the pushpin is pulled out &
     * other inits
     */
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_DONE_PROC, done_proc, NULL);
    xv_set(MaMA_Edit_Panel->Link_Settings, PANEL_DISPLAY_LEVEL, PANEL_NONE,
        NULL); 
    xv_set(MaMA_Edit_Panel->Doc_List, PANEL_CHOOSE_NONE, FALSE, NULL);
    xv_set(MaMA_Edit_Panel->Action_List, PANEL_CHOOSE_NONE, FALSE, NULL);
    xv_set(MaMA_Main_Window->Edit_List, PANEL_CHOOSE_NONE, FALSE, NULL);

#ifdef MaMA
    xv_set(MaMA_Main_Window->Main_Window, FRAME_LABEL, "MaMA - NoName", NULL);
#endif MaMA
#ifdef SaM 
    xv_set(MaMA_Main_Window->Main_Window, FRAME_LABEL, "SaM - NoName", NULL);

    prop_menu = (Menu)xv_get(MaMA_Main_Window->Props_Button,
        PANEL_ITEM_MENU);
    xv_set(xv_get(prop_menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, True, NULL);
#endif SaM


    Hardset_positions();

    notify_interpose_destroy_func(MaMA_Main_Window->Main_Window,
        DestroyBaseWindow);

    /*
     * Allow footer in MaMA_Edit_Panel
     */
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_SHOW_FOOTER, TRUE, NULL);

    /*
     * Initialize the Drag Drop package.
     */
    gdd_init_dragdrop(MaMA_Main_Window->Main_Window);
    gdd_register_drop_target(MaMA_Main_Window->edit_drop_target, 
        edit_list_drop_proc, edit_list_drag_proc);
    gdd_register_drop_target(MaMA_Edit_Panel->doc_drop_target, 
        doc_drop_proc, doc_drag_proc);
            
    
    /*
     * Initialize the GFM package
     */
    Load = gfm_initialize(NULL, MaMA_Main_Window->Main_Window,
        dgettext("MaMA_labels", "MaMA: Load Edit List"));
    Saveas = gfm_initialize(NULL, MaMA_Main_Window->Main_Window,
        dgettext("MaMA_labels", "MaMA: Save the Edit List"));
    Select = gfm_initialize(NULL, MaMA_Edit_Panel->Edit_Panel,
        dgettext("MaMA_labels", "MaMA: Select Frame Document"));
    gfm_set_action (Select, dgettext("MaMA_labels", "Add To List"));
    gfm_set_action (Load, dgettext("MaMA_labels", "Load"));
    gfm_set_action (Saveas, dgettext("MaMA_labels", "Save"));

}

/*
 * Menu handler for `Props_Menu (Port Manager...)'.
 */
Menu_item
MaMA_Props_Menu_item0_callback(Menu_item item, Menu_generate op)
{
    switch (op) {
    case MENU_DISPLAY:
        break;

    case MENU_DISPLAY_DONE:
        break;

    case MENU_NOTIFY:
#ifndef SaM
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(MaMA_PM_Panel->PM_Panel, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */
#endif

        break;

    case MENU_NOTIFY_DONE:
        break;
    }
    return item;
}

/*
 * Notify callback function for `PM_Connect_Button'.
 */
void
PM_Connect_proc(Panel_item item, Event *event)
{
#ifndef SaM
    char buffer[FILELEN];
    char OldHostname[FILELEN];
    
    Print("->PM_Connect_proc\n");

    strcpy(buffer, (char *)xv_get(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, 
        NULL));

    if (0 != strcmp(buffer, ""))
    {
        strcpy(OldHostname, senderPort.hostName);/* Save old hostname         */
        strcpy(senderPort.hostName, buffer);	/* copy new hostname          */
        DestroyReceiver(sender, receiver);	/* destroy current connection */

        /*
         * Port Manager connection
         */
        sender = NIL(Sender *);
        sender = NewSender(&senderPort);
        if (sender == NIL(Sender *))
        {
            /*
             * Restore connection with old Port Manager
             */
            strcpy(senderPort.hostName, OldHostname);
            sender = NewSender(&senderPort);

            notice_prompt (MaMA_Main_Window->Main_Window, NULL,
                NOTICE_MESSAGE_STRINGS,    
                dgettext("MaMA_labels", "No Port Manager running on:"),
                (char *)xv_get(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, NULL),
                NULL,
                NOTICE_BUTTON, 
                dgettext("MaMA_labels", "Restore old connection"), 100,
                NULL);
        }

        receiver = NewReceiver(sender, "MaMA", ReceiverPortNumber);
        xv_set(MaMA_PM_Panel->PM_Cur_Connection_tf, PANEL_VALUE, 
            senderPort.hostName, NULL);
        xv_set(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, "", NULL);
    }
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
#endif
}

/*
 * Notify callback function for `PM_Set_Default_Button'.
 */
void
PM_Set_Default_proc(Panel_item item, Event *event)
{
#ifndef SaM
    char OldHostname[FILELEN];

    Print("->PM_Set_Default_proc\n");

    DestroyReceiver(sender, receiver);		/* destroy current connection */

    strcpy(OldHostname, senderPort.hostName);
    strcpy(senderPort.hostName, "localhost");
    xv_set(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, "localhost", NULL);

    /*
     * Port Manager connection
     */
    sender = NIL(Sender *);
    sender = NewSender(&senderPort);
    if (sender == NIL(Sender *))
    {
        /*
         * Restore connection with old Port Manager
         */
        strcpy(senderPort.hostName, OldHostname);
        sender = NewSender(&senderPort);

        notice_prompt (MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,    
            dgettext("MaMA_labels", "No Port Manager running on:"),
            (char *)xv_get(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, NULL),
            NULL,
            NOTICE_BUTTON, 
            dgettext("MaMA_labels", "Restore old connection"), 100,
            NULL);
    }

    receiver = NewReceiver(sender, "MaMA", ReceiverPortNumber);
    xv_set(MaMA_PM_Panel->PM_Cur_Connection_tf, PANEL_VALUE, 
        senderPort.hostName, NULL);
    xv_set(MaMA_PM_Panel->PM_Connect_tf, PANEL_VALUE, "", NULL);
    
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
#endif
}


/******************************************************************************\
*                                                                              *
*        Name : Icon_init                                                      *
*                                                                              *
* Description : Handles icon init. stuff                                       *
*                                                                              *
\******************************************************************************/
void
Icon_init()
{
    Xv_opaque Main_Window_image;
    Xv_opaque Main_Window_image_mask;

    Print("->Icon_init\n");

    Main_Window_image = xv_create(XV_NULL, SERVER_IMAGE,
        SERVER_IMAGE_DEPTH, 1,
        SERVER_IMAGE_BITS, icon_bits,
        XV_WIDTH, 64,   
        XV_HEIGHT, 64,
        NULL);

    Main_Window_image_mask = xv_create(XV_NULL, SERVER_IMAGE,
        SERVER_IMAGE_DEPTH, 1,
        SERVER_IMAGE_BITS, icon_mask_bits,
        XV_WIDTH, 64,   
        XV_HEIGHT, 64,
        NULL);
    
    xv_set(MaMA_Main_Window->Main_Window, 
        FRAME_ICON, 
        xv_create(XV_NULL, ICON,
            ICON_IMAGE, Main_Window_image,
            ICON_MASK_IMAGE, Main_Window_image_mask,
            NULL),
        NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : Notice_Handler                                                 *
*                                                                              *
* Description : Handles a frequently used notice                               *
*                                                                              *
\******************************************************************************/
int
Notice_Handler()
{
    int result;
    int Row;

    Print("->Notice_Handler\n");

    if (NumberOfEdits == 0)
    {

        /* 
         * No Edits, so no "Apply changes" option 
         */
        result = notice_prompt(MaMA_Edit_Panel->Edit_Panel, NULL,
             NOTICE_MESSAGE_STRINGS,
             dgettext("MaMA_labels",
             "Warning: The ActionList has been changed! You can:"),
             NULL,
             NOTICE_BUTTON, dgettext("MaMA_labels", "Insert Edit"), 101, 
             NOTICE_BUTTON, dgettext("MaMA_labels", "Ignore changes"), 102,
             NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 103,
             NULL);
    } else {
        result = notice_prompt(MaMA_Edit_Panel->Edit_Panel, NULL,
             NOTICE_MESSAGE_STRINGS,
             dgettext("MaMA_labels",
             "Warning: The ActionList has been changed! You can:"),
             NULL,
             NOTICE_BUTTON, dgettext("MaMA_labels", "Apply changes"), 100,
             NOTICE_BUTTON, dgettext("MaMA_labels", "Insert Edit"), 101, 
             NOTICE_BUTTON, dgettext("MaMA_labels", "Ignore changes"), 102,
             NOTICE_BUTTON, dgettext("MaMA_labels", "Cancel"), 103,
             NULL);
    }

    if (result == 100)
    {
        /*
         * Check for a label name
         */
        if (CheckLabelName())
        {
            return(False);
        }
   
        /*
         * Check for a unique label name
         */
        ChangeEditMode = True;
        if (CheckIfUniqueLabel())
        {
            return(False);
        }

        Change_Edit_From_Pop_Proc(MaMA_Main_Window->Edit_List, NIL(Event *));
 	xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);
    }

    if (result == 101)
    {
        /*
         * Check for a label name
         */
        if (CheckLabelName())
        {
            return(False);
        }

        /*
         * Check for a unique label name
         */
        if (CheckIfUniqueLabel())
        {
            return(False);
        }

        Row = (int)xv_get(MaMA_Main_Window->Edit_List,
            PANEL_LIST_FIRST_SELECTED);
        insert_edit_proc(MaMA_Main_Window->Edit_List, NIL(Event *));
        xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_SELECT, Row, TRUE,NULL);
        (void )SelectEdit(EditList, Row);
 	xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);

    }

    if (result == 102)
    {
        ActionListChanged = False;
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_LEFT_FOOTER, "", NULL);
	FILL_POPUP = True;
    }

    if (result == 103)
    {
        return(False);
    }

    return(True);
}

/*
 * Notify callback function for `Change_Edit_Button'.
 */
void
change_edit_proc(Panel_item item, Event *event)
{
    Print("->change_edit_proc\n");

    if ((ActionListChanged) && (!(Notice_Handler())))
    {
        return; 
    }

    if(!((int)xv_get(MaMA_Edit_Panel->Edit_Panel, XV_SHOW)))
    {
        PositionPopup();
    }

    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_SHOW, TRUE, NULL);
    FillPopup();
}

/******************************************************************************\
*                                                                              *
*        Name : SetHeader                                                      *
*                                                                              *
* Description : Sets the proper header in the main window                      *
*                                                                              *
\******************************************************************************/
void
SetHeader(char *FullFileName)
{
    char Header[8 + FILELEN]; 

    Print("->SetHeader\n");

#ifdef MaMA 
    sprintf(Header, "MaMA - %s", RetrieveFileName(FullFileName));
#endif MaMA 

#ifdef SaM
    sprintf(Header, "SaM - %s", RetrieveFileName(FullFileName));
#endif SaM

    xv_set(MaMA_Main_Window->Main_Window, FRAME_LABEL, Header, NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : PositionPopup                                                  *
*                                                                              *
* Description : Positions the popup next to the main window                    *
*                                                                              *
\******************************************************************************/
void
PositionPopup()
{
    int X_Main, Y_Main;
    int X_Edit, Y_Edit;
    int Main_Height, Main_Width;
    int Edit_Height, Edit_Width;
    int Window_Height, Window_Width;

    Print("->PositionPopup\n");

    /*
     * Initial values
     */
    Main_Width = 384;		/* Width of Main Window                       */
    Main_Height = 302;		/* Height of Main Window                      */
    Edit_Width = 523;		/* Width of Edit Window                       */
    Edit_Height = 564;		/* Height of Edit Window                      */
    Window_Width = 1150;	/* Width of screen                            */
    Window_Height = 913;	/* Height of screen                           */

    X_Main = (int)xv_get(MaMA_Main_Window->Main_Window, XV_X);
    Y_Main = (int)xv_get(MaMA_Main_Window->Main_Window, XV_Y);

    /*
     * Initially Popup next to main
     */
    X_Edit = X_Main + Main_Width;
    Y_Edit = Y_Main - 26;

    /*
     * If Edit Window would run of on the right side => place it left of Main
     */
    if (X_Main + Main_Width + Edit_Width > Window_Width)
    {
        X_Edit = X_Main - 10 - Edit_Width;
    }

    /*
     * If no place on left side => place on left side of screen
     */
    if ((X_Main < Edit_Width) && 
        (X_Main + Main_Width + Edit_Width > Window_Width))
    {
        X_Edit = 0;
    }

    /*
     * If Edit Window would run out of bottom => place just above the bottom
     */
    if (Y_Main + Edit_Height > Window_Height)
    {
        Y_Edit = Window_Height - Edit_Height - 26;
    }

    /*
     * Place Window
     */
    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_X, X_Edit, NULL);
    xv_set(MaMA_Edit_Panel->Edit_Panel, XV_Y, Y_Edit, NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : SetMenu                                                        *
*                                                                              *
* Description : Sets "Save" menu-item and changes default menu-item            *
*                                                                              *
\******************************************************************************/
void
SetMenu()
{
    Menu file_menu;
    file_menu = (Menu)xv_get(MaMA_Main_Window->File_Button,
        PANEL_ITEM_MENU);

    xv_set(xv_get(file_menu, MENU_NTH_ITEM, 3), MENU_STRING,
        dgettext("MaMA_labels", "Save (needed)"), NULL);

    if (strcmp(EditListInfo->FullFileName, "NoName") == 0)
    {
        xv_set(file_menu, MENU_DEFAULT_ITEM, xv_get(file_menu,
            MENU_NTH_ITEM, 4), NULL);
    } else {
        xv_set(file_menu, MENU_DEFAULT_ITEM, xv_get(file_menu,
            MENU_NTH_ITEM, 3), NULL);
    }
        
}

/******************************************************************************\
*                                                                              *
*        Name : ResetMenu                                                      *
*                                                                              *
* Description : Resets menu-item and default menu-item                         *
*                                                                              *
\******************************************************************************/
void
ResetMenu()
{
    Menu file_menu;
    file_menu = (Menu)xv_get(MaMA_Main_Window->File_Button,
        PANEL_ITEM_MENU);

    xv_set(xv_get(file_menu, MENU_NTH_ITEM, 3), MENU_STRING,
        dgettext("MaMA_labels", "Save EditList"), NULL);
    xv_set(file_menu, MENU_DEFAULT_ITEM, xv_get(file_menu,
        MENU_NTH_ITEM, 2), NULL);
}

/*
 * Notify callback function for `Edit_Up_Button'.
 */
void
edit_up_button_proc(Panel_item item, Event *event)
{
    int SelectedRow;
    char buf[100];

    Print("->edit_up_button_proc\n");

    EditList = MoveEditUp(EditList);

    SelectedRow = (int)xv_get(MaMA_Main_Window->Edit_List, 
        PANEL_LIST_FIRST_SELECTED);

    if ((SelectedRow != 0) && (SelectedRow != -1))
    {
        strcpy(buf, (char *)xv_get(MaMA_Main_Window->Edit_List,
            PANEL_LIST_STRING, SelectedRow));

        xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_STRING,
            SelectedRow, ((int)xv_get(MaMA_Main_Window->Edit_List,
            PANEL_LIST_STRING, SelectedRow - 1, NULL)), NULL);

        xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_STRING,
            SelectedRow - 1, buf, NULL);

        /* 
         * Mark entry as selected
         */
        xv_set(MaMA_Main_Window->Edit_List,
            PANEL_LIST_SELECT, SelectedRow-1, TRUE, NULL);
        SelectEdit(EditList, SelectedRow - 1);

        EditListChanged = True;
        xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, 
            dgettext("MaMA_labels", "Edit List Modified"), NULL);
    }

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    MoveEditButtonsActive();			/* (de-)activate edit buttons */
}

/*
 * Notify callback function for `Edit_Down_Button'.
 */
void
edit_down_button_proc(Panel_item item, Event *event)
{
    int SelectedRow;
    char buf[100];

    Print("->edit_down_button_proc\n");

    EditList = MoveEditDown(EditList);

    SelectedRow = (int)xv_get(MaMA_Main_Window->Edit_List, 
        PANEL_LIST_FIRST_SELECTED);

    if ((SelectedRow + 1 < NumberOfEdits) && (SelectedRow != -1))
    {
        strcpy(buf, (char *)xv_get(MaMA_Main_Window->Edit_List,
            PANEL_LIST_STRING, SelectedRow, NULL));

        xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_STRING,
      	    SelectedRow, (xv_get(MaMA_Main_Window->Edit_List,
            PANEL_LIST_STRING, SelectedRow + 1, NULL)),NULL);

        xv_set(MaMA_Main_Window->Edit_List, PANEL_LIST_STRING,
            SelectedRow + 1, buf, NULL);

        /* 
         * Mark entry as selected
         */
        xv_set(MaMA_Main_Window->Edit_List,
            PANEL_LIST_SELECT, SelectedRow + 1, TRUE, NULL);
        SelectEdit(EditList, SelectedRow + 1);

        EditListChanged = True;
        xv_set(MaMA_Main_Window->Main_Window, FRAME_RIGHT_FOOTER, 
            dgettext("MaMA_labels", "Edit List Modified"), NULL);
    }
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    MoveEditButtonsActive();			/* (de-)activate edit buttons */
}

/*
 * Menu handler for `Props_Menu (Preferences...)'.
 */
Menu_item
MaMA_Props_Menu_item1_callback(Menu_item item, Menu_generate op)
{
    int i = 0;
    int rows = 0;
    AUTOMNTLIST *AutoMntListPtr;

    switch (op) {
        case MENU_DISPLAY:
            break;

        case MENU_DISPLAY_DONE:
            break;

        case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(MaMA_Pref_Panel->Pref_Panel, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(MaMA_Pref_Panel->Pref_Panel, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

            AutoMntListPtr = AutoMntList;
            while (AutoMntListPtr != NIL(AUTOMNTLIST *))
            {
                rows++;
                AutoMntListPtr = AutoMntListPtr->next;
            }

            xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_DELETE_ROWS,
                0, rows, NULL);

            AutoMntListPtr = AutoMntList;
            while (AutoMntListPtr != NIL(AUTOMNTLIST *))
            {
                xv_set(MaMA_Pref_Panel->AutoMnt_List, 
                    PANEL_LIST_INSERT, i,
                    PANEL_LIST_STRING, i++, AutoMntListPtr->Dir, NULL);
                AutoMntListPtr = AutoMntListPtr->next;
            }
            xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_SELECT, 0 , 
                TRUE, NULL);
            SelectAutoMnt(AutoMntList, 0);

            break;

	case MENU_NOTIFY_DONE:
		break;
    }
    return item;
}

/*
 * Notify callback function for `Pref_Apply_Button'.
 */
void
pref_apply_button_proc(Panel_item item, Event *event)
{
    Print("->pref_apply_button_proc\n");
    Apply_Pref();
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Pref_Reset_Button'.
 */
void
pref_reset_button_proc(Panel_item item, Event *event)
{
    int i = 0;
    int rows = 0;
    AUTOMNTLIST *AutoMntListPtr;

    Print("->pref_reset_button_proc\n");

    Reset_Pref();

    AutoMntListPtr = AutoMntList;
    while (AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        rows++;
        AutoMntListPtr = AutoMntListPtr->next;
    }

    xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_DELETE_ROWS, 0, rows,NULL);
    AutoMntListPtr = AutoMntList;
    while (AutoMntListPtr != NIL(AUTOMNTLIST *))
    {
        xv_set(MaMA_Pref_Panel->AutoMnt_List, 
            PANEL_LIST_INSERT, i,
            PANEL_LIST_STRING, i++, AutoMntListPtr->Dir, NULL);
        AutoMntListPtr = AutoMntListPtr->next;
    }
    xv_set(MaMA_Pref_Panel->AutoMnt_List, PANEL_LIST_SELECT, 0 , TRUE, NULL);
    SelectAutoMnt(AutoMntList, 0);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Add_AutoMnt_Button'.
 */
void
add_automnt_button_proc(Panel_item item, Event *event)
{
    Print("->add_automnt_button_proc\n");
	
    AutoMntList = AddAutoMnt(AutoMntList);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `Del_AutoMnt_Button'.
 */
void
del_automnt_button_proc(Panel_item item, Event *event)
{
    Print("->del_automnt_button_proc\n");

    AutoMntList = DeleteSelectedAutoMnt(AutoMntList);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `AutoMnt_List'.
 */
int
automnt_list_proc(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
    switch(op) {
        case PANEL_LIST_OP_DESELECT:
            break;

        case PANEL_LIST_OP_SELECT:
            SelectAutoMnt(AutoMntList, row);
            break;

        case PANEL_LIST_OP_VALIDATE:
            break;

        case PANEL_LIST_OP_DELETE:
            break;
    }
        
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

    return XV_OK;
}
