/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

 
#include <MaMA_include.h>
#include <MaMA_global.h>

#if defined(sonyriscV) || defined(OKI)
#include <netinet/in.h>
#endif

#include <rpc/rpc.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>

#ifdef SUNVIEW_RECT
#include <sunwindow/notify.h>
#endif
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#define Success 0
#define Failure -1

#define FRAMEVERSION  "FrameMaker3.0-X"

static struct timeval fiveSeconds = { 5, 0 };
static struct timeval halfMinute = { 60, 0 };
static FmRpcNiceErrorT nice;

extern Display *d;
extern char *propName;

#define FRAME_RPC "_Frame_RPC"

char
*GetFrameVersion()
{
    return(FRAMEVERSION);
}

/*
I call RPC's.
*/

/*
Utilities.
*/

getHostAndPort(host, portNum)
char *host;
int *portNum;
{
    Atom prop, actualType;
    int actualFormat;
    long itemCount, bytesAfter;
    unsigned char *data;
    
    if (strcmp(propName, "none") == 0) {
        strcpy(host, "localhost");
        *portNum = FM_RPC_PROG;
    } else  {
        if (strcmp(propName, "") == 0)
            strcpy(propName, FRAME_RPC);

        prop = XInternAtom(d, propName, False);

        XGetWindowProperty(d, RootWindowOfScreen(DefaultScreenOfDisplay(d)), 
                           prop, 0, 256,
                           False, AnyPropertyType, &actualType, &actualFormat,
                           &itemCount, &bytesAfter, &data);

        *host = 0;
        *portNum = -1;

        if (actualType != None) {
            while (*data != ':')
                *host++ = *data++;
            *host = 0;
            data++;
            sscanf(data, "%d", portNum);
        }
    }
}


RegisterRPC(prog, vers)
int prog;
int vers;
{
char hostname[128];
char buf[256];
Atom prop;

	prop = XInternAtom(d, "_Frame_fmbitmapRPC", False);
	gethostname(hostname, sizeof(hostname));
	sprintf(buf,"%s:%d:%d",hostname, prog, vers);
	XChangeProperty(d, RootWindowOfScreen(DefaultScreenOfDisplay(d)),
		prop, XA_STRING, 8, PropModeReplace, buf, strlen(buf));
	XFlush(d);

}

static bool_t localCall(proc, inproc, in, outproc, out, total_timeout)
struct timeval total_timeout;
char *in, *out;
xdrproc_t inproc, outproc;
{
struct hostent *hp;
int addrlen, sock = RPC_ANYSOCK;
CLIENT *client;
enum clnt_stat clnt_stat;
struct sockaddr_in server_addr;
char rpcHost[128];
int  rpcPort;

getHostAndPort(rpcHost, &rpcPort);
hp = gethostbyname(rpcHost);
if (! hp)
	return (FALSE);

addrlen = sizeof(struct sockaddr_in);
bcopy(hp->h_addr, (caddr_t)&server_addr.sin_addr, hp->h_length);
server_addr.sin_family = AF_INET;
server_addr.sin_port = 0;

client = clntudp_create(&server_addr, rpcPort, FM_RPC_VERS, total_timeout, &sock); 
if (! client)
	return (FALSE);
	
clnt_stat = clnt_call(client, proc, inproc, in, outproc, out, total_timeout);
if (clnt_stat != RPC_SUCCESS) {
	clnt_perror(client, "");
	return (FALSE);
}

close(sock);
clnt_destroy(client);
return (TRUE);
}

static freeReturn(returnp, freer)
char *returnp;
xdrproc_t freer; 
{
XDR anXdrStream;

xdrmem_create(&anXdrStream, returnp, 8 * 1024, XDR_FREE);
freer(&anXdrStream, returnp);
}

/*
RPC's.
*/

void doFmCommands(unsigned int doc, int *codes, unsigned int  num)
{
FmRpcCommandsArgT arg;

arg.doc = doc; 
arg.commands.FmRpcCommandsT_len = num;
arg.commands.FmRpcCommandsT_val = codes;
bzero(&nice, sizeof(nice));
if (localCall(FM_RPC_COMMANDS, xdr_FmRpcCommandsArgT, &arg, xdr_FmRpcNiceErrorT, &nice, halfMinute)) {
	if (nice.code != Success)
		;
	freeReturn(&nice, xdr_FmRpcNiceErrorT);
}
}

int CloseFMDoc(doc)
unsigned int doc;
{
int codes[12];

codes[0] = KBD_CLOSEWIN;
doFmCommands(doc, codes, 1);
}

int OpenFMDoc(char *doc)
{ 
FmRpcOpenDocArgT arg;
FmRpcOpenDocReturnT openDocReturn;
int handle;

handle = -1;
arg.doc = doc;

bzero(&openDocReturn, sizeof(openDocReturn));
if (localCall(FM_RPC_OPEN_DOC, xdr_FmRpcOpenDocArgT, &arg, xdr_FmRpcOpenDocReturnT, &openDocReturn, halfMinute)) {
	if (openDocReturn.nice.code != Success) {
	}
	else handle = openDocReturn.doc;
	freeReturn(&openDocReturn, xdr_FmRpcOpenDocReturnT);
}
return (handle);
}

int GoToLink(src, dst, tag, isNewWindow)
unsigned int src;
char *dst, *tag;
unsigned int isNewWindow;
{ 
FmRpcGoToLinkArgT arg;

arg.doc = src;
arg.dstDoc = dst;
arg.tag = tag;
arg.isNewWindow = isNewWindow;
bzero(&nice, sizeof(nice));
if (localCall(FM_RPC_GO_TO_LINK, xdr_FmRpcGoToLinkArgT, &arg, xdr_FmRpcNiceErrorT, &nice, halfMinute)) {
	if (nice.code != Success) {
		freeReturn(&nice, xdr_FmRpcNiceErrorT);
		return (-1);
	}
	freeReturn(&nice, xdr_FmRpcNiceErrorT);
	return (0);
}
return (-1);
}

int Import(file) 
char *file;
{
FmRpcImportArgT arg;

arg.doc = NULL; 
arg.file = file; 
arg.isCurrentDoc = 1;
arg.isCopy = 0;
bzero(&nice, sizeof(nice));
if (localCall(FM_RPC_IMPORT, xdr_FmRpcImportArgT, &arg, xdr_FmRpcNiceErrorT, &nice, halfMinute)) {
	if (nice.code != Success) {
		freeReturn(&nice, xdr_FmRpcNiceErrorT);
		return (-1);
	}
	freeReturn(&nice, xdr_FmRpcNiceErrorT);
	return (0);
}
return (-1);
}

FmRpcSaveMifArgT aMifArg;
int mode = 0777;

int
saveMarkers(unsigned int doc, char *file)
{
	bzero(&aMifArg, sizeof(aMifArg));

        aMifArg.doc = doc;
        aMifArg.file = file;
        aMifArg.mode = mode ;
        aMifArg.isMakeBackup = False;
	aMifArg.saveOptions = MIF_SAVE_MKRS;

	bzero(&nice, sizeof(nice));

        if(localCall(FM_RPC_SAVE_MIF, xdr_FmRpcSaveMifArgT,
		(char *) &aMifArg, xdr_FmRpcNiceErrorT, &nice, halfMinute))
	{ 
	    if (nice.code != Success)
	    {
		    freeReturn(&nice, xdr_FmRpcNiceErrorT);
		    return (-1);
	    }
	    freeReturn(&nice, xdr_FmRpcNiceErrorT);
	    return (0);
	}
return(-1);
}

