;GIL-3
(
(
	:type                   :menu
	:name                   File_Menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Open Edit List..." "Save Edit List" "Save As..." "About MaMA..." "Quit MaMA" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (open_edit_proc save_edit_proc saveas_edit_proc nil quit_proc )
	:menu-item-menus        (nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (File_Menu "Open Edit List...")
		:when                   (Notify )
		:to                     (File_Menu "Open Edit List...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (open_edit_proc)
		)
		(
		:from                   (File_Menu "Save Edit List")
		:when                   (Notify )
		:to                     (File_Menu "Save Edit List")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (save_edit_proc)
		)
		(
		:from                   (File_Menu "Save As...")
		:when                   (Notify )
		:to                     (File_Menu "Save As...")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (saveas_edit_proc)
		)
		(
		:from                   (File_Menu "Quit MaMA")
		:when                   (Notify )
		:to                     (File_Menu "Quit MaMA")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (quit_proc)
		)
		(
		:from                   (File_Menu "About MaMA...")
		:when                   (Notify )
		:to                     (About_Panel)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :menu
	:name                   Delete_Actions_Menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Selected" "All" )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (nil nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (del_sel_action del_all_actions )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (Delete_Actions_Menu "Selected")
		:when                   (Notify )
		:to                     (Delete_Actions_Menu "Selected")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (del_sel_action)
		)
		(
		:from                   (Delete_Actions_Menu "All")
		:when                   (Notify )
		:to                     (Delete_Actions_Menu "All")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (del_all_actions)
		)
		(
		:from                   (Delete_Actions_Menu "Selected")
		:when                   (Notify )
		:to                     (Delete_Actions_Menu "Selected")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (delete_sel_proc)
		)
		(
		:from                   (Delete_Actions_Menu "All")
		:when                   (Notify )
		:to                     (Delete_Actions_Menu "All")
		:function_type          CallFunction
		:arg_type               ()
		:action                 (del_all_proc)
		)
	)
)
(
	:type                   :menu
	:name                   Link_Menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             ""
	:menu-item-labels       ("Empty" )
	:menu-item-label-types  (:string )
	:menu-item-states       (:active )
	:menu-item-defaults     (nil )
	:initial-selections     (nil )
	:menu-item-handlers     (nil )
	:menu-item-menus        (nil )
	:menu-item-colors       ("" )
	:pinnable               t
	:user-data              ()
	:actions                ()
)
(
	:type                   :menu
	:name                   Props_Menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Properties"
	:menu-item-labels       ("Port Manager..." "Preferences..." )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (nil nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (nil nil )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (Props_Menu "Port Manager...")
		:when                   (Notify )
		:to                     (PM_Panel)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Props_Menu "Preferences...")
		:when                   (Notify )
		:to                     (Pref_Panel)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :base-window
	:name                   Main_Window
	:owner                  nil
	:width                  366
	:height                 272
	:background-color       ""
	:foreground-color       ""
	:label                  "MaMA"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              nil
	:icon-file              "./include/images/MaMA_main.icon"
	:icon-label             ""
	:icon-mask-file         "./include/images/MaMA_main_mask.icon"
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Main_Control
	:owner                  Main_Window
	:help                   ""
	:x                      0
	:y                      0
	:width                  366
	:height                 220
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :drop-target
	:name                   edit_drop_target
	:owner                  Main_Control
	:help                   "Drag and Drop target for Edit Lists"
	:x                      319
	:y                      8
	:width                  38
	:height                 32
	:drop-target_width      32
	:default-drop-site      t
	:draggable              t
	:droppable              nil
	:label                  ""
	:label-type             :string
	:normal-drop-glyph      "./include/images/MaMA_doc_glyph.icon"
	:busy-drop-glyph        "./include/images/MaMA_doc_glyph.icon"
	:dnd-cursor             "./include/images/MaMA_doc_glyph.icon"
	:dnd-cursor-xhot        25
	:dnd-cursor-yhot        25
	:dnd-accept-cursor      "./include/images/MaMA_doc_glyph.icon"
	:dnd-accept-cursor-xhot 25
	:dnd-accept-cursor-yhot 25
	:foreground-color       "Foreground"
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window edit_drop_target)
		:when                   (DroppedUpon )
		:to                     (Main_Window edit_drop_target)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (edit_list_drop_proc)
		)
	)
)
(
	:type                   :button
	:name                   File_Button
	:owner                  Main_Control
	:help                   "A filemenu button for a.o. loading and saving Edit Lists"
	:x                      10
	:y                      10
	:width                  54
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "File"
	:label-type             :string
	:initial-state          :active
	:menu                   File_Menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Props_Button
	:owner                  Main_Control
	:help                   ""
	:x                      74
	:y                      10
	:width                  94
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Properties"
	:label-type             :string
	:initial-state          :active
	:menu                   Props_Menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group11
	:x                      10
	:y                      10
	:group-type             :row
	:members                (File_Button Props_Button )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   Edit_List
	:owner                  Main_Control
	:help                   "The Edit List, each Edit has a label, a number of actions and a duration."
	:x                      10
	:y                      53
	:width                  -1
	:height                 116
	:value-x                10
	:value-y                53
	:rows                   4
	:foreground-color       ""
	:label                  ""
	:title                  "Edit Label                                #Actions   Time"
	:label-type             :string
	:layout-type            :horizontal
	:read-only              t
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         edit_list_proc
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Edit_List)
		:when                   (Notify )
		:to                     (Main_Window Edit_List)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (edit_list_proc)
		)
	)
)
(
	:type                   :button
	:name                   Edit_Up_Button
	:owner                  Main_Control
	:help                   "This button moves an Edit List entry one up."
	:x                      290
	:y                      182
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/up.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         edit_up_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Edit_Up_Button)
		:when                   (Notify )
		:to                     (Main_Window Edit_Up_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (edit_up_button_proc)
		)
	)
)
(
	:type                   :button
	:name                   Edit_Down_Button
	:owner                  Main_Control
	:help                   "This button moves an Edit List entry one down."
	:x                      326
	:y                      182
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/down.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         edit_down_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Edit_Down_Button)
		:when                   (Notify )
		:to                     (Main_Window Edit_Down_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (edit_down_button_proc)
		)
	)
)
(
	:type                   :group
	:name                   group26
	:x                      290
	:y                      182
	:group-type             :row
	:members                (Edit_Up_Button Edit_Down_Button )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Create_Edit_Button
	:owner                  Main_Control
	:help                   "This button pops up another window for building a new Edit"
	:x                      10
	:y                      186
	:width                  73
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "New Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         create_edit_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Create_Edit_Button)
		:when                   (Notify )
		:to                     (Main_Window Create_Edit_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (create_edit_proc)
		)
		(
		:from                   (Main_Window Create_Edit_Button)
		:when                   (Notify )
		:to                     (Edit_Panel)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   Change_Edit_Button
	:owner                  Main_Control
	:help                   "With this button you can change the selected Edit"
	:x                      93
	:y                      186
	:width                  92
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Change Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         change_edit_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Change_Edit_Button)
		:when                   (Notify )
		:to                     (Main_Window Change_Edit_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (change_edit_proc)
		)
		(
		:from                   (Main_Window Change_Edit_Button)
		:when                   (Notify )
		:to                     (Edit_Panel)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :button
	:name                   Delete_Edit_Button
	:owner                  Main_Control
	:help                   "This button deletes the selected Edit"
	:x                      195
	:y                      186
	:width                  85
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         del_edit_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Delete_Edit_Button)
		:when                   (Notify )
		:to                     (Main_Window Delete_Edit_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (del_edit_proc)
		)
	)
)
(
	:type                   :group
	:name                   group5
	:x                      10
	:y                      186
	:group-type             :row
	:members                (Create_Edit_Button Change_Edit_Button Delete_Edit_Button )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group30
	:x                      10
	:y                      182
	:group-type             :row
	:members                (group5 group26 )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Edit_Preview_Control
	:owner                  Main_Window
	:help                   ""
	:x                      0
	:y                      220
	:width                  366
	:height                 52
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   Time_message1
	:owner                  Edit_Preview_Control
	:help                   ""
	:x                      137
	:y                      11
	:width                  38
	:height                 13
	:foreground-color       ""
	:label                  "Time:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :gauge
	:name                   Time_Gauge1
	:owner                  Edit_Preview_Control
	:help                   "Gauge for the elapsed time"
	:x                      182
	:y                      12
	:width                  101
	:height                 11
	:value-x                182
	:value-y                12
	:slider-width           85
	:ticks                  0
	:foreground-color       "Black"
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-range             nil
	:min-value              0
	:max-value              100
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   Start_message1
	:owner                  Edit_Preview_Control
	:help                   ""
	:x                      182
	:y                      28
	:width                  35
	:height                 13
	:foreground-color       ""
	:label                  "00:00"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   End_message1
	:owner                  Edit_Preview_Control
	:help                   ""
	:x                      247
	:y                      28
	:width                  35
	:height                 13
	:foreground-color       ""
	:label                  "00:00"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group3
	:x                      137
	:y                      11
	:group-type             nil
	:members                (Time_message1 Time_Gauge1 Start_message1 End_message1 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :gauge
	:name                   Action_Time_Gauge
	:owner                  Edit_Preview_Control
	:help                   "Gauge to indicate the time, left for the action to be performed."
	:x                      293
	:y                      11
	:width                  11
	:height                 36
	:value-x                293
	:value-y                11
	:slider-width           20
	:ticks                  0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :vertical
	:show-range             nil
	:min-value              0
	:max-value              10
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group12
	:x                      137
	:y                      11
	:group-type             :row
	:members                (group3 Action_Time_Gauge )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   Repeat_Setting
	:owner                  Edit_Preview_Control
	:help                   "When this setting is set, the presentation repeats \"forever\". When it is not set, the presentation is performed/played once."
	:x                      320
	:y                      12
	:width                  26
	:height                 26
	:value-x                320
	:value-y                12
	:rows                   1
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     nil
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("./include/images/repeat.button" )
	:choice-label-types     (:glyph )
	:choice-colors          ("" )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Stop_Button
	:owner                  Edit_Preview_Control
	:help                   "Stops the previewing of the Edit"
	:x                      27
	:y                      13
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/stop.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         stop_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Stop_Button)
		:when                   (Notify )
		:to                     (Main_Window Stop_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (stop_button_proc)
		)
	)
)
(
	:type                   :button
	:name                   Play_Button
	:owner                  Edit_Preview_Control
	:help                   "Start playing the previewing of the Edit"
	:x                      63
	:y                      13
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/play.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         play_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Play_Button)
		:when                   (Notify )
		:to                     (Main_Window Play_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (play_button_proc)
		)
	)
)
(
	:type                   :button
	:name                   Pause_Button
	:owner                  Edit_Preview_Control
	:help                   "Pause/resume the previewing of the Edit"
	:x                      99
	:y                      13
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/pause.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         pause_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Main_Window Pause_Button)
		:when                   (Notify )
		:to                     (Main_Window Pause_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (pause_button_proc)
		)
	)
)
(
	:type                   :message
	:name                   Preview_Action_message1
	:owner                  Edit_Preview_Control
	:help                   ""
	:x                      17
	:y                      26
	:width                  0
	:height                 0
	:foreground-color       ""
	:label                  ""
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group1
	:x                      27
	:y                      13
	:group-type             :row
	:members                (Preview_Action_message1 Stop_Button Play_Button Pause_Button )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   About_Panel
	:owner                  Main_Window
	:width                  442
	:height                 180
	:background-color       "Dark Slate Blue"
	:foreground-color       ""
	:label                  "About MaMA"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              t
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   About_Control
	:owner                  About_Panel
	:help                   ""
	:x                      0
	:y                      0
	:width                  442
	:height                 180
	:background-color       "Dark Slate Blue"
	:foreground-color       "Dark Slate Blue"
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   About_message1
	:owner                  About_Control
	:help                   ""
	:x                      79
	:y                      31
	:width                  269
	:height                 13
	:foreground-color       "White"
	:label                  "MaMA (Maestro and Maker Association)"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   About_message2
	:owner                  About_Control
	:help                   ""
	:x                      83
	:y                      55
	:width                  274
	:height                 13
	:foreground-color       "White"
	:label                  "A media editor for FrameMaker made for use"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   About_message3
	:owner                  About_Control
	:help                   ""
	:x                      59
	:y                      79
	:width                  325
	:height                 13
	:foreground-color       "White"
	:label                  "with the MAEstro Multimedia Authoring Environment"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   About_message4
	:owner                  About_Control
	:help                   ""
	:x                      83
	:y                      103
	:width                  246
	:height                 13
	:foreground-color       "White"
	:label                  "by Simon Voogd & Hendrik Blokhuis"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group24
	:x                      59
	:y                      31
	:group-type             nil
	:members                (About_message1 About_message2 About_message3 About_message4 )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   OK_Button
	:owner                  About_Control
	:help                   ""
	:x                      200
	:y                      136
	:width                  36
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       "Dark Slate Blue"
	:label                  "OK"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (About_Panel OK_Button)
		:when                   (Notify )
		:to                     (About_Panel)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
	)
)
(
	:type                   :popup-window
	:name                   Edit_Panel
	:owner                  Main_Window
	:width                  515
	:height                 524
	:background-color       "White"
	:foreground-color       "White"
	:label                  ""
	:label-type             :string
	:initial-state          :invisible
	:show-footer            t
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Label_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      0
	:width                  515
	:height                 202
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   Action_List
	:owner                  Label_Control
	:help                   "This list describes an Edit as a list of actions,
each entry consists of an action, a FrameMaker 
document on which the action is performed, and a
duration. Fit is used if the action is 'Zoom In', 'Zoom Out' or 'Zoom 100%'."
	:x                      20
	:y                      20
	:width                  -1
	:height                 134
	:value-x                20
	:value-y                20
	:rows                   5
	:foreground-color       ""
	:label                  ""
	:title                  "Action:                             Time:      Fit:      Target Document:                                "
	:label-type             :string
	:layout-type            :vertical
	:read-only              t
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         action_list_proc
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Action_List)
		:when                   (Notify )
		:to                     (Edit_Panel Action_List)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (action_list_proc)
		)
	)
)
(
	:type                   :button
	:name                   Up_Button
	:owner                  Label_Control
	:help                   "
Button for moving the selected entry one entry UP."
	:x                      219
	:y                      164
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/up.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Up_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Add_Doc_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (up_button_proc)
		)
	)
)
(
	:type                   :button
	:name                   Down_Button
	:owner                  Label_Control
	:help                   "
Button for moving the selected entry one entry DOWN."
	:x                      255
	:y                      164
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/down.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Down_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Add_Doc_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (down_button_proc)
		)
	)
)
(
	:type                   :text-field
	:name                   Edit_Label_tf
	:owner                  Label_Control
	:help                   "The label for the current Edit, this label must be unique!"
	:x                      20
	:y                      175
	:width                  189
	:height                 15
	:value-x                81
	:value-y                175
	:value-length           16
	:stored-length          100
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "   Label:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group4
	:x                      20
	:y                      164
	:group-type             :row
	:members                (Edit_Label_tf Up_Button Down_Button )
	:rows                   1
	:row-alignment          :bottom-edges
	:columns                0
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group14
	:x                      20
	:y                      20
	:group-type             :column
	:members                (Action_List group4 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                1
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Label_Control
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      20
	:vertical-offset        20
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Action_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      202
	:width                  238
	:height                 35
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   Action_Settings
	:owner                  Action_Control
	:help                   "All the possible actions that can be performed
on the Target Document"
	:x                      27
	:y                      5
	:width                  203
	:height                 23
	:value-x                81
	:value-y                5
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       "Black"
	:setting-type           :stack
	:selection-required     t
	:label                  "Action:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Jump to HyperLink" "Goto First Page" "Goto Next Page" "Goto Prev Page" "Goto Last Page" "Zoom In" "Zoom Out" "Zoom To 100%" "Open Document" "Close Document" "Quit Document" )
	:choice-label-types     (:string :string :string :string :string :string :string :string :string :string :string )
	:choice-colors          ("" "" "" "" "" "" "" "" "" "" "" )
	:choice-defaults        (nil nil nil nil nil nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil nil nil nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Action_Settings "Jump to HyperLink")
		:when                   (Notify )
		:to                     (Edit_Panel Link_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto First Page")
		:when                   (Notify )
		:to                     (Edit_Panel Link_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto Last Page")
		:when                   (Notify )
		:to                     (Edit_Panel Link_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Open Document")
		:when                   (Notify )
		:to                     (Edit_Panel Link_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Close Document")
		:when                   (Notify )
		:to                     (Edit_Panel Link_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Zoom In")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Zoom Out")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Zoom To 100%")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto First Page")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto Last Page")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Open Document")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Close Document")
		:when                   (Notify )
		:to                     (Edit_Panel Zoom_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto Next Page")
		:when                   (Notify )
		:to                     (Edit_Panel Rep_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto Prev Page")
		:when                   (Notify )
		:to                     (Edit_Panel Rep_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto First Page")
		:when                   (Notify )
		:to                     (Edit_Panel Rep_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto Last Page")
		:when                   (Notify )
		:to                     (Edit_Panel Rep_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Open Document")
		:when                   (Notify )
		:to                     (Edit_Panel Rep_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Close Document")
		:when                   (Notify )
		:to                     (Edit_Panel Rep_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto First Page")
		:when                   (Notify )
		:to                     (Edit_Panel Empty_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Goto Last Page")
		:when                   (Notify )
		:to                     (Edit_Panel Empty_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Open Document")
		:when                   (Notify )
		:to                     (Edit_Panel Empty_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Close Document")
		:when                   (Notify )
		:to                     (Edit_Panel Empty_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (Edit_Panel Action_Settings "Quit Document")
		:when                   (Notify )
		:to                     (Edit_Panel Empty_Layer)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :group
	:name                   group2
	:x                      27
	:y                      5
	:group-type             nil
	:members                (Action_Settings )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :right-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Action_Control
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      27
	:vertical-offset        5
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Doc_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      238
	:y                      202
	:width                  277
	:height                 244
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   Dir_tf
	:owner                  Doc_Control
	:help                   "Directorie of the current Target Document"
	:x                      15
	:y                      9
	:width                  240
	:height                 15
	:value-x                47
	:value-y                9
	:value-length           26
	:stored-length          100
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Dir:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   File_tf
	:owner                  Doc_Control
	:help                   "Filename of the current Target Document"
	:x                      11
	:y                      34
	:width                  196
	:height                 15
	:value-x                47
	:value-y                34
	:value-length           20
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "File:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :drop-target
	:name                   doc_drop_target
	:owner                  Doc_Control
	:help                   "Drop target for FrameMaker Documents"
	:x                      217
	:y                      34
	:width                  38
	:height                 32
	:drop-target_width      32
	:default-drop-site      nil
	:draggable              t
	:droppable              nil
	:label                  ""
	:label-type             :string
	:normal-drop-glyph      "./include/images/Frame_doc_glyph.icon"
	:busy-drop-glyph        "./include/images/Frame_doc_glyph.icon"
	:dnd-cursor             "./include/images/Frame_doc_glyph.icon"
	:dnd-cursor-xhot        0
	:dnd-cursor-yhot        0
	:dnd-accept-cursor      "./include/images/Frame_doc_glyph.icon"
	:dnd-accept-cursor-xhot 0
	:dnd-accept-cursor-yhot 0
	:foreground-color       ""
	:initial-state          :active
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel doc_drop_target)
		:when                   (DroppedUpon )
		:to                     (Edit_Panel doc_drop_target)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (doc_drop_proc)
		)
	)
)
(
	:type                   :group
	:name                   group15
	:x                      11
	:y                      34
	:group-type             :row
	:members                (File_tf doc_drop_target )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :vertical-centers
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group16
	:x                      11
	:y                      9
	:group-type             :column
	:members                (Dir_tf group15 )
	:rows                   0
	:row-alignment          :top-edges
	:columns                1
	:column-alignment       :right-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   Doc_List
	:owner                  Doc_Control
	:help                   "List of possible Target Documents"
	:x                      11
	:y                      82
	:width                  -1
	:height                 116
	:value-x                11
	:value-y                82
	:rows                   4
	:foreground-color       ""
	:label                  ""
	:title                  "FrameMaker Target Documents:"
	:label-type             :string
	:layout-type            :horizontal
	:read-only              t
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         doc_list_proc
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Doc_List)
		:when                   (Notify )
		:to                     (Edit_Panel Doc_List)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (doc_list_proc)
		)
	)
)
(
	:type                   :button
	:name                   View_Doc_Button
	:owner                  Doc_Control
	:help                   "This button causes FrameMaker to open the selected Target Document.
Warning: Be sure FrameMaker is running!"
	:x                      56
	:y                      208
	:width                  48
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "View"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         view_target_doc_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel View_Doc_Button)
		:when                   (Notify )
		:to                     (Edit_Panel View_Doc_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (view_target_doc_proc)
		)
	)
)
(
	:type                   :button
	:name                   Add_Doc_Button
	:owner                  Doc_Control
	:help                   "This button pops up a filechooser to select another Target Document."
	:x                      114
	:y                      208
	:width                  51
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         add_target_doc_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Add_Doc_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Add_Doc_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (add_target_doc_proc)
		)
	)
)
(
	:type                   :button
	:name                   Delete_Doc_Button
	:owner                  Doc_Control
	:help                   "This button deletes the selected Target Document out of the list."
	:x                      175
	:y                      208
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         del_target_doc_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Delete_Doc_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Delete_Doc_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (del_target_doc_proc)
		)
	)
)
(
	:type                   :group
	:name                   group13
	:x                      56
	:y                      208
	:group-type             :row
	:members                (View_Doc_Button Add_Doc_Button Delete_Doc_Button )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group17
	:x                      11
	:y                      82
	:group-type             :column
	:members                (Doc_List group13 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                1
	:column-alignment       :vertical-centers
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group18
	:x                      11
	:y                      9
	:group-type             nil
	:members                (group16 group17 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :vertical-centers
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Doc_Control
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      11
	:vertical-offset        9
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Link_Layer
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      237
	:width                  238
	:height                 59
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   Link_Settings
	:owner                  Link_Layer
	:help                   "Generated list of Hyperlinks."
	:x                      40
	:y                      7
	:width                  77
	:height                 23
	:value-x                81
	:value-y                7
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "Link:"
	:label-type             :string
	:notify-handler         link_setting_proc
	:event-handler          nil
	:choices                ()
	:choice-label-types     ()
	:choice-colors          ()
	:choice-defaults        ()
	:initial-selections     ()
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Link_Settings)
		:when                   (Notify )
		:to                     (Edit_Panel Link_Settings)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (link_setting_proc)
		)
	)
)
(
	:type                   :group
	:name                   group29
	:x                      40
	:y                      7
	:group-type             nil
	:members                (Link_Settings )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :right-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Link_Layer
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      40
	:vertical-offset        7
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Update_Button
	:owner                  Link_Layer
	:help                   "Button for Updating the HyperLink list with the links of the selected FrameMaker document.
For that,  the document is open(ed)!"
	:x                      162
	:y                      9
	:width                  62
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Update"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         update_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Update_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Update_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (update_button_proc)
		)
	)
)
(
	:type                   :text-field
	:name                   Link_Name_tf
	:owner                  Link_Layer
	:help                   "Used for the action \"Jump To A HyperLink\"

Textfield for a HyperLink that must occur in the Target Document."
	:x                      80
	:y                      33
	:width                  144
	:height                 15
	:value-x                80
	:value-y                33
	:value-length           18
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         link_name_tf_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Link_Name_tf)
		:when                   (Notify )
		:to                     (Edit_Panel Link_Name_tf)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (link_name_tf_proc)
		)
	)
)
(
	:type                   :group
	:name                   group28
	:x                      80
	:y                      9
	:group-type             :column
	:members                (Update_Button Link_Name_tf )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                1
	:column-alignment       :right-edges
	:horizontal-spacing     10
	:vertical-spacing       5
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Zoom_Layer
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      237
	:width                  238
	:height                 59
	:background-color       ""
	:foreground-color       ""
	:initial-state          :invisible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   Fit_Settings
	:owner                  Zoom_Layer
	:help                   "Used for the action \"Zoom Page\"

After zooming, fit window to page or fit the page to the window.
No choice required
"
	:x                      52
	:y                      18
	:width                  165
	:height                 23
	:value-x                80
	:value-y                18
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     nil
	:label                  "Fit:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("None" "Window To Page" "Page To Window" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:choice-defaults        (nil nil nil )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Rep_Layer
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      237
	:width                  238
	:height                 59
	:background-color       ""
	:foreground-color       ""
	:initial-state          :invisible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   Repeat_tf
	:owner                  Rep_Layer
	:help                   "Used for the actions \"Next/Prev Page\",

for repeating these commands a number of times"
	:x                      23
	:y                      21
	:width                  117
	:height                 15
	:value-x                81
	:value-y                21
	:value-length           3
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Repeat:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              250
	:min-value              1
	:initial-value          1
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   Times_message
	:owner                  Rep_Layer
	:help                   ""
	:x                      162
	:y                      22
	:width                  53
	:height                 13
	:foreground-color       ""
	:label                  "Time(s)"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group8
	:x                      23
	:y                      21
	:group-type             :row
	:members                (Repeat_tf Times_message )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Rep_Layer
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      23
	:vertical-offset        21
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Empty_Layer
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      237
	:width                  238
	:height                 59
	:background-color       ""
	:foreground-color       ""
	:initial-state          :invisible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Duration_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      296
	:width                  238
	:height                 72
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   Minutes_tf
	:owner                  Duration_Control
	:help                   "Textfield for number of minutes"
	:x                      34
	:y                      15
	:width                  97
	:height                 15
	:value-x                80
	:value-y                15
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  "Time:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              59
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   min_message
	:owner                  Duration_Control
	:help                   "This button adds the Edit in the Edit List"
	:x                      141
	:y                      16
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "Minutes"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group20
	:x                      34
	:y                      15
	:group-type             :row
	:members                (Minutes_tf min_message )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :right-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   Seconds_tf
	:owner                  Duration_Control
	:help                   "Textfield for number of seconds"
	:x                      80
	:y                      40
	:width                  51
	:height                 15
	:value-x                80
	:value-y                57
	:value-length           2
	:stored-length          2
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :vertical
	:value-underlined       t
	:max-value              59
	:min-value              0
	:initial-value          0
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   Sec_message
	:owner                  Duration_Control
	:help                   ""
	:x                      141
	:y                      41
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "Seconds"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group19
	:x                      80
	:y                      57
	:group-type             :row
	:members                (Seconds_tf Sec_message )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group21
	:x                      34
	:y                      15
	:group-type             :column
	:members                (group20 group19 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                1
	:column-alignment       :right-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Duration_Control
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      34
	:vertical-offset        15
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Action_Preview_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      368
	:width                  238
	:height                 78
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Stop_Button2
	:owner                  Action_Preview_Control
	:help                   "Stops the previewing of the Action"
	:x                      82
	:y                      4
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/stop.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         stop_button2_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Stop_Button2)
		:when                   (Notify )
		:to                     (Edit_Panel Stop_Button2)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (stop_button2_proc)
		)
	)
)
(
	:type                   :button
	:name                   Play_Button2
	:owner                  Action_Preview_Control
	:help                   "Start playing the previewing of the Action"
	:x                      118
	:y                      4
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/play.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         play_button2_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Play_Button2)
		:when                   (Notify )
		:to                     (Edit_Panel Play_Button2)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (play_button2_proc)
		)
	)
)
(
	:type                   :button
	:name                   Pause_Button2
	:owner                  Action_Preview_Control
	:help                   "Pause/resume the previewing of the Action"
	:x                      154
	:y                      4
	:width                  26
	:height                 26
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "./include/images/pause.button"
	:label-type             :glyph
	:initial-state          :active
	:menu                   nil
	:notify-handler         pause_button2_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Pause_Button2)
		:when                   (Notify )
		:to                     (Edit_Panel Pause_Button2)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (pause_button2_proc)
		)
	)
)
(
	:type                   :group
	:name                   group22
	:x                      82
	:y                      4
	:group-type             nil
	:members                (Stop_Button2 Play_Button2 Pause_Button2 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   Time_message2
	:owner                  Action_Preview_Control
	:help                   ""
	:x                      31
	:y                      40
	:width                  38
	:height                 13
	:foreground-color       ""
	:label                  "Time:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :gauge
	:name                   Time_Gauge2
	:owner                  Action_Preview_Control
	:help                   "Gauge for the elapsed time"
	:x                      79
	:y                      41
	:width                  101
	:height                 11
	:value-x                79
	:value-y                41
	:slider-width           85
	:ticks                  0
	:foreground-color       "Black"
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:orientation            :horizontal
	:show-range             nil
	:min-value              0
	:max-value              100
	:min-tick-string        ""
	:max-tick-string        ""
	:initial-value          0
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   Start_message2
	:owner                  Action_Preview_Control
	:help                   ""
	:x                      75
	:y                      58
	:width                  35
	:height                 13
	:foreground-color       ""
	:label                  "00:00"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   End_message2
	:owner                  Action_Preview_Control
	:help                   ""
	:x                      144
	:y                      58
	:width                  35
	:height                 13
	:foreground-color       ""
	:label                  "00:00"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group7
	:x                      75
	:y                      58
	:group-type             nil
	:members                (Start_message2 End_message2 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group23
	:x                      31
	:y                      40
	:group-type             nil
	:members                (Time_message2 Time_Gauge2 group7 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group25
	:x                      31
	:y                      4
	:group-type             nil
	:members                (group22 group23 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Action_Button_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      446
	:width                  515
	:height                 78
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Add_Action_Button
	:owner                  Action_Button_Control
	:help                   "This button adds the Action in the Action List.
You can adjust it's position with the 'arrow' buttons."
	:x                      96
	:y                      8
	:width                  84
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add Action"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         add_action_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Add_Action_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Add_Action_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (add_action_proc)
		)
	)
)
(
	:type                   :button
	:name                   Change_Action_Button
	:owner                  Action_Button_Control
	:help                   "This button changes the selected Action of the Action List."
	:x                      190
	:y                      8
	:width                  106
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Change Action"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         change_action_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Change_Action_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Change_Action_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (change_action_proc)
		)
	)
)
(
	:type                   :button
	:name                   Del_Action_Button
	:owner                  Action_Button_Control
	:help                   "With this button you can delete the selected Action from the List or delete all the Actions."
	:x                      306
	:y                      8
	:width                  113
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete Action"
	:label-type             :string
	:initial-state          :active
	:menu                   Delete_Actions_Menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group27
	:x                      96
	:y                      8
	:group-type             :row
	:members                (Add_Action_Button Change_Action_Button Del_Action_Button )
	:rows                   1
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          Action_Button_Control
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      96
	:vertical-offset        8
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   Apply_Edit_Control
	:owner                  Edit_Panel
	:help                   ""
	:x                      0
	:y                      481
	:width                  515
	:height                 43
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Insert_Edit_Button
	:owner                  Apply_Edit_Control
	:help                   "This button adds the Edit (as shown in the Action List) in the List of Edits."
	:x                      161
	:y                      12
	:width                  81
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Insert Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         insert_edit_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Insert_Edit_Button)
		:when                   (Notify )
		:to                     (Edit_Panel Insert_Edit_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (insert_edit_proc)
		)
	)
)
(
	:type                   :button
	:name                   Change_Edit_Button_In_Pop
	:owner                  Apply_Edit_Control
	:help                   "With this button the selected Edit is changed
to the Edit as defined in the Action List."
	:x                      252
	:y                      12
	:width                  92
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Change Edit"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         Change_Edit_From_Pop_Proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Edit_Panel Change_Edit_Button_In_Pop)
		:when                   (Notify )
		:to                     (Edit_Panel Change_Edit_Button_In_Pop)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (Change_Edit_From_Pop_Proc)
		)
	)
)
(
	:type                   :group
	:name                   group10
	:x                      161
	:y                      12
	:group-type             :row
	:members                (Insert_Edit_Button Change_Edit_Button_In_Pop )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :stack
	:name                   layered_pane2
	:owner                  Edit_Panel
	:members                (Link_Layer Empty_Layer Zoom_Layer Rep_Layer )
	:user-data              ()
)
(
	:type                   :popup-window
	:name                   PM_Panel
	:owner                  Main_Window
	:width                  303
	:height                 103
	:background-color       ""
	:foreground-color       ""
	:label                  "Port Manager connection"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   PM_Control
	:owner                  PM_Panel
	:help                   ""
	:x                      0
	:y                      0
	:width                  303
	:height                 103
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   PM_Cur_Connection_tf
	:owner                  PM_Control
	:help                   ""
	:x                      9
	:y                      12
	:width                  285
	:height                 15
	:value-x                166
	:value-y                12
	:value-length           16
	:stored-length          64
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Current Port Manager:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       nil
	:initial-value          ""
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   PM_Connect_tf
	:owner                  PM_Control
	:help                   ""
	:x                      32
	:y                      37
	:width                  262
	:height                 15
	:value-x                166
	:value-y                37
	:value-length           16
	:stored-length          64
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "New Port Manager:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group6
	:x                      9
	:y                      12
	:group-type             :column
	:members                (PM_Cur_Connection_tf PM_Connect_tf )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                1
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   PM_Connect_Button
	:owner                  PM_Control
	:help                   ""
	:x                      94
	:y                      71
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PM_Connect_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (PM_Panel PM_Connect_Button)
		:when                   (Notify )
		:to                     (PM_Panel PM_Connect_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PM_Connect_proc)
		)
	)
)
(
	:type                   :button
	:name                   PM_Set_Default_Button
	:owner                  PM_Control
	:help                   ""
	:x                      157
	:y                      71
	:width                  51
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Reset"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         PM_Set_Default_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (PM_Panel PM_Set_Default_Button)
		:when                   (Notify )
		:to                     (PM_Panel PM_Set_Default_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (PM_Set_Default_proc)
		)
	)
)
(
	:type                   :group
	:name                   group9
	:x                      94
	:y                      71
	:group-type             :row
	:members                (PM_Connect_Button PM_Set_Default_Button )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   Pref_Panel
	:owner                  Main_Window
	:width                  429
	:height                 282
	:background-color       ""
	:foreground-color       ""
	:label                  "Preferences"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 t
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls1
	:owner                  Pref_Panel
	:help                   ""
	:x                      0
	:y                      0
	:width                  429
	:height                 282
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   Frame_path_tf
	:owner                  controls1
	:help                   "Enter here the complete command to start the proper FrameMaker version."
	:x                      12
	:y                      7
	:width                  405
	:height                 15
	:value-x                177
	:value-y                7
	:value-length           30
	:stored-length          256
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "FrameMaker command:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   Open_FM_Setting
	:owner                  controls1
	:help                   "Perform autom. an 'Open Doc' before each Action is performed,
or let the user add this Action to his/her wishes to the Edit. "
	:x                      56
	:y                      32
	:width                  363
	:height                 46
	:value-x                177
	:value-y                32
	:rows                   2
	:columns                0
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :exclusive
	:selection-required     t
	:label                  "Open Document:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Auto Open Document for each Action" "User shall perform Open Document" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   AutoMnt_List
	:owner                  controls1
	:help                   "The directories listed here will be removed
from the beginning of a path name.
This way the files will still be accessable
by machines using other auto mount directories."
	:x                      32
	:y                      88
	:width                  198
	:height                 98
	:value-x                177
	:value-y                88
	:rows                   3
	:foreground-color       ""
	:label                  "Remove from paths:"
	:title                  "Auto mount directories"
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    nil
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         automnt_list_proc
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (Pref_Panel AutoMnt_List)
		:when                   (Notify )
		:to                     (Pref_Panel AutoMnt_List)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (automnt_list_proc)
		)
	)
)
(
	:type                   :button
	:name                   Add_AutoMnt_Button
	:owner                  controls1
	:help                   "Add the directory entered after \"Directory:\"
to the \"Auto mount directories\" list."
	:x                      219
	:y                      196
	:width                  42
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         add_automnt_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Pref_Panel Add_AutoMnt_Button)
		:when                   (Notify )
		:to                     (Pref_Panel Add_AutoMnt_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (add_automnt_button_proc)
		)
	)
)
(
	:type                   :button
	:name                   Del_AutoMnt_Button
	:owner                  controls1
	:help                   "Delete the selected auto mount directory from
the \"Auto mount directories\" list."
	:x                      271
	:y                      196
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         del_automnt_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Pref_Panel Del_AutoMnt_Button)
		:when                   (Notify )
		:to                     (Pref_Panel Del_AutoMnt_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (del_automnt_button_proc)
		)
	)
)
(
	:type                   :group
	:name                   group32
	:x                      219
	:y                      196
	:group-type             :row
	:members                (Add_AutoMnt_Button Del_AutoMnt_Button )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group33
	:x                      32
	:y                      88
	:group-type             nil
	:members                (AutoMnt_List group32 )
	:rows                   0
	:row-alignment          :horizontal-centers
	:columns                0
	:column-alignment       :vertical-centers
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   Add_AutoMnt_tf
	:owner                  controls1
	:help                   "Type here the name of an auto mount directory,
that has to be added to the list with the 
\"Add\" button."
	:x                      103
	:y                      225
	:width                  202
	:height                 15
	:value-x                177
	:value-y                225
	:value-length           16
	:stored-length          64
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Directory:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group35
	:x                      32
	:y                      88
	:group-type             :column
	:members                (group33 Add_AutoMnt_tf )
	:rows                   0
	:row-alignment          :top-edges
	:columns                1
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group34
	:x                      12
	:y                      7
	:group-type             :column
	:members                (Frame_path_tf Open_FM_Setting group35 )
	:rows                   0
	:row-alignment          :top-edges
	:columns                1
	:column-alignment       :labels
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   Pref_Apply_Button
	:owner                  controls1
	:help                   ""
	:x                      158
	:y                      260
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         pref_apply_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Pref_Panel Pref_Apply_Button)
		:when                   (Notify )
		:to                     (Pref_Panel Pref_Apply_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (pref_apply_button_proc)
		)
	)
)
(
	:type                   :button
	:name                   Pref_Reset_Button
	:owner                  controls1
	:help                   ""
	:x                      221
	:y                      260
	:width                  51
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Reset"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         pref_reset_button_proc
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (Pref_Panel Pref_Reset_Button)
		:when                   (Notify )
		:to                     (Pref_Panel Pref_Reset_Button)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (pref_reset_button_proc)
		)
	)
)
(
	:type                   :group
	:name                   group31
	:x                      158
	:y                      260
	:group-type             :row
	:members                (Pref_Apply_Button Pref_Reset_Button )
	:rows                   1
	:row-alignment          :top-edges
	:columns                0
	:column-alignment       :left-edges
	:horizontal-spacing     10
	:vertical-spacing       10
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
(
	:type                   :group
	:name                   group36
	:x                      12
	:y                      7
	:group-type             :column
	:members                (group34 group31 )
	:rows                   0
	:row-alignment          :top-edges
	:columns                1
	:column-alignment       :vertical-centers
	:horizontal-spacing     10
	:vertical-spacing       20
	:anchor-object          nil
	:anchor-point           :north-west
	:reference-point        :north-west
	:horizontal-offset      0
	:vertical-offset        0
	:user-data              ()
	:actions                ()
)
)
