/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/DTR/RCS/dtr.h,v 1.11 92/05/29 12:42:11 drapeau Exp $ */
/* $Log:	dtr.h,v $
 * Revision 1.11  92/05/29  12:42:11  drapeau
 * Modified code to track new name of the MAEstro "Selection" structure;
 * it is now named "MAESelection".
 * 
 * Revision 1.10  92/01/09  12:41:36  drapeau
 * Slight modifications to the code to make it ANSI-compliant.
 * 
 * Revision 1.0  92/01/06  17:47:11  drapeau
 * Made a number of cosmetic changes to make code easier to read and
 * to conform to programming specifications.
 * 
 * Revision 0.32  91/09/30  16:13:25  derek
 * DTR will now disconnect from the Port Manager when it quits.  Also,
 * a number of printf statements are removed.
 * 
 * Revision 0.31  91/09/18  22:47:46  derek
 * The following things are done:
 * 1.	The Makefile is changed corresponding to the changes in collab/.
 * 2.	Copyright messages included.
 * 3.	Some minor bugs fixed.
 * 
 * Revision 0.30  91/08/27  18:06:17  derek
 * The SizeToFit bug is fixed.
 * 
 * Revision 0.29  91/08/27  17:22:55  derek
 * The zooming bug is fixed in this version.
 * 
 * Revision 0.28  91/08/22  13:10:13  derek
 * I have added GetAppIcon().
 * 
 * Revision 0.27  91/08/21  11:34:36  derek
 * The following changes are made:
 * 1.	Now the duration and size of the recorded sound will be displayed
 * 	during recording.
 * 2.	I have changed GetSelection() corresponding to the request of Tek joo
 * 3.	Info Panel is added to the application.
 * 4.	Fixed SizeToFitHandler() so that when no file or buffer is currently
 * 	loaded, it would not do anything (except giving a warning
 * 	notice_prompt).
 * 5.	Inplemented the `Close' Menu option in the document menu.
 * 6.	Fixed the bug in which after ClearAll and I press PreviewEdit,
 * 	the edit wont be played.
 * 7.	I have made the changes corresponding to the change in OpenPanel's
 * 	name.  (from OpenPanel to Browse).
 * 8.	Incorporated BrowseCheck to check command line arg.
 * 9.	Changed most EditingStatusMessages to NoticePrompts.
 * 10.	SoundFileSaveAsPopUp and EditListSaveAsPopUp are removed 
 * 	from the application.
 * 
 * Revision 0.26  91/08/16  18:10:59  derek
 * 
 * The following things are done:
 * 1.	I have fixed an openpanel bug in my code in which I 
 * 	made the app return the wrong values to OpenHandler and
 * 	the SaveHandler.
 * 2.	The flashing color of the play button has been changed from
 * 	Red to Green.
 * 3.	Fixed a quantization bug: Buffer.play.end, when converted
 * 	from endingTimeInSec, should not exceed Buffer_hdr_data_size - 1.
 * 
 * Revision 0.25  91/08/14  16:14:23  derek
 * Fixed a few saving/appending bugs.
 * 
 * Revision 0.24  91/08/13  20:38:45  derek
 * The buttons (play, pause, record) will now flash after they are pressed.
 * This only applies to times when audio files (not edit-lists) are 
 * played.
 * 
 * Revision 0.23  91/08/08  11:02:29  derek
 * This is a cleaner version.  I have removed lots of printf/fprintf 
 * statements from it, and have also cleaned up the code using xsaber.
 * This version should run substantially faster.
 * 
 * Revision 0.22  91/08/07  16:25:00  derek
 * The Edit list part of DTR is done.  OpenPanel is also incorporated.
 * 
 * Revision 0.21  91/08/06  12:42:16  derek
 * Edit list panel is done.  Still need to link it to the network code.
 * 
 * Revision 0.20  91/07/31  14:51:13  derek
 * I have changed the user interface so that text fields like size and
 * duration will be displayed in normal (not bold) format.   I also fixed
 * a network bug.  In addition, I have added a routine to check how
 * much disk space is left in /usr/tmp.
 * 
 * Revision 0.19  91/07/30  11:45:55  derek
 * I have fixed the tmp file conflict bug.
 * 
 * Revision 0.18  91/07/29  15:10:37  derek
 * The playing w/o stopping error is fixed.
 * 
 * Revision 0.17  91/07/26  13:18:37  derek
 * Some saving bugs fixed.
 * 
 * Revision 0.16  91/07/24  12:52:20  derek
 * Disk editing is done.  Now the application can record sound infinitely,
 * as long as there is disk space available.  Command line args are also
 * supported.
 * 
 * Revision 0.15  91/07/23  21:25:52  derek
 * This version is not ready for release.  Disk space editing is half-done:
 * the application can play an infinite sound and the canvases can handle
 * infinite sound files.  The app is pretty bug free too, I think.  The
 * weakness is that it cannot record sond infinitely.
 * 
 * Revision 0.14  91/06/26  15:56:07  derek
 * I have reformatted the code to conform coding specs.
 * 
 * Revision 0.13  91/06/25  16:34:46  derek
 * The displaying of wrong pause message is fixed.
 * 
 * Revision 0.12  91/06/20  19:55:21  derek
 * The network part should be working.  Also fixed numerous minor parts
 * involving the canvas and the display.
 * 
 * Revision 0.11  91/06/05  14:59:30  derek
 * checking in after porting the code to collab
 * 
 * Revision 0.10  1991/04/25  01:47:16  derek
 * This version is checked in on 4/24/91
 * */
static char dtrHeaderRcsid[] = "$Header: /Source/Media/collab/DTR/RCS/dtr.h,v 1.11 92/05/29 12:42:11 drapeau Exp $";

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/panel.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/scrollbar.h>
#include <xview/cms.h>
#include <gdd.h>
#include <errno.h>
#include <math.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/dir.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <stropts.h>
#include <sys/ioctl.h>
#include <sys/vfs.h>

#include <multimedia/libaudio.h>
#include <multimedia/audio_device.h>
#include <multimedia/ulaw2linear.h>

#include <Sender.h>
#include <Receiver.h>

#include <Browse.h>

/*
 * Network Protocol stuff.
 */
extern	void		OpenDoc();
extern	void		SetSelection();
extern	void		PerformSelection();
extern	char		**GetDoc();
extern	MAESelection 	*GetSelection();
extern  void		HaltSelection();
extern	void		PauseSelection();
extern	void		ResumeSelection();
extern	void		HideApplication();
extern	void		ShowApplication();
extern  IconData	*GetAppIcon();
extern	void		InitNetwork();


Sender 		*sender;
Receiver	*receiver;
Port		senderPort;
int		ReceiverPortNumber;

char		currentSoundFile[MAXPATHLEN];


typedef	char    BOOL;
#define	TRUE	1
#define FALSE	0


/*
 * OpenPanel functions and variable.
 */
extern	int	OpenHandler();
extern	int	SaveHandler();

#define	IS_EDITLIST	1
#define	IS_SOUNDFILE	0	



/*
 * DEBUG mode!!
 */
/*#define DEBUG*/

/*
 * Some debugging routines.
 */
#ifdef DEBUG
#define EVENT(P)     \
  printf("Event: %s\tAP: %d\tAR: %d\tWaitFlag: %d\n", \
	 (P), ActiveFlag & PLAY, ActiveFlag & RECORD, \
	 WaitFlag)
#else
#define EVENT(P)
#endif

#define	PERROR(msg)	fprintf(stderr, "%s(%d): \"%s\" (%s)\n",	\
			    prog, __LINE__, msg, sys_errlist[errno]);

/*
 * Some global variables
 */
char	prog[20];
int	soundfd;
char	msg[200];
unsigned char   SndBuf[1024];					    /*  Sound buffer for holding segments of sound.     */

int	WaitFlag;						    /*  TRUE if either PLAY or RECORD.                  */
int	ActiveFlag;						    /*  TRUE if either PLAY or RECORD.                  */
BOOL    SoundBufferReady;
BOOL	FileReady;
BOOL    SameSoundFile;
BOOL    BufferSaved;

#define	PLAY	1
#define RECORD	2

int		Audioctl_fd;					    /*  fd for audio control device.                    */
int		Audio_fd;					    /*  fd for audio i/o device.                        */
int		Alert_fd;					    /*  fd for alert i/o                                */
int		Sync_sched;					    /*  sigpoll_sync_handler scheduled                  */
Audio_info	Audio_state;					    /*  audio device state structure                    */
Audio_hdr	Device_phdr;					    /*  Play configuration info                         */
Audio_hdr	Device_rhdr;					    /*  Record configuration info                       */
Audio_hdr       tmpSoundHdr;
int		tmpSoundFd;


#define	MAXLENGTH		200
#define AUDIO_DEV		"/dev/audio"
#define AUDIO_CTLDEV		"/dev/audioctl"
#define MAX_GAIN		(100)
#define	MAX_RECORD_TIME		(5 * 60)			    /*  Max record time in seconds                      */
#define DEVICE_SAMPLE_RATE	8000

/*
 * Global variables for Wave Canvas display.
 */
int     WaveCanvasWidth;
int     WaveCanvasHeight;
int     WaveWindowWidth;
int     WaveWindowHeight;
int     WaveCanvasMidHeight;
int     WaveScopeWidth;						    /*  This is the half height of the wave.            */
double  oldLeftFloatMarker;
double  oldRightFloatMarker;
BOOL    WaveCanvasRightMarkerSet;
char    WaveCanvasInitReady;
double  Zoom;
int     leftButtonHoldPoint;
double  WaveCanvasDataSamplingInterval;				    /*  Buffer.hdr.data_size / WaveWindowWidth          */
double  DefaultWaveCanvasDataSamplingInterval;
double	FrameStartingSecond;					    /*  This is the time (in second) at which the...    */
								    /*  ...window starts.                               */


/*
 * Global variables for Global Wave Canvas Display.
 */
int     GlobalWaveCanvasWidth;
int     GlobalWaveCanvasHeight;
int     GlobalWaveWindowWidth;
int     GlobalWaveWindowHeight;
int     GlobalWaveCanvasMidHeight;
int     GlobalWaveScopeWidth;					    /*  This is the half height of the wave.            */
char    GlobalWaveCanvasInitReady;
double  oldLeftFloatGbWaveMarker;
double  oldRightFloatGbWaveMarker;
BOOL    GlobalWaveCanvasRightMarkerSet;
int     GbWaveLeftButtonHoldPoint;
double  GlobalWaveCanvasDataSamplingInterval;

BOOL    CanUndo;


/*
 * Global variables for recording.
 */
char	SoundFileInTmp[40];


/*
 * Global variables for Scale Canvas Display.
 */
int     ScaleWindowHeight;


#define MAX_ZOOM  5						    /*  MAX_ZOOM is in terms of real zoom value.        */
#define NOTREADY  -1
#define GLOW_INTERVAL 0.5

/*
 * macros for VUMeter
 */
#define SCOPE_WIDTH 256
#define SCOPE_MASK  (SCOPE_WIDTH - 1)

struct sound_buffer {
    Audio_hdr	hdr;						    /*  encoding info.                                  */
    char	info[MAXLENGTH];
    char	filename[MAXLENGTH];
    int         headersize;					    /*  size of the header.                             */
    
    unsigned char	*data;					    /*  ptr to data buffer.                             */
    unsigned	alloc_size;					    /*  size of data buffer.                            */
    unsigned char       *olddata;				    /*  ptr to old data buffer.                         */
    unsigned    old_alloc_size;					    /*  size of olddata buffer.                         */
    unsigned    old_hdr_data_size;
    int		hdr_size;
    int		draining;
    int		paused;

    struct {
	time_t		modified;
	struct direct	**files;
	Menu		menu;
    }			menu;					    /*  cached menu.                                    */

    struct {
	unsigned	start;					    /*  selected region to play.                        */
	unsigned	end;
	unsigned	io_position;
    }			play;
    struct {
	int	cursor_pos;					    /*  cursor position in buffer                       */
	int	start;						    /*  marks selected region                           */
	int	end;
	int	position;
	int	last;
    }			display;
} Buffer;


struct cut_buffer {
    unsigned    alloc_size;
    unsigned char       *data;
} CutBuffer;


extern	char	*sys_errlist[];

/*
 * audio.c
 */
extern	 void   	InitAudio();
extern   void	        InitAudioControl();
extern   int	        AudioOpen();
extern   Notify_value	SigpollAsyncHandler();
extern   Notify_value	SigpollSyncHandler();
extern   BOOL	        AudioReadState();
extern   void	        AudioUpdatePanel();
extern   void	        AudioFlushClose();
extern   int            UnscaleGain();
extern   double         ScaleGain();
extern	 void		SetPlayGain();
extern	 void		UpdateRecordingMessageDisplay();


/*
 * play.c
 */
extern   void	        Play();
extern   void	        StartPlay();
extern   void	        PlayService();
extern   void		StopPlay();
extern   void	        StopRecord();
extern   void	        PlayUpdateCursor();

/*
 * buffer.c
 */
extern   void	        InitBuffer();
extern   BOOL		ReadSoundFile(BOOL intoBuffer);
extern   void		FileUpdate();
extern	 BOOL		IsTmpSoundFile();
extern	 unsigned char  GetFileData();

/*
 * dtrutils.c
 */
extern	void		Alert();
extern	void    	ClearStatusMessage();
extern	void    	ClearMessageDisplay();
extern	BOOL		NullFileName();
extern	void		AlertByNoticePrompt();
extern	Notify_value	DestroyMainWindow();
extern	void		UpdateHeader(int modified);
extern	void		UpdateEditListHeader(int modified);

/*
 * pause.c
 */
extern   void    	Pause();

/*
 * record.c
 */
extern   void    	StartRecord();
extern   void  		RecordService();
extern   void    	StopRecord();
extern	 void		InitRecord();
extern	 void		RemoveSoundFileInTmp();


/*
 * save.c
 */
extern   int	    	SaveSoundFile();


/*
 * display.c
 */
extern   void    	InitDisplay();
extern   void           DisplaySoundDuration();
extern   void    	DisplaySoundSelectionDuration();
extern   void           DisplaySoundSize();
extern   void           DisplaySoundSelectionSize();
extern   void    	UpdateMessageDisplay();
extern   void		UpdateZoomLevelDisplay();
extern	 void		UpdateSpaceOnTmp();
extern	 void		UpdateButtonGlow();
extern	 void		CancelButtonGlow();

int	RedColorIndex;
int	BlackColorIndex;
int	GreenColorIndex;


/*
 * canvas.c
 */
extern   void    	RepaintWaveCanvas();
extern   void    	InitWaveCanvas();
extern   void		InitScaleCanvas();
extern   void    	InitWaveCanvasScrollbar();
extern   void           InitScaleCanvasScrollbar();
extern   Notify_value   WaveCanvasScrollBarHandler();
extern   void  		ResetWaveCanvas();
extern   void    	ClearWaveCanvas();
extern   void		ClearScaleCanvas();
extern   void    	WaveCanvasMarkerHandler();
extern   void           WaveCanvasBackwardMarkerHandler();
extern   unsigned long* GetColormap();
extern   int     	GetColorIndex();
extern   void    	WaveCanvasPenColor();
extern	 void		ScaleCanvasPenColor();
extern   void		WaveCanvasRepaintHandler();
extern   void		ResetWaveCanvasMarkers();
extern   void           ReverseWaveCanvasArea();
extern   void           UpdateCanvasesAndScrollbarParameters();
extern   void           CenterWaveCanvasHighlightedSegment();
extern   void		HighlightWaveCanvas();
extern   void    	InitVUMeterCanvas();
extern   void    	UpdateVUMeter();
extern   void    	ClearVUMeterCanvas();
extern   void           VUMeterCanvasPenColor();
extern   void           ResetVUMeter();
extern	 void		CalculateLevelAndDisplayVUMeter();
extern	 void		ScaleCanvasRepaintHandler();

extern   void	        ClearAllSound();


/*
 * editlist.c
 */
#define	USER			1
#define NON_USER		0
#define NO_CURRENT_EDIT		-1
#define DEFAULT_EDITLIST_SIZE	50

struct editList
{
  int   	capacity;
  int		numItems;
  char		**soundFile;
  char		**label;
  int		*startingMin;
  double	*startingSec;
  int		*endingMin;
  double	*endingSec;
  int		*volume;
} EditList;

extern	 void		InitEditList();
extern	 void		ReallocateMemoryForEditList();
extern	 int		ReadEditListFromFile();
extern	 void		DeselectList();
extern	 int		WriteEditListToFile();
extern	 void		ResetCurrentSelection();
extern	 void		EmptyList();
extern	 void		UpdateNumEditsMessage();
extern	 void		SetCurrentSelection();
extern	 char		*FormatEntry();
extern	 void		NewEditList();
extern	 void		DeleteAllSelections();
extern	 void		RedrawEditList();
extern	 void		DeleteItemFromEditList();
extern	 void		DeleteSelection();
extern	 void		ModifySelection();
extern	 void		AddSelection();
extern	 void		SetEditList(char* editListName);
extern	 void		SetScrollListFont();
extern   void           EnableEditListPanel();
extern   void           DisableEditListPanel();


BOOL	 unsavedChangesExist;
char	 absoluteEditListName[MAXPATHLEN];
int      currentSelection;					    /*  This flag indicates the current selection... */
								    /*  ...number (in the internal EditList data...  */
								    /*  ...structure.                                */
BOOL	 currentSelectionReadyToPlay;				    /*  This flag is set to be true after...         */
								    /*  SetCurrentSelection() is called.  If the...  */
								    /*  selection on the canvas is changed etc., ... */
								    /*  ...this flag will be set to FALSE.           */

/*
 * gbcanvas.c
 */
extern   void    	RepaintGlobalWaveCanvas();
extern   void    	InitGlobalWaveCanvas();
extern   void  		ResetGlobalWaveCanvas();
extern   void    	ClearGlobalWaveCanvas();
extern   void    	GlobalWaveCanvasMarkerHandler();
extern   void           GlobalWaveCanvasBackwardMarkerHandler();
extern   unsigned long* GlobalWaveCanvasGetColormap();
extern   void    	GlobalWaveCanvasPenColor();
extern   void		GlobalWaveCanvasRepaintHandler();
extern   void		ResetGlobalWaveCanvasMarkers();
extern   void           ReverseGlobalWaveCanvasArea();
extern   void           UpdateCanvasFrame();
extern	 void		DisplayCanvasFrame();


/*
 * openpanel.c
 */
extern	 void		InitOpenPanel();
extern	 int		OpenHandler();
extern	 int		SaveHandler();

char	 *documentFirstLine;
char	 *documentFileType;

#define	FILE_OK		0
#define	FILE_NOT_OK	-1


/*
 * waveedit.c
 */
extern   void           WaveCutHandler();
extern   void           WaveCopyHandler();
extern	 void		WavePasteHandler();
extern   void           AllocCutBuffer();
extern	 void		SetWaveEditModeOn();
extern	 void		SetWaveEditModeOff();
extern	 void		InitWaveEditVariables();

BOOL	  		WaveEditMode;				    /*  Flag indicating whether wave-edit mode is on.   */


/*
 * timer.c
 */
extern   Notify_value   VUMeterTimerHandler();
extern   void    	SetVUMeterTimer();
extern   void    	CancelVUMeterTimer();
extern   Notify_value   ButtonGlowTimerHandler();
extern   void    	SetButtonGlowTimer();
extern   void    	CancelButtonGlowTimer();


/*
 * dtr.c
 */
void	UpdateSelection();
