
/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * fademask.c - fade two images using a mask. 
 *
 * Author:      Raul Rivero
 *              Vicerrectorado de Estudiantes 
 *              University of Oviedo
 * Date:        Thu Jan 06 1993
 * Copyright (c) 1993, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

extern int LUGverbose;
extern char *MY_NAME; 

main( argc, argv )
int argc;
char **argv;
{
  int i;
  bitmap_hdr base, super, mask, out;

  MY_NAME = argv[0];

   /*
   * Get options ( some day I'll build a procedure ).
   */
  if ( argc > 1 ) {             /* else core on SGI */
    while ( argv[1][0] == '-' ) {
      for ( i = 1; argv[1][i]; i++ ) {
        switch ( argv[1][i] ) {
                case 'v':
                        LUGverbose++;
                        break;
                default :
                        fprintf( stderr, "Usage: %s [-v] <input_image> <output_base_name> <#_of_frames>\n",
                                 MY_NAME );
                        exit( 0 );
                        break;
        }
      }
      argv++;
      argc--;
    }
  }

  if ( argc < 4 ) {
    fprintf( stderr, "Usage: %s [-v] <base_image> <super_image> <mask_image> [<output_image>]\n",
             MY_NAME );
    exit( 0 );
  }

  /* Read the input files */
  read_lug_file( argv[1], &base );
  read_lug_file( argv[2], &super );
  read_lug_file( argv[3], &mask );
  

  /* We wanna a true color image. Why?. Ok, it's my program! :-) */
  if ( base.depth < 24 || super.depth < 24 || mask.depth < 24 )
   error( 7 ); 

  /* Calculate the image */ 
  fade_mask( &base, &super, &mask, &out );

  /* And write it */
  if ( argc > 4 )
    write_lug_file( argv[4], &out );
  else write_alias_file( argv[4], &out );

}


#ifndef ULTIMO_LUG

RGB_to_BW( r, g, b )
int r, g, b;
{
  return( (int) ((30*r + 59*g + 11*b) / 100));
}

#endif
