#include <LEDA/graph.h>
#include <LEDA/ugraph.h>
#include <LEDA/graph_alg.h>


main(int argc, char** argv)
{
  GRAPH<string,double> G;

  cmdline_graph(G,argc,argv);

  node s = G.first_node();
  node t = G.last_node();

  float T = used_time();

  cout << "node/edge arrays     ";
  cout.flush();

  edge_array<int>  cost(G);
  node_array<int>  dist(G);
  node_array<edge> pred(G);

  node_array<int>  ord(G);
  node_array<int>  compnum(G);
  edge_array<int>  flow(G) ;
  node_array<int>  reached(G,false);
  node_array<int>  dfs_num(G);
  node_array<int>  comp_num(G);
  node_array<int>  layer(G,-1);

  cout << string("%6.2f sec\n",used_time(T));


  cout << "UGRAPH(string,double)";
  cout.flush();
  UGRAPH<string,double> U = G;
  cout << string("%6.2f sec\n",used_time(T));

  node_array<int> compnum1(U);

  edge e;

  cout << "edge labels          ";
  cout.flush();
  init_random();
  forall_edges(e,G)  G[e] = cost[e] = random(0,1000);
  cout << string("%6.2f sec\n",used_time(T));

  newline;

  cout << "TOPSORT              ";
  cout.flush();
  TOPSORT(G,ord); 
  cout << string("%6.2f sec\n",used_time(T));

  cout << "DFS                  ";
  cout.flush();
  DFS(G,G.choose_node(),reached);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "DFS_NUM              ";
  cout.flush();
  DFS_NUM(G,dfs_num,comp_num);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "BFS                  ";
  cout.flush();
  BFS(G,G.first_node(),layer);
  cout << string("%6.2f sec\n",used_time(T));


  cout << "COMPONENTS           ";
  cout.flush();
  COMPONENTS(U,compnum1);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "COMPONENTS1          ";
  cout.flush();
  COMPONENTS1(U,compnum1);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "STRONG_COMPONENTS    ";
  cout.flush();
  STRONG_COMPONENTS(G,compnum);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "TRANSITIVE_CLOSURE   ";
  cout.flush();
  TRANSITIVE_CLOSURE(G);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "SPANNING_TREE        ";
  cout.flush();
  SPANNING_TREE(G);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "MIN_SPANNING_TREE    ";
  cout.flush();
  MIN_SPANNING_TREE(G,cost);
  cout << string("%6.2f sec\n",used_time(T));

  cout << "DIJKSTRA <int>       ";
  cout.flush();
  DIJKSTRA(G,s,cost,dist,pred);
  cout << string("%6.2f sec  \n",used_time(T));

  cout << "BELLMAN_FORD<int>    ";
  cout.flush();
  BELLMAN_FORD(G,s,cost,dist,pred);
  cout << string("%6.2f sec  \n",used_time(T));

  /*
  cout << "ALL PAIRS<int>       ";
  cout.flush();
  ALL_PAIRS_SHORTEST_PATHS(G,cost,M);
  cout << string("%6.2f sec\n",used_time(T));
  */

  cout << "MAX_FLOW<int>        ";
  cout.flush();
  MAX_FLOW(G,s,t,cost,flow) ;
  cout << string("%6.2f sec\n",used_time(T));

  cout << "MAX_CARD_MATCHING    ";
  cout.flush();
  MAX_CARD_MATCHING(G);
  cout << string("%6.2f sec\n",used_time(T));

  newline;
  cout << "TOTAL TIME           ";
  cout << string("%6.2f sec\n",used_time());

  return 0;
}
