#include <LEDA/impl/skiplist.h>
#include <LEDA/impl/rs_tree.h>
#include <LEDA/impl/ab_tree.h>
#include <LEDA/impl/bb_tree.h>
#include <LEDA/impl/rb_tree.h>
#include <LEDA/impl/ch_hash.h>
#include <LEDA/impl/dp_hashing.h>

struct int_rs_tree : public rs_tree
{ int int_type() const { return 1; }
 };

struct int_skiplist : public skiplist
{ int int_type() const { return 1; }
 };

struct int_rb_tree : public rb_tree
{
int int_type() const { return 1; }
 };

struct int_ch_hash : public ch_hash
{
int int_type() const { return 1; }
 };


#define DIC_TEST(type,D)\
  type D;\
  for(i=0; i<N; i++) D.insert(GenPtr(RAND[i]),0);\
  cout << string("%10.2f",used_time(T));\
  cout.flush();\
\
  for(i=0; i<N; i++)  D.lookup(GenPtr(RAND[i]));\
  cout << string("%10.2f",used_time(T));\
  cout.flush();\
\
  for(i=0; i<N; i++)  D.del(GenPtr(RAND[i]));\
  cout << string("%10.2f",used_time(T));\
\
  cout << string("%10.2f     size = %d",used_time(T0),D.size());\
  newline;

main()

{ int  N = read_int("# keys = ");
  int* RAND = new int[N];
  int  i;

  init_random(654321);
  for(i=0; i<N; i++) RAND[i] = random(0,MAXINT-1);

  newline;
  cout << "                  insert    lookup    delete     total\n";
  newline;

  float T  = used_time();
  float T0 = T;

  cout << "rs_tree<int>  ";
  cout.flush();
  DIC_TEST(int_rs_tree,RST)

  cout << "skiplist<int> ";
  cout.flush();
  DIC_TEST(int_skiplist,SKIP)

  cout << "rb_tree<int>  ";
  cout.flush();
  DIC_TEST(int_rb_tree,RB_TREE)

  cout << "ch_hash       ";
  cout.flush();
  DIC_TEST(int_ch_hash,CH)

  cout << "dphash        ";
  cout.flush();
  DIC_TEST(dphash,DPH)

  newline;

  cout << "rs_tree       ";
  cout.flush();
  DIC_TEST(rs_tree,DRST)

  cout << "skiplist      ";
  cout.flush();
  DIC_TEST(skiplist,DSKIP)

  cout << "rb_tree       ";
  cout.flush();
  DIC_TEST(rb_tree,DRB)

  cout << "ch_hash       ";
  cout.flush();
  DIC_TEST(ch_hash,DCH)


/*
  cout << "bb_tree       ";
  cout.flush();
  DIC_TEST(bb_tree,BB_TREE)

  cout << "ab_tree       ";
  cout.flush();
  DIC_TEST(ab_tree,AB_TREE)
*/

  return 0;
}
