/*******************************************************************************
+
+  LEDA  3.0
+
+
+  sortseq.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_SORTSEQ_H
#define LEDA_SORTSEQ_H

#include <LEDA/impl/ab_tree.h>

typedef ab_tree_node* seq_item;


template<class keytype, class inftype>

class _CLASSTYPE sortseq : public ab_tree {

int  int_type()              const { return INT_TYPE(keytype); }
int  cmp(GenPtr x, GenPtr y) const
                     { return compare(ACCESS(keytype,x),ACCESS(keytype,y)); }
void clear_key(GenPtr& x)   const { Clear(ACCESS(keytype,x)); }
void clear_inf(GenPtr& x)   const { Clear(ACCESS(inftype,x)); }
void copy_key(GenPtr& x)    const { x = Copy(ACCESS(keytype,x)); }
void copy_inf(GenPtr& x)    const { x = Copy(ACCESS(inftype,x)); }
void print_key(GenPtr x)    const { Print(ACCESS(keytype,x),cout); }
void print_inf(GenPtr x)    const { Print(ACCESS(inftype,x),cout); }

public:

virtual keytype  key(seq_item it) const { return ACCESS(keytype,ab_tree::key(it)); }
virtual inftype  inf(seq_item it) const { return ACCESS(inftype,ab_tree::inf(it)); } 

virtual seq_item lookup(keytype y) const { return ab_tree::lookup(Convert(y)); }
virtual seq_item locate(keytype y) const { return ab_tree::locate(Convert(y)); }
virtual seq_item locate_pred(keytype y) const { return ab_tree::locate_pred(Convert(y)); }

virtual seq_item succ(seq_item x) const { return ab_tree::succ(x); }
virtual seq_item succ(keytype y) const { return locate(y); }

virtual seq_item pred(seq_item x) const { return ab_tree::pred(x); }
virtual seq_item pred(keytype y) const { return locate_pred(y); }

virtual seq_item insert(keytype y,inftype x)
                         { return ab_tree::insert(Convert(y),Convert(x)); } 

virtual seq_item insert_at(seq_item it,keytype y,inftype x)
{ return ab_tree::insert_at_item(it,Convert(y),Convert(x)); } 

virtual void reverse_items(seq_item a, seq_item b) { ab_tree::reverse_items(a,b); }
virtual void flip_items(seq_item a, seq_item b)    { reverse_items(a,b); }

virtual void del(keytype y)         { ab_tree::del(Convert(y)); } 
virtual void del_item(seq_item it)  { ab_tree::del_item(it); } 
virtual void change_inf(seq_item it, inftype i) { ab_tree::change_inf(it,Convert(i));}
virtual void split(seq_item x,sortseq& S1,sortseq& S2)
                      { ab_tree::split_at_item(x,(ab_tree&)S1,(ab_tree&)S2); }

virtual sortseq& conc(sortseq& S) { ab_tree::conc((ab_tree&)S); return *this; }

sortseq()    {}
sortseq(const sortseq& w) : ab_tree(w) {}

sortseq& operator=(const sortseq& w)
{ ab_tree::operator=(w); return *this; }

virtual ~sortseq()   { clear(); }
} ;



//------------------------------------------------------------------------------
//
// Sorted sequences with implementation parameter:
//
//   _sortseq<keytype,inftype,seq_impl> 
//
//------------------------------------------------------------------------------

#define _sortseq_class(ktype,itype,impl)\
\
class _CLASSTYPE _sortseq_(ktype,itype,impl) : public impl, public sortseq<ktype,itype>\
{\
int int_type() const { return INT_TYPE(ktype); }\
\
int cmp(GenPtr x, GenPtr y) const\
{ return compare(ACCESS(ktype,x),ACCESS(ktype,y)); }\
void clear_key(GenPtr& x) const { Clear(ACCESS(ktype,x)); }\
void clear_inf(GenPtr& x) const { Clear(ACCESS(itype,x)); }\
void copy_key(GenPtr& x) const { x = Copy(ACCESS(ktype,x)); }\
void copy_inf(GenPtr& x) const { x = Copy(ACCESS(itype,x)); }\
void print_key(GenPtr x) const { Print(ACCESS(ktype,x),cout); }\
void print_inf(GenPtr x) const { Print(ACCESS(itype,x),cout); }\
\
public:\
\
ktype key(seq_item it) const { return ACCESS(ktype,impl::key(impl::item(it))); }\
itype inf(seq_item it) const { return ACCESS(itype,impl::inf(impl::item(it))); }\
\
seq_item lookup(ktype y) const { return (seq_item)impl::lookup(Convert(y)); }\
seq_item locate(ktype y) const { return (seq_item)impl::locate(Convert(y)); }\
seq_item locate_pred(ktype y) const { return (seq_item)impl::locate_pred(Convert(y)); }\
\
seq_item succ(seq_item x) const { return (seq_item)impl::succ(impl::item(x)); }\
seq_item succ(ktype y) const { return locate(y); }\
\
seq_item pred(seq_item x) const { return (seq_item)impl::pred(impl::item(x)); }\
seq_item pred(ktype y) const { return locate_pred(y); }\
\
seq_item insert(ktype y,itype x)\
{ return (seq_item)impl::insert(Convert(y),Convert(x));}\
\
seq_item insert_at(seq_item it,ktype y,itype x)\
{ return (seq_item)impl::insert_at_item(impl::item(it),Convert(y),Convert(x));}\
void reverse_items(seq_item a, seq_item b) { impl::reverse_items(impl::item(a),impl::item(b)); }\
void flip_items(seq_item a, seq_item b) { reverse_items(a,b); }\
\
void del(ktype y) { impl::del(Convert(y)); }\
void del_item(seq_item it) { impl::del_item(impl::item(it)); }\
void change_inf(seq_item it, itype i) { impl::change_inf(impl::item(it),Convert(i));}\
\
void split(seq_item it,sortseq<ktype,itype>& S1,sortseq<ktype,itype>& S2)\
{ impl::split_at_item(impl::item(it),*(impl*)&S1,*(impl*)&S2); }\
\
sortseq<ktype,itype>& conc(sortseq<ktype,itype>& S)\
{ impl::conc(*(impl*)&S); return *this; }\
\
_sortseq_(ktype,itype,impl)() {}\
_sortseq_(ktype,itype,impl)(const _sortseq_(ktype,itype,impl)& S) : impl(S) {}\
\
_sortseq_(ktype,itype,impl)& operator=(const _sortseq_(ktype,itype,impl)& S)\
{ impl::operator=(S); return *this; }\
\
~_sortseq_(ktype,itype,impl)() { impl::clear(); }

#if defined(__TEMPLATE_ARGS_AS_BASE__)
#define _sortseq_(a,b,c) _sortseq
template <class ktype, class itype, class impl> 
_sortseq_class(ktype,itype,impl)
};
#else
#define _sortseq(a,b,c)         name4(a,b,c,_sortseq)
#define _sortseq_(a,b,c)        name4(a,b,c,_sortseq)
#define _sortseqdeclare3(_a,_b,_c) _sortseq_class(_a,_b,_c) };
#endif

#endif
