/*******************************************************************************
+
+  LEDA  3.0
+
+
+  segment.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_SEGMENT_H
#define LEDA_SEGMENT_H

#include <LEDA/point.h>

//------------------------------------------------------------------------------
// segments
//------------------------------------------------------------------------------


class segment_rep : public handle_rep {

friend class segment;
friend class line;
friend class circle;
   
   point start;
   point end;
   
   segment_rep(point p, point q);
   segment_rep();  

  ~segment_rep() {}

   
   LEDA_MEMORY(segment_rep)
   
};


class segment  : public handle_base 
{

friend class line;
friend class circle;

segment_rep* ptr() const { return (segment_rep*)PTR; }

public:

 segment();                 
 segment(point x, point y); 
 segment(double x1, double y1, double x2, double y2) ;
 segment(point p, double alpha, double length);
 segment(const segment& s) : handle_base(s) {}     
~segment()                { clear(); }

segment& operator=(const segment& s) { handle_base::operator=(s); return *this;}

operator vector()  { return vector(xcoord2()-xcoord1(), ycoord2()-ycoord1()); }

bool intersection(segment s, point& inter);

point start()  const      { return ptr()->start; }
point end()    const      { return ptr()->end; }

double xcoord1()          { return ptr()->start.ptr()->x; }
double xcoord2()          { return ptr()->end.ptr()->x;   }
double ycoord1()          { return ptr()->start.ptr()->y; }
double ycoord2()          { return ptr()->end.ptr()->y;   }

segment translate(double,double);
segment translate(const vector&);

double  angle(segment);
double  angle();
double  direction()       { return angle();}
double  distance(segment);
double  distance(point);
double  distance();
double  slope();
double  x_proj(double);
double  y_proj(double);
double  y_abs();
double  length();

segment rotate(double);
segment rotate(point,double);

bool  vertical();
bool  horizontal();

bool  right()            { return ptr()->start.ptr()->x < ptr()->end.ptr()->x; }
bool  left()             { return ptr()->start.ptr()->x > ptr()->end.ptr()->x; }
bool  up()               { return ptr()->start.ptr()->y < ptr()->end.ptr()->y; }
bool  down()             { return ptr()->start.ptr()->y > ptr()->end.ptr()->y; }

segment operator+(const vector& v) { return translate(v); }

int operator==(const segment& s) 
{ return (ptr()->start == s.ptr()->start && ptr()->end == s.ptr()->end); }

int operator!=(const segment& s) { return !operator==(s);}

friend ostream& operator<<(ostream& out, const segment& s);
friend istream& operator>>(istream& in, segment& s);

friend void Print(const segment&, ostream&  =cout);
friend void Read(segment&,  istream& =cin);

};

inline void Print(const segment& s, ostream& out) { out << s; } 
inline void Read(segment& s,  istream& in)        { in >> s; }

LEDA_HANDLE_TYPE(segment)



//------------------------------------------------------------------------------
// SEGMENT(cmp): segments with user defined linear order cmp
//------------------------------------------------------------------------------

typedef int (*CMP_SEGMENT_TYPE)(segment,segment);


template <CMP_SEGMENT_TYPE cmp>

struct _CLASSTYPE SEGMENT : public point 
{  SEGMENT(segment  p )         : segment(p)   {}
   SEGMENT(SEGMENT& p)     : segment(p)   {}
   SEGMENT() {}
 ~ SEGMENT() {}
friend int compare(SEGMENT<cmp>& x, SEGMENT<cmp>& y) { return cmp(x,y); }
};


#endif
