/*******************************************************************************
+
+  LEDA  3.0
+
+
+  polygon.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_POLYGON_H
#define LEDA_POLYGON_H

#include <LEDA/point.h>
#include <LEDA/segment.h>
#include <LEDA/line.h>

//------------------------------------------------------------------------------
// polygons
//------------------------------------------------------------------------------



class polygon_rep : public handle_rep {

friend class polygon;

  list<segment> seg_list;

  polygon_rep() { }
  polygon_rep(list<segment> L) { seg_list = L; }

 ~polygon_rep() {}
   
  LEDA_MEMORY(polygon_rep)
   
};


class list_polygon_;


class polygon   : public handle_base 
{

polygon_rep* ptr() const { return (polygon_rep*)PTR; }

bool check();

public:

 polygon();
 polygon(list<point>&, bool=true);

 polygon(const polygon& P) : handle_base(P) {}

~polygon()                { clear(); }

polygon& operator=(const polygon& P) { handle_base::operator=(P); return *this;}


list<point>   vertices() const;  
list<segment> segments() const { return ptr()->seg_list; }

bool          inside  (point p); 
bool          outside (point p); 

list<point>   intersection(segment s);
list<point>   intersection(line l);  
list_polygon_ intersection(polygon P);

polygon       translate(double, double);
polygon       translate(const vector&);

polygon       rotate(point, double);
polygon       rotate(double);

int         size()                  { return ptr()->seg_list.size(); }
bool        empty()                 { return ptr()->seg_list.empty(); }

polygon operator+(const vector& v) { return translate(v); }

friend ostream& operator<<(ostream& out, const polygon& p);
friend istream& operator>>(istream& in,  polygon& p);

friend void Print(const polygon&, ostream& = cout);
friend void Read(polygon&, istream& = cin);

};

inline void Print(const polygon& P, ostream& out) { out << P; } 
inline void Read(polygon& P, istream& in)         { in  >> P; }

LEDA_HANDLE_TYPE(polygon)


struct list_polygon_: public list<polygon>
{
  list_polygon_(const list<polygon>& L) : list<polygon>(L) {}
};


//------------------------------------------------------------------------------
// POLYGON<cmp>: polygons with user defined linear order cmp
//------------------------------------------------------------------------------

typedef int (*CMP_POLYGON_TYPE)(polygon,polygon);


template <CMP_POLYGON_TYPE cmp>

struct _CLASSTYPE POLYGON : public polygon 
{  POLYGON(polygon  p )         : polygon(p)   {}
   POLYGON(POLYGON& p)     : polygon(p)   {}
   POLYGON() {}
 ~ POLYGON() {}
friend int compare(POLYGON<cmp>& x, POLYGON<cmp>& y) { return cmp(x,y); }
};


#endif 
