/*******************************************************************************
+
+  LEDA  3.0
+
+
+  b_queue.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_BQUEUE_H
#define LEDA_BQUEUE_H

//------------------------------------------------------------------------------
// bounded queues
//------------------------------------------------------------------------------

#include <LEDA/basic.h>


template<class type> 

class _CLASSTYPE b_queue  
{
        type* v;
        int n;
        int start;
        int end;
public:										
b_queue(int s) 
{ if (s<1) error_handler(88,"_b_queue: bad size");
  n = s+1; 
  v = new type[n];
  if (v==0) error_handler(88,"_b_queue: out of memory");
  start = end = 0; 
}

virtual ~b_queue() {}

int empty() const { return (size()==0) ? true : false; }

int size() const 
{ int s = end-start;
  return (s<0) ?  (n+s) : s;
}

void append(type& a)
{ v[end++] = a;
  end %= n;
  if (start==end) error_handler(88, "_b_queue overflow");
}

type pop()
{ if (start==end) error_handler(88, "_b_queue underflow");
  type x = v[start];
  start = (start+1) % n;
  return x;
}

type top() const
{ if (start==end) error_handler(88, "_b_queue empty");
  return v[start];
}

void clear() { start = end = 0; }

};

#endif
