 /*
  * Khoros: $Id: xvhelp.c,v 1.1 1991/05/10 16:00:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: xvhelp.c,v 1.1 1991/05/10 16:00:03 khoros Exp $";
#endif

 /*
  * $Log: xvhelp.c,v $
 * Revision 1.1  1991/05/10  16:00:03  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: xvhelp.c
 >>>>
 >>>>      Program Name: xvhelp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program an X window widget which displays the help file
 >>>>	specified,  and  allows  the user to read and scroll through
 >>>>	the help page.
 >>>>	
 >>>>	
 >>>>            Author: Stephanie Hallett and Danielle Argiro
 >>>>
 >>>> Date Last Updated: Tue Apr  2 16:26:20 1991
 >>>>
 >>>>          Routines: main- the main program for xvhelp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvhelp.h"


/****************************************************************
 *
 * Routine Name:  main program for xvhelp
 *
 *       Input:  
 *        -i  Help File 
 *
 *
 *        [-t] title of help box
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

        consolidate_args();

        display = xvf_initialize(ac,av, "xvhelp");

        if (xvhelp->t != NULL)
        {
           if (strcmp(xvhelp->t,"") == 0)
            xvhelp->t = NULL;
        }
        xvf_online_help_wait(xvhelp->i,xvhelp->t);

/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for xvhelp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "xvhelp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program an X window widget which displays the help file\n");
	fprintf(stderr, "\tspecified,  and  allows  the user to read and scroll through\n");
	fprintf(stderr, "\tthe help page.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  Help File  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t]  title of help box (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for xvhelp\n");
	fprintf(stderr, "\t[-U] Gives the usage for xvhelp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called xvhelp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses xvhelp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for xvhelp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) Help File \n        {infile}: "; 
char	*t_pstr = 
	"\nEnter: (t) title of help box \n        {string}: "; 
char	*t_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "xvhelp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "xvhelp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "xvhelp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "xvhelp.ans");
		}

	     }

	}

	/*
	 * allocate the xvhelp structure
	 */
	xvhelp = (xvhelp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (xvhelp_struct));

	/*
	 * get required arguments for xvhelp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(xvhelp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(xvhelp->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(xvhelp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    xvhelp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(xvhelp->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for xvhelp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	xvhelp->t_flag = vget_string(fid, prompt_flag,
	"-t", t_pstr, &(xvhelp->t),
	t_def);

	if (prompt_flag == FALSE)
	{
	    if ((xvhelp->t_flag == 1)&&(xvhelp->t == NULL))
    	{
		fprintf(stderr, "xvhelp:\n");
		fprintf(stderr, "you must specify a name following '-t'\n");
		gw_usage();
		exit(1);
		}
	}

}



