 /*
  * Khoros: $Id: editimage.c,v 1.3 1992/03/20 22:38:23 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: editimage.c,v 1.3 1992/03/20 22:38:23 dkhoros Exp $";
#endif

 /*
  * $Log: editimage.c,v $
 * Revision 1.3  1992/03/20  22:38:23  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: editimage.c
 >>>>
 >>>>      Program Name: editimage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Interactive Image Display and Manipulation Program
 >>>>	
 >>>>	

 >>>>            Author: Mark Young, Stephanie Hallett, Danielle Argiro
 >>>>
 >>>> Date Last Updated: Fri Mar  6 10:39:17 1992
 >>>>
 >>>>          Routines: main- the main program for editimage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "editimage.h"


/****************************************************************
 *
 * Routine Name:  main program for editimage
 *
 *       Input:  
 *
 *
 *           [-i] input image filename
 *           [-ov] overlay image filename
 *           [-s] input shape mask filename
 *           [-c] input clip mask filename
 *           [-roi_out] output ROI filename
 *           [-x] x value of upper-left corner of editimage user interface  (-1 < value < 1000)
 *           [-y] y value of upper-left corner of editimage user interface  (-1 < value < 1000)
 *           [-zoom] initial zoom factor  (value > 0.0)
 *           [-update] initial update time  (value >= 0.0)
 *           [-display] host:display.screen
 *           [-form] editimage form
 *           [-cmap_image] image with alternate colormap filename
 *           [-use_cmap] use colormap?
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        float   update = 0.0;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args();
/* -main_before_lib_call_end */

/* -main_library_call */

        if (editimage->update_flag)
           update = editimage->update;

        if (!(leditimage(argv, argc, program, editimage->i, editimage->ov,
                         editimage->s, editimage->c, editimage->roi_out,
                         editimage->zoom, update, editimage->display, 
                         editimage->form, editimage->use_cmap, 
                         editimage->cmap_image, editimage->x, editimage->y)))
            exit(1);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for editimage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "editimage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tInteractive Image Display and Manipulation Program\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input image filename (infile) [null]\n");
	fprintf(stderr,"\t[-ov]  overlay image filename (infile) [null]\n");
	fprintf(stderr,"\t[-s]  input shape mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-c]  input clip mask filename (infile) [null]\n");
	fprintf(stderr,"\t[-roi_out]  output ROI filename (outfile) [null]\n");
	fprintf(stderr,"\t[-x]  x value of upper-left corner of editimage user interface (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-y]  y value of upper-left corner of editimage user interface (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-zoom]  initial zoom factor (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-update]  initial update time (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-display]  host:display.screen (string) [null]\n");
	fprintf(stderr,"\t[-form]  editimage form (string) [null]\n");
	fprintf(stderr,"\t[-cmap_image]  image with alternate colormap filename (infile) [null]\n");
	fprintf(stderr,"\t[-use_cmap]  use colormap? (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for editimage\n");
	fprintf(stderr, "\t[-V] Gives the version for editimage\n");
	fprintf(stderr, "\t[-U] Gives the usage for editimage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called editimage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses editimage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for editimage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*ov_pstr = 
	"\nEnter: (ov) overlay image filename \n        {infile}: "; 
char	*s_pstr = 
	"\nEnter: (s) input shape mask filename \n        {infile}: "; 
char	*c_pstr = 
	"\nEnter: (c) input clip mask filename \n        {infile}: "; 
char	*roi_out_pstr = 
	"\nEnter: (roi_out) output ROI filename \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x value of upper-left corner of editimage user interface \n        {integer, -1 to 1000 [-1] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y value of upper-left corner of editimage user interface \n        {integer, -1 to 1000 [-1] }: "; 
char	*zoom_pstr = 
	"\nEnter: (zoom) initial zoom factor \n        {float, > 0.0 [2.000000] }: "; 
char	*update_pstr = 
	"\nEnter: (update) initial update time \n        {float, >= 0.0 [0.000000] }: "; 
char	*display_pstr = 
	"\nEnter: (display) host:display.screen \n        {string}: "; 
char	*display_def = NULL;
char	*form_pstr = 
	"\nEnter: (form) editimage form \n        {string}: "; 
char	*form_def = NULL;
char	*cmap_image_pstr = 
	"\nEnter: (cmap_image) image with alternate colormap filename \n        {infile}: "; 
char	*use_cmap_pstr = 
	"\nEnter: (use_cmap) use colormap? \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "editimage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "editimage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "editimage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "editimage.ans");
		}

	     }

	}

	/*
	 * allocate the editimage structure
	 */
	editimage = (editimage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (editimage_struct));

	/*
	 * get optional arguments for editimage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	editimage->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(editimage->i))
;

	editimage->ov_flag = vget_infile(fid, prompt_flag,
	"-ov", ov_pstr, &(editimage->ov))
;

	editimage->s_flag = vget_infile(fid, prompt_flag,
	"-s", s_pstr, &(editimage->s))
;

	editimage->c_flag = vget_infile(fid, prompt_flag,
	"-c", c_pstr, &(editimage->c))
;

	editimage->roi_out_flag = vget_outfile(fid, prompt_flag,
	"-roi_out", roi_out_pstr, &(editimage->roi_out))
;

	editimage->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(editimage->x),
	-1, -1, 1000);

	editimage->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(editimage->y),
	-1, -1, 1000);

	editimage->zoom_flag = vget_float(fid, prompt_flag,
	"-zoom", zoom_pstr, &(editimage->zoom),
	2.000000, 2.000000, 2.000000);

	editimage->update_flag = vget_float(fid, prompt_flag,
	"-update", update_pstr, &(editimage->update),
	0.000000, 1.000000, 1.000000);

	editimage->display_flag = vget_string(fid, prompt_flag,
	"-display", display_pstr, &(editimage->display),
	display_def);

	if (prompt_flag == FALSE)
	{
	    if ((editimage->display_flag == 1)&&(editimage->display == NULL))
    	{
		fprintf(stderr, "editimage:\n");
		fprintf(stderr, "you must specify a name following '-display'\n");
		gw_usage();
		exit(1);
		}
	}
	editimage->form_flag = vget_string(fid, prompt_flag,
	"-form", form_pstr, &(editimage->form),
	form_def);

	if (prompt_flag == FALSE)
	{
	    if ((editimage->form_flag == 1)&&(editimage->form == NULL))
    	{
		fprintf(stderr, "editimage:\n");
		fprintf(stderr, "you must specify a name following '-form'\n");
		gw_usage();
		exit(1);
		}
	}
	editimage->cmap_image_flag = vget_infile(fid, prompt_flag,
	"-cmap_image", cmap_image_pstr, &(editimage->cmap_image))
;

	editimage->use_cmap_flag = vget_logic(fid, prompt_flag,
	"-use_cmap", use_cmap_pstr, &(editimage->use_cmap), 1);


}



