 /*
  * Khoros: $Id: error.c,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: error.c,v 1.1 1991/05/10 15:56:56 khoros Exp $";
#endif

 /*
  * $Log: error.c,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: error.c
   >>>>               
   >>>>   description: Signal Handler for Errors
   >>>>              
   >>>>      routines: X3D_signal_handler()
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME:  X3D_signal_handler
*
*      PURPOSE:  This routine is used to trap for any math errors
*		 that may be generated by the math-parser routines.
*
*        INPUT:  1.  sig --  the signal number
*		 2.  flag -- type of trap error
*		 3.  context -- a pointer to the signal context
*
*
*       OUTPUT:  none.
*
*    CALLED BY:  By the system
*
*   WRITTEN BY:  Danielle Argiro & Josh Siegel & Mark Young
*
*   STRIPPED FROM: xvparser  BY:  Mike Lang
*
*************************************************************/



vsignal  X3D_signal_handler(sig, flags, context)

int	sig, flags;
struct	sigcontext *context;
{
	/*
	 *  Make sure that the signal is a SIGFPE error.  (This should
	 *  always be the case, but just in case...)
	 */
	if ((sig !=  SIGFPE) && (sig != SIGILL))
	{
	   fprintf(stderr,"\n\n ERROR: \n");
	   fprintf(stderr," Received an error of unknown signal type %d.",sig);
	   fprintf(stderr,"\n Beware! this should not have happened.\n\n");
	}

	/*  Otherwise check to see what kind of trap or fault error. */
	switch( flags )
	{

#ifdef FPE_FLTOVF_FAULT
	   case FPE_FLTOVF_FAULT:
#endif
#ifdef FPE_FLTOVF_TRAP
	   case FPE_FLTOVF_TRAP:
#endif
#ifdef FPE_OVERFLOW_TRAP
	   case FPE_OVERFLOW_TRAP:
#endif
#if defined(FPE_OVERFLOW_TRAP) || defined(FPE_FLTOVF_TRAP) || defined(FPE_FLTOVF_FAULT)
	      fprintf(stderr,"\n\n X3D_signal_handler: \n Function over interval");
	      fprintf(stderr," specified resulted in overflow \n");
	      break;
#endif

#ifdef FPE_FLTUND_FAULT
	   case FPE_FLTUND_FAULT:
#endif
#ifdef FPE_FLTUND_TRAP
	   case FPE_FLTUND_TRAP:
#endif
#ifdef FPE_UNDERFLOW_TRAP
	   case FPE_UNDERFLOW_TRAP:
#endif
	      fprintf(stderr,"\n\n X3D_signal_handler: \n Function over interval");
	      fprintf(stderr," specified resulted in underflow \n");
	      break;

#ifdef FPE_FLTDIV_FAULT
	   case FPE_FLTDIV_FAULT:
#endif
#ifdef FPE_FLTDIV_TRAP
	   case FPE_FLTDIV_TRAP:
#endif
#ifdef FPE_DIVZERO_TRAP
	   case FPE_DIVZERO_TRAP:
#endif
	      fprintf(stderr,"\n\n X3D_signal_handler: \n floating point divide by");
	      fprintf(stderr," zero.\n Function undefined within interval");
	      fprintf(stderr," specified \n");
	      break;

#ifdef FPE_INTDIV_TRAP
	   case FPE_INTDIV_TRAP:
	      fprintf(stderr,"\n\n X3D_signal_handler: \n integer divide by zero.\n");
	      fprintf(stderr," function undefined within interval specified\n");
	      break;
#endif
#ifdef FPE_ZERODIV_TRAP
	   case FPE_ZERODIV_TRAP:
	      fprintf(stderr,"\n\n X3D_signal_handler: \n divide by zero.\n");
	      fprintf(stderr," function undefined within interval specified\n");
	      break;
#endif

#if defined(mc68000) && ! defined(NeXT)
	   case FPE_FPA_ENABLE:
	      fprintf(stderr,"\n\n X3D_signal_handler: \n fpa not enabled\n");
	      break;

	   case FPE_FPA_ERROR:
	      fprintf(stderr,"\n\n error: \n fpa arithmetic exception\n");
	      break;
#endif

	   default:   
	      fprintf(stderr,"\n\n X3D_signal_handler: \n");
	      fprintf(stderr," Received an error of unknown trap or fault type %d.\n\n", flags);
	      fprintf(stderr," Beware! this should not have happened.\n\n");
	      break;
	}
	fprintf(stderr,"\n\n");

	/*  Return to the calling menu routine. */
	(void) signal(SIGFPE, SIG_IGN);
	(void) signal(SIGILL, SIG_IGN);
	longjmp(jump_dest, 1);
}
