 /*
  * Khoros: $Id: vmapxfer.h,v 1.1 1991/05/10 15:50:36 khoros Exp $
  */

 /*
  * $Log: vmapxfer.h,v $
 * Revision 1.1  1991/05/10  15:50:36  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmapxfer.h
 >>>>            Author: Tom Sauer, Scott Wilson
 >>>> Date Last Updated: Tue Mar  5 22:38:01 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vmapxfer_h_
#define _vmapxfer_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vmapxfer Argument Structure
*
****************************************************************/

typedef struct _vmapxfer  {

/*
 *  Input Image to receive map (Required infile)
 */
char	*i1_file;	/* Input Image to receive map FILENAME */
int	 i1_flag;	/* Input Image to receive map FLAG */

/*
 *  input image to extract map from (Required infile)
 */
char	*i2_file;	/* input image to extract map from FILENAME */
int	 i2_flag;	/* input image to extract map from FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

}  vmapxfer_struct;

vmapxfer_struct *vmapxfer;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT1(image) \
image = readimage(vmapxfer->i1_file); \
if(image == NULL){ \
(void) fprintf(stderr,"vmapxfer: Image could not be read\n"); \
exit(1); \
}
#define READINPUT2(image2) \
image2 = readimage(vmapxfer->i2_file); \
if(image2 == NULL){ \
(void) fprintf(stderr,"vmapxfer: Image could not be read\n"); \
exit(1); \
}

#define CHECKINPUT1(program, image) \
(void) proper_num_images(program,image,1,TRUE); \
\
if ( (! propertype(program, image, VFF_TYP_BIT, FALSE))  && \
(! propertype(program, image, VFF_TYP_1_BYTE, FALSE))  && \
(! propertype(program, image, VFF_TYP_2_BYTE, FALSE))  && \
(! propertype(program, image, VFF_TYP_4_BYTE, FALSE))) \
{ \
(void) fprintf(stderr,"%s: Input image %s must\n", program, vmapxfer->i1_file); \
(void) fprintf(stderr,"be of Data Storage Type BIT, BYTE, SHORT or LONG\n"); \
exit(1); \
}

#define CHECKINPUT2(program, image2) \
(void) proper_num_images(program,image,1,TRUE); \
\
if ( (! proper_map_scheme(program, image2, VFF_MS_ONEPERBAND, FALSE)) && \
(! proper_map_scheme(program, image2, VFF_MS_SHARED, FALSE)))  \
{ \
(void) fprintf(stderr,"%s:  Extracting image %s must\n", program, vmapxfer->i2_file); \
(void) fprintf(stderr,"have a Map Scheme of One-Per-Band or Shared\n"); \
exit(1); \
}
/* -include_macros_end */

#endif
