 /*
  * Khoros: $Id: vcustom.c,v 1.2 1991/12/18 09:40:01 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vcustom.c,v 1.2 1991/12/18 09:40:01 dkhoros Exp $";
#endif

 /*
  * $Log: vcustom.c,v $
 * Revision 1.2  1991/12/18  09:40:01  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcustom.c
 >>>>
 >>>>      Program Name: vcustom
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Create a custom  image  via  keyboard  entry,  intended  for
 >>>>	building custom kernels for spatial convolution.
 >>>>	
 >>>>	

 >>>>            Author: Richard Krukar
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:17:29 1991
 >>>>
 >>>>          Routines: main- the main program for vcustom
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vcustom.h"


/****************************************************************
 *
 * Routine Name:  main program for vcustom
 *
 *       Input:  
 *         -o  output image 
 *         -r  specify the number of rows   (value > 0)
 *         -c  specify the number of columns   (value > 0)
 *
 *
 *         [-trigger] trigger input
 *         [-t] lets user choose data type of image
 *		'float' (Float),
 *		'byte' (Byte),
 *		'short' (Short),
 *		 or 'integer' (Integer)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

if(!vget_type(&type, vcustom->t_toggle)){
   fprintf(stderr,"vcustom:  Invalid data type specified\n");
   exit(1);
}

if(type!=VFF_TYP_1_BYTE && type!=VFF_TYP_2_BYTE && type!=VFF_TYP_4_BYTE && type!=VFF_TYP_FLOAT){
   fprintf(stderr,"%s:  Illegal image data type specified.\n",program);
   exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
  /* Call the procedure that does the work */
if(! lvcustom(&image, vcustom->r_int, vcustom->c_int, type))
{
  (void) fprintf(stderr, "lvcustom Failed\n");
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vcustom->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vcustom 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vcustom :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreate a custom  image  via  keyboard  entry,  intended  for\n");
	fprintf(stderr, "\tbuilding custom kernels for spatial convolution.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-r  specify the number of rows  (integer, > 0)\n");
	fprintf(stderr,"\t-c  specify the number of columns  (integer, > 0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (Float),\n");
	fprintf(stderr, "\t\t'byte'  (Byte),\n");
	fprintf(stderr, "\t\t'short'  (Short),\n");
	fprintf(stderr, "\t\t or 'integer'  (Integer)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vcustom\n");
	fprintf(stderr, "\t[-U] Gives the usage for vcustom\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vcustom.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vcustom.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vcustom
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) specify the number of rows \n        {integer, > 0}: "; 
char	*c_pstr = 
	"\nEnter: (c) specify the number of columns \n        {integer, > 0}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (Float)\n\t\t'byte' (Byte)\n\t\t'short' (Short)\n\t\tor 'integer' (Integer)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vcustom", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vcustom.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vcustom: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vcustom.ans");
		}

	     }

	}

	/*
	 * allocate the vcustom structure
	 */
	vcustom = (vcustom_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vcustom_struct));

	/*
	 * get required arguments for vcustom
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vcustom->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vcustom->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcustom->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vcustom->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vcustom->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcustom->r_flag = vget_int(fid, prompt_flag,
			"-r", r_pstr, &(vcustom->r_int),
			3, 2, 2)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcustom->r_flag))
		{
		    fprintf(stderr, "\t\tr is required, please re-enter: \n");
		    vcustom->r_flag = vget_int(fid, prompt_flag,
		    "-r", r_pstr, &(vcustom->r_int),
		    3, 2, 2);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-r' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcustom->c_flag = vget_int(fid, prompt_flag,
			"-c", c_pstr, &(vcustom->c_int),
			3, 2, 2)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcustom->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    vcustom->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(vcustom->c_int),
		    3, 2, 2);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vcustom
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vcustom->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vcustom->trigger_file))
;


	/*
	 * get optional toggles for vcustom
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vcustom->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vcustom->t_toggle),
		"float");

		if (((strcmp(vcustom->t_toggle, "float") == 0)) || 
		     ((strcmp(vcustom->t_toggle, "byte") == 0)) || 
		     ((strcmp(vcustom->t_toggle, "short") == 0)) || 
		     ((strcmp(vcustom->t_toggle, "integer") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vcustom->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vcustom->t_toggle),
		"float");

		if (((strcmp(vcustom->t_toggle, "float") != 0)) && 
		     ((strcmp(vcustom->t_toggle, "byte") != 0)) && 
		     ((strcmp(vcustom->t_toggle, "short") != 0)) && 
		     ((strcmp(vcustom->t_toggle, "integer") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



