 /*
  * Khoros: $Id: vmos2band.h,v 1.2 1992/03/20 23:03:38 dkhoros Exp $
  */

 /*
  * $Log: vmos2band.h,v $
 * Revision 1.2  1992/03/20  23:03:38  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmos2band.h
 >>>>            Author: Donna Koechner
 >>>> Date Last Updated: Tue Mar 17 09:02:11 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vmos2band_h_
#define _vmos2band_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vmos2band Argument Structure
*
****************************************************************/

typedef struct _vmos2band  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  number of rows in each subimage (must be same for all subimages) (Required integer)
 */
int	 r_int; 	/* number of rows in each subimage (must be same for all subimages) INT */
int	 r_flag;	/* number of rows in each subimage (must be same for all subimages) FLAG */

/*
 *  number of columns in each subimage (must be same for all subimages) (Required integer)
 */
int	 c_int; 	/* number of columns in each subimage (must be same for all subimages) INT */
int	 c_flag;	/* number of columns in each subimage (must be same for all subimages) FLAG */

/*
 *  Subimage border size in pixels (inner borders) (Optional integer)
 */
int	 bs_int; 	/* Subimage border size in pixels (inner borders) INT */
int	 bs_flag;	/* Subimage border size in pixels (inner borders) FLAG */

/*
 *  Mosaic image border size in pixels (outer border) (Optional integer)
 */
int	 bm_int; 	/* Mosaic image border size in pixels (outer border) INT */
int	 bm_flag;	/* Mosaic image border size in pixels (outer border) FLAG */

/*
 *  Horzontal index of first subimage (will be first band) (Optional integer)
 */
int	 x_int; 	/* Horzontal index of first subimage (will be first band) INT */
int	 x_flag;	/* Horzontal index of first subimage (will be first band) FLAG */

/*
 *  Vertical index of first subimage (will be first band) (Optional integer)
 */
int	 y_int; 	/* Vertical index of first subimage (will be first band) INT */
int	 y_flag;	/* Vertical index of first subimage (will be first band) FLAG */

/*
 *  Number of subimages to skip (periodic) when putting subimages into band format (Optional integer)
 */
int	 s_int; 	/* Number of subimages to skip (periodic) when putting subimages into band format INT */
int	 s_flag;	/* Number of subimages to skip (periodic) when putting subimages into band format FLAG */

/*
 *  Number of subimages to be put into band format (Optional integer)
 */
int	 n_int; 	/* Number of subimages to be put into band format INT */
int	 n_flag;	/* Number of subimages to be put into band format FLAG */

}  vmos2band_struct;

vmos2band_struct *vmos2band;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vmos2band->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vmos2band: Image could not be read\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_num_bands(program,image,1,TRUE); \
        \
        (void) proper_dim(program,image,0,TRUE); \
        \
        (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE); \
/* -include_macros_end */

#endif
