 /*
  * Khoros: $Id: vcast.c,v 1.1 1991/05/10 15:46:57 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vcast.c,v 1.1 1991/05/10 15:46:57 khoros Exp $";
#endif

 /*
  * $Log: vcast.c,v $
 * Revision 1.1  1991/05/10  15:46:57  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcast.c
 >>>>
 >>>>      Program Name: vcast
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Upconvert all images to the highest input image data type.
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:23:17 1991
 >>>>
 >>>>          Routines: main- the main program for vcast
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vcast.h"


/****************************************************************
 *
 * Routine Name:  main program for vcast
 *
 *       Input:  
 *       -i1  input image #1 
 *       -i2  input image #2 
 *       -o1  output image #1 
 *       -o2  output image #2 
 *
 *
 *       [-i3] input image #3
 *       [-i4] input image #4
 *       [-i5] input image #5
 *       [-o3] output image #3
 *       [-o4] output image #4
 *       [-o5] output image #5
 *       [-t] Select data type [default = Auto Upcast to Highest Input Data Type]
 *		'byte' (choose byte data type),
 *		'short' (choose short data type),
 *		'int' (choose integer data type),
 *		'float' (choose float data type),
 *		'complex' (choose complex data type),
 *		 or 'double' (choose double data type)
 *		   [default = byte] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *img1, *img2, *img3, *img4, *img5,
               **images,  *readimage();
int  i, num_images, type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);
  i = 0;

  /*
   * If the optional type selection is used 
   *  then get the appropriate data type.
   */
  if (vcast->t_flag)
  {
    if (!vget_type(&type, vcast->t_toggle))
    {
      (void)fprintf(stderr, "vcast: unknown data type!\n");
      exit(1);
    }
  }
  else    /* otherwise, do auto upconvert to highest input image data type */
  {
    type = -1;
  }

                          /* Find out how many images there are. */
  num_images = 2;         /* must have at least two input images */
  if (vcast->i3_flag)     /* now count the optional images */
      num_images++;
  if (vcast->i4_flag)
      num_images++;
  if (vcast->i5_flag)
      num_images++;
                          /* get space for image structures */
  images = (struct xvimage **) malloc(sizeof(struct xvimage *) * num_images);
  if (images == NULL)
  {
    (void) fprintf(stderr,"vcast: Unable to malloc space for image structures\n");
    exit(1);
  }

  img1 = readimage(vcast->i1_file);
  if (img1 == NULL)
  {
   (void) fprintf(stderr,"vcast: Can not read input image #1\n");
    exit(1);                    
  }
  images[i++] = img1;

  img2 = readimage(vcast->i2_file);
  if (img2 == NULL)
  {
   (void) fprintf(stderr,"vcast: Can not read input image #2\n");
    exit(1);                    
  }
  images[i++] = img2;

  (void) proper_num_images(program, img1, 1, TRUE);

  MATCHINPUT(program, img1, img2);      /* Verify input images */

    /* Now check for optional input images */
if ( vcast->i3_flag )
{
  img3 = readimage(vcast->i3_file);
  if (img3 == NULL)
  {
   (void) fprintf(stderr,"vcast: Can not read input image #3\n");
    exit(1);                    
  }
  images[i++] = img3;
  MATCHINPUT(program, img1, img3);      /* Verify input images */
}

if ( vcast->i4_flag )
{
  img4 = readimage(vcast->i4_file);
  if (img4 == NULL)
  {
   (void) fprintf(stderr,"vcast: Can not read input image #4\n");
    exit(1);                    
  }
  images[i++] = img4;
  MATCHINPUT(program, img1, img4);      /* Verify input images */
}

if ( vcast->i5_flag )
{
  img5 = readimage(vcast->i5_file);
  if (img5 == NULL)
  {
   (void) fprintf(stderr,"vcast: Can not read input image #5\n");
    exit(1);                    
  }
  images[i] = img5;
  MATCHINPUT(program, img1, img5);      /* Verify input images */
}

/* -main_before_lib_call_end */

/* -main_library_call */
  if(! lvcast(images, num_images, type) )
  {
   (void) fprintf(stderr, "lvcast Failed\n");
   exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
 (void) writeimage(vcast->o1_file, img1);
 (void) writeimage(vcast->o2_file, img2);

 if ( vcast->i3_flag)
    (void) writeimage(vcast->o3_file, img3);

 if ( vcast->i4_flag)
    (void) writeimage(vcast->o4_file, img4);

 if ( vcast->i5_flag)
    (void) writeimage(vcast->o5_file, img5);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vcast 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vcast :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tUpconvert all images to the highest input image data type.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image #1  (infile)\n");
	fprintf(stderr,"\t-i2  input image #2  (infile)\n");
	fprintf(stderr,"\t-o1  output image #1  (outfile)\n");
	fprintf(stderr,"\t-o2  output image #2  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i3]  input image #3 (infile) [null]\n");
	fprintf(stderr,"\t[-i4]  input image #4 (infile) [null]\n");
	fprintf(stderr,"\t[-i5]  input image #5 (infile) [null]\n");
	fprintf(stderr,"\t[-o3]  output image #3 (outfile) [null]\n");
	fprintf(stderr,"\t[-o4]  output image #4 (outfile) [null]\n");
	fprintf(stderr,"\t[-o5]  output image #5 (outfile) [null]\n");
	fprintf(stderr, "\t[-t]  Select data type [default = Auto Upcast to Highest Input Data Type]\n");
	fprintf(stderr, "\t\t'byte'  (choose byte data type),\n");
	fprintf(stderr, "\t\t'short'  (choose short data type),\n");
	fprintf(stderr, "\t\t'int'  (choose integer data type),\n");
	fprintf(stderr, "\t\t'float'  (choose float data type),\n");
	fprintf(stderr, "\t\t'complex'  (choose complex data type),\n");
	fprintf(stderr, "\t\t or 'double'  (choose double data type)\n");
	fprintf(stderr, "\t\t[default = byte]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vcast\n");
	fprintf(stderr, "\t[-U] Gives the usage for vcast\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vcast.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vcast.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vcast
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image #1 \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image #2 \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) output image #1 \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) output image #2 \n        {outfile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) input image #3 \n        {infile}: "; 
char	*i4_pstr = 
	"\nEnter: (i4) input image #4 \n        {infile}: "; 
char	*i5_pstr = 
	"\nEnter: (i5) input image #5 \n        {infile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) output image #3 \n        {outfile}: "; 
char	*o4_pstr = 
	"\nEnter: (o4) output image #4 \n        {outfile}: "; 
char	*o5_pstr = 
	"\nEnter: (o5) output image #5 \n        {outfile}: "; 
char	*t_pstr = "\nEnter: (t) Select data type [default = Auto Upcast to Highest Input Data Type] -- \n      \t\t'byte' (choose byte data type)\n\t\t'short' (choose short data type)\n\t\t'int' (choose integer data type)\n\t\t'float' (choose float data type)\n\t\t'complex' (choose complex data type)\n\t\tor 'double' (choose double data type)\n  [byte]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vcast", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vcast.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vcast: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vcast.ans");
		}

	     }

	}

	/*
	 * allocate the vcast structure
	 */
	vcast = (vcast_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vcast_struct));

	/*
	 * get required arguments for vcast
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vcast->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vcast->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcast->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vcast->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vcast->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcast->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vcast->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcast->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vcast->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vcast->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcast->o1_flag = vget_outfile(fid, prompt_flag,
			"-o1", o1_pstr, &(vcast->o1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcast->o1_flag))
		{
		    fprintf(stderr, "\t\to1 is required, please re-enter: \n");
		    vcast->o1_flag = vget_outfile(fid, prompt_flag,
		    "-o1", o1_pstr, &(vcast->o1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vcast->o2_flag = vget_outfile(fid, prompt_flag,
			"-o2", o2_pstr, &(vcast->o2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vcast->o2_flag))
		{
		    fprintf(stderr, "\t\to2 is required, please re-enter: \n");
		    vcast->o2_flag = vget_outfile(fid, prompt_flag,
		    "-o2", o2_pstr, &(vcast->o2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vcast
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vcast->i3_flag = vget_infile(fid, prompt_flag,
	"-i3", i3_pstr, &(vcast->i3_file))
;

	vcast->i4_flag = vget_infile(fid, prompt_flag,
	"-i4", i4_pstr, &(vcast->i4_file))
;

	vcast->i5_flag = vget_infile(fid, prompt_flag,
	"-i5", i5_pstr, &(vcast->i5_file))
;

	vcast->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(vcast->o3_file))
;

	vcast->o4_flag = vget_outfile(fid, prompt_flag,
	"-o4", o4_pstr, &(vcast->o4_file))
;

	vcast->o5_flag = vget_outfile(fid, prompt_flag,
	"-o5", o5_pstr, &(vcast->o5_file))
;


	/*
	 * get optional toggles for vcast
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vcast->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vcast->t_toggle),
		"byte");

		if (((strcmp(vcast->t_toggle, "byte") == 0)) || 
		     ((strcmp(vcast->t_toggle, "short") == 0)) || 
		     ((strcmp(vcast->t_toggle, "int") == 0)) || 
		     ((strcmp(vcast->t_toggle, "float") == 0)) || 
		     ((strcmp(vcast->t_toggle, "complex") == 0)) || 
		     ((strcmp(vcast->t_toggle, "double") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vcast->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vcast->t_toggle),
		"byte");

		if (((strcmp(vcast->t_toggle, "byte") != 0)) && 
		     ((strcmp(vcast->t_toggle, "short") != 0)) && 
		     ((strcmp(vcast->t_toggle, "int") != 0)) && 
		     ((strcmp(vcast->t_toggle, "float") != 0)) && 
		     ((strcmp(vcast->t_toggle, "complex") != 0)) && 
		     ((strcmp(vcast->t_toggle, "double") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



