 /*
  * Khoros: $Id: vnormal.c,v 1.1 1991/05/10 15:45:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vnormal.c,v 1.1 1991/05/10 15:45:48 khoros Exp $";
#endif

 /*
  * $Log: vnormal.c,v $
 * Revision 1.1  1991/05/10  15:45:48  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vnormal.c
 >>>>
 >>>>      Program Name: vnormal
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Normalize an image, forcing the pixel values to lie within a
 >>>>	specified range.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:58:26 1991
 >>>>
 >>>>          Routines: main- the main program for vnormal
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vnormal.h"


/****************************************************************
 *
 * Routine Name:  main program for vnormal
 *
 *       Input:  
 *         -i  input image filename 
 *         -o  output image filename 
 *         -n  specifies normalization factor   (value > 0.0)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vnormal->i_file);
    if (image == NULL) exit(1);        /* Quit if error reading the image */

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvconvert(image,image->data_storage_type,1,0,vnormal->n_float,1.0,0))
    {
        (void) fprintf(stderr, "lvconvert Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vnormal->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vnormal 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vnormal :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tNormalize an image, forcing the pixel values to lie within a\n");
	fprintf(stderr, "\tspecified range.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr,"\t-n  specifies normalization factor  (float, > 0.0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vnormal\n");
	fprintf(stderr, "\t[-U] Gives the usage for vnormal\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vnormal.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vnormal.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vnormal
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies normalization factor \n        {float, > 0.0}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vnormal", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vnormal.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vnormal: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vnormal.ans");
		}

	     }

	}

	/*
	 * allocate the vnormal structure
	 */
	vnormal = (vnormal_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vnormal_struct));

	/*
	 * get required arguments for vnormal
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vnormal->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vnormal->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vnormal->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vnormal->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vnormal->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vnormal->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vnormal->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vnormal->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vnormal->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vnormal->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vnormal->n_flag = vget_float(fid, prompt_flag,
			"-n", n_pstr, &(vnormal->n_float),
			255.000000, 2.000000, 2.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vnormal->n_flag))
		{
		    fprintf(stderr, "\t\tn is required, please re-enter: \n");
		    vnormal->n_flag = vget_float(fid, prompt_flag,
		    "-n", n_pstr, &(vnormal->n_float),
		    255.000000, 2.000000, 2.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-n' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



