 /*
  * Khoros: $Id: lvm180.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvm180.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvm180.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvm180.c
 >>>>
 >>>>      Program Name: vm180
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:30:16 1991 
 >>>>
 >>>>          Routines: lvm180 - the library call for vm180
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvm180 - library call for vm180
*
* Purpose:
*    
*    computes a 180 degree rotation of a morphological kernel.
*    
*    
* Input:
*    
*         1. kernel - pointer to an xvimage (morphological kernel)  It
*         is strongly advisable to use a kernel created with vmcustom.
*    
*    
* Output:
*    
*    1. kernel - holds the resulting rotated kernel
*    
*    
*
* Written By: Pascal ADAM
*    
*    Ghosted by Pascal ADAM Fri May 25 14:05:41 MDT 1990
*    
*    
****************************************************************/


/* -library_def */
int
lvm180(kernel)
struct xvimage *kernel;
/* -library_def_end */

/* -library_code */
{

        int krows,kcols,starti,startj,i;
        unsigned char *result;

        krows = kernel -> col_size;
        kcols = kernel -> row_size;
        starti= (int) kernel -> ispare1;
        startj= (int) kernel -> ispare2;

        /* dynamic memory allocation for temporary storage  */
        /* of kernel  element ............................  */
        result = (unsigned char *)malloc (kcols * krows * sizeof(unsigned char));
        if (result == NULL) {
           (void) fprintf(stderr,"lvm180: insufficient memory available\n");
           return(0);
           }
        for (i = 0; i < krows * kcols; i++) {
           result[i] = kernel -> imagedata[i];
           }

        for (i = 0; i < krows * kcols; i++) {
           kernel -> imagedata[i] = result[krows * kcols -1 -i];
           }

        kernel -> ispare1 = (int) (-1 * (starti + krows));
        kernel -> ispare2 = (int) (-1 * (startj + kcols));


        return(1);
}
/* -library_code_end */
