 /*
  * Khoros: $Id: lvhpf.c,v 1.2 1992/03/20 23:06:04 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvhpf.c,v 1.2 1992/03/20 23:06:04 dkhoros Exp $";
#endif

 /*
  * $Log: lvhpf.c,v $
 * Revision 1.2  1992/03/20  23:06:04  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvhpf.c
 >>>>
 >>>>      Program Name: vhpf
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:02:12 1991 
 >>>>
 >>>>          Routines: lvhpf - the library call for vhpf
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvhpf - library call for vhpf
*
* Purpose:
*    
*    Perform a high-pass filtering operation on an image  in  the
*    frequency domain.
*    
*    
* Input:
*    
*         1. image -- xvimage structure
*         2. order -- high-pass filter order;
*         3. filtyp -- high-pass filter type; if 0
*                      selects an exponential
*                      filter (default), if 1
*                      selects a butterworth filter
*         4. fcut -- cutoff frequency radius;
*                    default value is 0.5
*    
*    
* Output:
*    
*         1. image -- holds the result of the
*                     high-pass filtered image.
*         image is used for both the input xvimage structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvhpf returns 1 upon success and 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, Ramiro Jordan
*    
*    Scott Wilson - 27-Jan-91 - Removed FFT processing code
*    
*    
****************************************************************/


/* -library_def */
int
lvhpf(image,order,filtyp,fcut)
struct xvimage *image;
int  order,filtyp;
float fcut;
/* -library_def_end */

/* -library_code */
{
    int    i, j, nr, nc;
    int    cutoff, p;
    float  *f,e,ehpf(),bhpf();

    nc = image->row_size;
    nr = image->col_size;

    if (nr > nc) cutoff = fcut*nr*0.5;
    else cutoff = fcut*nc*0.5;

    p = 0;
    f = (float *)(image->imagedata);

    for (i=0; i<nr; i++)             /* Rows of FFT */
      {
        /* Perform filter operation (multiplication) over the line */
        for (j=0; j<nc; j++)
          {
            switch (filtyp)
              {
                case 0 : e = ehpf(i,j,cutoff,nr,order);
                         break;
                case 1 : e = bhpf(i,j,cutoff,nr,order);
                         break;
                default : fprintf(stderr,"lvhpf: Unknown filter type\n");
                          return(0);
                          break;
              }
            f[p] = f[p]*e; p++; /* Real part */
            f[p] = f[p]*e; p++; /* Imaginary part */
          }
      }
      return(1);
}

float
ehpf(i,j,cutoff,n,order)
int i,j,cutoff,n,order;
/* Exponential highpass filter */
  {
    int x,y;
    double f,d;

    x = (n/2)-j;
    y = (n/2)-i;
    d = sqrt((double)(x*x+y*y));
    if (d != 0.0)
      {
        f = cutoff/d;
        if (order != 1) f = pow(f,(double)order);
        f = exp((-.347)*f*f);
      }
    else f = 0.0;
    return((float)f);
  }

float
bhpf(i,j,cutoff,n,order)
int i,j,cutoff,n,order;
/* Butterworth highpass filter */
  {
    int x,y;
    double f,d;

    x = (n/2)-j;
    y = (n/2)-i;
    d = sqrt((double)(x*x+y*y));
    if (d != 0.0)
      {
        f = cutoff/d;
        if (order != 1) f = pow(f,(double)(2*order));
        f = 1.0 / (1.0 + 0.414*f);
      }
    else f = 0.0;
    return((float)f);
  }
/* -library_code_end */
