 /*
  * Khoros: $Id: vwarp.h,v 1.1 1991/05/10 15:52:18 khoros Exp $
  */

 /*
  * $Log: vwarp.h,v $
 * Revision 1.1  1991/05/10  15:52:18  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vwarp.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Thu Mar 28 00:21:12 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vwarp_h_
#define _vwarp_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vwarp Argument Structure
*
****************************************************************/

typedef struct _vwarp  {

/*
 *  input image (Required infile)
 */
char	*i1_file;	/* input image FILENAME */
int	 i1_flag;	/* input image FLAG */

/*
 *  X polynomial coefficients image (Required infile)
 */
char	*i2_file;	/* X polynomial coefficients image FILENAME */
int	 i2_flag;	/* X polynomial coefficients image FLAG */

/*
 *  Y polynomial coefficients image (Required infile)
 */
char	*i3_file;	/* Y polynomial coefficients image FILENAME */
int	 i3_flag;	/* Y polynomial coefficients image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  x coordinate of center-of-action (Optional float)
 */
float	 x_float;	/* x coordinate of center-of-action FLOAT */
int	 x_flag;   	/* x coordinate of center-of-action FLAG */

/*
 *  y coordinate of center-of-action (Optional float)
 */
float	 y_float;	/* y coordinate of center-of-action FLOAT */
int	 y_flag;   	/* y coordinate of center-of-action FLAG */

}  vwarp_struct;

vwarp_struct *vwarp;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1, xcoeffs, ycoeffs) \
        (void) proper_num_images(program,img1,1,TRUE); \
        if (propertype(program,img1,VFF_TYP_COMPLEX,FALSE) || \
            propertype(program,img1,VFF_TYP_BIT,FALSE)) \
        { \
            (void) fprintf(stderr, "Input image: Image data type can \
NOT be COMPLEX || BIT\n"); \
            exit(1); \
        } \
        if (propertype(program,xcoeffs,VFF_TYP_COMPLEX,FALSE) || \
            propertype(program,xcoeffs,VFF_TYP_BIT,FALSE)) \
        { \
            (void) fprintf(stderr, "xcoeffs: Image data type can \
NOT be COMPLEX || BIT\n"); \
            exit(1); \
        } \
        if (propertype(program,ycoeffs,VFF_TYP_COMPLEX,FALSE) || \
            propertype(program,ycoeffs,VFF_TYP_BIT,FALSE)) \
        { \
            (void) fprintf(stderr, "ycoeffs: Image data type can \
NOT be COMPLEX || BIT\n"); \
            exit(1); \
        } \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) proper_loc_type(program,img1,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
